/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.util.PathUtil;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;

public class LocalFilePath
implements FilePath {
    private static final Logger LOG = Logger.getInstance(LocalFilePath.class);
    @NotNull
    private final @SystemIndependent String myPath;
    private final boolean myIsDirectory;
    private VirtualFile myCachedFile;

    public LocalFilePath(@NotNull String path, boolean isDirectory) {
        if (path == null) {
            LocalFilePath.$$$reportNull$$$0(0);
        }
        this.myPath = FileUtil.toCanonicalPath((String)path);
        this.myIsDirectory = isDirectory;
        if (this.myPath.isEmpty()) {
            LOG.error(new Throwable("Invalid empty file path: '" + path + "'"));
        }
    }

    public LocalFilePath(@NotNull Path path, boolean isDirectory) {
        if (path == null) {
            LocalFilePath.$$$reportNull$$$0(1);
        }
        this(path.toAbsolutePath().toString(), isDirectory);
    }

    protected LocalFilePath(@NotNull String path, boolean isDirectory, @Nullable Void privateConstructorMarker) {
        if (path == null) {
            LocalFilePath.$$$reportNull$$$0(2);
        }
        this.myPath = path;
        this.myIsDirectory = isDirectory;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalFilePath path = (LocalFilePath)o;
        if (this.myIsDirectory != path.myIsDirectory) {
            return false;
        }
        if (this.myPath.equals(path.myPath)) {
            return true;
        }
        if (!this.myPath.equalsIgnoreCase(path.myPath)) {
            return false;
        }
        VirtualFile file = this.getVirtualFile();
        VirtualFile oFile = path.getVirtualFile();
        if (file == null && oFile == null) {
            return !SystemInfo.isFileSystemCaseSensitive;
        }
        return Objects.equals(file, oFile);
    }

    public int hashCode() {
        int result = Strings.stringHashCodeInsensitive((CharSequence)this.myPath);
        result = 31 * result + (this.myIsDirectory ? 1 : 0);
        return result;
    }

    @Override
    @NotNull
    public String getPath() {
        String string = this.myPath;
        if (string == null) {
            LocalFilePath.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public boolean isDirectory() {
        return this.myIsDirectory;
    }

    @Override
    public boolean isUnder(@NotNull FilePath parent, boolean strict) {
        if (parent == null) {
            LocalFilePath.$$$reportNull$$$0(4);
        }
        return FileUtil.startsWith((String)this.getPath(), (String)parent.getPath(), (boolean)SystemInfo.isFileSystemCaseSensitive, (boolean)strict);
    }

    @Override
    @Nullable
    public FilePath getParentPath() {
        String parent = PathUtil.getParentPath((String)this.myPath);
        if (SystemInfo.isWindows) {
            if (parent.isEmpty()) {
                return null;
            }
            if (!this.myPath.startsWith("/") && !parent.contains("/")) {
                return new LocalFilePath(parent + "/", true, null);
            }
        } else if (parent.isEmpty()) {
            if (this.myPath.length() > 1 && this.myPath.startsWith("/")) {
                return new LocalFilePath("/", true, null);
            }
            return null;
        }
        return new LocalFilePath(parent, true, null);
    }

    @Override
    @Nullable
    public VirtualFile getVirtualFile() {
        VirtualFile cachedFile = this.myCachedFile;
        if (cachedFile == null || !cachedFile.isValid() || !(!cachedFile.isCaseSensitive() ? this.getPath(cachedFile).equalsIgnoreCase(this.myPath) : this.getPath(cachedFile).equals(this.myPath))) {
            this.myCachedFile = cachedFile = this.findFile(this.myPath);
        }
        return cachedFile;
    }

    @Nullable
    protected VirtualFile findFile(@NotNull String path) {
        if (path == null) {
            LocalFilePath.$$$reportNull$$$0(5);
        }
        return LocalFileSystem.getInstance().findFileByPath(path);
    }

    @NotNull
    @NonNls
    protected String getPath(@NotNull VirtualFile cachedFile) {
        if (cachedFile == null) {
            LocalFilePath.$$$reportNull$$$0(6);
        }
        String string = cachedFile.getPath();
        if (string == null) {
            LocalFilePath.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    @Nullable
    public VirtualFile getVirtualFileParent() {
        FilePath parent = this.getParentPath();
        return parent != null ? parent.getVirtualFile() : null;
    }

    @Override
    @NotNull
    public File getIOFile() {
        return new File(this.myPath);
    }

    @Override
    @NotNull
    public String getName() {
        String string = PathUtil.getFileName((String)this.myPath);
        if (string == null) {
            LocalFilePath.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    @NotNull
    public String getPresentableUrl() {
        String string = FileUtil.toSystemDependentName((String)this.myPath);
        if (string == null) {
            LocalFilePath.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    @NotNull
    public Charset getCharset() {
        Charset charset = this.getCharset(null);
        if (charset == null) {
            LocalFilePath.$$$reportNull$$$0(10);
        }
        return charset;
    }

    @Override
    @NotNull
    public Charset getCharset(@Nullable Project project) {
        VirtualFile file = this.getVirtualFile();
        String path = this.myPath;
        while (!(file != null && file.isValid() || path.isEmpty())) {
            path = PathUtil.getParentPath((String)path);
            file = this.findFile(path);
        }
        if (file != null) {
            Charset charset = file.getCharset();
            if (charset == null) {
                LocalFilePath.$$$reportNull$$$0(11);
            }
            return charset;
        }
        EncodingManager e = project == null ? EncodingManager.getInstance() : EncodingProjectManager.getInstance((Project)project);
        Charset charset = e.getDefaultCharset();
        if (charset == null) {
            LocalFilePath.$$$reportNull$$$0(12);
        }
        return charset;
    }

    @Override
    @NotNull
    public FileType getFileType() {
        VirtualFile file = this.getVirtualFile();
        FileTypeManager manager = FileTypeManager.getInstance();
        FileType fileType = file != null ? manager.getFileTypeByFile(file) : manager.getFileTypeByFileName(this.getName());
        if (fileType == null) {
            LocalFilePath.$$$reportNull$$$0(13);
        }
        return fileType;
    }

    @NonNls
    public String toString() {
        return this.myPath + (this.myIsDirectory && !StringUtil.endsWith((CharSequence)this.myPath, (CharSequence)"/") ? "/" : "");
    }

    @Override
    public boolean isNonLocal() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 7, 8, 9, 10, 11, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/LocalFilePath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cachedFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/LocalFilePath";
                break;
            }
            case 3: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableUrl";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCharset";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isUnder";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 7, 8, 9, 10, 11, 12, 13 -> new IllegalStateException(string);
        };
    }
}

