/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.settings;

import com.intellij.platform.settings.Setting;
import com.intellij.platform.settings.SettingDescriptor;
import com.intellij.platform.settings.SettingDescriptorTemplateFactoryImpl;
import com.intellij.platform.settings.SettingSerializerDescriptor;
import com.intellij.platform.settings.SettingsController;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B-\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u0014\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u0015J\u0018\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00018\u0000H\u0096@\u00a2\u0006\u0002\u0010\u0019R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001a"}, d2={"Lcom/intellij/platform/settings/SettingImpl;", "T", "", "Lcom/intellij/platform/settings/Setting;", "serializer", "Lcom/intellij/platform/settings/SettingSerializerDescriptor;", "group", "Lcom/intellij/platform/settings/SettingDescriptorTemplateFactoryImpl;", "subKey", "", "controller", "Lcom/intellij/platform/settings/SettingsController;", "<init>", "(Lcom/intellij/platform/settings/SettingSerializerDescriptor;Lcom/intellij/platform/settings/SettingDescriptorTemplateFactoryImpl;Ljava/lang/String;Lcom/intellij/platform/settings/SettingsController;)V", "settingDescriptor", "Lcom/intellij/platform/settings/SettingDescriptor;", "getSettingDescriptor", "()Lcom/intellij/platform/settings/SettingDescriptor;", "settingDescriptor$delegate", "Lkotlin/Lazy;", "get", "()Ljava/lang/Object;", "set", "", "value", "(Ljava/lang/Object;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.platform.settings"})
final class SettingImpl<T>
implements Setting<T> {
    @NotNull
    private final SettingSerializerDescriptor<T> serializer;
    @NotNull
    private final SettingDescriptorTemplateFactoryImpl group;
    @NotNull
    private final String subKey;
    @NotNull
    private final SettingsController controller;
    @NotNull
    private final Lazy settingDescriptor$delegate;

    public SettingImpl(@NotNull SettingSerializerDescriptor<T> serializer, @NotNull SettingDescriptorTemplateFactoryImpl group, @NotNull String subKey, @NotNull SettingsController controller) {
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)subKey, (String)"subKey");
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        this.serializer = serializer;
        this.group = group;
        this.subKey = subKey;
        this.controller = controller;
        this.settingDescriptor$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> SettingImpl.settingDescriptor_delegate$lambda$0(this));
    }

    private final SettingDescriptor<T> getSettingDescriptor() {
        Lazy lazy = this.settingDescriptor$delegate;
        return (SettingDescriptor)lazy.getValue();
    }

    @Override
    @Nullable
    public T get() {
        return this.controller.getItem(this.getSettingDescriptor());
    }

    @Override
    @Nullable
    public Object set(@Nullable T value, @NotNull Continuation<? super Unit> $completion) {
        this.controller.setItem(this.getSettingDescriptor(), value);
        return Unit.INSTANCE;
    }

    private static final SettingDescriptor settingDescriptor_delegate$lambda$0(SettingImpl this$0) {
        return this$0.group.createSettingDescriptor(this$0.subKey, this$0.serializer);
    }
}

