/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.ide.ui.IdeUiService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileEditor.UnlockOption;
import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessExtension;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.WritingAccessProvider;
import com.intellij.openapi.vfs.ex.temp.TempFileSystemMarker;
import com.intellij.project.ProjectKt;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class NonProjectFileWritingAccessProvider
extends WritingAccessProvider {
    private static final Key<Boolean> ENABLE_IN_TESTS = Key.create((String)"NON_PROJECT_FILE_ACCESS_ENABLE_IN_TESTS");
    private static final Key<Boolean> HONOUR_RECENT_FILES_IN_TESTS = Key.create((String)"NON_PROJECT_FILE_ACCESS_HONOUR_RECENT_FILES_IN_TESTS");
    private static final NotNullLazyKey<AtomicInteger, UserDataHolder> ACCESS_ALLOWED = NotNullLazyKey.createLazyKey((String)"NON_PROJECT_FILE_ACCESS", holder -> new AtomicInteger());
    private static final AtomicBoolean myInitialized = new AtomicBoolean();
    @NotNull
    private final Project myProject;
    @Nullable
    private static NullableFunction<? super List<VirtualFile>, UnlockOption> ourCustomUnlocker;

    @TestOnly
    public static void setCustomUnlocker(@Nullable NullableFunction<? super List<VirtualFile>, UnlockOption> unlocker) {
        ourCustomUnlocker = unlocker;
    }

    public NonProjectFileWritingAccessProvider(@NotNull Project project) {
        if (project == null) {
            NonProjectFileWritingAccessProvider.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        if (myInitialized.compareAndSet(false, true)) {
            VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)new OurVirtualFileListener());
        }
    }

    @NotNull
    public Collection<VirtualFile> requestWriting(@NotNull Collection<? extends VirtualFile> files) {
        if (files == null) {
            NonProjectFileWritingAccessProvider.$$$reportNull$$$0(1);
        }
        if (NonProjectFileWritingAccessProvider.isAllAccessAllowed()) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                NonProjectFileWritingAccessProvider.$$$reportNull$$$0(2);
            }
            return list;
        }
        ArrayList<VirtualFile> deniedFiles = new ArrayList<VirtualFile>();
        for (VirtualFile virtualFile : files) {
            if (NonProjectFileWritingAccessProvider.isWriteAccessAllowed(virtualFile, this.myProject)) continue;
            deniedFiles.add(virtualFile);
        }
        if (deniedFiles.isEmpty()) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                NonProjectFileWritingAccessProvider.$$$reportNull$$$0(3);
            }
            return list;
        }
        UnlockOption unlockOption = this.askToUnlock(deniedFiles);
        if (unlockOption == null) {
            ArrayList<VirtualFile> arrayList = deniedFiles;
            if (arrayList == null) {
                NonProjectFileWritingAccessProvider.$$$reportNull$$$0(4);
            }
            return arrayList;
        }
        switch (unlockOption) {
            case UNLOCK: {
                NonProjectFileWritingAccessProvider.allowWriting(deniedFiles);
                break;
            }
            case UNLOCK_DIR: {
                NonProjectFileWritingAccessProvider.allowWriting(ContainerUtil.map(deniedFiles, VirtualFile::getParent));
                break;
            }
            case UNLOCK_ALL: {
                ((AtomicInteger)ACCESS_ALLOWED.getValue((UserDataHolder)NonProjectFileWritingAccessProvider.getApp())).incrementAndGet();
            }
        }
        List<VirtualFile> list = Collections.emptyList();
        if (list == null) {
            NonProjectFileWritingAccessProvider.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Nullable
    private UnlockOption askToUnlock(@NotNull List<VirtualFile> files) {
        if (files == null) {
            NonProjectFileWritingAccessProvider.$$$reportNull$$$0(6);
        }
        if (ourCustomUnlocker != null) {
            return (UnlockOption)ourCustomUnlocker.fun(files);
        }
        return IdeUiService.getInstance().askForUnlock(this.myProject, files);
    }

    public static boolean isWriteAccessAllowed(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            NonProjectFileWritingAccessProvider.$$$reportNull$$$0(7);
        }
        if (project == null) {
            NonProjectFileWritingAccessProvider.$$$reportNull$$$0(8);
        }
        if (LightEdit.owns((Project)project)) {
            return true;
        }
        if (NonProjectFileWritingAccessProvider.isAllAccessAllowed()) {
            return true;
        }
        if (file.isDirectory()) {
            return true;
        }
        if (!(file.getFileSystem() instanceof LocalFileSystem)) {
            return true;
        }
        if (file.getFileSystem() instanceof TempFileSystemMarker) {
            return true;
        }
        Application application = NonProjectFileWritingAccessProvider.getApp();
        boolean unitTestMode = application.isUnitTestMode();
        if ((!unitTestMode || HONOUR_RECENT_FILES_IN_TESTS.get((UserDataHolder)application) == Boolean.TRUE) && IdeUiService.getInstance().isFileRecentlyChanged(project, file)) {
            return true;
        }
        if (!unitTestMode && FileUtil.isAncestor((File)new File(FileUtil.getTempDirectory()), (File)VfsUtilCore.virtualToIoFile((VirtualFile)file), (boolean)true)) {
            return true;
        }
        for (VirtualFile each = file; each != null; each = each.getParent()) {
            if (((AtomicInteger)ACCESS_ALLOWED.getValue((UserDataHolder)each)).get() <= 0) continue;
            return true;
        }
        return NonProjectFileWritingAccessProvider.isProjectFile(file, project);
    }

    private static boolean isProjectFile(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            NonProjectFileWritingAccessProvider.$$$reportNull$$$0(9);
        }
        if (project == null) {
            NonProjectFileWritingAccessProvider.$$$reportNull$$$0(10);
        }
        for (NonProjectFileWritingAccessExtension each : NonProjectFileWritingAccessExtension.EP_NAME.getExtensionList((AreaInstance)project)) {
            if (each.isWritable(file)) {
                return true;
            }
            if (!each.isNotWritable(file)) continue;
            return false;
        }
        ProjectFileIndex fileIndex = ProjectFileIndex.getInstance((Project)project);
        if (fileIndex.isInContent(file)) {
            return true;
        }
        if (!Registry.is((String)"ide.hide.excluded.files") && fileIndex.isExcluded(file) && !fileIndex.isUnderIgnored(file)) {
            return true;
        }
        if (project instanceof ProjectEx && !project.isDefault()) {
            if (ProjectKt.getStateStore((Project)project).isProjectFile(file)) {
                return true;
            }
            String filePath = file.getPath();
            for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                if (!VfsUtilCore.pathEqualsTo((VirtualFile)file, (String)module.getModuleFilePath())) continue;
                return true;
            }
        }
        return false;
    }

    @Deprecated(forRemoval=true)
    public static void allowWriting(VirtualFile ... allowedFiles) {
        NonProjectFileWritingAccessProvider.allowWriting(Arrays.asList(allowedFiles));
    }

    public static void allowWriting(Iterable<? extends VirtualFile> allowedFiles) {
        for (VirtualFile virtualFile : allowedFiles) {
            ((AtomicInteger)ACCESS_ALLOWED.getValue((UserDataHolder)virtualFile)).incrementAndGet();
        }
    }

    public static void disableChecksDuring(@NotNull Runnable runnable) {
        if (runnable == null) {
            NonProjectFileWritingAccessProvider.$$$reportNull$$$0(11);
        }
        Application app = NonProjectFileWritingAccessProvider.getApp();
        ((AtomicInteger)ACCESS_ALLOWED.getValue((UserDataHolder)app)).incrementAndGet();
        try {
            runnable.run();
        }
        finally {
            ((AtomicInteger)ACCESS_ALLOWED.getValue((UserDataHolder)app)).decrementAndGet();
        }
    }

    @TestOnly
    public static void enableChecksInTests(@NotNull Disposable disposable) {
        if (disposable == null) {
            NonProjectFileWritingAccessProvider.$$$reportNull$$$0(12);
        }
        NonProjectFileWritingAccessProvider.enableChecksInTests(false, disposable);
    }

    @TestOnly
    public static void enableChecksInTests(@Nullable Boolean honourRecentFiles, @NotNull Disposable disposable) {
        if (disposable == null) {
            NonProjectFileWritingAccessProvider.$$$reportNull$$$0(13);
        }
        NonProjectFileWritingAccessProvider.getApp().putUserData(ENABLE_IN_TESTS, (Object)Boolean.TRUE);
        NonProjectFileWritingAccessProvider.getApp().putUserData(HONOUR_RECENT_FILES_IN_TESTS, (Object)honourRecentFiles);
        NonProjectFileWritingAccessProvider.getApp().putUserData(ACCESS_ALLOWED, null);
        Disposer.register((Disposable)disposable, () -> {
            NonProjectFileWritingAccessProvider.getApp().putUserData(ENABLE_IN_TESTS, null);
            NonProjectFileWritingAccessProvider.getApp().putUserData(HONOUR_RECENT_FILES_IN_TESTS, null);
            NonProjectFileWritingAccessProvider.getApp().putUserData(ACCESS_ALLOWED, null);
        });
    }

    private static boolean isAllAccessAllowed() {
        Application app = NonProjectFileWritingAccessProvider.getApp();
        if (app.isUnitTestMode() && app.getUserData(ENABLE_IN_TESTS) != Boolean.TRUE) {
            return true;
        }
        return ((AtomicInteger)ACCESS_ALLOWED.getValue((UserDataHolder)app)).get() > 0;
    }

    private static Application getApp() {
        return ApplicationManager.getApplication();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/impl/NonProjectFileWritingAccessProvider";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/NonProjectFileWritingAccessProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "requestWriting";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "requestWriting";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "askToUnlock";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isWriteAccessAllowed";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isProjectFile";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "disableChecksDuring";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "enableChecksInTests";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5 -> new IllegalStateException(string);
        };
    }

    private static final class OurVirtualFileListener
    implements VirtualFileListener {
        private OurVirtualFileListener() {
        }

        public void fileCreated(@NotNull VirtualFileEvent event) {
            if (event == null) {
                OurVirtualFileListener.$$$reportNull$$$0(0);
            }
            OurVirtualFileListener.unlock(event);
        }

        public void fileCopied(@NotNull VirtualFileCopyEvent event) {
            if (event == null) {
                OurVirtualFileListener.$$$reportNull$$$0(1);
            }
            OurVirtualFileListener.unlock((VirtualFileEvent)event);
        }

        private static void unlock(@NotNull VirtualFileEvent event) {
            if (event == null) {
                OurVirtualFileListener.$$$reportNull$$$0(2);
            }
            if (!event.isFromRefresh() && !event.getFile().isDirectory()) {
                NonProjectFileWritingAccessProvider.allowWriting(Collections.singletonList(event.getFile()));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/intellij/openapi/fileEditor/impl/NonProjectFileWritingAccessProvider$OurVirtualFileListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileCreated";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileCopied";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "unlock";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

