/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.util.PartiallyKnownStringKt;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.psi.util.SplitEscaper;
import com.intellij.psi.util.StringEntry;
import com.intellij.util.SmartList;
import com.intellij.util.containers.UtilKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 52\u00020\u0001:\u00015B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\bB#\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0005\u0010\u000fB\u0011\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u0005\u0010\u0010J\n\u0010\u0018\u001a\u00020\nH\u0096\u0080\u0004J\u001a\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\n2\b\b\u0002\u0010\u001c\u001a\u00020\u001aH\u0007J\u0018\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u000eH\u0002J \u0010 \u001a\u00020!2\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020\u000eH\u0002J\u001a\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00000%2\u0006\u0010&\u001a\u00020\u001aJ0\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00000\u00032\u0006\u0010\u001b\u001a\u00020\n2\u001a\b\u0002\u0010(\u001a\u0014\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020+0)J\u0018\u0010,\u001a\u0004\u0018\u00010\u000e2\u0006\u0010-\u001a\u00020\f2\u0006\u0010#\u001a\u00020\u000eJ\"\u0010,\u001a\u0004\u0018\u00010\u000e2\u0006\u0010-\u001a\u00020\f2\u0006\u0010.\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020\u000eH\u0002J\u0010\u0010/\u001a\u0004\u0018\u00010\u000e2\u0006\u00100\u001a\u00020\fJ\u0014\u00101\u001a\u0002022\b\u00103\u001a\u0004\u0018\u00010\u0001H\u0096\u0082\u0004J\n\u00104\u001a\u00020\u001aH\u0096\u0080\u0004R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0013\u001a\u0004\u0018\u00010\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015\u00a8\u00066"}, d2={"Lcom/intellij/psi/util/PartiallyKnownString;", "", "segments", "", "Lcom/intellij/psi/util/StringEntry;", "<init>", "(Ljava/util/List;)V", "single", "(Lcom/intellij/psi/util/StringEntry;)V", "string", "", "sourcePsi", "Lcom/intellij/psi/PsiElement;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "(Ljava/lang/String;Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/util/TextRange;)V", "(Ljava/lang/String;)V", "getSegments", "()Ljava/util/List;", "valueIfKnown", "getValueIfKnown", "()Ljava/lang/String;", "concatenationOfKnown", "getConcatenationOfKnown", "toString", "findIndexOfInKnown", "", "pattern", "startFrom", "rangeForSubElement", "parent", "partRange", "buildSegmentWithMappedRange", "Lcom/intellij/psi/util/StringEntry$Known;", "value", "rangeInPks", "splitAtInKnown", "Lkotlin/Pair;", "splitAt", "split", "escaperFactory", "Lkotlin/Function2;", "", "Lcom/intellij/psi/util/SplitEscaper;", "mapRangeToHostRange", "host", "rangeInHost", "getRangeInHost", "originalHost", "equals", "", "other", "hashCode", "Companion", "intellij.platform.lang"})
@SourceDebugExtension(value={"SMAP\nPartiallyKnownString.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PartiallyKnownString.kt\ncom/intellij/psi/util/PartiallyKnownString\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,352:1\n1#2:353\n2829#3,7:354\n1586#3:361\n1661#3,3:362\n13#4:365\n13#4:366\n*S KotlinDebug\n*F\n+ 1 PartiallyKnownString.kt\ncom/intellij/psi/util/PartiallyKnownString\n*L\n244#1:354,7\n152#1:361\n152#1:362,3\n195#1:365\n205#1:366\n*E\n"})
public final class PartiallyKnownString {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<StringEntry> segments;
    @NotNull
    private static final PartiallyKnownString empty = new PartiallyKnownString(CollectionsKt.emptyList());

    public PartiallyKnownString(@NotNull List<? extends StringEntry> segments) {
        Intrinsics.checkNotNullParameter(segments, (String)"segments");
        this.segments = segments;
    }

    @NotNull
    public final List<StringEntry> getSegments() {
        return this.segments;
    }

    @Nullable
    public final String getValueIfKnown() {
        StringEntry.Known known;
        Iterator<StringEntry> iterator = CollectionsKt.singleOrNull(this.segments);
        StringEntry.Known known2 = known = iterator instanceof StringEntry.Known ? (StringEntry.Known)((Object)iterator) : null;
        if (known != null) {
            StringEntry.Known it = known;
            boolean bl = false;
            return it.getValue();
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (StringEntry segment : this.segments) {
            StringEntry stringEntry = segment;
            if (stringEntry instanceof StringEntry.Known) {
                stringBuffer.append(((StringEntry.Known)segment).getValue());
                continue;
            }
            if (stringEntry instanceof StringEntry.Unknown) {
                return null;
            }
            throw new NoWhenBranchMatchedException();
        }
        return stringBuffer.toString();
    }

    @NotNull
    public final String getConcatenationOfKnown() {
        StringEntry.Known known;
        Iterator<StringEntry> iterator = CollectionsKt.singleOrNull(this.segments);
        StringEntry.Known known2 = known = iterator instanceof StringEntry.Known ? (StringEntry.Known)((Object)iterator) : null;
        if (known != null) {
            StringEntry.Known it = known;
            boolean bl = false;
            return it.getValue();
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (StringEntry segment : this.segments) {
            if (!(segment instanceof StringEntry.Known)) continue;
            stringBuffer.append(((StringEntry.Known)segment).getValue());
        }
        String string = stringBuffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public String toString() {
        return CollectionsKt.joinToString$default((Iterable)this.segments, null, null, null, (int)0, null, PartiallyKnownString::toString$lambda$0, (int)31, null);
    }

    public PartiallyKnownString(@NotNull StringEntry single) {
        Intrinsics.checkNotNullParameter((Object)single, (String)"single");
        this(CollectionsKt.listOf((Object)single));
    }

    public PartiallyKnownString(@NotNull String string, @Nullable PsiElement sourcePsi, @NotNull TextRange textRange) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
        this(new StringEntry.Known(string, sourcePsi, textRange));
    }

    public PartiallyKnownString(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        TextRange textRange = TextRange.EMPTY_RANGE;
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"EMPTY_RANGE");
        this(string, null, textRange);
    }

    @JvmOverloads
    public final int findIndexOfInKnown(@NotNull String pattern, int startFrom) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        int accumulated = 0;
        for (StringEntry segment : this.segments) {
            StringEntry stringEntry = segment;
            if (stringEntry instanceof StringEntry.Known) {
                int i = StringsKt.indexOf$default((CharSequence)((StringEntry.Known)segment).getValue(), (String)pattern, (int)(startFrom - accumulated), (boolean)false, (int)4, null);
                if (i >= 0) {
                    return accumulated + i;
                }
                accumulated += ((StringEntry.Known)segment).getValue().length();
                continue;
            }
            if (stringEntry instanceof StringEntry.Unknown) continue;
            throw new NoWhenBranchMatchedException();
        }
        return -1;
    }

    public static /* synthetic */ int findIndexOfInKnown$default(PartiallyKnownString partiallyKnownString, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return partiallyKnownString.findIndexOfInKnown(string, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final TextRange rangeForSubElement(StringEntry parent, TextRange partRange) {
        TextRange textRange;
        Pair<PsiElement, TextRange> pair = parent.getRangeAlignedToHost();
        if (pair != null) {
            TextRange textRange2;
            TextRange textRange3;
            Pair<PsiElement, TextRange> pair2 = pair;
            boolean bl = false;
            PsiElement host = (PsiElement)pair2.component1();
            TextRange hostRange = (TextRange)pair2.component2();
            TextRange textRange4 = this.mapRangeToHostRange(host, hostRange, partRange);
            if (textRange4 != null) {
                PsiElement psiElement = parent.getSourcePsi();
                Intrinsics.checkNotNull((Object)psiElement);
                textRange3 = textRange4.shiftLeft(PsiTreeUtilKt.getStartOffset((PsiElement)psiElement) - PsiTreeUtilKt.getStartOffset((PsiElement)host));
            } else {
                textRange3 = null;
            }
            if ((textRange2 = textRange3) != null) {
                textRange = textRange2;
                return textRange;
            }
        }
        TextRange textRange5 = partRange.shiftRight(parent.getRange().getStartOffset());
        textRange = textRange5;
        Intrinsics.checkNotNullExpressionValue((Object)textRange5, (String)"shiftRight(...)");
        return textRange;
    }

    private final StringEntry.Known buildSegmentWithMappedRange(StringEntry parent, String value, TextRange rangeInPks) {
        return new StringEntry.Known(value, parent.getSourcePsi(), this.rangeForSubElement(parent, rangeInPks));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Pair<PartiallyKnownString, PartiallyKnownString> splitAtInKnown(int splitAt) {
        int accumulated = 0;
        SmartList left = new SmartList();
        Iterator iterator = ((Iterable)this.segments).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            boolean bl;
            int i = n++;
            StringEntry segment = (StringEntry)iterator.next();
            StringEntry stringEntry = segment;
            if (stringEntry instanceof StringEntry.Known) {
                void $this$splitAtInKnown_u24lambda_u240;
                ArrayList arrayList;
                if (accumulated + ((StringEntry.Known)segment).getValue().length() < splitAt) {
                    accumulated += ((StringEntry.Known)segment).getValue().length();
                    bl = left.add((Object)segment);
                    continue;
                }
                String string = ((StringEntry.Known)segment).getValue().substring(0, splitAt - accumulated);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String leftPart = string;
                String string2 = ((StringEntry.Known)segment).getValue().substring(splitAt - accumulated);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                String rightPart = string2;
                TextRange textRange = TextRange.from((int)0, (int)leftPart.length());
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"from(...)");
                left.add((Object)this.buildSegmentWithMappedRange(segment, leftPart, textRange));
                ArrayList arrayList2 = arrayList = new ArrayList(CollectionsKt.getLastIndex(this.segments) - i + 1);
                PartiallyKnownString partiallyKnownString = new PartiallyKnownString((List)left);
                boolean bl2 = false;
                if (((CharSequence)rightPart).length() > 0) {
                    TextRange textRange2 = TextRange.from((int)leftPart.length(), (int)rightPart.length());
                    Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"from(...)");
                    $this$splitAtInKnown_u24lambda_u240.add(this.buildSegmentWithMappedRange(segment, rightPart, textRange2));
                }
                $this$splitAtInKnown_u24lambda_u240.addAll((Collection)this.segments.subList(i + 1, this.segments.size()));
                List list = arrayList;
                return TuplesKt.to((Object)partiallyKnownString, (Object)new PartiallyKnownString(list));
            }
            if (stringEntry instanceof StringEntry.Unknown) {
                bl = left.add((Object)segment);
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
        return TuplesKt.to((Object)this, (Object)empty);
    }

    @NotNull
    public final List<PartiallyKnownString> split(@NotNull String pattern, @NotNull Function2<? super CharSequence, ? super String, ? extends SplitEscaper> escaperFactory) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter(escaperFactory, (String)"escaperFactory");
        return PartiallyKnownString.split$collectPaths(pattern, escaperFactory, this, (List)new SmartList(), new ArrayList(), this.segments);
    }

    public static /* synthetic */ List split$default(PartiallyKnownString partiallyKnownString, String string, Function2 function2, int n, Object object) {
        if ((n & 2) != 0) {
            function2 = PartiallyKnownString::split$lambda$0;
        }
        return partiallyKnownString.split(string, (Function2<? super CharSequence, ? super String, ? extends SplitEscaper>)function2);
    }

    @Nullable
    public final TextRange mapRangeToHostRange(@NotNull PsiElement host, @NotNull TextRange rangeInPks) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)rangeInPks, (String)"rangeInPks");
        TextRange textRange = ElementManipulators.getValueTextRange((PsiElement)host);
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getValueTextRange(...)");
        return this.mapRangeToHostRange(host, textRange, rangeInPks);
    }

    private final TextRange mapRangeToHostRange(PsiElement host, TextRange rangeInHost, TextRange rangeInPks) {
        int accumulated = 0;
        for (StringEntry segment : this.segments) {
            Pair<PsiElement, TextRange> pair;
            if (!(segment instanceof StringEntry.Known) || segment.getRangeAlignedToHost() == null) continue;
            PsiElement segmentHost = (PsiElement)pair.component1();
            TextRange segmentRangeInHost = (TextRange)pair.component2();
            if (!Intrinsics.areEqual((Object)segmentHost, (Object)host) || !rangeInHost.contains(segmentRangeInHost)) continue;
            int segmentEnd = accumulated + ((StringEntry.Known)segment).getValue().length();
            if (rangeInPks.getStartOffset() >= accumulated && rangeInPks.getEndOffset() <= segmentEnd) {
                int inSegmentStart = rangeInPks.getStartOffset() - accumulated;
                int inSegmentEnd = rangeInPks.getEndOffset() - accumulated;
                return PartiallyKnownString.mapRangeToHostRange$getHostRangeEscapeAware(host, segmentRangeInHost, inSegmentStart, inSegmentEnd);
            }
            accumulated = segmentEnd;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final TextRange getRangeInHost(@NotNull PsiElement originalHost) {
        Intrinsics.checkNotNullParameter((Object)originalHost, (String)"originalHost");
        List ranges2 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)this.segments), arg_0 -> PartiallyKnownString.getRangeInHost$lambda$0(originalHost, arg_0)), PartiallyKnownString::getRangeInHost$lambda$1));
        if (ranges2.isEmpty()) {
            return null;
        }
        Iterable $this$reduce$iv = ranges2;
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void p1;
            TextRange textRange = (TextRange)iterator$iv.next();
            TextRange p0 = (TextRange)accumulator$iv;
            boolean bl = false;
            accumulator$iv = p0.union((TextRange)p1);
        }
        return (TextRange)accumulator$iv;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Object object2 = other;
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.intellij.psi.util.PartiallyKnownString");
        PartiallyKnownString cfr_ignored_0 = (PartiallyKnownString)object2;
        return Intrinsics.areEqual(this.segments, ((PartiallyKnownString)other).segments);
    }

    public int hashCode() {
        return ((Object)this.segments).hashCode();
    }

    @JvmOverloads
    public final int findIndexOfInKnown(@NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        return PartiallyKnownString.findIndexOfInKnown$default(this, pattern, 0, 2, null);
    }

    private static final CharSequence toString$lambda$0(StringEntry segment) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)segment, (String)"segment");
        StringEntry stringEntry = segment;
        if (stringEntry instanceof StringEntry.Known) {
            charSequence = ((StringEntry.Known)segment).getValue();
        } else if (stringEntry instanceof StringEntry.Unknown) {
            charSequence = "<???>";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return charSequence;
    }

    private static final SplitEscaper split$lambda$0(CharSequence charSequence, String string) {
        Intrinsics.checkNotNullParameter((Object)charSequence, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        return SplitEscaper.AcceptAll.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<PartiallyKnownString> split$collectPaths(String $pattern, Function2<? super CharSequence, ? super String, ? extends SplitEscaper> $escaperFactory, PartiallyKnownString this$0, List<PartiallyKnownString> result, List<StringEntry> pending, List<? extends StringEntry> segments) {
        while (true) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$split_u24collectPaths_u24lambda_u244_u240;
            Iterable<StringEntry> iterable2;
            List list;
            List<Object> list2;
            Pair pair;
            if (UtilKt.headTailOrNull(segments) == null) {
                List<PartiallyKnownString> list3;
                List<PartiallyKnownString> $this$split_u24collectPaths_u24lambda_u241 = list3 = result;
                boolean bl = false;
                $this$split_u24collectPaths_u24lambda_u241.add(new PartiallyKnownString(pending));
                return list3;
            }
            StringEntry head = (StringEntry)pair.component1();
            List tail = (List)pair.component2();
            StringEntry stringEntry = head;
            if (stringEntry instanceof StringEntry.Unknown) {
                List<PartiallyKnownString> bl = result;
                List<StringEntry> $this$split_u24collectPaths_u24lambda_u242 = list2 = pending;
                boolean bl2 = false;
                $this$split_u24collectPaths_u24lambda_u242.add(head);
                List<StringEntry> list4 = list2;
                result = bl;
                pending = list4;
                segments = tail;
                continue;
            }
            if (!(stringEntry instanceof StringEntry.Known)) break;
            String value = ((StringEntry.Known)head).getValue();
            List stringParts = SequencesKt.toList(PartiallyKnownStringKt.splitToTextRanges(value, $pattern, $escaperFactory));
            if (stringParts.size() == 1) {
                List<StringEntry> bl2;
                list2 = result;
                List<StringEntry> $this$split_u24collectPaths_u24lambda_u243 = bl2 = pending;
                boolean iterable2 = false;
                $this$split_u24collectPaths_u24lambda_u243.add(head);
                list = bl2;
                result = list2;
                pending = list;
                segments = tail;
                continue;
            }
            list = result;
            List<PartiallyKnownString> $this$split_u24collectPaths_u24lambda_u244 = list;
            boolean bl = false;
            List<StringEntry> list5 = iterable2 = pending;
            List<PartiallyKnownString> list6 = $this$split_u24collectPaths_u24lambda_u244;
            boolean $i$a$-apply-PartiallyKnownString$split$collectPaths$4$22 = false;
            String string = ((TextRange)CollectionsKt.first((List)stringParts)).substring(value);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            $this$split_u24collectPaths_u24lambda_u244_u240.add(new StringEntry.Known(string, ((StringEntry.Known)head).getSourcePsi(), this$0.rangeForSubElement(head, (TextRange)CollectionsKt.first((List)stringParts))));
            List<StringEntry> list7 = iterable2;
            list6.add(new PartiallyKnownString(list7));
            iterable2 = stringParts.subList(1, stringParts.size() - 1);
            list6 = $this$split_u24collectPaths_u24lambda_u244;
            boolean $i$f$map = false;
            void $i$a$-apply-PartiallyKnownString$split$collectPaths$4$22 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                TextRange textRange = (TextRange)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                String string2 = it.substring(value);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                collection.add(new PartiallyKnownString(string2, ((StringEntry.Known)head).getSourcePsi(), this$0.rangeForSubElement(head, (TextRange)it)));
            }
            list6.addAll((List)destination$iv$iv);
            list2 = list;
            Object[] objectArray = new StringEntry[1];
            String string3 = ((TextRange)CollectionsKt.last((List)stringParts)).substring(value);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            objectArray[0] = new StringEntry.Known(string3, ((StringEntry.Known)head).getSourcePsi(), this$0.rangeForSubElement(head, (TextRange)CollectionsKt.last((List)stringParts)));
            list = CollectionsKt.mutableListOf((Object[])objectArray);
            result = list2;
            pending = list;
            segments = tail;
        }
        throw new NoWhenBranchMatchedException();
    }

    private static final TextRange mapRangeToHostRange$getHostRangeEscapeAware(PsiElement $host, TextRange segmentRange, int inSegmentStart, int inSegmentEnd) {
        if ($host instanceof PsiLanguageInjectionHost) {
            try {
                LiteralTextEscaper literalTextEscaper = ((PsiLanguageInjectionHost)$host).createLiteralTextEscaper();
                Intrinsics.checkNotNullExpressionValue((Object)literalTextEscaper, (String)"createLiteralTextEscaper(...)");
                LiteralTextEscaper escaper = literalTextEscaper;
                boolean decode = escaper.decode(segmentRange, new StringBuilder());
                if (decode) {
                    int start = escaper.getOffsetInHost(inSegmentStart, segmentRange);
                    int end = escaper.getOffsetInHost(inSegmentEnd, segmentRange);
                    if (start != -1 && end != -1 && start <= end) {
                        return new TextRange(start, end);
                    }
                    boolean $i$f$logger = false;
                    Logger logger = Logger.getInstance(PartiallyKnownString.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    Attachment[] attachmentArray = PartiallyKnownStringKt.mkAttachments($host);
                    logger.error("decoding of " + segmentRange + " failed for " + $host + " : [" + start + ", " + end + "] inSegment = [" + inSegmentStart + ", " + inSegmentEnd + "]", Arrays.copyOf(attachmentArray, attachmentArray.length));
                    return new TextRange(segmentRange.getStartOffset() + inSegmentStart, segmentRange.getStartOffset() + inSegmentEnd);
                }
            }
            catch (Exception e) {
                if (e instanceof ControlFlowException) {
                    throw e;
                }
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(PartiallyKnownString.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                Attachment[] attachmentArray = PartiallyKnownStringKt.mkAttachments($host);
                logger.error("decoding of " + segmentRange + " failed for " + $host + " inSegment = [" + inSegmentStart + ", " + inSegmentEnd + "]", (Throwable)e, Arrays.copyOf(attachmentArray, attachmentArray.length));
            }
        }
        return new TextRange(segmentRange.getStartOffset() + inSegmentStart, segmentRange.getStartOffset() + inSegmentEnd);
    }

    private static final Pair getRangeInHost$lambda$0(PsiElement $originalHost, StringEntry s) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Pair<PsiElement, TextRange> pair = s.getRangeAlignedToHost();
        if (pair != null) {
            Pair<PsiElement, TextRange> pair2;
            Pair<PsiElement, TextRange> it = pair2 = pair;
            boolean bl = false;
            object = Intrinsics.areEqual((Object)it.getFirst(), (Object)$originalHost) ? pair2 : null;
        } else {
            object = null;
        }
        return object;
    }

    private static final TextRange getRangeInHost$lambda$1(Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (TextRange)it.getSecond();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/psi/util/PartiallyKnownString$Companion;", "", "<init>", "()V", "empty", "Lcom/intellij/psi/util/PartiallyKnownString;", "getEmpty", "()Lcom/intellij/psi/util/PartiallyKnownString;", "intellij.platform.lang"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PartiallyKnownString getEmpty() {
            return empty;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

