/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.PsiLocation;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Location<E extends PsiElement> {
    public static final DataKey<Location<?>> DATA_KEY = DataKey.create((String)"Location");
    public static final DataKey<Location<?>[]> DATA_KEYS = DataKey.create((String)"LocationArray");

    @NotNull
    public abstract E getPsiElement();

    @NotNull
    public abstract Project getProject();

    @NotNull
    public abstract <T extends PsiElement> Iterator<Location<T>> getAncestors(Class<T> var1, boolean var2);

    @Nullable
    public VirtualFile getVirtualFile() {
        E psiElement = this.getPsiElement();
        if (psiElement.isValid()) {
            VirtualFile virtualFile;
            if (psiElement instanceof PsiFileSystemItem) {
                return ((PsiFileSystemItem)psiElement).getVirtualFile();
            }
            PsiFile psiFile = psiElement.getContainingFile();
            if (psiFile != null && (virtualFile = psiFile.getVirtualFile()) != null && virtualFile.isValid()) {
                return virtualFile;
            }
        }
        return null;
    }

    public Navigatable getNavigatable() {
        return this.getOpenFileDescriptor();
    }

    @Nullable
    public OpenFileDescriptor getOpenFileDescriptor() {
        VirtualFile file = this.getVirtualFile();
        return file != null ? new OpenFileDescriptor(this.getProject(), file, this.getPsiElement().getTextOffset()) : null;
    }

    @Nullable
    public <Ancestor extends PsiElement> Location<Ancestor> getParent(Class<Ancestor> parentClass) {
        Location<PsiElement> parent;
        Iterator<Location<PsiElement>> ancestors = this.getAncestors(PsiElement.class, true);
        if (ancestors.hasNext() && parentClass.isInstance((parent = ancestors.next()).getPsiElement())) {
            Location<PsiElement> location = parent;
            return location;
        }
        return null;
    }

    @Nullable
    public <Ancestor extends PsiElement> Ancestor getParentElement(Class<Ancestor> parentClass) {
        return Location.safeGetPsiElement(this.getParent(parentClass));
    }

    @Nullable
    public static <T extends PsiElement> T safeGetPsiElement(Location<T> location) {
        return location != null ? (T)location.getPsiElement() : null;
    }

    @Nullable
    public static <T> T safeCast(Object obj, Class<T> expectedClass) {
        if (expectedClass.isInstance(obj)) {
            Object t = obj;
            return (T)t;
        }
        return null;
    }

    @NotNull
    public PsiLocation<E> toPsiLocation() {
        return new PsiLocation<E>(this.getProject(), this.getPsiElement());
    }

    @Nullable
    public abstract Module getModule();
}

