/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.impl.common;

import com.intellij.ide.structureView.StructureViewExtension;
import com.intellij.ide.structureView.StructureViewFactoryEx;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.customRegions.CustomRegionStructureUtil;
import com.intellij.ide.util.treeView.NodeDescriptorProvidingKey;
import com.intellij.ide.util.treeView.TreeAnchorizer;
import com.intellij.navigation.ItemPresentation;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public abstract class PsiTreeElementBase<T extends PsiElement>
implements StructureViewTreeElement,
ItemPresentation,
NodeDescriptorProvidingKey {
    private final Object myValue;

    protected PsiTreeElementBase(T psiElement) {
        this.myValue = psiElement == null ? null : TreeAnchorizer.getService().createAnchor(psiElement);
    }

    @Override
    @NotNull
    public ItemPresentation getPresentation() {
        PsiTreeElementBase psiTreeElementBase = this;
        if (psiTreeElementBase == null) {
            PsiTreeElementBase.$$$reportNull$$$0(0);
        }
        return psiTreeElementBase;
    }

    @Override
    @NotNull
    public Object getKey() {
        String string = String.valueOf(this.getElement());
        if (string == null) {
            PsiTreeElementBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public final T getElement() {
        return (T)(this.myValue == null ? null : (PsiElement)TreeAnchorizer.getService().retrieveElement(this.myValue));
    }

    public Icon getIcon(boolean open) {
        T element = this.getElement();
        if (element != null) {
            int flags = 2;
            if (!(element instanceof PsiFile) || !element.isWritable()) {
                flags |= 1;
            }
            return element.getIcon(flags);
        }
        return null;
    }

    public T getValue() {
        return this.getElement();
    }

    public boolean isSearchInLocationString() {
        return false;
    }

    public String toString() {
        T element = this.getElement();
        return element != null ? element.toString() : "";
    }

    public final StructureViewTreeElement @NotNull [] getChildren() {
        List<StructureViewTreeElement> list2 = this.doGetChildren(true);
        StructureViewTreeElement[] structureViewTreeElementArray = list2.isEmpty() ? EMPTY_ARRAY : list2.toArray(EMPTY_ARRAY);
        if (structureViewTreeElementArray == null) {
            PsiTreeElementBase.$$$reportNull$$$0(2);
        }
        return structureViewTreeElementArray;
    }

    @NotNull
    public final List<StructureViewTreeElement> getChildrenWithoutCustomRegions() {
        return this.doGetChildren(false);
    }

    @NotNull
    private List<StructureViewTreeElement> doGetChildren(boolean withCustomRegions) {
        T element = this.getElement();
        if (element == null) {
            List<StructureViewTreeElement> list2 = Collections.emptyList();
            if (list2 == null) {
                PsiTreeElementBase.$$$reportNull$$$0(3);
            }
            return list2;
        }
        Collection<StructureViewTreeElement> baseChildren = this.getChildrenBase();
        if (!this.isAllowExtensions()) {
            List<StructureViewTreeElement> list3;
            if (baseChildren instanceof List) {
                List list4 = (List)baseChildren;
                list3 = list4;
            } else {
                list3 = new ArrayList<StructureViewTreeElement>(baseChildren);
            }
            return list3;
        }
        return PsiTreeElementBase.mergeWithExtensions(element, baseChildren, withCustomRegions);
    }

    public void navigate(boolean requestFocus) {
        T element = this.getElement();
        if (element != null) {
            ((Navigatable)element).navigate(requestFocus);
        }
    }

    public boolean canNavigate() {
        T element = this.getElement();
        return element instanceof Navigatable && ((Navigatable)element).canNavigate();
    }

    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    public abstract @Unmodifiable @NotNull Collection<StructureViewTreeElement> getChildrenBase();

    @ApiStatus.Internal
    public boolean isAllowExtensions() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PsiTreeElementBase that = (PsiTreeElementBase)o;
        T value = this.getValue();
        return value == null ? that.getValue() == null : value.equals(that.getValue());
    }

    public int hashCode() {
        T value = this.getValue();
        return value == null ? 0 : value.hashCode();
    }

    public boolean isValid() {
        return this.getElement() != null;
    }

    @ApiStatus.Internal
    @NotNull
    public static List<StructureViewTreeElement> mergeWithExtensions(@NotNull PsiElement element, @NotNull Collection<StructureViewTreeElement> baseChildren, boolean withCustomRegions) {
        if (element == null) {
            PsiTreeElementBase.$$$reportNull$$$0(4);
        }
        if (baseChildren == null) {
            PsiTreeElementBase.$$$reportNull$$$0(5);
        }
        ArrayList<StructureViewTreeElement> result2 = new ArrayList<StructureViewTreeElement>(withCustomRegions ? CustomRegionStructureUtil.groupByCustomRegions(element, baseChildren) : baseChildren);
        StructureViewFactoryEx structureViewFactory = StructureViewFactoryEx.getInstanceEx(element.getProject());
        Class aClass = element.getClass();
        for (StructureViewExtension extension : structureViewFactory.getAllExtensions(aClass)) {
            Object[] children = extension.getChildren(element);
            if (children != null) {
                ContainerUtil.addAll(result2, (Object[])children);
            }
            extension.filterChildren(result2, children == null || children.length == 0 ? Collections.emptyList() : Arrays.asList(children));
        }
        ArrayList<StructureViewTreeElement> arrayList = result2;
        if (arrayList == null) {
            PsiTreeElementBase.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/structureView/impl/common/PsiTreeElementBase";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetChildren";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/structureView/impl/common/PsiTreeElementBase";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeWithExtensions";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "mergeWithExtensions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

