/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.ex.util;

import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.util.DataStorage;
import com.intellij.openapi.editor.ex.util.LayerDescriptor;
import com.intellij.openapi.editor.ex.util.LayeredHighlighterIterator;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.ex.util.LimitedRangeHighlighterIterator;
import com.intellij.openapi.editor.ex.util.SegmentArray;
import com.intellij.openapi.editor.ex.util.SegmentArrayWithData;
import com.intellij.openapi.editor.highlighter.HighlighterClient;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.text.MergingCharSequence;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LayeredLexerEditorHighlighter
extends LexerEditorHighlighter {
    private static final Logger LOG = Logger.getInstance(LayeredLexerEditorHighlighter.class);
    private final Map<IElementType, LayerDescriptor> myTokensToLayer;

    public LayeredLexerEditorHighlighter(@NotNull SyntaxHighlighter highlighter, @NotNull EditorColorsScheme scheme) {
        if (highlighter == null) {
            LayeredLexerEditorHighlighter.$$$reportNull$$$0(0);
        }
        if (scheme == null) {
            LayeredLexerEditorHighlighter.$$$reportNull$$$0(1);
        }
        super(highlighter, scheme);
        this.myTokensToLayer = new HashMap<IElementType, LayerDescriptor>();
    }

    @Override
    @NotNull
    protected SegmentArrayWithData createSegments() {
        return new MappingSegments(this.createStorage());
    }

    @NotNull
    private MappingSegments getMappingSegments() {
        MappingSegments mappingSegments = (MappingSegments)this.getSegments();
        if (mappingSegments == null) {
            LayeredLexerEditorHighlighter.$$$reportNull$$$0(2);
        }
        return mappingSegments;
    }

    public synchronized void registerLayer(@NotNull IElementType tokenType, @NotNull LayerDescriptor layerHighlighter) {
        if (tokenType == null) {
            LayeredLexerEditorHighlighter.$$$reportNull$$$0(3);
        }
        if (layerHighlighter == null) {
            LayeredLexerEditorHighlighter.$$$reportNull$$$0(4);
        }
        this.myTokensToLayer.put(tokenType, layerHighlighter);
        this.getSegments().removeAll();
    }

    protected synchronized void unregisterLayer(@NotNull IElementType tokenType) {
        LayerDescriptor layer;
        if (tokenType == null) {
            LayeredLexerEditorHighlighter.$$$reportNull$$$0(5);
        }
        if ((layer = this.myTokensToLayer.remove(tokenType)) != null) {
            this.getMappingSegments().myLayerBuffers.remove(layer);
            this.getSegments().removeAll();
        }
    }

    @Override
    public void setText(@NotNull CharSequence text2) {
        if (text2 == null) {
            LayeredLexerEditorHighlighter.$$$reportNull$$$0(6);
        }
        if (this.updateLayers()) {
            this.resetText(text2);
        } else {
            super.setText(text2);
        }
    }

    @Override
    @NotNull
    protected LexerEditorHighlighter.TokenProcessor createTokenProcessor(final int startIndex, @NotNull SegmentArrayWithData segments, final @NotNull CharSequence text2) {
        if (segments == null) {
            LayeredLexerEditorHighlighter.$$$reportNull$$$0(7);
        }
        if (text2 == null) {
            LayeredLexerEditorHighlighter.$$$reportNull$$$0(8);
        }
        final MappingSegments mappingSegments = (MappingSegments)segments;
        return new LexerEditorHighlighter.TokenProcessor(){
            final Map<Mapper, LightMapper> docTexts = FactoryMap.create(key -> {
                MappedRange predecessor = key.findPredecessor(startIndex, mappingSegments);
                return new LightMapper((Mapper)key, predecessor != null ? predecessor.range.getEndOffset() : 0);
            });

            @Override
            public void addToken(int tokenIndex, int startOffset, int endOffset, int data, @NotNull IElementType tokenType) {
                if (tokenType == null) {
                    1.$$$reportNull$$$0(0);
                }
                mappingSegments.setElementLight(tokenIndex, startOffset, endOffset, data);
                Mapper mapper = mappingSegments.getMappingDocument(tokenType);
                if (mapper != null) {
                    this.docTexts.get(mapper).addToken(text2.subSequence(startOffset, endOffset), tokenType, tokenIndex);
                }
            }

            @Override
            public void finish() {
                this.docTexts.keySet().forEach(mapper -> mappingSegments.freezeHighlighter((Mapper)mapper));
                for (LightMapper mapper2 : this.docTexts.values()) {
                    mapper2.finish();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tokenType", "com/intellij/openapi/editor/ex/util/LayeredLexerEditorHighlighter$1", "addToken"));
            }
        };
    }

    protected boolean updateLayers() {
        return false;
    }

    protected boolean updateLayers(@NotNull DocumentEvent e) {
        if (e == null) {
            LayeredLexerEditorHighlighter.$$$reportNull$$$0(9);
        }
        return this.updateLayers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void documentChanged(@NotNull DocumentEvent e) {
        if (e == null) {
            LayeredLexerEditorHighlighter.$$$reportNull$$$0(10);
        }
        boolean changed = this.updateLayers(e);
        LayeredLexerEditorHighlighter layeredLexerEditorHighlighter = this;
        synchronized (layeredLexerEditorHighlighter) {
            if (changed) {
                super.setText(e.getDocument().getImmutableCharSequence());
            } else {
                super.documentChanged(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public HighlighterIterator createIterator(int startOffset) {
        LayeredLexerEditorHighlighter layeredLexerEditorHighlighter = this;
        // MONITORENTER : layeredLexerEditorHighlighter
        LayeredHighlighterIteratorImpl layeredHighlighterIteratorImpl = new LayeredHighlighterIteratorImpl(startOffset);
        // MONITOREXIT : layeredLexerEditorHighlighter
        if (layeredHighlighterIteratorImpl != null) return layeredHighlighterIteratorImpl;
        LayeredLexerEditorHighlighter.$$$reportNull$$$0(11);
        return layeredHighlighterIteratorImpl;
    }

    @NotNull
    public HighlighterIterator createBaseIterator(int startOffset) {
        HighlighterIterator highlighterIterator = super.createIterator(startOffset);
        if (highlighterIterator == null) {
            LayeredLexerEditorHighlighter.$$$reportNull$$$0(12);
        }
        return highlighterIterator;
    }

    @Override
    public void setColorScheme(@NotNull EditorColorsScheme scheme) {
        if (scheme == null) {
            LayeredLexerEditorHighlighter.$$$reportNull$$$0(13);
        }
        super.setColorScheme(scheme);
        for (MappedRange mapping : this.getMappingSegments().myRanges) {
            Mapper mapper;
            Mapper mapper2 = mapper = mapping == null ? null : mapping.mapper;
            if (mapper == null) continue;
            mapper.resetCachedTextAttributes();
        }
    }

    @Override
    protected boolean hasAdditionalData(int segmentIndex) {
        return this.getMappingSegments().myRanges[segmentIndex] != null;
    }

    private static MappedRange @NotNull [] reallocateArray(MappedRange @NotNull [] array, int index) {
        if (array == null) {
            LayeredLexerEditorHighlighter.$$$reportNull$$$0(14);
        }
        if (index < array.length) {
            if (array == null) {
                LayeredLexerEditorHighlighter.$$$reportNull$$$0(15);
            }
            return array;
        }
        MappedRange[] mappedRangeArray = (MappedRange[])ArrayUtil.realloc((Object[])array, (int)SegmentArray.calcCapacity((int)array.length, (int)index), MappedRange[]::new);
        if (mappedRangeArray == null) {
            LayeredLexerEditorHighlighter.$$$reportNull$$$0(16);
        }
        return mappedRangeArray;
    }

    @Override
    @NonNls
    public String toString() {
        return this.getClass().getName() + ": '" + this.myText.toString() + "'";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 11, 12, 15, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
            case 1: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 2: 
            case 11: 
            case 12: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/ex/util/LayeredLexerEditorHighlighter";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layerHighlighter";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "segments";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/ex/util/LayeredLexerEditorHighlighter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMappingSegments";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createIterator";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createBaseIterator";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "reallocateArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 11: 
            case 12: 
            case 15: 
            case 16: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "registerLayer";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "unregisterLayer";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setText";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createTokenProcessor";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "updateLayers";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "documentChanged";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setColorScheme";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "reallocateArray";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 11, 12, 15, 16 -> new IllegalStateException(string);
        };
    }

    private final class MappingSegments
    extends SegmentArrayWithData {
        private MappedRange[] myRanges;
        private final Map<LayerDescriptor, Mapper> myLayerBuffers;
        @Nullable
        private Set<LazyLexerEditorHighlighter> myFreezedHighlighters;

        private MappingSegments(DataStorage o) {
            if (o == null) {
                MappingSegments.$$$reportNull$$$0(0);
            }
            super(o);
            this.myRanges = new MappedRange[64];
            this.myLayerBuffers = new HashMap<LayerDescriptor, Mapper>();
        }

        @Nullable
        Mapper getMappingDocument(@NotNull IElementType token) {
            LayerDescriptor descriptor;
            if (token == null) {
                MappingSegments.$$$reportNull$$$0(1);
            }
            if ((descriptor = LayeredLexerEditorHighlighter.this.myTokensToLayer.get(token)) == null) {
                return null;
            }
            Mapper mapper = this.myLayerBuffers.get(descriptor);
            if (mapper == null) {
                mapper = new Mapper(descriptor);
                this.myLayerBuffers.put(descriptor, mapper);
            }
            return mapper;
        }

        public void removeAll() {
            if (this.mySegmentCount != 0) {
                Arrays.fill(this.myRanges, null);
            }
            this.myLayerBuffers.clear();
            super.removeAll();
        }

        public void replace(int startIndex, int endIndex, @NotNull SegmentArrayWithData newData) {
            if (newData == null) {
                MappingSegments.$$$reportNull$$$0(2);
            }
            this.withFreezedHighlighters(() -> super.replace(startIndex, endIndex, newData));
        }

        public void setElementAt(int i, int startOffset, int endOffset, int data) {
            this.setElementLight(i, startOffset, endOffset, data);
            MappedRange range = this.myRanges[i];
            if (range != null) {
                this.freezeHighlighter(range.mapper);
                range.mapper.removeMapping(range);
                this.myRanges[i] = null;
            }
            this.updateMappingForToken(i);
        }

        private void setElementLight(int i, int startOffset, int endOffset, int data) {
            super.setElementAt(i, startOffset, endOffset, data);
            this.myRanges = LayeredLexerEditorHighlighter.reallocateArray(this.myRanges, i + 1);
        }

        public void remove(int startIndex, int endIndex) {
            Mapper mapper;
            Object2IntOpenHashMap mins = new Object2IntOpenHashMap(endIndex - startIndex);
            mins.defaultReturnValue(-1);
            Object2IntOpenHashMap maxs = new Object2IntOpenHashMap(endIndex - startIndex);
            maxs.defaultReturnValue(-1);
            for (int i = startIndex; i < endIndex; ++i) {
                MappedRange range = this.myRanges[i];
                if (range != null && range.range.isValid()) {
                    mapper = range.mapper;
                    int currentMin = mins.getOrDefault((Object)mapper, Integer.MAX_VALUE);
                    mins.put((Object)mapper, Math.min(currentMin, range.range.getStartOffset()));
                    int currentMax = maxs.getOrDefault((Object)mapper, 0);
                    maxs.put((Object)mapper, Math.max(currentMax, range.range.getEndOffset()));
                }
                this.myRanges[i] = null;
            }
            for (Object2IntMap.Entry entry : maxs.object2IntEntrySet()) {
                mapper = (Mapper)entry.getKey();
                int max = entry.getIntValue();
                this.freezeHighlighter(mapper);
                int min = mins.getInt((Object)mapper);
                mapper.doc.deleteString(min - mapper.mySeparator.length(), max);
            }
            this.removeRange(this.myRanges, startIndex, endIndex);
            super.remove(startIndex, endIndex);
        }

        protected void replace(int startOffset, @NotNull SegmentArrayWithData data, int len) {
            if (data == null) {
                MappingSegments.$$$reportNull$$$0(3);
            }
            super.replace(startOffset, data, len);
            for (int i = startOffset; i < startOffset + len; ++i) {
                this.updateMappingForToken(i);
            }
        }

        private MappedRange @NotNull [] insert(MappedRange @NotNull [] array, MappedRange @NotNull [] insertArray, int startIndex, int insertLength) {
            if (array == null) {
                MappingSegments.$$$reportNull$$$0(4);
            }
            if (insertArray == null) {
                MappingSegments.$$$reportNull$$$0(5);
            }
            MappedRange[] newArray = LayeredLexerEditorHighlighter.reallocateArray(array, this.mySegmentCount + insertLength);
            if (startIndex < this.mySegmentCount) {
                System.arraycopy(newArray, startIndex, newArray, startIndex + insertLength, this.mySegmentCount - startIndex);
            }
            System.arraycopy(insertArray, 0, newArray, startIndex, insertLength);
            if (newArray == null) {
                MappingSegments.$$$reportNull$$$0(6);
            }
            return newArray;
        }

        private <T> void removeRange(T @NotNull [] array, int startIndex, int endIndex) {
            if (array == null) {
                MappingSegments.$$$reportNull$$$0(7);
            }
            if (endIndex < this.mySegmentCount) {
                System.arraycopy(array, endIndex, array, startIndex, this.mySegmentCount - endIndex);
            }
            Arrays.fill(array, this.mySegmentCount - (endIndex - startIndex), this.mySegmentCount, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void insert(@NotNull SegmentArrayWithData segmentArray, int startIndex) {
            if (segmentArray == null) {
                MappingSegments.$$$reportNull$$$0(8);
            }
            LayeredLexerEditorHighlighter layeredLexerEditorHighlighter = LayeredLexerEditorHighlighter.this;
            synchronized (layeredLexerEditorHighlighter) {
                super.insert(segmentArray, startIndex);
                int newCount = segmentArray.getSegmentCount();
                MappedRange[] newRanges = new MappedRange[newCount];
                this.myRanges = this.insert(this.myRanges, newRanges, startIndex, newCount);
                int endIndex = startIndex + segmentArray.getSegmentCount();
                LexerEditorHighlighter.TokenProcessor processor = LayeredLexerEditorHighlighter.this.createTokenProcessor(startIndex, LayeredLexerEditorHighlighter.this.getSegments(), LayeredLexerEditorHighlighter.this.myText);
                for (int i = startIndex; i < endIndex; ++i) {
                    int data = this.getSegmentData(i);
                    IElementType token = LayeredLexerEditorHighlighter.this.getSegments().unpackTokenFromData(data);
                    processor.addToken(i, this.getSegmentStart(i), this.getSegmentEnd(i), data, token);
                }
                processor.finish();
            }
        }

        private void updateMappingForToken(int i) {
            int data = this.getSegmentData(i);
            IElementType token = LayeredLexerEditorHighlighter.this.getSegments().unpackTokenFromData(data);
            Mapper mapper = this.getMappingDocument(token);
            MappedRange oldMapping = this.myRanges[i];
            if (mapper != null) {
                this.freezeHighlighter(mapper);
                if (oldMapping != null) {
                    if (oldMapping.mapper == mapper && oldMapping.outerToken == token) {
                        mapper.updateMapping(i, oldMapping);
                    } else {
                        oldMapping.mapper.removeMapping(oldMapping);
                        this.myRanges[i] = mapper.insertMapping(i, token);
                    }
                } else {
                    this.myRanges[i] = mapper.insertMapping(i, token);
                }
            } else if (oldMapping != null) {
                this.freezeHighlighter(oldMapping.mapper);
                oldMapping.mapper.removeMapping(oldMapping);
                this.myRanges[i] = null;
            }
        }

        private void withFreezedHighlighters(@NotNull Runnable action) {
            if (action == null) {
                MappingSegments.$$$reportNull$$$0(9);
            }
            if (this.myFreezedHighlighters != null) {
                action.run();
                return;
            }
            this.myFreezedHighlighters = new HashSet<LazyLexerEditorHighlighter>();
            try {
                action.run();
            }
            finally {
                this.myFreezedHighlighters.forEach(highlighter -> {
                    try {
                        highlighter.finishUpdate();
                    }
                    catch (IllegalStateException e) {
                        LOG.error(e.getMessage() + "\nLayer highlighter: " + String.valueOf(highlighter.getSyntaxHighlighter()) + "\nTop level highlighter: " + String.valueOf(LayeredLexerEditorHighlighter.this.getSyntaxHighlighter()), (Throwable)e, new Attachment[]{new Attachment("layerTextAfterChange.txt", highlighter.myText.toString()), new Attachment("editorTextAfterChange.txt", LayeredLexerEditorHighlighter.this.myText.toString())});
                    }
                });
                this.myFreezedHighlighters = null;
            }
        }

        private void freezeHighlighter(@NotNull Mapper mapper) {
            if (mapper == null) {
                MappingSegments.$$$reportNull$$$0(10);
            }
            if (this.myFreezedHighlighters != null && this.myFreezedHighlighters.add(mapper.highlighter)) {
                mapper.highlighter.beginUpdate();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "token";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newData";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "array";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "insertArray";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/editor/ex/util/LayeredLexerEditorHighlighter$MappingSegments";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "segmentArray";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/editor/ex/util/LayeredLexerEditorHighlighter$MappingSegments";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "insert";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getMappingDocument";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "replace";
                    break;
                }
                case 4: 
                case 5: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "insert";
                    break;
                }
                case 6: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "removeRange";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "withFreezedHighlighters";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "freezeHighlighter";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 6 -> new IllegalStateException(string);
            };
        }
    }

    private final class LayeredHighlighterIteratorImpl
    implements LayeredHighlighterIterator {
        private final HighlighterIterator myBaseIterator;
        private HighlighterIterator myLayerIterator;
        private int myLayerStartOffset;
        private Mapper myCurrentMapper;

        private LayeredHighlighterIteratorImpl(int offset) {
            this.myBaseIterator = LayeredLexerEditorHighlighter.this.createBaseIterator(offset);
            if (!this.myBaseIterator.atEnd()) {
                int shift = offset - this.myBaseIterator.getStart();
                this.initLayer(shift);
            }
        }

        private void initLayer(int shiftInToken) {
            if (this.myBaseIterator.atEnd()) {
                this.myLayerIterator = null;
                this.myCurrentMapper = null;
                return;
            }
            MappedRange mapping = LayeredLexerEditorHighlighter.this.getMappingSegments().myRanges[((LexerEditorHighlighter.HighlighterIteratorImpl)this.myBaseIterator).currentIndex()];
            if (mapping != null) {
                this.myCurrentMapper = mapping.mapper;
                this.myLayerIterator = this.myCurrentMapper.createIterator(mapping, shiftInToken);
                this.myLayerStartOffset = this.myBaseIterator.getStart() - mapping.range.getStartOffset();
            } else {
                this.myCurrentMapper = null;
                this.myLayerIterator = null;
            }
        }

        @Override
        public TextAttributes getTextAttributes() {
            if (this.myCurrentMapper != null) {
                return this.myCurrentMapper.getAttributes(this.getTokenType());
            }
            return this.myBaseIterator.getTextAttributes();
        }

        @Override
        public TextAttributesKey @NotNull [] getTextAttributesKeys() {
            if (this.myCurrentMapper != null) {
                TextAttributesKey[] textAttributesKeyArray = this.myCurrentMapper.getAttributesKeys(this.getTokenType());
                if (textAttributesKeyArray == null) {
                    LayeredHighlighterIteratorImpl.$$$reportNull$$$0(0);
                }
                return textAttributesKeyArray;
            }
            TextAttributesKey[] textAttributesKeyArray = this.myBaseIterator.getTextAttributesKeys();
            if (textAttributesKeyArray == null) {
                LayeredHighlighterIteratorImpl.$$$reportNull$$$0(1);
            }
            return textAttributesKeyArray;
        }

        @Override
        @NotNull
        public SyntaxHighlighter getActiveSyntaxHighlighter() {
            if (this.myCurrentMapper != null) {
                SyntaxHighlighter syntaxHighlighter = this.myCurrentMapper.mySyntaxHighlighter;
                if (syntaxHighlighter == null) {
                    LayeredHighlighterIteratorImpl.$$$reportNull$$$0(2);
                }
                return syntaxHighlighter;
            }
            SyntaxHighlighter syntaxHighlighter = LayeredLexerEditorHighlighter.this.getSyntaxHighlighter();
            if (syntaxHighlighter == null) {
                LayeredHighlighterIteratorImpl.$$$reportNull$$$0(3);
            }
            return syntaxHighlighter;
        }

        @Override
        public int getStart() {
            if (this.myLayerIterator != null) {
                return this.myLayerIterator.getStart() + this.myLayerStartOffset;
            }
            return this.myBaseIterator.getStart();
        }

        @Override
        public int getEnd() {
            if (this.myLayerIterator != null) {
                return this.myLayerIterator.getEnd() + this.myLayerStartOffset;
            }
            return this.myBaseIterator.getEnd();
        }

        @Override
        public IElementType getTokenType() {
            return this.myLayerIterator != null ? this.myLayerIterator.getTokenType() : this.myBaseIterator.getTokenType();
        }

        @Override
        public void advance() {
            if (this.myLayerIterator != null) {
                this.myLayerIterator.advance();
                if (!this.myLayerIterator.atEnd()) {
                    return;
                }
            }
            this.myBaseIterator.advance();
            this.initLayer(0);
        }

        @Override
        public void retreat() {
            if (this.myLayerIterator != null) {
                this.myLayerIterator.retreat();
                if (!this.myLayerIterator.atEnd()) {
                    return;
                }
            }
            this.myBaseIterator.retreat();
            this.initLayer(this.myBaseIterator.atEnd() ? 0 : this.myBaseIterator.getEnd() - this.myBaseIterator.getStart() - 1);
        }

        @Override
        public boolean atEnd() {
            return this.myBaseIterator.atEnd();
        }

        @Override
        public Document getDocument() {
            return this.myBaseIterator.getDocument();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/openapi/editor/ex/util/LayeredLexerEditorHighlighter$LayeredHighlighterIteratorImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextAttributesKeys";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActiveSyntaxHighlighter";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static class MappedRange {
        private RangeMarker range;
        private final Mapper mapper;
        private final IElementType outerToken;

        MappedRange(@NotNull Mapper mapper, @NotNull RangeMarker range, @NotNull IElementType outerToken) {
            if (range == null) {
                MappedRange.$$$reportNull$$$0(0);
            }
            if (outerToken == null) {
                MappedRange.$$$reportNull$$$0(1);
            }
            if (mapper == null) {
                MappedRange.$$$reportNull$$$0(2);
            }
            this.mapper = mapper;
            this.range = range;
            this.outerToken = outerToken;
            assert (mapper.doc == range.getDocument());
        }

        @NonNls
        public String toString() {
            return "MappedRange{range=" + String.valueOf(this.range) + ", outerToken=" + String.valueOf(this.outerToken) + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "range";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "outerToken";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "mapper";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/editor/ex/util/LayeredLexerEditorHighlighter$MappedRange";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class Mapper
    implements HighlighterClient {
        private final DocumentImpl doc;
        private final LazyLexerEditorHighlighter highlighter;
        private final String mySeparator;
        private final Map<IElementType, TextAttributes> myAttributesMap;
        private final Map<IElementType, TextAttributesKey[]> myKeysMap;
        @NotNull
        private final SyntaxHighlighter mySyntaxHighlighter;
        private final TextAttributesKey myBackground;

        private Mapper(LayerDescriptor descriptor) {
            if (descriptor == null) {
                Mapper.$$$reportNull$$$0(0);
            }
            this.myAttributesMap = new HashMap<IElementType, TextAttributes>();
            this.myKeysMap = new HashMap<IElementType, TextAttributesKey[]>();
            this.doc = new DocumentImpl((CharSequence)"", true);
            this.mySyntaxHighlighter = descriptor.getLayerHighlighter();
            this.myBackground = descriptor.getBackgroundKey();
            this.highlighter = new LazyLexerEditorHighlighter(this.mySyntaxHighlighter, LayeredLexerEditorHighlighter.this.getScheme());
            this.mySeparator = descriptor.getTokenSeparator();
            this.highlighter.setEditor(this);
            this.doc.addDocumentListener((DocumentListener)this.highlighter);
        }

        @NotNull
        TextAttributes getAttributes(IElementType tokenType) {
            TextAttributes attrs = this.myAttributesMap.get(tokenType);
            if (attrs == null) {
                TextAttributesKey[] keys = this.getAttributesKeys(tokenType);
                attrs = LayeredLexerEditorHighlighter.this.convertAttributes(keys);
                this.myAttributesMap.put(tokenType, attrs);
            }
            TextAttributes textAttributes = attrs;
            if (textAttributes == null) {
                Mapper.$$$reportNull$$$0(1);
            }
            return textAttributes;
        }

        private TextAttributesKey @NotNull [] getAttributesKeys(IElementType tokenType) {
            TextAttributesKey[] textAttributesKeyArray = this.myKeysMap.computeIfAbsent(tokenType, type -> SyntaxHighlighterBase.pack(this.myBackground, this.mySyntaxHighlighter.getTokenHighlights((IElementType)type)));
            if (textAttributesKeyArray == null) {
                Mapper.$$$reportNull$$$0(2);
            }
            return textAttributesKeyArray;
        }

        @NotNull
        HighlighterIterator createIterator(@NotNull MappedRange mapper, int shift) {
            if (mapper == null) {
                Mapper.$$$reportNull$$$0(3);
            }
            int rangeStart = mapper.range.getStartOffset();
            int rangeEnd = mapper.range.getEndOffset();
            return new LimitedRangeHighlighterIterator(this.highlighter.createIterator(rangeStart + shift), rangeStart, rangeEnd);
        }

        @Override
        public Project getProject() {
            return LayeredLexerEditorHighlighter.this.getClient().getProject();
        }

        @Override
        public void repaint(int start, int end) {
        }

        @Override
        public Document getDocument() {
            return LayeredLexerEditorHighlighter.this.getDocument();
        }

        void resetCachedTextAttributes() {
            this.myAttributesMap.clear();
        }

        void updateMapping(int tokenIndex, @NotNull MappedRange oldMapping) {
            if (oldMapping == null) {
                Mapper.$$$reportNull$$$0(4);
            }
            CharSequence tokenText = this.getTokenText(tokenIndex);
            int start = oldMapping.range.getStartOffset();
            int end = oldMapping.range.getEndOffset();
            if (Comparing.equal((CharSequence)this.doc.getCharsSequence().subSequence(start, end), (CharSequence)tokenText)) {
                return;
            }
            this.doc.replaceString(start, end, tokenText);
            int newEnd = start + tokenText.length();
            if (oldMapping.range.getStartOffset() != start || oldMapping.range.getEndOffset() != newEnd) {
                assert (oldMapping.range.getDocument() == this.doc);
                oldMapping.range.dispose();
                oldMapping.range = this.doc.createRangeMarker(start, newEnd);
            }
        }

        @NotNull
        private MappedRange insertMapping(int tokenIndex, @NotNull IElementType outerToken) {
            if (outerToken == null) {
                Mapper.$$$reportNull$$$0(5);
            }
            CharSequence tokenText = this.getTokenText(tokenIndex);
            int length = tokenText.length();
            MappedRange predecessor = this.findPredecessor(tokenIndex, LayeredLexerEditorHighlighter.this.getMappingSegments());
            int insertOffset = predecessor != null ? predecessor.range.getEndOffset() : 0;
            this.doc.insertString(insertOffset, (CharSequence)new MergingCharSequence((CharSequence)this.mySeparator, tokenText));
            RangeMarker marker = this.doc.createRangeMarker(insertOffset += this.mySeparator.length(), insertOffset + length);
            return new MappedRange(this, marker, outerToken);
        }

        @NotNull
        private CharSequence getTokenText(int tokenIndex) {
            CharSequence charSequence = LayeredLexerEditorHighlighter.this.myText.subSequence(LayeredLexerEditorHighlighter.this.getSegments().getSegmentStart(tokenIndex), LayeredLexerEditorHighlighter.this.getSegments().getSegmentEnd(tokenIndex));
            if (charSequence == null) {
                Mapper.$$$reportNull$$$0(6);
            }
            return charSequence;
        }

        @Nullable
        MappedRange findPredecessor(int token, @NotNull MappingSegments segments) {
            if (segments == null) {
                Mapper.$$$reportNull$$$0(7);
            }
            --token;
            while (token >= 0) {
                MappedRange mappedRange = segments.myRanges[token];
                if (mappedRange != null && mappedRange.mapper == this) {
                    return mappedRange;
                }
                --token;
            }
            return null;
        }

        private void removeMapping(@NotNull MappedRange mapping) {
            RangeMarker rangeMarker;
            if (mapping == null) {
                Mapper.$$$reportNull$$$0(8);
            }
            if ((rangeMarker = mapping.range).isValid()) {
                int start = rangeMarker.getStartOffset();
                int end = rangeMarker.getEndOffset();
                assert (this.doc == rangeMarker.getDocument());
                this.doc.deleteString(start - this.mySeparator.length(), end);
                rangeMarker.dispose();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 1: 
                case 2: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/editor/ex/util/LayeredLexerEditorHighlighter$Mapper";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mapper";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldMapping";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outerToken";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "segments";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mapping";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/editor/ex/util/LayeredLexerEditorHighlighter$Mapper";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAttributes";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAttributesKeys";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTokenText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 6: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createIterator";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "updateMapping";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "insertMapping";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "findPredecessor";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "removeMapping";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 6 -> new IllegalStateException(string);
            };
        }
    }

    private static class LazyLexerEditorHighlighter
    extends LexerEditorHighlighter {
        private boolean inUpdate;
        private List<DocumentUpdate> updates;

        LazyLexerEditorHighlighter(@NotNull SyntaxHighlighter highlighter, @NotNull EditorColorsScheme scheme) {
            if (highlighter == null) {
                LazyLexerEditorHighlighter.$$$reportNull$$$0(0);
            }
            if (scheme == null) {
                LazyLexerEditorHighlighter.$$$reportNull$$$0(1);
            }
            super(highlighter, scheme);
        }

        public void beginUpdate() {
            this.inUpdate = true;
            this.updates = new SmartList();
        }

        public void finishUpdate() {
            this.inUpdate = false;
            if (this.updates.isEmpty()) {
                this.updates = null;
                return;
            }
            this.sortUpdates();
            this.mergeUpdates();
            Document document = this.updates.get((int)0).document;
            int documentSize = document.getTextLength();
            int processedOffset = -1;
            for (DocumentUpdate event : this.updates) {
                if (event.offset + event.newLength < processedOffset || (processedOffset = super.incrementalUpdate(event.offset, event.oldLength, event.newLength, document)) < documentSize) continue;
                break;
            }
            this.updates = null;
        }

        @Override
        int incrementalUpdate(int eventOffset, int eventOldLength, int eventNewLength, @NotNull Document document) {
            if (document == null) {
                LazyLexerEditorHighlighter.$$$reportNull$$$0(2);
            }
            if (this.inUpdate) {
                if (!LazyLexerEditorHighlighter.mergeUpdate(this.updates, eventOffset, eventOldLength, eventNewLength)) {
                    this.updates.add(new DocumentUpdate(eventOffset, eventOldLength, eventNewLength, document));
                }
                return -1;
            }
            return super.incrementalUpdate(eventOffset, eventOldLength, eventNewLength, document);
        }

        private static boolean mergeUpdate(@NotNull List<? extends DocumentUpdate> updates, int eventOffset, int eventOldLength, int eventNewLength) {
            if (updates == null) {
                LazyLexerEditorHighlighter.$$$reportNull$$$0(3);
            }
            if (updates.isEmpty()) {
                return false;
            }
            int MERGE_MARGIN = 5;
            DocumentUpdate a = updates.get(updates.size() - 1);
            if (eventOffset < a.offset) {
                return false;
            }
            if (a.offset == eventOffset) {
                if (a.newLength > eventOldLength) {
                    a.newLength += eventNewLength - eventOldLength;
                } else {
                    a.oldLength += eventOldLength - a.newLength;
                    a.newLength = eventNewLength;
                }
            } else if (a.offset + a.newLength > eventOffset) {
                if (a.offset + a.newLength < eventOffset + eventOldLength) {
                    a.oldLength = eventOldLength + eventOffset - (a.offset + a.oldLength);
                }
                a.newLength += eventNewLength - eventOldLength;
            } else if (a.offset + a.newLength + 5 >= eventOffset) {
                int offsetDiff = eventOffset - a.offset - a.newLength;
                a.oldLength += offsetDiff + eventOldLength;
                a.newLength += offsetDiff + eventNewLength;
            } else {
                return false;
            }
            return true;
        }

        private void mergeUpdates() {
            ArrayList<DocumentUpdate> result2 = new ArrayList<DocumentUpdate>(this.updates.size());
            result2.add(this.updates.get(0));
            for (int i = 1; i < this.updates.size(); ++i) {
                DocumentUpdate b = this.updates.get(i);
                if (LazyLexerEditorHighlighter.mergeUpdate(result2, b.offset, b.oldLength, b.newLength)) continue;
                result2.add(b);
            }
            this.updates = result2;
        }

        private void sortUpdates() {
            int sortedFrom = this.updates.size();
            while (sortedFrom != 0) {
                int lastSortedIndex = 0;
                for (int i = 1; i < sortedFrom; ++i) {
                    DocumentUpdate a = this.updates.get(i - 1);
                    DocumentUpdate b = this.updates.get(i);
                    if (a.offset <= b.offset) continue;
                    if (a.offset < b.offset + b.oldLength) {
                        int delta = b.offset + b.oldLength - a.offset;
                        a.offset = b.offset;
                        a.oldLength -= Math.min(0, delta);
                        a.newLength -= Math.min(0, delta);
                    } else {
                        a.offset += b.newLength - b.oldLength;
                    }
                    this.updates.set(i - 1, b);
                    this.updates.set(i, a);
                    lastSortedIndex = i;
                }
                sortedFrom = lastSortedIndex;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "highlighter";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scheme";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updates";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/editor/ex/util/LayeredLexerEditorHighlighter$LazyLexerEditorHighlighter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "incrementalUpdate";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mergeUpdate";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static class DocumentUpdate {
            int offset;
            int oldLength;
            int newLength;
            final Document document;

            DocumentUpdate(int offset, int oldLength, int newLength, Document document) {
                this.offset = offset;
                this.oldLength = oldLength;
                this.newLength = newLength;
                this.document = document;
            }

            public String toString() {
                return "update at " + this.offset + ": " + this.oldLength + " => " + this.newLength;
            }
        }
    }

    private final class LightMapper {
        final Mapper mapper;
        final StringBuilder text;
        final IntList lengths;
        final List<IElementType> tokenTypes;
        final Int2IntMap index2Global;
        private final String mySeparator;
        final int insertOffset;

        LightMapper(Mapper mapper, int insertOffset) {
            if (mapper == null) {
                LightMapper.$$$reportNull$$$0(0);
            }
            this.text = new StringBuilder();
            this.lengths = new IntArrayList();
            this.tokenTypes = new ArrayList<IElementType>();
            this.index2Global = new Int2IntOpenHashMap();
            this.mapper = mapper;
            this.mySeparator = mapper.mySeparator;
            this.insertOffset = insertOffset;
        }

        void addToken(@NotNull CharSequence tokenText, @NotNull IElementType tokenType, int globalIndex) {
            if (tokenText == null) {
                LightMapper.$$$reportNull$$$0(1);
            }
            if (tokenType == null) {
                LightMapper.$$$reportNull$$$0(2);
            }
            this.index2Global.put(this.tokenTypes.size(), globalIndex);
            this.text.append(this.mySeparator).append(tokenText);
            this.lengths.add(tokenText.length());
            this.tokenTypes.add(tokenType);
        }

        void finish() {
            assert (this.insertOffset >= 0);
            DocumentImpl document = this.mapper.doc;
            document.insertString(this.insertOffset, (CharSequence)this.text);
            int start = this.insertOffset;
            for (int i = 0; i < this.tokenTypes.size(); ++i) {
                IElementType type = this.tokenTypes.get(i);
                int len = this.lengths.getInt(i);
                int globalIndex = this.index2Global.get(i);
                MappedRange[] ranges = LayeredLexerEditorHighlighter.this.getMappingSegments().myRanges;
                this.checkNull(type, ranges[globalIndex]);
                ranges[globalIndex] = new MappedRange(this.mapper, document.createRangeMarker(start += this.mySeparator.length(), start + len), type);
                start += len;
            }
        }

        private void checkNull(@NotNull IElementType type, @Nullable MappedRange range) {
            if (type == null) {
                LightMapper.$$$reportNull$$$0(3);
            }
            if (range != null) {
                Document mainDocument = LayeredLexerEditorHighlighter.this.getDocument();
                VirtualFile file = mainDocument == null ? null : FileDocumentManager.getInstance().getFile(mainDocument);
                LOG.error("Expected null range on " + String.valueOf(type) + ", found " + String.valueOf(range) + "; highlighter=" + String.valueOf(LayeredLexerEditorHighlighter.this.getSyntaxHighlighter()), new Attachment[]{new Attachment(file != null ? file.getName() : "editorText.txt", LayeredLexerEditorHighlighter.this.myText.toString())});
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mapper";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tokenText";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tokenType";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/editor/ex/util/LayeredLexerEditorHighlighter$LightMapper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addToken";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkNull";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

