/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote;

import com.intellij.execution.ExecutionExceptionWithAttachments;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.remote.RemoteBundle;
import com.intellij.remote.RemoteCredentialException;
import java.net.NoRouteToHostException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteSdkException
extends ExecutionExceptionWithAttachments {
    private final Throwable myCause;
    private static final Logger LOG = Logger.getInstance(RemoteSdkException.class);

    public RemoteSdkException(@NlsContexts.DialogMessage String s, Throwable throwable) {
        this(s, throwable, null, null);
    }

    public RemoteSdkException(@NlsContexts.DialogMessage String s, Throwable throwable, @Nullable String stdout, @Nullable String stderr) {
        super(s, throwable, stdout, stderr);
        for (Throwable t = throwable; t != null; t = t.getCause()) {
            if (!(t instanceof NoRouteToHostException)) continue;
            this.myCause = t;
            return;
        }
        this.myCause = throwable;
    }

    public RemoteSdkException(@NlsContexts.DialogMessage String s) {
        this(s, null, null);
    }

    public RemoteSdkException(@NlsContexts.DialogMessage String s, @Nullable String stdout, @Nullable String stderr) {
        super(s, stdout, stderr);
        LOG.warn(String.format("message %s, out: %s, err: %s", s, stdout, stderr));
        this.myCause = null;
    }

    public String getMessage() {
        return this.myCause instanceof NoRouteToHostException ? this.myCause.getMessage() : super.getMessage();
    }

    @NotNull
    public static RemoteSdkException cantObtainRemoteCredentials(@NotNull Throwable e) {
        if (e == null) {
            RemoteSdkException.$$$reportNull$$$0(0);
        }
        if (e.getCause() instanceof RemoteCredentialException) {
            return new RemoteSdkException(RemoteBundle.message("remote.sdk.exception.cant.obtain.remote.credentials", new Object[0]), e);
        }
        if (e instanceof RemoteSdkException) {
            RemoteSdkException remoteSdkException = (RemoteSdkException)((Object)e);
            if (remoteSdkException == null) {
                RemoteSdkException.$$$reportNull$$$0(1);
            }
            return remoteSdkException;
        }
        return new RemoteSdkException(e.getMessage(), e);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/remote/RemoteSdkException";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/remote/RemoteSdkException";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "cantObtainRemoteCredentials";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "cantObtainRemoteCredentials";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

