/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.smart;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.formatting.FormattingMode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ReadAndWriteScope;
import com.intellij.openapi.application.ReadConstraint;
import com.intellij.openapi.application.ReadResult;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.codeStyle.CodeStyleManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.smart.YAMLInjectedElementEnterHandlerKt;
import org.jetbrains.yaml.smart.YamlCoroutineScopeService;
import org.jetbrains.yaml.smart.YamlIndentPreservationUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\u0014\u0010\u0013\u001a\u00020\u0014*\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0012H\u0002J,\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0019H\u0082@\u00a2\u0006\u0002\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/yaml/smart/YAMLInjectedElementEnterHandler;", "Lcom/intellij/codeInsight/editorActions/enter/EnterHandlerDelegate;", "<init>", "()V", "postProcessEnter", "Lcom/intellij/codeInsight/editorActions/enter/EnterHandlerDelegate$Result;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "usePreviousLineIndents", "", "document", "Lcom/intellij/openapi/editor/Document;", "linesToAdjustIndent", "Ljava/util/TreeSet;", "", "getLineIndentRange", "Lcom/intellij/openapi/util/TextRange;", "line", "reformatAsync", "project", "Lcom/intellij/openapi/project/Project;", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Document;Ljava/lang/Iterable;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.yaml.backend"})
@SourceDebugExtension(value={"SMAP\nYAMLInjectedElementEnterHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 YAMLInjectedElementEnterHandler.kt\norg/jetbrains/yaml/smart/YAMLInjectedElementEnterHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,129:1\n1642#2,10:130\n1915#2:140\n1916#2:142\n1652#2:143\n1#3:141\n*S KotlinDebug\n*F\n+ 1 YAMLInjectedElementEnterHandler.kt\norg/jetbrains/yaml/smart/YAMLInjectedElementEnterHandler\n*L\n95#1:130,10\n95#1:140\n95#1:142\n95#1:143\n95#1:141\n*E\n"})
public final class YAMLInjectedElementEnterHandler
implements EnterHandlerDelegate {
    @NotNull
    public EnterHandlerDelegate.Result postProcessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull DataContext dataContext) {
        int line;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Object object = CommonDataKeys.HOST_EDITOR.getData(dataContext);
        EditorEx editorEx = object instanceof EditorEx ? (EditorEx)object : null;
        if (editorEx == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        EditorEx hostEditor = editorEx;
        int caretOffset = hostEditor.getCaretModel().getOffset();
        String string = (String)YamlIndentPreservationUtilsKt.getINDENT_BEFORE_PROCESSING().get((UserDataHolder)file);
        if (string == null) {
            string = "";
        }
        String injectionIndent = string;
        RangeMarker rangeMarker = (RangeMarker)YamlIndentPreservationUtilsKt.getINJECTION_RANGE_BEFORE_ENTER().get((UserDataHolder)file);
        if (rangeMarker == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        RangeMarker pointer = rangeMarker;
        DocumentEx documentEx = hostEditor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        DocumentEx document = documentEx;
        PsiLanguageInjectionHost psiLanguageInjectionHost = InjectedLanguageManager.getInstance((Project)file.getProject()).getInjectionHost((PsiElement)file);
        if (psiLanguageInjectionHost == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        PsiLanguageInjectionHost currentInjectionHost = psiLanguageInjectionHost;
        TextRange currentHostRange = currentInjectionHost.getTextRange();
        TreeSet lines = YAMLInjectedElementEnterHandlerKt.access$linesBetween((Document)document, currentHostRange.getEndOffset(), pointer.getEndOffset());
        pointer.dispose();
        YamlIndentPreservationUtilsKt.getINJECTION_RANGE_BEFORE_ENTER().set((UserDataHolder)file, null);
        int caretLine = document.getLineNumber(caretOffset);
        lines.add(caretLine);
        TreeSet<Integer> linesToAdjustIndent = new TreeSet<Integer>();
        Iterator iterator = lines.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            boolean fix;
            Object e = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            line = ((Number)e).intValue();
            int lineStartOffset = document.getLineStartOffset(line);
            CharSequence lineChars = document.getCharsSequence().subSequence(lineStartOffset, document.getLineEndOffset(line));
            int commonPrefixLength = StringUtil.commonPrefixLength((CharSequence)lineChars, (CharSequence)injectionIndent);
            boolean bl = fix = !StringsKt.startsWith$default((CharSequence)lineChars, (CharSequence)injectionIndent, (boolean)false, (int)2, null);
            if (fix) {
                document.replaceString(lineStartOffset, lineStartOffset + commonPrefixLength, (CharSequence)injectionIndent);
                if (line == caretLine) {
                    hostEditor.getCaretModel().moveToOffset(lineStartOffset + injectionIndent.length());
                }
            }
            if (!fix) {
                if (!StringsKt.isBlank((CharSequence)lineChars)) continue;
                Integer n = (Integer)lines.last();
                int n2 = line;
                if (n != null && n == n2) continue;
            }
            linesToAdjustIndent.add(line);
        }
        if (Registry.Companion.is("yaml.injection.async.indent")) {
            this.usePreviousLineIndents((Document)document, linesToAdjustIndent);
            Project project = file.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            BuildersKt.launch$default((CoroutineScope)YamlCoroutineScopeService.Companion.getCoroutineScope(project), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, file, document, linesToAdjustIndent, null){
                int label;
                final /* synthetic */ YAMLInjectedElementEnterHandler this$0;
                final /* synthetic */ PsiFile $file;
                final /* synthetic */ DocumentEx $document;
                final /* synthetic */ TreeSet<Integer> $linesToAdjustIndent;
                {
                    this.this$0 = $receiver;
                    this.$file = $file;
                    this.$document = $document;
                    this.$linesToAdjustIndent = $linesToAdjustIndent;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            Project project = this.$file.getProject();
                            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                            this.label = 1;
                            Object object2 = YAMLInjectedElementEnterHandler.access$reformatAsync(this.this$0, project, (Document)this.$document, this.$linesToAdjustIndent, (Continuation)this);
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        } else {
            Iterator iterator3 = linesToAdjustIndent.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator3, (String)"iterator(...)");
            iterator2 = iterator3;
            while (iterator2.hasNext()) {
                Object e = iterator2.next();
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                line = ((Number)e).intValue();
                CodeStyleManager.getInstance((Project)file.getProject()).adjustLineIndent((Document)document, this.getLineIndentRange((Document)document, line).getEndOffset());
            }
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    private final void usePreviousLineIndents(Document document, TreeSet<Integer> linesToAdjustIndent) {
        Iterator<Integer> iterator = linesToAdjustIndent.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<Integer> iterator2 = iterator;
        while (iterator2.hasNext()) {
            Integer n = iterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"next(...)");
            int line = ((Number)n).intValue();
            if (line == 0) continue;
            TextRange prevLineIndentRange = this.getLineIndentRange(document, line - 1);
            TextRange indentRange = this.getLineIndentRange(document, line);
            if (prevLineIndentRange.getLength() == indentRange.getLength()) continue;
            document.replaceString(indentRange.getStartOffset(), indentRange.getEndOffset(), prevLineIndentRange.subSequence(document.getCharsSequence()));
        }
    }

    private final TextRange getLineIndentRange(Document $this$getLineIndentRange, int line) {
        int lineStart = $this$getLineIndentRange.getLineStartOffset(line);
        int indentEnd = StringUtil.skipWhitespaceForward((CharSequence)$this$getLineIndentRange.getCharsSequence(), (int)lineStart);
        TextRange textRange = TextRange.create((int)lineStart, (int)indentEnd);
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"create(...)");
        return textRange;
    }

    private final Object reformatAsync(Project project, Document document, Iterable<Integer> linesToAdjustIndent, Continuation<? super Unit> $completion) {
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        ReadConstraint[] readConstraintArray = new ReadConstraint[]{ReadConstraint.Companion.withDocumentsCommitted(project)};
        Object object = CoroutinesKt.constrainedReadAndWriteAction((ReadConstraint[])readConstraintArray, arg_0 -> YAMLInjectedElementEnterHandler.reformatAsync$lambda$0(linesToAdjustIndent, this, document, project, codeStyleManager, arg_0), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private static final void reformatAsync$lambda$0$1$0(List $toAdjust, YAMLInjectedElementEnterHandler this$0, Document $document) {
        for (Pair pair : $toAdjust) {
            int line = ((Number)pair.component1()).intValue();
            String lineIndent = (String)pair.component2();
            TextRange indentRange = this$0.getLineIndentRange($document, line);
            $document.replaceString(indentRange.getStartOffset(), indentRange.getEndOffset(), (CharSequence)lineIndent);
        }
    }

    private static final Unit reformatAsync$lambda$0$1(List $toAdjust, YAMLInjectedElementEnterHandler this$0, Document $document) {
        CommandProcessor.getInstance().runUndoTransparentAction(() -> YAMLInjectedElementEnterHandler.reformatAsync$lambda$0$1$0($toAdjust, this$0, $document));
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final ReadResult reformatAsync$lambda$0(Iterable $linesToAdjustIndent, YAMLInjectedElementEnterHandler this$0, Document $document, Project $project, CodeStyleManager $codeStyleManager, ReadAndWriteScope $this$constrainedReadAndWriteAction) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$constrainedReadAndWriteAction, (String)"$this$constrainedReadAndWriteAction");
        Iterable $this$mapNotNull$iv = $linesToAdjustIndent;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair it$iv$iv;
            String indent;
            PsiFile docFile;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            int line = ((Number)element$iv$iv).intValue();
            boolean bl2 = false;
            TextRange lineIndentRange = this$0.getLineIndentRange($document, line);
            if ((PsiDocumentManager.getInstance((Project)$project).getPsiFile($document) == null ? null : ($codeStyleManager.getLineIndent(docFile, lineIndentRange.getEndOffset(), FormattingMode.ADJUST_INDENT) == null ? null : (StringUtil.equals((CharSequence)lineIndentRange.subSequence($document.getCharsSequence()), (CharSequence)indent) ? null : TuplesKt.to((Object)line, (Object)indent)))) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List toAdjust = (List)destination$iv$iv;
        if (toAdjust.isEmpty()) {
            return $this$constrainedReadAndWriteAction.value((Object)Unit.INSTANCE);
        }
        return $this$constrainedReadAndWriteAction.writeAction(() -> YAMLInjectedElementEnterHandler.reformatAsync$lambda$0$1(toAdjust, this$0, $document));
    }

    public static final /* synthetic */ Object access$reformatAsync(YAMLInjectedElementEnterHandler $this, Project project, Document document, Iterable linesToAdjustIndent, Continuation $completion) {
        return $this.reformatAsync(project, document, linesToAdjustIndent, (Continuation<? super Unit>)$completion);
    }
}

