/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore.keePass;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialStore;
import com.intellij.credentialStore.Credentials;
import com.intellij.credentialStore.OneTimeString;
import com.intellij.credentialStore.kdbx.KdbxEntry;
import com.intellij.credentialStore.kdbx.KdbxGroup;
import com.intellij.credentialStore.kdbx.KeePassDatabase;
import com.intellij.credentialStore.kdbx.SecureString;
import com.intellij.credentialStore.keePass.InMemoryCredentialStore;
import com.intellij.credentialStore.keePass.KeePassCredentialStore;
import com.intellij.util.text.StringKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0096\u0002J\u001b\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\tH\u0096\u0002J\b\u0010\u000f\u001a\u00020\rH$R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u0082\u0001\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/intellij/credentialStore/keePass/BaseKeePassCredentialStore;", "Lcom/intellij/credentialStore/CredentialStore;", "<init>", "()V", "db", "Lcom/intellij/credentialStore/kdbx/KeePassDatabase;", "getDb", "()Lcom/intellij/credentialStore/kdbx/KeePassDatabase;", "get", "Lcom/intellij/credentialStore/Credentials;", "attributes", "Lcom/intellij/credentialStore/CredentialAttributes;", "set", "", "credentials", "markDirty", "Lcom/intellij/credentialStore/keePass/InMemoryCredentialStore;", "Lcom/intellij/credentialStore/keePass/KeePassCredentialStore;", "intellij.platform.credentialStore.impl"})
public abstract sealed class BaseKeePassCredentialStore
implements CredentialStore
permits InMemoryCredentialStore, KeePassCredentialStore {
    private BaseKeePassCredentialStore() {
    }

    @NotNull
    protected abstract KeePassDatabase getDb();

    @Nullable
    public Credentials get(@NotNull CredentialAttributes attributes) {
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        KdbxGroup kdbxGroup = this.getDb().getRootGroup$intellij_platform_credentialStore_impl().getGroup("IntelliJ Platform");
        if (kdbxGroup == null) {
            return null;
        }
        KdbxGroup group = kdbxGroup;
        String userName = StringKt.nullize$default((String)attributes.getUserName(), (boolean)false, (int)1, null);
        KdbxEntry kdbxEntry = group.getEntry(attributes.getServiceName(), StringKt.nullize$default((String)userName, (boolean)false, (int)1, null));
        if (kdbxEntry == null) {
            return null;
        }
        KdbxEntry entry = kdbxEntry;
        String string = userName;
        if (string == null) {
            string = entry.getUserName();
        }
        SecureString secureString = entry.getPassword();
        return new Credentials(string, secureString != null ? SecureString.get$default(secureString, false, 1, null) : null);
    }

    public void set(@NotNull CredentialAttributes attributes, @Nullable Credentials credentials) {
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        if (credentials == null) {
            KdbxGroup kdbxGroup = this.getDb().getRootGroup$intellij_platform_credentialStore_impl().getGroup("IntelliJ Platform");
            if (kdbxGroup != null) {
                kdbxGroup.removeEntry(attributes.getServiceName(), StringKt.nullize$default((String)attributes.getUserName(), (boolean)false, (int)1, null));
            }
        } else {
            SecureString secureString;
            KdbxEntry entry;
            String userName;
            KdbxGroup group = this.getDb().getRootGroup$intellij_platform_credentialStore_impl().getOrCreateGroup("IntelliJ Platform");
            String string = StringKt.nullize$default((String)attributes.getUserName(), (boolean)false, (int)1, null);
            if (string == null) {
                string = userName = credentials.getUserName();
            }
            if ((entry = group.getEntry(attributes.getServiceName(), Intrinsics.areEqual((Object)attributes.getServiceName(), (Object)"IntelliJ Platform") ? userName : null)) == null) {
                entry = group.createEntry(attributes.getServiceName(), userName);
            } else {
                entry.setUserName(userName);
            }
            if (attributes.isPasswordMemoryOnly() || credentials.getPassword() == null) {
                secureString = null;
            } else {
                KeePassDatabase keePassDatabase = this.getDb();
                OneTimeString oneTimeString = credentials.getPassword();
                Intrinsics.checkNotNull((Object)oneTimeString);
                secureString = keePassDatabase.protectValue$intellij_platform_credentialStore_impl((CharSequence)oneTimeString);
            }
            entry.setPassword(secureString);
        }
        if (this.getDb().isDirty()) {
            this.markDirty();
        }
    }

    protected abstract void markDirty();

    public /* synthetic */ BaseKeePassCredentialStore(DefaultConstructorMarker $constructor_marker) {
        this();
    }
}

