/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.impl.DummyRootDescriptor;
import com.intellij.openapi.roots.impl.LibraryRootDescriptor;
import com.intellij.openapi.roots.impl.ModuleRootDescriptor;
import com.intellij.openapi.roots.impl.RootDescriptor;
import com.intellij.openapi.roots.impl.SdkRootDescriptor;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.platform.workspace.jps.entities.LibraryEntity;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.ImmutableEntityStorage;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.workspaceModel.core.fileIndex.WorkspaceFileSetWithCustomData;
import com.intellij.workspaceModel.core.fileIndex.impl.DummyWorkspaceFileSetData;
import com.intellij.workspaceModel.core.fileIndex.impl.ModuleSourceRootData;
import com.intellij.workspaceModel.core.fileIndex.impl.StoredFileSet;
import com.intellij.workspaceModel.ide.impl.legacyBridge.sdk.SdkBridgeImpl;
import com.intellij.workspaceModel.ide.legacyBridge.LibraryBridgesKt;
import java.lang.invoke.MethodHandles;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\u0004\u0018\u00010\u00012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"findFileSetDescriptor", "Lcom/intellij/openapi/roots/impl/RootDescriptor;", "set", "Lcom/intellij/workspaceModel/core/fileIndex/WorkspaceFileSetWithCustomData;", "snapshot", "Lcom/intellij/platform/workspace/storage/ImmutableEntityStorage;", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.projectModel.impl"})
@JvmName(name="FileSet2RootDescriptor")
@SourceDebugExtension(value={"SMAP\nFileSet2RootDescriptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileSet2RootDescriptor.kt\ncom/intellij/openapi/roots/impl/FileSet2RootDescriptor\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,55:1\n67#2,4:56\n67#2,4:60\n67#2,4:64\n57#2:68\n35#2,2:69\n*S KotlinDebug\n*F\n+ 1 FileSet2RootDescriptor.kt\ncom/intellij/openapi/roots/impl/FileSet2RootDescriptor\n*L\n22#1:56,4\n34#1:60,4\n51#1:64,4\n55#1:68\n55#1:69,2\n*E\n"})
public final class FileSet2RootDescriptor {
    @NotNull
    private static final Logger log;

    @Nullable
    public static final RootDescriptor findFileSetDescriptor(@NotNull WorkspaceFileSetWithCustomData<?> set, @NotNull ImmutableEntityStorage snapshot) {
        Intrinsics.checkNotNullParameter(set, (String)"set");
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        if (!(set instanceof StoredFileSet)) {
            Logger $this$trace$iv = log;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Unexpected file set: " + set);
            }
            return null;
        }
        Object data = set.getData();
        if (data instanceof DummyWorkspaceFileSetData) {
            return new DummyRootDescriptor(set.getRoot());
        }
        WorkspaceEntity entity = ((StoredFileSet)((Object)set)).getEntityPointer().resolve((EntityStorage)snapshot);
        if (entity instanceof LibraryEntity) {
            Library library = LibraryBridgesKt.findLibraryBridge((LibraryEntity)entity, (EntityStorage)snapshot);
            if (library == null) {
                boolean bl = false;
                Logger $this$trace$iv = log;
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    Logger logger = $this$trace$iv;
                    boolean bl2 = false;
                    logger.trace("Library is not found for " + entity + " in " + snapshot);
                }
                return null;
            }
            Library library2 = library;
            return new LibraryRootDescriptor(set.getRoot(), library2);
        }
        if (data instanceof ModuleSourceRootData) {
            Module module = ((ModuleSourceRootData)data).getModule();
            return new ModuleRootDescriptor(set.getRoot(), module);
        }
        Sdk sdk = SdkBridgeImpl.Companion.findSdk(snapshot, set);
        if (sdk != null) {
            return new SdkRootDescriptor(set.getRoot(), sdk);
        }
        Logger $this$trace$iv = log;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Unexpected data: " + data);
        }
        return null;
    }

    static {
        boolean $i$f$fileLogger = false;
        boolean $i$f$currentClassLogger = false;
        Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
        Logger logger = Logger.getInstance(clazz$iv$iv);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        log = logger;
    }
}

