/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.CollectHighlightsUtil;
import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.TextRangeScalarUtil;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.reference.SoftReference;
import com.intellij.util.Processor;
import com.intellij.util.containers.ConcurrentLongObjectMap;
import com.intellij.util.containers.Stack;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class Divider {
    private static final int STARTING_TREE_HEIGHT = 10;
    private static final Key<CachedStampedMap> CACHED_DIVIDED_ELEMENTS_KEY = Key.create((String)"CACHED_DIVIDED_ELEMENTS");
    private static final PsiElement HAVE_TO_GET_CHILDREN = PsiUtilCore.NULL_PSI_ELEMENT;

    public static void divideInsideAndOutsideAllRoots(@NotNull PsiFile psiFile, @NotNull TextRange restrictRange, @NotNull TextRange priorityRange, @Nullable Predicate<? super PsiFile> rootFilter, @NotNull Processor<? super DividedElements> processor) {
        if (psiFile == null) {
            Divider.$$$reportNull$$$0(0);
        }
        if (restrictRange == null) {
            Divider.$$$reportNull$$$0(1);
        }
        if (priorityRange == null) {
            Divider.$$$reportNull$$$0(2);
        }
        if (processor == null) {
            Divider.$$$reportNull$$$0(3);
        }
        FileViewProvider viewProvider = psiFile.getViewProvider();
        for (PsiFile root : viewProvider.getAllFiles()) {
            if (rootFilter == null || !rootFilter.test((PsiFile)root)) continue;
            Divider.divideInsideAndOutsideInOneRoot(root, TextRangeScalarUtil.toScalarRange((Segment)restrictRange), TextRangeScalarUtil.toScalarRange((Segment)priorityRange), processor);
        }
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    public static void divideInsideAndOutsideInOneRoot(@NotNull PsiFile root, long restrictRange, long priorityRange, @NotNull Processor<? super DividedElements> processor) {
        void processor2;
        DividedElements elements;
        CachedStampedMap cache;
        if (root == null) {
            Divider.$$$reportNull$$$0(4);
        }
        if (processor == null) {
            Divider.$$$reportNull$$$0(5);
        }
        long modificationStamp = root.getModificationStamp();
        while (true) {
            if ((cache = (CachedStampedMap)root.getUserData(CACHED_DIVIDED_ELEMENTS_KEY)) != null && cache.modificationStamp == modificationStamp) break;
            ((UserDataHolderEx)root).replace(CACHED_DIVIDED_ELEMENTS_KEY, (Object)cache, (Object)new CachedStampedMap(modificationStamp, (ConcurrentLongObjectMap<Reference<DividedElements>>)ConcurrentCollectionFactory.createConcurrentLongObjectMap()));
        }
        ConcurrentLongObjectMap<Reference<DividedElements>> cachedMap = cache.elements();
        DividedElements cached = (DividedElements)SoftReference.dereference((Reference)((Reference)cachedMap.get(restrictRange)));
        if (cached != null && TextRangeScalarUtil.contains((long)cached.priorityRange, (long)priorityRange)) {
            elements = cached;
        } else {
            ArrayList<PsiElement> inside = new ArrayList<PsiElement>();
            ArrayList<PsiElement> outside = new ArrayList<PsiElement>();
            ArrayList parents = new ArrayList();
            Divider.divideInsideAndOutsideInOneRoot(root, restrictRange, priorityRange, inside, outside, parents);
            elements = new DividedElements(root, priorityRange, inside, outside, parents);
            cachedMap.put(restrictRange, new java.lang.ref.SoftReference<DividedElements>(elements));
        }
        processor2.process((Object)elements);
    }

    /*
     * WARNING - void declaration
     */
    private static void divideInsideAndOutsideInOneRoot(@NotNull PsiFile root, long restrictRange, long priorityRange, @NotNull List<PsiElement> inside, @NotNull List<PsiElement> list, @NotNull List<? super PsiElement> list2) {
        PsiElement parent;
        void outside;
        if (root == null) {
            Divider.$$$reportNull$$$0(6);
        }
        if (inside == null) {
            Divider.$$$reportNull$$$0(7);
        }
        if (list == null) {
            Divider.$$$reportNull$$$0(8);
        }
        if (list2 == null) {
            Divider.$$$reportNull$$$0(9);
        }
        int startOffset = TextRangeScalarUtil.startOffset((long)restrictRange);
        int endOffset = TextRangeScalarUtil.endOffset((long)restrictRange);
        List filters = CollectHighlightsUtil.EP_NAME.getExtensionList();
        IntArrayList starts = new IntArrayList(10);
        starts.push(startOffset);
        Stack elements = new Stack(10);
        Stack children = new Stack(10);
        PsiFile element = root;
        PsiElement child = HAVE_TO_GET_CHILDREN;
        int offset = 0;
        while (true) {
            boolean startChildrenVisiting;
            ProgressManager.checkCanceled();
            for (Condition filter : filters) {
                if (filter.value((Object)element)) continue;
                assert (child == HAVE_TO_GET_CHILDREN);
                child = null;
                break;
            }
            if (child == HAVE_TO_GET_CHILDREN) {
                startChildrenVisiting = true;
                child = element.getFirstChild();
            } else {
                startChildrenVisiting = false;
            }
            if (child == null) {
                int start;
                if (startChildrenVisiting) {
                    offset += element.getTextLength();
                }
                if (startOffset <= (start = starts.popInt()) && offset <= endOffset) {
                    if (TextRangeScalarUtil.containsRange((long)priorityRange, (int)start, (int)offset)) {
                        inside.add((PsiElement)element);
                    } else {
                        outside.add(element);
                    }
                }
                if (elements.isEmpty()) break;
                element = (PsiElement)elements.pop();
                child = (PsiElement)children.pop();
                continue;
            }
            if (offset > endOffset) break;
            children.push((Object)child.getNextSibling());
            starts.push(offset);
            elements.push((Object)element);
            element = child;
            child = HAVE_TO_GET_CHILDREN;
        }
        PsiElement psiElement = !outside.isEmpty() ? (PsiElement)outside.getLast() : (parent = !inside.isEmpty() ? inside.getLast() : CollectHighlightsUtil.findCommonParent((PsiElement)root, (int)startOffset, (int)endOffset));
        while (parent != null && !(parent instanceof PsiFile)) {
            void outParents;
            if ((parent = parent.getParent()) == null) continue;
            outParents.add(parent);
            TextRange textRange = parent.getTextRange();
            assert (textRange != null) : "Text range for " + String.valueOf(parent) + " is null. " + String.valueOf(parent.getClass()) + "; root: " + String.valueOf(root) + ": " + String.valueOf(root.getVirtualFile());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restrictRange";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "priorityRange";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inside";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outside";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outParents";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/Divider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "divideInsideAndOutsideAllRoots";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "divideInsideAndOutsideInOneRoot";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private record CachedStampedMap(long modificationStamp, @NotNull ConcurrentLongObjectMap<Reference<DividedElements>> elements) {
        @NotNull
        private final ConcurrentLongObjectMap<Reference<DividedElements>> elements;

        /*
         * WARNING - void declaration
         */
        private CachedStampedMap(long modificationStamp, @NotNull ConcurrentLongObjectMap<Reference<DividedElements>> concurrentLongObjectMap) {
            void elements;
            if (concurrentLongObjectMap == null) {
                CachedStampedMap.$$$reportNull$$$0(0);
            }
            this.modificationStamp = modificationStamp;
            this.elements = elements;
        }

        @NotNull
        public ConcurrentLongObjectMap<Reference<DividedElements>> elements() {
            ConcurrentLongObjectMap<Reference<DividedElements>> concurrentLongObjectMap = this.elements;
            if (concurrentLongObjectMap == null) {
                CachedStampedMap.$$$reportNull$$$0(1);
            }
            return concurrentLongObjectMap;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elements";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/Divider$CachedStampedMap";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/Divider$CachedStampedMap";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "elements";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public record DividedElements(@NotNull PsiFile psiRoot, long priorityRange, @NotNull @NotNull List<? extends @NotNull PsiElement> inside, @NotNull @NotNull List<? extends @NotNull PsiElement> outside, @NotNull @NotNull List<? extends @NotNull PsiElement> parents) {
        @NotNull
        private final PsiFile psiRoot;
        @NotNull
        private final @NotNull List<? extends @NotNull PsiElement> inside;
        @NotNull
        private final @NotNull List<? extends @NotNull PsiElement> outside;
        @NotNull
        private final @NotNull List<? extends @NotNull PsiElement> parents;

        /*
         * WARNING - void declaration
         */
        public DividedElements(@NotNull PsiFile psiRoot, long priorityRange, @NotNull @NotNull List<? extends @NotNull PsiElement> inside, @NotNull @NotNull List<? extends @NotNull PsiElement> outside, @NotNull @NotNull List<? extends @NotNull PsiElement> list) {
            void parents;
            if (psiRoot == null) {
                DividedElements.$$$reportNull$$$0(0);
            }
            if (inside == null) {
                DividedElements.$$$reportNull$$$0(1);
            }
            if (outside == null) {
                DividedElements.$$$reportNull$$$0(2);
            }
            if (list == null) {
                DividedElements.$$$reportNull$$$0(3);
            }
            this.psiRoot = psiRoot;
            this.priorityRange = priorityRange;
            this.inside = inside;
            this.outside = outside;
            this.parents = parents;
        }

        @NotNull
        public PsiFile psiRoot() {
            PsiFile psiFile = this.psiRoot;
            if (psiFile == null) {
                DividedElements.$$$reportNull$$$0(4);
            }
            return psiFile;
        }

        @NotNull
        public @NotNull List<? extends @NotNull PsiElement> inside() {
            List<? extends PsiElement> list = this.inside;
            if (list == null) {
                DividedElements.$$$reportNull$$$0(5);
            }
            return list;
        }

        @NotNull
        public @NotNull List<? extends @NotNull PsiElement> outside() {
            List<? extends PsiElement> list = this.outside;
            if (list == null) {
                DividedElements.$$$reportNull$$$0(6);
            }
            return list;
        }

        @NotNull
        public @NotNull List<? extends @NotNull PsiElement> parents() {
            List<? extends PsiElement> list = this.parents;
            if (list == null) {
                DividedElements.$$$reportNull$$$0(7);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5, 6, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiRoot";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inside";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outside";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parents";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/Divider$DividedElements";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/Divider$DividedElements";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "psiRoot";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "inside";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "outside";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "parents";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5, 6, 7 -> new IllegalStateException(string);
            };
        }
    }
}

