/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.find.FindUsagesSettings;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PredefinedSearchScopeProvider;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FindUsagesOptions
implements Cloneable {
    @NotNull
    public SearchScope searchScope;
    @ApiStatus.Internal
    public boolean isMaximalScope;
    public boolean isSearchForTextOccurrences;
    public boolean isUsages;
    public SearchRequestCollector fastTrack;

    public FindUsagesOptions(@NotNull Project project) {
        if (project == null) {
            FindUsagesOptions.$$$reportNull$$$0(0);
        }
        this(project, null);
    }

    public FindUsagesOptions(@NotNull Project project, @Nullable DataContext dataContext) {
        if (project == null) {
            FindUsagesOptions.$$$reportNull$$$0(1);
        }
        this(FindUsagesOptions.findScopeByName(project, dataContext, FindUsagesSettings.getInstance().getDefaultScopeName()));
    }

    public FindUsagesOptions(@NotNull SearchScope searchScope) {
        if (searchScope == null) {
            FindUsagesOptions.$$$reportNull$$$0(2);
        }
        this.isMaximalScope = false;
        this.isSearchForTextOccurrences = true;
        this.searchScope = searchScope;
    }

    @ApiStatus.Internal
    @NotNull
    public static SearchScope findScopeByName(@NotNull Project project, @Nullable DataContext dataContext, @Nullable String scopeName) {
        if (project == null) {
            FindUsagesOptions.$$$reportNull$$$0(3);
        }
        List<SearchScope> predefined = PredefinedSearchScopeProvider.getInstance().getPredefinedScopes(project, dataContext, true, false, false, false, false);
        for (SearchScope scope : predefined) {
            if (!scope.getDisplayName().equals(scopeName)) continue;
            SearchScope searchScope = scope;
            if (searchScope == null) {
                FindUsagesOptions.$$$reportNull$$$0(4);
            }
            return searchScope;
        }
        return FindUsagesOptions.getDefaultScope(project);
    }

    @ApiStatus.Internal
    @NotNull
    public static SearchScope getDefaultScope(@NotNull Project project) {
        if (project == null) {
            FindUsagesOptions.$$$reportNull$$$0(5);
        }
        GlobalSearchScope globalSearchScope = ProjectScope.getProjectScope((Project)project);
        if (globalSearchScope == null) {
            FindUsagesOptions.$$$reportNull$$$0(6);
        }
        return globalSearchScope;
    }

    public FindUsagesOptions clone() {
        try {
            return (FindUsagesOptions)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FindUsagesOptions that = (FindUsagesOptions)o;
        if (this.isSearchForTextOccurrences != that.isSearchForTextOccurrences) {
            return false;
        }
        if (this.isUsages != that.isUsages) {
            return false;
        }
        return this.searchScope.equals(that.searchScope);
    }

    public int hashCode() {
        int result = this.searchScope.hashCode();
        result = 31 * result + (this.isSearchForTextOccurrences ? 1 : 0);
        result = 31 * result + (this.isUsages ? 1 : 0);
        return result;
    }

    @NonNls
    public String toString() {
        return this.getClass().getSimpleName() + "{searchScope=" + String.valueOf(this.searchScope) + ", isSearchForTextOccurrences=" + this.isSearchForTextOccurrences + ", isUsages=" + this.isUsages + "}";
    }

    @NotNull
    @Nls
    public String generateUsagesString() {
        String string = AnalysisBundle.message((String)"find.usages.panel.title.usages", (Object[])new Object[0]);
        if (string == null) {
            FindUsagesOptions.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/find/findUsages/FindUsagesOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/find/findUsages/FindUsagesOptions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findScopeByName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultScope";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "generateUsagesString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findScopeByName";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultScope";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6, 7 -> new IllegalStateException(string);
        };
    }
}

