/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.util.io.storages.intmultimaps.extendiblehashmap;

import com.intellij.openapi.util.Pair;
import com.intellij.platform.util.io.storages.intmultimaps.DurableIntToMultiIntMap;
import com.intellij.platform.util.io.storages.mmapped.MMappedFileStorage;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.ClosedStorageException;
import com.intellij.util.io.CorruptedException;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.Unmappable;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public class ExtendibleHashMap
implements DurableIntToMultiIntMap,
Unmappable {
    public static final int IMPLEMENTATION_VERSION = 1;
    public static final int MAGIC_WORD = IOUtil.asciiToMagicWord((String)"EHMM");
    public static final int DEFAULT_SEGMENT_SIZE = 32768;
    public static final int DEFAULT_SEGMENTS_PER_PAGE = 32;
    public static final int DEFAULT_STORAGE_PAGE_SIZE = 0x100000;
    private static final boolean MARK_SAFELY_CLOSED_ON_FLUSH = SystemProperties.getBooleanProperty((String)"ExtendibleHashMap.MARK_SAFELY_CLOSED_ON_FLUSH", (boolean)true);
    private final MMappedFileStorage storage;
    private transient BufferSource bufferSource;
    private boolean dirty;
    private final boolean wasProperlyClosed;
    private transient HeaderLayout header;
    private final transient Int2ObjectMap<HashMapSegmentLayout> segmentsCache;
    private final transient HashMapAlgo hashMapAlgo;
    private static final int INT_GOLDEN_RATIO = -1640531527;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExtendibleHashMap(@NotNull MMappedFileStorage storage, int segmentSize) throws IOException {
        if (storage == null) {
            ExtendibleHashMap.$$$reportNull$$$0(0);
        }
        this.dirty = false;
        this.segmentsCache = new Int2ObjectOpenHashMap();
        this.hashMapAlgo = new HashMapAlgo(0.5f);
        if (Integer.bitCount(segmentSize) != 1) {
            throw new IllegalArgumentException("segmentSize(=" + segmentSize + ") must be power of 2");
        }
        int pageSize = storage.pageSize();
        if (segmentSize > pageSize) {
            throw new IllegalArgumentException("segmentSize(=" + segmentSize + ") must be <= pageSize(=" + pageSize + ")");
        }
        if (pageSize % segmentSize != 0) {
            throw new IllegalArgumentException("segmentSize(=" + segmentSize + ") must align with pageSize(=" + pageSize + ")");
        }
        ExtendibleHashMap extendibleHashMap = this;
        synchronized (extendibleHashMap) {
            this.storage = storage;
            boolean fileIsEmpty = storage.actualFileSize() == 0L;
            this.bufferSource = new BufferSourceOverMMappedFileStorage(storage);
            this.header = new HeaderLayout(this.bufferSource, segmentSize);
            if (fileIsEmpty) {
                this.initEmptyMap(segmentSize);
                this.wasProperlyClosed = true;
            } else {
                int magicWord = this.header.magicWord();
                if (magicWord != MAGIC_WORD) {
                    throw new IOException("[" + String.valueOf(storage.storagePath()) + "] is of incorrect type: .magicWord(=" + magicWord + ", '" + IOUtil.magicWordToASCII((int)magicWord) + "') != " + MAGIC_WORD + " expected");
                }
                if (this.header.version() != 1) {
                    throw new IOException("[" + String.valueOf(storage.storagePath()) + "]: version(=" + this.header.version() + ") != current impl version(=1)");
                }
                if (this.header.segmentSize() != segmentSize) {
                    throw new IOException("[" + String.valueOf(storage.storagePath()) + "]: segmentSize(=" + segmentSize + ") != segmentSize(=" + this.header.segmentSize() + ") storage was initialized with");
                }
                this.wasProperlyClosed = this.header.fileStatus() == 1;
                this.header.fileStatus((byte)1);
            }
        }
    }

    private void initEmptyMap(int segmentSize) throws IOException {
        this.header.magicWord(MAGIC_WORD);
        this.header.version(1);
        this.header.segmentSize(segmentSize);
        this.header.fileStatus((byte)1);
        this.header.globalHashSuffixDepth(0);
        this.header.actualSegmentsCount(0);
        HashMapSegmentLayout segment = this.allocateSegment(0, this.header.globalHashSuffixDepth());
        this.header.updateSegmentIndex(0, segment.segmentIndex());
    }

    public synchronized boolean wasProperlyClosed() {
        return this.wasProperlyClosed;
    }

    @Override
    public synchronized boolean put(int key, int value) throws IOException {
        HashMapSegmentLayout segment = this.segmentForKey(key);
        return this.putAndSplitSegmentIfNeeded(segment, key, value);
    }

    @Override
    public synchronized boolean has(int key, int value) throws IOException {
        HashMapSegmentLayout segment = this.segmentForKey(key);
        return this.hashMapAlgo.has(segment, key, value);
    }

    @Override
    public synchronized int lookup(int key, @NotNull DurableIntToMultiIntMap.ValueAcceptor valuesAcceptor) throws IOException {
        if (valuesAcceptor == null) {
            ExtendibleHashMap.$$$reportNull$$$0(1);
        }
        HashMapSegmentLayout segment = this.segmentForKey(key);
        return this.hashMapAlgo.lookup(segment, key, valuesAcceptor);
    }

    @Override
    public synchronized int lookupOrInsert(int key, @NotNull DurableIntToMultiIntMap.ValueAcceptor valuesAcceptor, @NotNull DurableIntToMultiIntMap.ValueCreator valueCreator) throws IOException {
        HashMapSegmentLayout segment;
        int valueFound;
        if (valuesAcceptor == null) {
            ExtendibleHashMap.$$$reportNull$$$0(2);
        }
        if (valueCreator == null) {
            ExtendibleHashMap.$$$reportNull$$$0(3);
        }
        if ((valueFound = this.hashMapAlgo.lookup(segment = this.segmentForKey(key), key, valuesAcceptor)) != 0) {
            return valueFound;
        }
        int newValue = valueCreator.newValueForKey(key);
        boolean reallyPut = this.putAndSplitSegmentIfNeeded(segment, key, newValue);
        assert (reallyPut) : key + " must be really put since we've checked it wasn't there";
        return newValue;
    }

    @Override
    public synchronized boolean remove(int key, int value) throws IOException {
        HashMapSegmentLayout segment = this.segmentForKey(key);
        return this.hashMapAlgo.remove(segment, key, value);
    }

    @Override
    public synchronized boolean replace(int key, int oldValue, int newValue) throws IOException {
        HashMapSegmentLayout segment = this.segmentForKey(key);
        return this.hashMapAlgo.replace(segment, key, oldValue, newValue);
    }

    @Override
    public synchronized int size() throws IOException {
        this.checkNotClosed();
        int segmentSize = this.header.segmentSize();
        int segmentsCount = this.header.actualSegmentsCount();
        int totalEntries = 0;
        for (int segmentIndex = 1; segmentIndex <= segmentsCount; ++segmentIndex) {
            totalEntries += HashMapSegmentLayout.aliveEntriesCount(this.bufferSource, segmentIndex, segmentSize);
        }
        return totalEntries;
    }

    @Override
    public synchronized boolean isEmpty() throws IOException {
        this.checkNotClosed();
        int segmentSize = this.header.segmentSize();
        int segmentsCount = this.header.actualSegmentsCount();
        for (int segmentIndex = 1; segmentIndex <= segmentsCount; ++segmentIndex) {
            int aliveEntriesCount = HashMapSegmentLayout.aliveEntriesCount(this.bufferSource, segmentIndex, segmentSize);
            if (aliveEntriesCount <= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public synchronized boolean forEach(@NotNull DurableIntToMultiIntMap.KeyValueProcessor processor) throws IOException {
        if (processor == null) {
            ExtendibleHashMap.$$$reportNull$$$0(4);
        }
        this.checkNotClosed();
        int segmentSize = this.header.segmentSize();
        int segmentsCount = this.header.actualSegmentsCount();
        for (int segmentIndex = 1; segmentIndex <= segmentsCount; ++segmentIndex) {
            HashMapSegmentLayout segment = new HashMapSegmentLayout(this.bufferSource, segmentIndex, segmentSize);
            if (segment.aliveEntriesCount() <= 0 || this.hashMapAlgo.forEach(segment, processor)) continue;
            return false;
        }
        return true;
    }

    @Override
    public synchronized void clear() throws IOException {
        this.checkNotClosed();
        if (this.header.actualSegmentsCount() == 1 && this.isEmpty()) {
            return;
        }
        int segmentSize = this.header.segmentSize();
        this.segmentsCache.clear();
        this.storage.zeroizeTillEOF(0L);
        this.initEmptyMap(segmentSize);
        this.dirty = true;
    }

    @Override
    public synchronized void flush() throws IOException {
        if (MARK_SAFELY_CLOSED_ON_FLUSH && this.dirty) {
            this.dirty = false;
            this.header.fileStatus((byte)1);
        }
    }

    public synchronized boolean isDirty() {
        return this.dirty;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.storage.isOpen()) {
            if (this.dirty) {
                this.header.fileStatus((byte)1);
            }
            this.storage.close();
            this.segmentsCache.clear();
            this.header = null;
            this.bufferSource = null;
        }
    }

    @Override
    public synchronized boolean isClosed() {
        return !this.storage.isOpen();
    }

    public synchronized void closeAndUnsafelyUnmap() throws IOException {
        this.close();
        this.storage.closeAndUnsafelyUnmap();
    }

    public synchronized void closeAndClean() throws IOException {
        this.close();
        this.storage.closeAndClean();
    }

    public String toString() {
        return "ExtendibleHashMap[" + String.valueOf(this.storage.storagePath()) + "][opened: " + this.storage.isOpen() + "][wasProperlyClosed: " + this.wasProperlyClosed + "]";
    }

    private void checkNotClosed() throws IOException {
        if (!this.storage.isOpen()) {
            throw new ClosedStorageException("Storage [" + String.valueOf(this.storage) + "] is closed");
        }
    }

    private void markModified() {
        if (!this.dirty) {
            this.dirty = true;
            this.header.fileStatus((byte)0);
        }
    }

    private HashMapSegmentLayout segmentForKey(int key) throws IOException {
        this.checkNotClosed();
        int hash = ExtendibleHashMap.hash(key);
        int segmentIndex = this.header.segmentIndexByHash(hash);
        HashMapSegmentLayout layout = (HashMapSegmentLayout)this.segmentsCache.get(segmentIndex);
        if (layout == null) {
            layout = new HashMapSegmentLayout(this.bufferSource, segmentIndex, this.header.segmentSize());
            this.segmentsCache.put(segmentIndex, (Object)layout);
        }
        return layout;
    }

    private void splitAndRearrangeEntries(HashMapSegmentLayout segment) throws IOException {
        int[] newSegmentSlotIndexes;
        byte segmentHashDepth;
        byte hashSuffixDepth = this.header.globalHashSuffixDepth();
        if (hashSuffixDepth == (segmentHashDepth = segment.hashSuffixDepth())) {
            this.doubleSegmentsTable();
        }
        assert (this.header.globalHashSuffixDepth() > segment.hashSuffixDepth()) : "globalHashSuffixDepth(=" + this.header.globalHashSuffixDepth() + ") must be > segment.hashSuffixDepth(=" + segment.hashSuffixDepth() + ")";
        Pair<HashMapSegmentLayout, HashMapSegmentLayout> splitSegments = this.split(segment);
        HashMapSegmentLayout oldSegment = (HashMapSegmentLayout)splitSegments.first;
        HashMapSegmentLayout newSegment = (HashMapSegmentLayout)splitSegments.second;
        for (int segmentSlotIndex : newSegmentSlotIndexes = ExtendibleHashMap.slotIndexesForSegment(newSegment.hashSuffix(), newSegment.hashSuffixDepth(), this.header.globalHashSuffixDepth())) {
            int segmentIndex = this.header.segmentIndex(segmentSlotIndex);
            assert (segmentIndex == oldSegment.segmentIndex()) : "segment[" + segmentSlotIndex + "].segmentIndex(=" + segmentIndex + ") but it must be " + oldSegment.segmentIndex();
            this.header.updateSegmentIndex(segmentSlotIndex, newSegment.segmentIndex());
        }
    }

    @VisibleForTesting
    public static int[] slotIndexesForSegment(int segmentHashSuffix, byte segmentHashSuffixDepth, byte globalHashSuffixDepth) {
        assert ((segmentHashSuffix & ~ExtendibleHashMap.suffixMask(segmentHashSuffixDepth)) == 0);
        assert (globalHashSuffixDepth >= segmentHashSuffixDepth) : "globalDepth(=" + globalHashSuffixDepth + ") must be >= segmentDepth(=" + segmentHashSuffixDepth + ")";
        int indexesCount = 1 << globalHashSuffixDepth - segmentHashSuffixDepth;
        int[] slotIndexes = new int[indexesCount];
        for (int i = 0; i < indexesCount; ++i) {
            int prefix = i << segmentHashSuffixDepth;
            slotIndexes[i] = prefix | segmentHashSuffix;
        }
        return slotIndexes;
    }

    private boolean putAndSplitSegmentIfNeeded(HashMapSegmentLayout segment, int key, int value) throws IOException {
        boolean wasReallyPut = this.hashMapAlgo.put(segment, key, value);
        if (wasReallyPut) {
            this.markModified();
        }
        if (this.hashMapAlgo.needsSplit(segment)) {
            this.splitAndRearrangeEntries(segment);
        }
        return wasReallyPut;
    }

    private HashMapSegmentLayout allocateSegment(int hashSuffix, byte hashSuffixDepth) throws IOException {
        int segmentsCount = this.header.actualSegmentsCount();
        int segmentIndex = segmentsCount + 1;
        HashMapSegmentLayout segment = new HashMapSegmentLayout(this.bufferSource, segmentIndex, this.header.segmentSize());
        segment.updateHashSuffix(hashSuffix, hashSuffixDepth);
        this.header.actualSegmentsCount(segmentsCount + 1);
        return segment;
    }

    private Pair<HashMapSegmentLayout, HashMapSegmentLayout> split(@NotNull HashMapSegmentLayout segmentToSplit) throws IOException {
        if (segmentToSplit == null) {
            ExtendibleHashMap.$$$reportNull$$$0(5);
        }
        int oldHashSuffix = segmentToSplit.hashSuffix();
        byte oldHashSuffixDepth = segmentToSplit.hashSuffixDepth();
        byte newHashSuffixDepth = (byte)(oldHashSuffixDepth + 1);
        int highestSuffixBit = 1 << newHashSuffixDepth - 1;
        int hashSuffix0 = oldHashSuffix;
        int hashSuffix1 = oldHashSuffix | highestSuffixBit;
        assert (hashSuffix0 != hashSuffix1) : "hashSuffixes must be different for splitting segments, but " + hashSuffix0 + " == " + hashSuffix1;
        HashMapSegmentLayout newSegment = this.allocateSegment(hashSuffix1, newHashSuffixDepth);
        segmentToSplit.updateHashSuffix(hashSuffix0, newHashSuffixDepth);
        int hashSuffixMask = segmentToSplit.hashSuffixMask();
        int entriesCount = segmentToSplit.entriesCount();
        for (int i = 0; i < entriesCount; ++i) {
            int hash;
            int key = segmentToSplit.entryKey(i);
            if (!this.hashMapAlgo.isSlotOccupied(key) || ((hash = ExtendibleHashMap.hash(key)) & hashSuffixMask) == hashSuffix0) continue;
            int value = segmentToSplit.entryValue(i);
            this.hashMapAlgo.markEntryAsDeleted(segmentToSplit, i);
            this.hashMapAlgo.put(newSegment, key, value);
        }
        return Pair.pair((Object)segmentToSplit, (Object)newSegment);
    }

    private void doubleSegmentsTable() throws IOException {
        byte hashSuffixDepth = this.header.globalHashSuffixDepth();
        int oldTableSize = this.header.segmentTableSize();
        if (oldTableSize * 2 > this.header.maxSegmentTableSize()) {
            throw new IllegalStateException("Can't expand table: currentSize=" + this.header.segmentTableSize() + " x2 > maxSize=" + this.header.maxSegmentTableSize() + " -> try increase segmentSize(=" + this.header.segmentSize() + ") if you need to store more keys");
        }
        this.header.globalHashSuffixDepth(hashSuffixDepth + 1);
        for (int i = 0; i < oldTableSize; ++i) {
            int segmentIndex = this.header.segmentIndex(i);
            this.header.updateSegmentIndex(oldTableSize + i, segmentIndex);
        }
    }

    private static int segmentSlotIndex(int hash, int hashSuffixDepth) {
        int segmentMask = ExtendibleHashMap.suffixMask(hashSuffixDepth);
        return hash & segmentMask;
    }

    private static int suffixMask(int suffixSize) {
        if (suffixSize == 32) {
            return -1;
        }
        return (1 << suffixSize) - 1;
    }

    private static int hash(int key) {
        int h = key * -1640531527;
        return h ^ h >>> 16;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valuesAcceptor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueCreator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "segmentToSplit";
                break;
            }
        }
        objectArray2[1] = "com/intellij/platform/util/io/storages/intmultimaps/extendiblehashmap/ExtendibleHashMap";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "lookup";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "lookupOrInsert";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "forEach";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "split";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class HashMapAlgo {
        public static final int NO_VALUE = 0;
        private final float loadFactor;

        private HashMapAlgo(float loadFactor) {
            this.loadFactor = loadFactor;
        }

        public int lookup(@NotNull HashTableData table, int key, DurableIntToMultiIntMap.ValueAcceptor valuesAcceptor) throws IOException {
            if (table == null) {
                HashMapAlgo.$$$reportNull$$$0(0);
            }
            HashMapAlgo.checkNotNoValue("key", key);
            int capacity = this.capacity(table);
            int startIndex = Math.abs(ExtendibleHashMap.hash(key) % capacity);
            for (int probe = 0; probe < capacity; ++probe) {
                int slotIndex = (startIndex + probe) % capacity;
                int slotKey = table.entryKey(slotIndex);
                int slotValue = table.entryValue(slotIndex);
                if (slotKey == key) {
                    assert (slotValue != 0) : "value(table[" + (slotIndex * 2 + 1) + "]) = 0 (NO_VALUE), while key(table[" + slotIndex * 2 + "]) = " + key;
                    if (!valuesAcceptor.accept(slotValue)) continue;
                    return slotValue;
                }
                if (slotKey == 0 && slotValue == 0) break;
            }
            return 0;
        }

        public boolean has(@NotNull HashTableData table, int key, int value) {
            if (table == null) {
                HashMapAlgo.$$$reportNull$$$0(1);
            }
            HashMapAlgo.checkNotNoValue("key", key);
            HashMapAlgo.checkNotNoValue("value", value);
            int capacity = this.capacity(table);
            int startIndex = Math.abs(ExtendibleHashMap.hash(key) % capacity);
            for (int probe = 0; probe < capacity; ++probe) {
                int slotIndex = (startIndex + probe) % capacity;
                int slotKey = table.entryKey(slotIndex);
                int slotValue = table.entryValue(slotIndex);
                if (slotKey == key && slotValue == value) {
                    return true;
                }
                if (slotKey == 0 && slotValue == 0) break;
            }
            return false;
        }

        public boolean put(@NotNull HashTableData table, int key, int value) {
            if (table == null) {
                HashMapAlgo.$$$reportNull$$$0(2);
            }
            HashMapAlgo.checkNotNoValue("key", key);
            HashMapAlgo.checkNotNoValue("value", value);
            int capacity = this.capacity(table);
            int startIndex = Math.abs(ExtendibleHashMap.hash(key) % capacity);
            int firstTombstoneIndex = -1;
            for (int probe = 0; probe < capacity; ++probe) {
                int slotIndex = (startIndex + probe) % capacity;
                int slotKey = table.entryKey(slotIndex);
                int slotValue = table.entryValue(slotIndex);
                if (slotKey == key && slotValue == value) {
                    return false;
                }
                if (this.isSlotOccupied(slotKey)) continue;
                if (slotValue != 0) {
                    if (firstTombstoneIndex != -1) continue;
                    firstTombstoneIndex = slotIndex;
                    continue;
                }
                int insertionIndex = firstTombstoneIndex >= 0 ? firstTombstoneIndex : slotIndex;
                table.updateEntry(insertionIndex, key, value);
                HashMapAlgo.incrementAliveValues(table);
                return true;
            }
            if (HashMapAlgo.aliveValues(table) == 0) {
                for (int slot = 0; slot < capacity; ++slot) {
                    table.updateEntry(slot, 0, 0);
                }
                return this.put(table, key, value);
            }
            if (firstTombstoneIndex != -1) {
                table.updateEntry(firstTombstoneIndex, key, value);
                HashMapAlgo.incrementAliveValues(table);
                return true;
            }
            throw new AssertionError((Object)("Table is full: all " + capacity + " items were traversed, but no free slot found, table: " + String.valueOf(table)));
        }

        public boolean remove(@NotNull HashTableData table, int key, int value) {
            if (table == null) {
                HashMapAlgo.$$$reportNull$$$0(3);
            }
            HashMapAlgo.checkNotNoValue("key", key);
            HashMapAlgo.checkNotNoValue("value", value);
            int capacity = this.capacity(table);
            int startIndex = Math.abs(ExtendibleHashMap.hash(key) % capacity);
            for (int probe = 0; probe < capacity; ++probe) {
                int slotIndex = (startIndex + probe) % capacity;
                int slotKey = table.entryKey(slotIndex);
                int slotValue = table.entryValue(slotIndex);
                if (slotKey == key && slotValue == value) {
                    this.markEntryAsDeleted(table, slotIndex);
                    return true;
                }
                if (slotKey != 0 || slotValue != 0) continue;
                return false;
            }
            return false;
        }

        public boolean replace(@NotNull HashTableData table, int key, int oldValue, int newValue) {
            if (table == null) {
                HashMapAlgo.$$$reportNull$$$0(4);
            }
            HashMapAlgo.checkNotNoValue("key", key);
            HashMapAlgo.checkNotNoValue("oldValue", oldValue);
            HashMapAlgo.checkNotNoValue("newValue", newValue);
            int capacity = this.capacity(table);
            int startIndex = Math.abs(ExtendibleHashMap.hash(key) % capacity);
            int oldValueSlotIndex = -1;
            int newValueSlotIndex = -1;
            for (int probe = 0; probe < capacity; ++probe) {
                int slotIndex = (startIndex + probe) % capacity;
                int slotKey = table.entryKey(slotIndex);
                int slotValue = table.entryValue(slotIndex);
                if (slotKey == key) {
                    if (slotValue == oldValue) {
                        oldValueSlotIndex = slotIndex;
                    } else if (slotValue == newValue) {
                        newValueSlotIndex = slotIndex;
                    }
                }
                if (slotKey == 0 && slotValue == 0) break;
            }
            if (oldValueSlotIndex != -1) {
                if (newValueSlotIndex != -1) {
                    this.markEntryAsDeleted(table, oldValueSlotIndex);
                } else {
                    table.updateEntry(oldValueSlotIndex, key, newValue);
                }
                return true;
            }
            return false;
        }

        public boolean forEach(@NotNull HashTableData table, @NotNull DurableIntToMultiIntMap.KeyValueProcessor processor) throws IOException {
            if (table == null) {
                HashMapAlgo.$$$reportNull$$$0(5);
            }
            if (processor == null) {
                HashMapAlgo.$$$reportNull$$$0(6);
            }
            int capacity = this.capacity(table);
            for (int index = 0; index < capacity; ++index) {
                int key = table.entryKey(index);
                int value = table.entryValue(index);
                if (!this.isSlotOccupied(key)) continue;
                assert (value != 0) : "value(table[" + (index + 1) + "]) = 0, while key(table[" + index + "]) = " + key;
                if (processor.process(key, value)) continue;
                return false;
            }
            return true;
        }

        public boolean isSlotOccupied(int key) {
            return key != 0;
        }

        public int capacity(@NotNull HashTableData table) {
            if (table == null) {
                HashMapAlgo.$$$reportNull$$$0(7);
            }
            return table.entriesCount();
        }

        public boolean needsSplit(@NotNull HashTableData table) {
            if (table == null) {
                HashMapAlgo.$$$reportNull$$$0(8);
            }
            return (float)HashMapAlgo.aliveValues(table) > (float)this.capacity(table) * this.loadFactor;
        }

        public int size(@NotNull HashTableData table) {
            if (table == null) {
                HashMapAlgo.$$$reportNull$$$0(9);
            }
            return HashMapAlgo.aliveValues(table);
        }

        public void markEntryAsDeleted(@NotNull HashTableData table, int entryIndex) {
            if (table == null) {
                HashMapAlgo.$$$reportNull$$$0(10);
            }
            table.updateEntry(entryIndex, 0, table.entryValue(entryIndex));
            HashMapAlgo.decrementAliveValues(table);
        }

        private static int aliveValues(@NotNull HashTableData table) {
            if (table == null) {
                HashMapAlgo.$$$reportNull$$$0(11);
            }
            return table.aliveEntriesCount();
        }

        private static void incrementAliveValues(@NotNull HashTableData table) {
            if (table == null) {
                HashMapAlgo.$$$reportNull$$$0(12);
            }
            table.updateAliveEntriesCount(table.aliveEntriesCount() + 1);
        }

        private static void decrementAliveValues(@NotNull HashTableData table) {
            if (table == null) {
                HashMapAlgo.$$$reportNull$$$0(13);
            }
            table.updateAliveEntriesCount(table.aliveEntriesCount() - 1);
        }

        private static void checkNotNoValue(String paramName, int value) {
            if (value == 0) {
                throw new IllegalArgumentException(paramName + " can't be = 0 -- it is special value used as NO_VALUE");
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/platform/util/io/storages/intmultimaps/extendiblehashmap/ExtendibleHashMap$HashMapAlgo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lookup";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "has";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "put";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "remove";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "replace";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "forEach";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "capacity";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "needsSplit";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "size";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "markEntryAsDeleted";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "aliveValues";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[2] = "incrementAliveValues";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[2] = "decrementAliveValues";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private record BufferSourceOverMMappedFileStorage(@NotNull MMappedFileStorage storage) implements BufferSource
    {
        @NotNull
        private final MMappedFileStorage storage;

        private BufferSourceOverMMappedFileStorage(@NotNull MMappedFileStorage storage) {
            if (storage == null) {
                BufferSourceOverMMappedFileStorage.$$$reportNull$$$0(0);
            }
        }

        @Override
        @NotNull
        public ByteBuffer slice(long offsetInFile, int length) throws IOException {
            ByteBuffer buffer = this.storage.pageByOffset(offsetInFile).rawPageBuffer();
            int offsetInPage = this.storage.toOffsetInPage(offsetInFile);
            ByteBuffer byteBuffer = buffer.slice(offsetInPage, length).order(buffer.order());
            if (byteBuffer == null) {
                BufferSourceOverMMappedFileStorage.$$$reportNull$$$0(1);
            }
            return byteBuffer;
        }

        @Override
        public int getInt(long offsetInFile) throws IOException {
            ByteBuffer buffer = this.storage.pageByOffset(offsetInFile).rawPageBuffer();
            int offsetInPage = this.storage.toOffsetInPage(offsetInFile);
            return buffer.getInt(offsetInPage);
        }

        @Override
        public String toString() {
            return "BufferSourceOverMMappedFileStorage{" + String.valueOf(this.storage) + "}";
        }

        @NotNull
        public MMappedFileStorage storage() {
            MMappedFileStorage mMappedFileStorage = this.storage;
            if (mMappedFileStorage == null) {
                BufferSourceOverMMappedFileStorage.$$$reportNull$$$0(2);
            }
            return mMappedFileStorage;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "storage";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/platform/util/io/storages/intmultimaps/extendiblehashmap/ExtendibleHashMap$BufferSourceOverMMappedFileStorage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/platform/util/io/storages/intmultimaps/extendiblehashmap/ExtendibleHashMap$BufferSourceOverMMappedFileStorage";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "slice";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "storage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }

    public static interface BufferSource {
        @NotNull
        public ByteBuffer slice(long var1, int var3) throws IOException;

        public int getInt(long var1) throws IOException;
    }

    static final class HeaderLayout {
        public static final int MAGIC_WORD_OFFSET = 0;
        public static final int VERSION_OFFSET = 4;
        public static final int SEGMENT_SIZE_OFFSET = 8;
        public static final int ACTUAL_SEGMENTS_COUNT_OFFSET = 12;
        public static final int GLOBAL_HASH_SUFFIX_DEPTH_OFFSET = 16;
        public static final int FILE_STATUS_OFFSET = 17;
        public static final int FIRST_FREE_OFFSET = 18;
        public static final int STATIC_HEADER_SIZE = 80;
        private static final int SEGMENTS_TABLE_OFFSET = 80;
        public static final byte FILE_STATUS_PROPERLY_CLOSED = 1;
        public static final byte FILE_STATUS_OPENED = 0;
        private final ByteBuffer headerBuffer;
        private final transient int headerSegmentSize;

        HeaderLayout(@NotNull BufferSource bufferSource, int headerSegmentSize) throws IOException {
            if (bufferSource == null) {
                HeaderLayout.$$$reportNull$$$0(0);
            }
            if (headerSegmentSize <= 80) {
                throw new IllegalArgumentException("headerSize(=" + headerSegmentSize + ") must be > STATIC_HEADER_SIZE(=80)");
            }
            this.headerSegmentSize = headerSegmentSize;
            this.headerBuffer = bufferSource.slice(0L, headerSegmentSize);
        }

        public int magicWord() {
            return this.headerBuffer.getInt(0);
        }

        public void magicWord(int magicWord) {
            this.headerBuffer.putInt(0, magicWord);
        }

        public int version() {
            return this.headerBuffer.getInt(4);
        }

        public void version(int version) {
            this.headerBuffer.putInt(4, version);
        }

        public int segmentSize() {
            return this.headerBuffer.getInt(8);
        }

        public void segmentSize(int size) {
            this.headerBuffer.putInt(8, size);
        }

        public byte fileStatus() {
            return this.headerBuffer.get(17);
        }

        public void fileStatus(byte connectionStatus) {
            this.headerBuffer.put(17, connectionStatus);
        }

        public static int magicWord(@NotNull ByteBuffer headerBuffer) {
            if (headerBuffer == null) {
                HeaderLayout.$$$reportNull$$$0(1);
            }
            return headerBuffer.getInt(0);
        }

        public static int version(@NotNull ByteBuffer headerBuffer) {
            if (headerBuffer == null) {
                HeaderLayout.$$$reportNull$$$0(2);
            }
            return headerBuffer.getInt(4);
        }

        public static int segmentSize(@NotNull ByteBuffer headerBuffer) {
            if (headerBuffer == null) {
                HeaderLayout.$$$reportNull$$$0(3);
            }
            return headerBuffer.getInt(8);
        }

        public static byte fileStatus(@NotNull ByteBuffer headerBuffer) {
            if (headerBuffer == null) {
                HeaderLayout.$$$reportNull$$$0(4);
            }
            return headerBuffer.get(17);
        }

        public int actualSegmentsCount() {
            return this.headerBuffer.getInt(12);
        }

        public void actualSegmentsCount(int count) {
            this.headerBuffer.putInt(12, count);
        }

        public byte globalHashSuffixDepth() {
            return this.headerBuffer.get(16);
        }

        public void globalHashSuffixDepth(int depth) {
            if (depth < 0 || depth >= 32) {
                throw new IllegalArgumentException("depth(=" + depth + ") must be in [0..32)");
            }
            this.headerBuffer.put(16, (byte)depth);
        }

        public int segmentIndex(int slotIndex) throws IOException {
            Objects.checkIndex(slotIndex, this.segmentTableSize());
            return Short.toUnsignedInt(this.headerBuffer.getShort(80 + slotIndex * 2));
        }

        public int segmentIndexByHash(int hash) throws IOException {
            byte hashSuffixDepth = this.globalHashSuffixDepth();
            int segmentSlotIndex = ExtendibleHashMap.segmentSlotIndex(hash, hashSuffixDepth);
            int segmentIndex = this.segmentIndex(segmentSlotIndex);
            if (segmentIndex < 1) {
                throw new CorruptedException("segmentIndex[hash: " + hash + ", suffix: " + hashSuffixDepth + ", slotIndex: " + segmentSlotIndex + "](= " + segmentIndex + ") must be >=1 => .segmentsTable is corrupted");
            }
            return segmentIndex;
        }

        public void updateSegmentIndex(int slotIndex, int segmentIndex) {
            Objects.checkIndex(slotIndex, this.segmentTableSize());
            if (segmentIndex < 1 || segmentIndex > 65535) {
                throw new IllegalArgumentException("segmentIndex(=" + segmentIndex + ") must be in [1..0xFFFF]");
            }
            this.headerBuffer.putShort(80 + slotIndex * 2, (short)segmentIndex);
        }

        public int segmentTableSize() {
            return 1 << this.globalHashSuffixDepth();
        }

        public int maxSegmentTableSize() {
            return (this.headerSegmentSize - 80) / 2;
        }

        public String toString() {
            return "HeaderLayout[headerSize=" + this.headerSegmentSize + "]";
        }

        public String dump() throws IOException {
            StringBuilder sb = new StringBuilder("HeaderLayout[size: " + this.headerSegmentSize + "b, globalHashSuffixSize: " + this.globalHashSuffixDepth() + "]");
            sb.append("[tableSize: " + this.segmentTableSize() + ", actualSegments: " + this.actualSegmentsCount() + "]\n");
            for (int i = 0; i < this.segmentTableSize(); ++i) {
                sb.append("\t[" + i + "]=" + this.segmentIndex(i) + "\n");
            }
            return sb.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bufferSource";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "headerBuffer";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/platform/util/io/storages/intmultimaps/extendiblehashmap/ExtendibleHashMap$HeaderLayout";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "magicWord";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "version";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "segmentSize";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileStatus";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @VisibleForTesting
    @ApiStatus.Internal
    public static final class HashMapSegmentLayout
    extends Record
    implements HashTableData {
        private final int segmentIndex;
        private final int segmentSize;
        @NotNull
        private final ByteBuffer segmentBuffer;
        private static final int LIVE_ENTRIES_COUNT_OFFSET = 0;
        private static final int HASH_SUFFIX_OFFSET = 4;
        private static final int HASH_SUFFIX_DEPTH_OFFSET = 8;
        private static final int STATIC_HEADER_SIZE = 16;
        private static final int HASHTABLE_SLOTS_OFFSET = 16;

        public HashMapSegmentLayout(int segmentIndex, int segmentSize, @NotNull ByteBuffer segmentBuffer) {
            if (segmentBuffer == null) {
                HashMapSegmentLayout.$$$reportNull$$$0(0);
            }
            if (segmentIndex < 1) {
                throw new IllegalArgumentException("segmentIndex(=" + segmentIndex + ") must be >=1 (0-th segment is a header)");
            }
            this.segmentIndex = segmentIndex;
            this.segmentSize = segmentSize;
            this.segmentBuffer = segmentBuffer;
        }

        @VisibleForTesting
        public HashMapSegmentLayout(@NotNull BufferSource bufferSource, int segmentIndex, int segmentSize) throws IOException {
            if (bufferSource == null) {
                HashMapSegmentLayout.$$$reportNull$$$0(1);
            }
            this(segmentIndex, segmentSize, bufferSource.slice((long)segmentIndex * (long)segmentSize, segmentSize));
        }

        @Override
        public int aliveEntriesCount() {
            return this.segmentBuffer.getInt(0);
        }

        void clear() {
            this.updateAliveEntriesCount(0);
            throw new UnsupportedOperationException("Method not implemented yet");
        }

        public static int aliveEntriesCount(@NotNull BufferSource bufferSource, int segmentIndex, int segmentSize) throws IOException {
            if (bufferSource == null) {
                HashMapSegmentLayout.$$$reportNull$$$0(2);
            }
            if (segmentIndex < 1) {
                throw new IllegalArgumentException("segmentIndex(=" + segmentIndex + ") must be >=1 (0-th segment is a header)");
            }
            long offsetInFile = (long)segmentIndex * (long)segmentSize;
            return bufferSource.getInt(offsetInFile + 0L);
        }

        @Override
        public void updateAliveEntriesCount(int aliveCount) {
            this.segmentBuffer.putInt(0, aliveCount);
        }

        public byte hashSuffixDepth() {
            return this.segmentBuffer.get(8);
        }

        public int hashSuffix() {
            return this.segmentBuffer.getInt(4);
        }

        public int hashSuffixMask() {
            return ExtendibleHashMap.suffixMask(this.hashSuffixDepth());
        }

        public void updateHashSuffix(int newHashSuffix, byte newHashSuffixDepth) {
            if (newHashSuffixDepth < 0 || newHashSuffixDepth > 32) {
                throw new IllegalArgumentException("hashSuffixDepth(=" + newHashSuffixDepth + ") must be in [0..32)");
            }
            int mask = ~ExtendibleHashMap.suffixMask(newHashSuffixDepth);
            if ((newHashSuffix & mask) != 0) {
                throw new IllegalArgumentException("hashSuffix(=" + Integer.toBinaryString(newHashSuffix) + ") must have no more than " + newHashSuffixDepth + " trailing bits (mask: " + Integer.toBinaryString(mask) + ")");
            }
            this.segmentBuffer.put(8, newHashSuffixDepth);
            this.segmentBuffer.putInt(4, newHashSuffix);
        }

        @Override
        public int entriesCount() {
            return this.slotsCount() / 2;
        }

        @Override
        public int entryKey(int entryIndex) {
            return this.slot(entryIndex * 2);
        }

        @Override
        public int entryValue(int entryIndex) {
            return this.slot(entryIndex * 2 + 1);
        }

        @Override
        public void updateEntry(int entryIndex, int key, int value) {
            this.segmentBuffer.putInt(HashMapSegmentLayout.offsetOfSlot(entryIndex * 2), key);
            this.segmentBuffer.putInt(HashMapSegmentLayout.offsetOfSlot(entryIndex * 2 + 1), value);
        }

        private int slot(int slotNo) {
            return this.segmentBuffer.getInt(HashMapSegmentLayout.offsetOfSlot(slotNo));
        }

        private static int offsetOfSlot(int slotNo) {
            return 16 + slotNo * 4;
        }

        private int slotsCount() {
            return (this.segmentSize - 16) / 4;
        }

        @Override
        public String toString() {
            return "HashMapSegmentLayout[segmentNo=" + this.segmentIndex + ", segmentSize=" + this.segmentSize + "][hashSuffix: " + this.hashSuffix() + ", depth: " + this.hashSuffixDepth() + "]{" + this.aliveEntriesCount() + " alive entries of " + this.entriesCount() + "}";
        }

        public String dump() throws IOException {
            StringBuilder sb = new StringBuilder("Segment[#" + this.segmentIndex + "][size: " + this.segmentSize + "b][hashSuffix: " + this.hashSuffix() + ", depth: " + this.hashSuffixDepth() + ", mask: " + Integer.toBinaryString(this.hashSuffixMask()) + "][entries: " + this.entriesCount() + ", alive: " + this.aliveEntriesCount() + "]\n");
            for (int i = 0; i < this.entriesCount(); ++i) {
                int key = this.entryKey(i);
                int value = this.entryValue(i);
                if (key == 0) continue;
                sb.append("\t[").append(i).append("]=(").append(key).append(", ").append(value).append(")\n");
            }
            return sb.toString();
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{HashMapSegmentLayout.class, "segmentIndex;segmentSize;segmentBuffer", "segmentIndex", "segmentSize", "segmentBuffer"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{HashMapSegmentLayout.class, "segmentIndex;segmentSize;segmentBuffer", "segmentIndex", "segmentSize", "segmentBuffer"}, this, o);
        }

        public int segmentIndex() {
            return this.segmentIndex;
        }

        public int segmentSize() {
            return this.segmentSize;
        }

        @NotNull
        public ByteBuffer segmentBuffer() {
            ByteBuffer byteBuffer = this.segmentBuffer;
            if (byteBuffer == null) {
                HashMapSegmentLayout.$$$reportNull$$$0(3);
            }
            return byteBuffer;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "segmentBuffer";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bufferSource";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/platform/util/io/storages/intmultimaps/extendiblehashmap/ExtendibleHashMap$HashMapSegmentLayout";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/platform/util/io/storages/intmultimaps/extendiblehashmap/ExtendibleHashMap$HashMapSegmentLayout";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "segmentBuffer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "aliveEntriesCount";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    public static interface HashTableData {
        public int entriesCount();

        public int aliveEntriesCount();

        public void updateAliveEntriesCount(int var1);

        public int entryKey(int var1);

        public int entryValue(int var1);

        public void updateEntry(int var1, int var2, int var3);
    }
}

