/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl.id;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.cache.impl.id.IdIndexer;
import com.intellij.psi.impl.cache.impl.id.IdTableBuilding;
import com.intellij.util.ThreeState;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.hints.BaseFileTypeInputFilter;
import com.intellij.util.indexing.hints.FileTypeIndexingHint;
import com.intellij.util.indexing.hints.FileTypeSubstitutionStrategy;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/psi/impl/cache/impl/id/IdIndexFilter;", "Lcom/intellij/util/indexing/hints/BaseFileTypeInputFilter;", "<init>", "()V", "acceptFileType", "Lcom/intellij/util/ThreeState;", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "slowPathIfFileTypeHintUnsure", "", "indexedFile", "Lcom/intellij/util/indexing/IndexedFile;", "intellij.platform.indexing.impl"})
@SourceDebugExtension(value={"SMAP\nIdIndexFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdIndexFilter.kt\ncom/intellij/psi/impl/cache/impl/id/IdIndexFilter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,44:1\n1#2:45\n*E\n"})
public final class IdIndexFilter
extends BaseFileTypeInputFilter {
    public IdIndexFilter() {
        super(FileTypeSubstitutionStrategy.BEFORE_SUBSTITUTION);
    }

    @Override
    @NotNull
    public ThreeState acceptFileType(@NotNull FileType fileType) {
        Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
        IdIndexer fileTypeIndexer = IdTableBuilding.getFileTypeIndexer(fileType);
        if (fileTypeIndexer == null) {
            return ThreeState.NO;
        }
        if (fileTypeIndexer instanceof FileTypeIndexingHint) {
            return ((FileTypeIndexingHint)fileTypeIndexer).acceptsFileTypeFastPath(fileType);
        }
        return ThreeState.YES;
    }

    public boolean slowPathIfFileTypeHintUnsure(@NotNull IndexedFile indexedFile) {
        Intrinsics.checkNotNullParameter((Object)indexedFile, (String)"indexedFile");
        VirtualFile virtualFile = indexedFile.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        VirtualFile file = virtualFile;
        FileType fileType = file.getFileType();
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileType(...)");
        FileType fileType2 = fileType;
        IdIndexer fileTypeIndexer = IdTableBuilding.getFileTypeIndexer(fileType2);
        if (!(fileTypeIndexer != null)) {
            boolean $i$a$-check-IdIndexFilter$slowPathIfFileTypeHintUnsure$32 = false;
            String $i$a$-check-IdIndexFilter$slowPathIfFileTypeHintUnsure$32 = "slowPathIfFileTypeHintUnsure(" + indexedFile + "): must be called only with filetypes which have associated fileTypeIndexer";
            throw new IllegalStateException($i$a$-check-IdIndexFilter$slowPathIfFileTypeHintUnsure$32.toString());
        }
        if (!(fileTypeIndexer instanceof FileTypeIndexingHint)) {
            boolean bl = false;
            String string = "slowPathIfFileTypeHintUnsure(" + indexedFile + "): " + fileTypeIndexer + " must implement FileTypeIndexingHint";
            throw new IllegalStateException(string.toString());
        }
        return ((FileTypeIndexingHint)fileTypeIndexer).slowPathIfFileTypeHintUnsure(indexedFile);
    }
}

