/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.diagnostic.PluginException;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PackagePrefixFileSystemItem;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.impl.source.resolve.reference.impl.CachingReference;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceCompletion;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelper;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelperRegistrar;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceOwner;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceResolver;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.NullFileReferenceHelper;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiFileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiFileSystemItemUtil;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiFileSystemItemProcessor;
import com.intellij.refactoring.rename.BindablePsiReference;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.CommonProcessors;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.IndexingBundle;
import java.net.URI;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class FileReference
implements PsiFileReference,
FileReferenceOwner,
PsiPolyVariantReference,
LocalQuickFixProvider,
EmptyResolveMessageProvider,
BindablePsiReference {
    private static final Logger LOG = Logger.getInstance(FileReference.class);
    public static final FileReference[] EMPTY = new FileReference[0];
    private final int myIndex;
    private TextRange myRange;
    private final String myText;
    @NotNull
    private final FileReferenceSet myFileReferenceSet;

    public FileReference(@NotNull FileReferenceSet fileReferenceSet, TextRange range, int index, String text) {
        if (fileReferenceSet == null) {
            FileReference.$$$reportNull$$$0(0);
        }
        this.myFileReferenceSet = fileReferenceSet;
        this.myIndex = index;
        this.myRange = range;
        this.myText = text;
    }

    public FileReference(FileReference original) {
        this(original.myFileReferenceSet, original.myRange, original.myIndex, original.myText);
    }

    @Nullable
    public static FileReference findFileReference(@NotNull PsiReference original) {
        FileReferenceOwner referenceOwner;
        PsiFileReference fileReference;
        if (original == null) {
            FileReference.$$$reportNull$$$0(1);
        }
        if (original instanceof PsiMultiReference) {
            PsiMultiReference multiReference = (PsiMultiReference)original;
            for (PsiReference reference : multiReference.getReferences()) {
                if (!(reference instanceof FileReference)) continue;
                FileReference fileReference2 = (FileReference)reference;
                return fileReference2;
            }
        } else if (original instanceof FileReferenceOwner && (fileReference = (referenceOwner = (FileReferenceOwner)original).getLastFileReference()) instanceof FileReference) {
            FileReference fileRef = (FileReference)fileReference;
            return fileRef;
        }
        return null;
    }

    @NotNull
    protected Collection<PsiFileSystemItem> getContexts() {
        FileReference contextRef = this.getContextReference();
        ArrayList<PsiFileSystemItem> result = new ArrayList<PsiFileSystemItem>();
        if (contextRef == null) {
            Collection<PsiFileSystemItem> defaultContexts = this.myFileReferenceSet.getDefaultContexts();
            for (PsiFileSystemItem context : defaultContexts) {
                if (context != null) continue;
                LOG.error((Throwable)PluginException.createByClass((String)"Null context", null, this.myFileReferenceSet.getClass()));
            }
            result.addAll(defaultContexts);
        } else {
            ResolveResult[] resolveResults;
            for (ResolveResult resolveResult : resolveResults = contextRef.multiResolve(false)) {
                PsiElement element = resolveResult.getElement();
                if (element == null) continue;
                result.add((PsiFileSystemItem)element);
            }
        }
        result.addAll(this.myFileReferenceSet.getExtraContexts());
        ArrayList<PsiFileSystemItem> arrayList = result;
        if (arrayList == null) {
            FileReference.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        PsiFile file = this.getElement().getContainingFile();
        ResolveResult[] resolveResultArray = ResolveCache.getInstance((Project)file.getProject()).resolveWithCaching((PsiPolyVariantReference)this, (ResolveCache.PolyVariantContextResolver)MyResolver.INSTANCE, false, false, file);
        if (resolveResultArray == null) {
            FileReference.$$$reportNull$$$0(3);
        }
        return resolveResultArray;
    }

    protected ResolveResult @NotNull [] innerResolve(boolean caseSensitive, @NotNull PsiFile containingFile) {
        int resultCount;
        String referenceText;
        if (containingFile == null) {
            FileReference.$$$reportNull$$$0(4);
        }
        if ((referenceText = this.getText()).isEmpty() && this.myIndex == 0) {
            ResolveResult[] resolveResultArray = new ResolveResult[]{new PsiElementResolveResult((PsiElement)containingFile)};
            if (resolveResultArray == null) {
                FileReference.$$$reportNull$$$0(5);
            }
            return resolveResultArray;
        }
        Collection contexts = (Collection)RecursionManager.doPreventingRecursion((Object)this, (boolean)false, () -> this.getContexts());
        if (contexts == null) {
            LOG.error("Recursion occurred for " + String.valueOf(this.getClass()) + " on " + this.getElement().getText());
            if (ResolveResult.EMPTY_ARRAY == null) {
                FileReference.$$$reportNull$$$0(6);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        LinkedHashSet<PsiElementResolveResult> result = new LinkedHashSet<PsiElementResolveResult>();
        for (PsiFileSystemItem context : contexts) {
            this.innerResolveInContext(referenceText, context, result, caseSensitive);
        }
        if (contexts.isEmpty() && this.isAllowedEmptyPath(referenceText)) {
            result.add(new PsiElementResolveResult((PsiElement)containingFile));
        }
        ResolveResult[] resolveResultArray = (resultCount = result.size()) > 0 ? result.toArray(new ResolveResult[resultCount]) : ResolveResult.EMPTY_ARRAY;
        if (resolveResultArray == null) {
            FileReference.$$$reportNull$$$0(7);
        }
        return resolveResultArray;
    }

    protected void innerResolveInContext(@NotNull String text, @NotNull PsiFileSystemItem context, final @NotNull Collection<? super ResolveResult> result, final boolean caseSensitive) {
        if (text == null) {
            FileReference.$$$reportNull$$$0(8);
        }
        if (context == null) {
            FileReference.$$$reportNull$$$0(9);
        }
        if (result == null) {
            FileReference.$$$reportNull$$$0(10);
        }
        if (this.isAllowedEmptyPath(text) || ".".equals(text) || "/".equals(text)) {
            FileReferenceResolver resolver;
            ResolveResult element;
            if (context instanceof FileReferenceResolver && (element = this.resolveFileReferenceResolver(resolver = (FileReferenceResolver)context, text)) != null) {
                result.add((ResolveResult)element);
                return;
            }
            result.add((ResolveResult)new PsiElementResolveResult((PsiElement)context));
        } else if ("..".equals(text)) {
            FileReferenceResolver resolver;
            ResolveResult element;
            if (context instanceof FileReferenceResolver && (element = this.resolveFileReferenceResolver(resolver = (FileReferenceResolver)context, text)) != null) {
                result.add((ResolveResult)element);
                return;
            }
            PsiFileSystemItem resolved = context.getParent();
            if (resolved != null) {
                result.add((ResolveResult)new PsiElementResolveResult((PsiElement)resolved));
            }
        } else {
            int separatorIndex = text.indexOf(47);
            if (separatorIndex >= 0) {
                ArrayList<PsiElementResolveResult> resolvedContexts = new ArrayList<PsiElementResolveResult>();
                if (separatorIndex == 0 && "/".equals(context.getName())) {
                    resolvedContexts.add(new PsiElementResolveResult((PsiElement)context));
                } else {
                    this.innerResolveInContext(text.substring(0, separatorIndex), context, resolvedContexts, caseSensitive);
                }
                String restOfText = text.substring(separatorIndex + 1);
                for (ResolveResult resolveResult : resolvedContexts) {
                    PsiFileSystemItem item = (PsiFileSystemItem)resolveResult.getElement();
                    if (item == null) continue;
                    this.innerResolveInContext(restOfText, item, result, caseSensitive);
                }
            } else {
                PsiDirectory directory;
                FileReferenceResolver resolver;
                ResolveResult resolveResult;
                final String decoded = this.decode(text);
                if (context instanceof PackagePrefixFileSystemItem) {
                    PackagePrefixFileSystemItem prefixFileSystemItem = (PackagePrefixFileSystemItem)context;
                    context = prefixFileSystemItem.getDirectory();
                } else if (context instanceof FileReferenceResolver && (resolveResult = this.resolveFileReferenceResolver(resolver = (FileReferenceResolver)context, decoded)) != null) {
                    result.add((ResolveResult)resolveResult);
                    return;
                }
                if (context.getParent() == null && FileUtil.namesEqual((String)decoded, (String)context.getName())) {
                    result.add((ResolveResult)new PsiElementResolveResult((PsiElement)FileReference.getOriginalFile(context)));
                } else if (context instanceof PsiDirectory && FileReference.caseSensitivityApplies(directory = (PsiDirectory)context, caseSensitive)) {
                    PsiFile child2 = directory.findFile(decoded);
                    if (child2 == null) {
                        child2 = directory.findSubdirectory(decoded);
                    }
                    if (child2 != null) {
                        result.add((ResolveResult)new PsiElementResolveResult((PsiElement)FileReference.getOriginalFile((PsiFileSystemItem)child2)));
                    }
                } else {
                    FileReference.processVariants(context, new PsiFileSystemItemProcessor(){

                        public boolean acceptItem(@NotNull String name, boolean isDirectory) {
                            if (name == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            return caseSensitive ? decoded.equals(name) : decoded.compareToIgnoreCase(name) == 0;
                        }

                        public boolean execute(@NotNull PsiFileSystemItem element) {
                            if (element == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            result.add(new PsiElementResolveResult((PsiElement)FileReference.getOriginalFile(element)));
                            return true;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2;
                            Object[] objectArray3 = new Object[3];
                            switch (n) {
                                default: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "name";
                                    break;
                                }
                                case 1: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "element";
                                    break;
                                }
                            }
                            objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReference$1";
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "acceptItem";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "execute";
                                    break;
                                }
                            }
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    });
                }
            }
        }
    }

    @NotNull
    @NlsSafe
    public String getFileNameToCreate() {
        String string = this.decode(this.getCanonicalText());
        if (string == null) {
            FileReference.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Nullable
    @NlsSafe
    public String getNewFileTemplateName() {
        FileType fileType = FileTypeRegistry.getInstance().getFileTypeByFileName(this.myText);
        if (fileType != UnknownFileType.INSTANCE) {
            return fileType.getName() + " File." + fileType.getDefaultExtension();
        }
        return null;
    }

    @Nullable
    private ResolveResult resolveFileReferenceResolver(@NotNull FileReferenceResolver fileReferenceResolver, @NotNull String text) {
        PsiFileSystemItem resolve;
        if (fileReferenceResolver == null) {
            FileReference.$$$reportNull$$$0(12);
        }
        if (text == null) {
            FileReference.$$$reportNull$$$0(13);
        }
        return (resolve = fileReferenceResolver.resolveFileReference(this, text)) != null ? new PsiElementResolveResult((PsiElement)FileReference.getOriginalFile(resolve)) : null;
    }

    private static boolean caseSensitivityApplies(PsiDirectory context, boolean caseSensitive) {
        return context.getVirtualFile().isCaseSensitive() == caseSensitive;
    }

    private boolean isAllowedEmptyPath(String text) {
        return text.isEmpty() && this.isLast() && (StringUtil.isEmpty((String)this.myFileReferenceSet.getPathString()) && this.myFileReferenceSet.isEmptyPathAllowed() || !this.myFileReferenceSet.isEndingSlashNotAllowed() && this.myIndex > 0);
    }

    @Contract(pure=true)
    @NotNull
    public String decode(@NotNull String text) {
        if (text == null) {
            FileReference.$$$reportNull$$$0(14);
        }
        if (SystemInfo.isMac) {
            text = Normalizer.normalize(text, Normalizer.Form.NFC);
        }
        String _text = text;
        int paramIndex = text.lastIndexOf(63);
        if (paramIndex >= 0) {
            _text = text.substring(0, paramIndex);
        }
        if (this.myFileReferenceSet.isUrlEncoded()) {
            String string;
            try {
                string = StringUtil.notNullize((String)new URI(_text).getPath(), (String)text);
            }
            catch (Exception ignored) {
                String string2 = text;
                if (string2 == null) {
                    FileReference.$$$reportNull$$$0(16);
                }
                return string2;
            }
            if (string == null) {
                FileReference.$$$reportNull$$$0(15);
            }
            return string;
        }
        String string = _text;
        if (string == null) {
            FileReference.$$$reportNull$$$0(17);
        }
        return string;
    }

    public Object @NotNull [] getVariants() {
        FileReferenceCompletion completion = FileReferenceCompletion.getInstance();
        if (completion != null) {
            Object[] objectArray = completion.getFileReferenceCompletionVariants(this);
            if (objectArray == null) {
                FileReference.$$$reportNull$$$0(18);
            }
            return objectArray;
        }
        if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
            FileReference.$$$reportNull$$$0(19);
        }
        return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
    }

    protected Object createLookupItem(PsiElement candidate) {
        return null;
    }

    @ApiStatus.Internal
    public static PsiFileSystemItem getOriginalFile(PsiFileSystemItem fileSystemItem) {
        PsiFile psiFile;
        PsiManager psiManager;
        VirtualFile file = fileSystemItem.getVirtualFile();
        if (file != null && !file.isDirectory() && (psiManager = fileSystemItem.getManager()) != null && (psiFile = psiManager.findFile(file)) != null) {
            fileSystemItem = psiFile;
        }
        return fileSystemItem;
    }

    @Nullable
    protected String encode(String name, PsiElement psiElement) {
        try {
            return new URI(null, null, name, null).toString();
        }
        catch (Exception ignored) {
            return name;
        }
    }

    protected static void processVariants(PsiFileSystemItem context, PsiFileSystemItemProcessor processor) {
        context.processChildren((PsiElementProcessor)processor);
    }

    @Nullable
    private FileReference getContextReference() {
        return this.myIndex > 0 ? this.myFileReferenceSet.getReference(this.myIndex - 1) : null;
    }

    @NotNull
    public PsiElement getElement() {
        PsiElement psiElement = this.myFileReferenceSet.getElement();
        if (psiElement == null) {
            FileReference.$$$reportNull$$$0(20);
        }
        return psiElement;
    }

    public PsiFileSystemItem resolve() {
        ResolveResult[] resolveResults = this.multiResolve(false);
        return resolveResults.length == 1 ? (PsiFileSystemItem)resolveResults[0].getElement() : null;
    }

    @Nullable
    public PsiFileSystemItem innerSingleResolve(boolean caseSensitive, @NotNull PsiFile containingFile) {
        ResolveResult[] resolveResults;
        if (containingFile == null) {
            FileReference.$$$reportNull$$$0(21);
        }
        return (resolveResults = this.innerResolve(caseSensitive, containingFile)).length == 1 ? (PsiFileSystemItem)resolveResults[0].getElement() : null;
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            FileReference.$$$reportNull$$$0(22);
        }
        if (element instanceof PsiDirectoryContainer) {
            PsiDirectoryContainer container = (PsiDirectoryContainer)element;
            Object[] directories = container.getDirectories();
            for (ResolveResult result : this.multiResolve(false)) {
                PsiFileSystemItem fileSystemItem;
                PsiElement resultElement = result.getElement();
                if (!(resultElement instanceof PsiFileSystemItem) || !ContainerUtil.exists((Object[])directories, arg_0 -> FileReference.lambda$isReferenceTo$1(fileSystemItem = (PsiFileSystemItem)resultElement, arg_0))) continue;
                return true;
            }
            return false;
        }
        if (!(element instanceof PsiFileSystemItem)) {
            return false;
        }
        PsiFileSystemItem fileSystemItem = (PsiFileSystemItem)element;
        PsiFileSystemItem item = this.resolve();
        return item != null && FileReferenceHelperRegistrar.areElementsEquivalent(item, fileSystemItem);
    }

    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = this.myRange;
        if (textRange == null) {
            FileReference.$$$reportNull$$$0(23);
        }
        return textRange;
    }

    @NotNull
    @NlsSafe
    public String getCanonicalText() {
        String string = this.myText;
        if (string == null) {
            FileReference.$$$reportNull$$$0(24);
        }
        return string;
    }

    public String getText() {
        return this.myText;
    }

    public boolean isSoft() {
        return this.myFileReferenceSet.isSoft();
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            FileReference.$$$reportNull$$$0(25);
        }
        ElementManipulator manipulator = CachingReference.getManipulator((PsiElement)this.getElement());
        this.myFileReferenceSet.setElement(manipulator.handleContentChange(this.getElement(), this.getRangeInElement(), newElementName));
        int delta = newElementName.length() - this.myRange.getLength();
        this.myRange = new TextRange(this.getRangeInElement().getStartOffset(), this.getRangeInElement().getStartOffset() + newElementName.length());
        FileReference[] references = this.myFileReferenceSet.getAllReferences();
        for (int idx = this.myIndex + 1; idx < references.length; ++idx) {
            references[idx].myRange = references[idx].myRange.shiftRight(delta);
        }
        return this.myFileReferenceSet.getElement();
    }

    public PsiElement bindToElement(@NotNull PsiElement element, boolean absolute) throws IncorrectOperationException {
        String newName;
        VirtualFile curVFile;
        if (element == null) {
            FileReference.$$$reportNull$$$0(26);
        }
        if (!(element instanceof PsiFileSystemItem)) {
            throw new IncorrectOperationException("Cannot bind to element, should be instanceof PsiFileSystemItem: " + String.valueOf(element));
        }
        PsiFileSystemItem fileSystemItem = (PsiFileSystemItem)element;
        if (this.getCanonicalText().isEmpty() && element == this.getElement().getContainingFile()) {
            return this.getElement();
        }
        VirtualFile dstVFile = fileSystemItem.getVirtualFile();
        if (dstVFile == null) {
            throw new IncorrectOperationException("Cannot bind to non-physical element:" + String.valueOf(element));
        }
        PsiFile file = this.getElement().getContainingFile();
        PsiLanguageInjectionHost contextPsiFile = InjectedLanguageManager.getInstance((Project)file.getProject()).getInjectionHost((PsiElement)file);
        if (contextPsiFile != null) {
            file = contextPsiFile.getContainingFile();
        }
        if ((curVFile = file.getVirtualFile()) == null && (curVFile = file.getOriginalFile().getVirtualFile()) == null) {
            throw new IncorrectOperationException("Cannot bind from non-physical element:" + String.valueOf(file));
        }
        Project project = element.getProject();
        if (absolute) {
            String relativePath;
            PsiFileSystemItem root = null;
            PsiFileSystemItem dstItem = null;
            for (FileReferenceHelper helper : FileReferenceHelperRegistrar.getHelpers()) {
                PsiFileSystemItem _root;
                PsiFileSystemItem _dstItem;
                if (!helper.isMine(project, curVFile, dstVFile) || (_dstItem = helper.getPsiFileSystemItem(project, dstVFile)) == null || (_root = helper.findRoot(project, dstVFile)) == null) continue;
                root = _root;
                dstItem = _dstItem;
                break;
            }
            if (root == null) {
                PsiFileSystemItem _root;
                PsiFileSystemItem _dstItem = NullFileReferenceHelper.INSTANCE.getPsiFileSystemItem(project, dstVFile);
                if (_dstItem != null && (_root = NullFileReferenceHelper.INSTANCE.findRoot(project, dstVFile)) != null) {
                    root = _root;
                    dstItem = _dstItem;
                }
                if (root == null) {
                    return this.getElement();
                }
            }
            if ((relativePath = PsiFileSystemItemUtil.findRelativePath(root, dstItem)) == null) {
                return this.getElement();
            }
            newName = this.myFileReferenceSet.getNewAbsolutePath(root, relativePath);
        } else {
            FileReferenceHelper helper = FileReferenceHelperRegistrar.getNotNullHelper(file);
            Collection<PsiFileSystemItem> contexts = this.getContextsForBindToElement(curVFile, project, helper);
            for (PsiFileSystemItem context : contexts) {
                String path;
                FileReferenceResolver resolver;
                String path2;
                VirtualFile contextFile = context.getVirtualFile();
                assert (contextFile != null);
                if (context instanceof FileReferenceResolver && (path2 = (resolver = (FileReferenceResolver)context).getRelativePath(this, dstVFile, element)) != null) {
                    return this.rename(path2);
                }
                if (!VfsUtilCore.isAncestor((VirtualFile)contextFile, (VirtualFile)dstVFile, (boolean)true) || (path = VfsUtilCore.getRelativePath((VirtualFile)dstVFile, (VirtualFile)contextFile, (char)'/')) == null) continue;
                return this.rename(path);
            }
            PsiFileSystemItem dstItem = helper.getPsiFileSystemItem(project, dstVFile);
            PsiFileSystemItem curItem = helper.getPsiFileSystemItem(project, curVFile);
            if (curItem == null) {
                throw new IncorrectOperationException("Cannot find path between files; src = " + curVFile.getPresentableUrl() + "; dst = " + dstVFile.getPresentableUrl() + "; Contexts: " + String.valueOf(contexts));
            }
            if (curItem.equals((Object)dstItem)) {
                if (this.getCanonicalText().equals(dstItem.getName())) {
                    return this.getElement();
                }
                return this.fixRefText(file.getName());
            }
            newName = PsiFileSystemItemUtil.findRelativePath((PsiFileSystemItem)curItem, (PsiFileSystemItem)dstItem);
            if (newName == null) {
                return this.getElement();
            }
        }
        if (this.myFileReferenceSet.isUrlEncoded()) {
            newName = this.encode(newName, element);
        }
        return this.rename(newName);
    }

    protected @Unmodifiable Collection<PsiFileSystemItem> getContextsForBindToElement(VirtualFile curVFile, Project project, FileReferenceHelper helper) {
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
        helper.processContexts(this.getFileReferenceSet(), curVFile, true, (Processor<? super PsiFileSystemItem>)processor);
        return processor.getResults();
    }

    protected PsiElement fixRefText(String name) {
        return ElementManipulators.handleContentChange((PsiElement)this.getElement(), (TextRange)this.getRangeInElement(), (String)name);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            FileReference.$$$reportNull$$$0(27);
        }
        return this.bindToElement(element, this.myFileReferenceSet.isAbsolutePathReference());
    }

    protected PsiElement rename(String newName) throws IncorrectOperationException {
        TextRange range = new TextRange(this.myFileReferenceSet.getStartInElement(), this.getRangeInElement().getEndOffset());
        PsiElement element = this.getElement();
        try {
            return CachingReference.getManipulator((PsiElement)element).handleContentChange(element, range, newName);
        }
        catch (IncorrectOperationException e) {
            LOG.error("Cannot rename " + String.valueOf(this.getClass()) + " from " + String.valueOf(this.myFileReferenceSet.getClass()) + " to " + newName, (Throwable)e);
            throw e;
        }
    }

    protected static FileReferenceHelper @NotNull [] getHelpers() {
        FileReferenceHelper[] fileReferenceHelperArray = FileReferenceHelperRegistrar.getHelpers();
        if (fileReferenceHelperArray == null) {
            FileReference.$$$reportNull$$$0(28);
        }
        return fileReferenceHelperArray;
    }

    public int getIndex() {
        return this.myIndex;
    }

    @NotNull
    @Nls(capitalization=Nls.Capitalization.Sentence)
    public String getUnresolvedMessagePattern() {
        String string = AnalysisBundle.message((String)"error.cannot.resolve.file.or.dir", (Object[])new Object[]{IndexingBundle.message((String)(this.isLast() ? "terms.file" : "terms.directory"), (Object[])new Object[0]), StringUtil.escapePattern((String)this.decode(this.getCanonicalText()))});
        if (string == null) {
            FileReference.$$$reportNull$$$0(29);
        }
        return string;
    }

    public final boolean isLast() {
        return this.myIndex == this.myFileReferenceSet.getAllReferences().length - 1;
    }

    @NotNull
    public FileReferenceSet getFileReferenceSet() {
        FileReferenceSet fileReferenceSet = this.myFileReferenceSet;
        if (fileReferenceSet == null) {
            FileReference.$$$reportNull$$$0(30);
        }
        return fileReferenceSet;
    }

    public @NotNull LocalQuickFix @Nullable [] getQuickFixes() {
        ArrayList<? extends LocalQuickFix> result = new ArrayList<LocalQuickFix>();
        for (FileReferenceHelper helper : FileReference.getHelpers()) {
            result.addAll(helper.registerFixes(this));
        }
        return result.toArray(LocalQuickFix.EMPTY_ARRAY);
    }

    public FileReference getLastFileReference() {
        return this.myFileReferenceSet.getLastReference();
    }

    private static /* synthetic */ boolean lambda$isReferenceTo$1(PsiFileSystemItem fileSystemItem, PsiDirectory dir) {
        return FileReferenceHelperRegistrar.areElementsEquivalent(fileSystemItem, (PsiFileSystemItem)dir);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5, 6, 7, 11, 15, 16, 17, 18, 19, 20, 23, 24, 28, 29, 30 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileReferenceSet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 28: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReference";
                break;
            }
            case 4: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 8: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileReferenceResolver";
                break;
            }
            case 22: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReference";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getContexts";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "innerResolve";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileNameToCreate";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "decode";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpers";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileReferenceSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findFileReference";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 28: 
            case 29: 
            case 30: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "innerResolve";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "innerResolveInContext";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "resolveFileReferenceResolver";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "decode";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "innerSingleResolve";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5, 6, 7, 11, 15, 16, 17, 18, 19, 20, 23, 24, 28, 29, 30 -> new IllegalStateException(string);
        };
    }

    private static class MyResolver
    implements ResolveCache.PolyVariantContextResolver<FileReference> {
        static final MyResolver INSTANCE = new MyResolver();

        private MyResolver() {
        }

        public ResolveResult @NotNull [] resolve(@NotNull FileReference ref, @NotNull PsiFile containingFile, boolean incompleteCode) {
            if (ref == null) {
                MyResolver.$$$reportNull$$$0(0);
            }
            if (containingFile == null) {
                MyResolver.$$$reportNull$$$0(1);
            }
            ResolveResult[] resolveResultArray = ref.innerResolve(ref.getFileReferenceSet().isCaseSensitive(), containingFile);
            if (resolveResultArray == null) {
                MyResolver.$$$reportNull$$$0(2);
            }
            return resolveResultArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ref";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "containingFile";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReference$MyResolver";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReference$MyResolver";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "resolve";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "resolve";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

