/*
 * Decompiled with CFR 0.152.
 */
package kotlin.metadata.internal.protobuf;

import java.io.IOException;
import java.io.InputStream;
import kotlin.metadata.internal.protobuf.AbstractMessageLite;
import kotlin.metadata.internal.protobuf.ByteString;
import kotlin.metadata.internal.protobuf.CodedInputStream;
import kotlin.metadata.internal.protobuf.ExtensionRegistryLite;
import kotlin.metadata.internal.protobuf.InvalidProtocolBufferException;
import kotlin.metadata.internal.protobuf.MessageLite;
import kotlin.metadata.internal.protobuf.Parser;
import kotlin.metadata.internal.protobuf.UninitializedMessageException;

public abstract class AbstractParser<MessageType extends MessageLite>
implements Parser<MessageType> {
    private static final ExtensionRegistryLite EMPTY_REGISTRY = ExtensionRegistryLite.getEmptyRegistry();

    private UninitializedMessageException newUninitializedMessageException(MessageType message2) {
        if (message2 instanceof AbstractMessageLite) {
            return ((AbstractMessageLite)message2).newUninitializedMessageException();
        }
        return new UninitializedMessageException((MessageLite)message2);
    }

    private MessageType checkMessageInitialized(MessageType message2) throws InvalidProtocolBufferException {
        if (message2 != null && !message2.isInitialized()) {
            throw this.newUninitializedMessageException(message2).asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)message2);
        }
        return message2;
    }

    public MessageType parsePartialFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        CodedInputStream input = data.newCodedInput();
        MessageLite message2 = (MessageLite)this.parsePartialFrom(input, extensionRegistry);
        try {
            input.checkLastTagWas(0);
        }
        catch (InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(message2);
        }
        return (MessageType)message2;
    }

    @Override
    public MessageType parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return this.checkMessageInitialized(this.parsePartialFrom(data, extensionRegistry));
    }

    public MessageType parsePartialFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        CodedInputStream codedInput = CodedInputStream.newInstance(input);
        MessageLite message2 = (MessageLite)this.parsePartialFrom(codedInput, extensionRegistry);
        try {
            codedInput.checkLastTagWas(0);
        }
        catch (InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(message2);
        }
        return (MessageType)message2;
    }

    @Override
    public MessageType parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return this.checkMessageInitialized(this.parsePartialFrom(input, extensionRegistry));
    }

    public MessageType parsePartialDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        int size;
        try {
            int firstByte = input.read();
            if (firstByte == -1) {
                return null;
            }
            size = CodedInputStream.readRawVarint32(firstByte, input);
        }
        catch (IOException e) {
            throw new InvalidProtocolBufferException(e.getMessage());
        }
        AbstractMessageLite.Builder.LimitedInputStream limitedInput = new AbstractMessageLite.Builder.LimitedInputStream(input, size);
        return this.parsePartialFrom(limitedInput, extensionRegistry);
    }

    @Override
    public MessageType parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return this.checkMessageInitialized(this.parsePartialDelimitedFrom(input, extensionRegistry));
    }
}

