/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.eval4j.jdi;

import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.openapi.util.text.StringUtil;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import java.lang.reflect.AccessibleObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.eval4j.Eval;
import org.jetbrains.eval4j.Eval4JIllegalArgumentException;
import org.jetbrains.eval4j.FieldDescription;
import org.jetbrains.eval4j.MembersKt;
import org.jetbrains.eval4j.MethodDescription;
import org.jetbrains.eval4j.NewObjectValue;
import org.jetbrains.eval4j.Value;
import org.jetbrains.eval4j.ValuesKt;
import org.jetbrains.eval4j.jdi.JdiEvalKt;
import org.jetbrains.eval4j.jdi.JdiValuesKt;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0012\b\u0016\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u001a\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u001b\u001a\u0004\u0018\u00010\u0005H\u0016J\u0018\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u0005H\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0010H\u0016J\u0010\u0010!\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u0010H\u0016J\u0010\u0010\"\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010#\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\u00162\u0006\u0010%\u001a\u00020\u0018H\u0016J\u0018\u0010&\u001a\u00020\u001a*\u00020\u00182\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u0005H\u0002J\u0018\u0010'\u001a\u00020(*\u00020\u00182\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u0005H\u0002J\u0018\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020(2\u0006\u0010,\u001a\u00020\tH\u0016J\u0018\u0010-\u001a\u00020\u00162\u0006\u0010+\u001a\u00020\u00182\u0006\u0010,\u001a\u00020\tH\u0016J&\u00101\u001a\u00020\u00162\u0006\u00102\u001a\u00020\u00182\u0006\u0010,\u001a\u00020\t2\f\u00103\u001a\b\u0012\u0004\u0012\u00020\t04H\u0002J\u001e\u00105\u001a\u00020\u00162\u0006\u0010+\u001a\u00020\u00182\f\u00106\u001a\b\u0012\u0004\u0012\u00020\t04H\u0016J\f\u00107\u001a\u00020**\u00020\u0016H\u0002J\u0010\u00108\u001a\u00020\u00162\u0006\u00107\u001a\u00020\u0016H\u0016J\u0018\u00109\u001a\u00020\u00162\u0006\u00107\u001a\u00020\u00162\u0006\u0010:\u001a\u00020\u0016H\u0016J \u0010;\u001a\u00020<2\u0006\u00107\u001a\u00020\u00162\u0006\u0010:\u001a\u00020\u00162\u0006\u0010=\u001a\u00020\u0016H\u0016J\u001c\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020A2\n\b\u0002\u0010B\u001a\u0004\u0018\u00010\u001aH\u0002J\u0010\u0010C\u001a\u00020?2\u0006\u0010@\u001a\u00020AH\u0002J\u0010\u0010D\u001a\u00020\u00162\u0006\u0010@\u001a\u00020AH\u0016J\u0018\u0010E\u001a\u00020<2\u0006\u0010@\u001a\u00020A2\u0006\u0010=\u001a\u00020\u0016H\u0016J\u001a\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020I2\b\b\u0002\u0010J\u001a\u00020\u001aH\u0002J\u001a\u0010K\u001a\u0004\u0018\u00010G2\u0006\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020\u001aH\u0002J\u0012\u0010L\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001d\u001a\u00020\u0010H\u0002J2\u0010M\u001a\u0004\u0018\u00010N2\u0006\u0010O\u001a\u00020P2\u0006\u0010Q\u001a\u00020G2\u000e\u0010R\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010N042\u0006\u0010\b\u001a\u00020\tH\u0016J2\u0010M\u001a\u0004\u0018\u00010N2\u0006\u0010O\u001a\u00020S2\u0006\u0010Q\u001a\u00020G2\u000e\u0010R\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010N042\u0006\u0010\b\u001a\u00020\tH\u0016J\u001e\u0010T\u001a\u00020\u00162\u0006\u0010H\u001a\u00020I2\f\u0010U\u001a\b\u0012\u0004\u0012\u00020\u001604H\u0016J\u0018\u0010V\u001a\u00020\u00162\u0006\u0010W\u001a\u00020\u00162\u0006\u0010@\u001a\u00020AH\u0016J \u0010X\u001a\u00020<2\u0006\u0010W\u001a\u00020\u00162\u0006\u0010@\u001a\u00020A2\u0006\u0010=\u001a\u00020\u0016H\u0016J\u0018\u0010Y\u001a\u00020\u00162\u0006\u0010Z\u001a\u00020\u00162\u0006\u0010O\u001a\u00020\u0018H\u0002J2\u0010[\u001a\u0004\u0018\u00010N2\u0006\u0010\\\u001a\u00020]2\u0006\u0010Q\u001a\u00020G2\u000e\u0010R\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010N042\u0006\u0010^\u001a\u00020\tH\u0016J2\u0010_\u001a\u0004\u0018\u00010N2\u0006\u0010J\u001a\u00020P2\u0006\u0010`\u001a\u00020G2\u000e\u0010R\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010N042\u0006\u0010^\u001a\u00020\tH\u0016J.\u0010a\u001a\u00020\u00162\u0006\u0010W\u001a\u00020\u00162\u0006\u0010H\u001a\u00020I2\f\u0010U\u001a\b\u0012\u0004\u0012\u00020\u0016042\u0006\u0010b\u001a\u00020\u0014H\u0016J \u0010c\u001a\u00020\u00142\u0006\u0010Q\u001a\u00020G2\u000e\u0010R\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010N04H\u0016J\u001c\u0010d\u001a\u00020\u00142\b\u0010e\u001a\u0004\u0018\u00010\u00122\b\u0010f\u001a\u0004\u0018\u00010\u0012H\u0002J0\u0010g\u001a\u00020\u00162\u0006\u0010h\u001a\u00020\u00182\u0006\u0010W\u001a\u00020\u00162\u000e\u0010R\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010N042\u0006\u0010H\u001a\u00020IH\u0002J\u0018\u0010i\u001a\u00020\u00162\u000e\u0010R\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010N04H\u0002J\u0014\u0010j\u001a\u00020<*\n\u0012\u0006\u0012\u0004\u0018\u00010N04H\u0002J\u0014\u0010k\u001a\u00020<*\n\u0012\u0006\u0012\u0004\u0018\u00010N04H\u0002J,\u0010l\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010N042\f\u0010U\u001a\b\u0012\u0004\u0012\u00020\u0016042\f\u0010m\u001a\b\u0012\u0004\u0012\u00020\u001204H\u0002J\u0012\u0010n\u001a\b\u0012\u0004\u0012\u00020\u001204*\u00020GH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000e\u001a\u001e\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00100\u0010\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00120\u00120\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010.\u001a\u00020\u0018*\u00020\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100\u00a8\u0006o"}, d2={"Lorg/jetbrains/eval4j/jdi/JDIEval;", "Lorg/jetbrains/eval4j/Eval;", "vm", "Lcom/sun/jdi/VirtualMachine;", "defaultClassLoader", "Lcom/sun/jdi/ClassLoaderReference;", "thread", "Lcom/sun/jdi/ThreadReference;", "invokePolicy", "", "<init>", "(Lcom/sun/jdi/VirtualMachine;Lcom/sun/jdi/ClassLoaderReference;Lcom/sun/jdi/ThreadReference;I)V", "getThread", "()Lcom/sun/jdi/ThreadReference;", "primitiveTypes", "", "", "kotlin.jvm.PlatformType", "Lcom/sun/jdi/Type;", "isJava8OrLater", "", "loadClass", "Lorg/jetbrains/eval4j/Value;", "classType", "Lorg/jetbrains/org/objectweb/asm/Type;", "loadType", "Lcom/sun/jdi/ReferenceType;", "classLoader", "loadClassByName", "name", "jdiMirrorOfString", "Lcom/sun/jdi/StringReference;", "str", "loadString", "newInstance", "isInstanceOf", "value", "targetType", "asReferenceType", "asArrayType", "Lcom/sun/jdi/ArrayType;", "jdiNewArray", "Lcom/sun/jdi/ArrayReference;", "arrayType", "size", "newArray", "arrayElementType", "getArrayElementType", "(Lorg/jetbrains/org/objectweb/asm/Type;)Lorg/jetbrains/org/objectweb/asm/Type;", "fillArray", "elementType", "nestedSizes", "", "newMultiDimensionalArray", "dimensionSizes", "array", "getArrayLength", "getArrayElement", "index", "setArrayElement", "", "newValue", "findField", "Lcom/sun/jdi/Field;", "fieldDesc", "Lorg/jetbrains/eval4j/FieldDescription;", "receiver", "findStaticField", "getStaticField", "setStaticField", "findMethod", "Lcom/sun/jdi/Method;", "methodDesc", "Lorg/jetbrains/eval4j/MethodDescription;", "clazz", "findMethodOrNull", "internalNameWithoutModuleSuffix", "jdiInvokeStaticMethod", "Lcom/sun/jdi/Value;", "type", "Lcom/sun/jdi/ClassType;", "method", "args", "Lcom/sun/jdi/InterfaceType;", "invokeStaticMethod", "arguments", "getField", "instance", "setField", "unboxType", "boxedValue", "jdiInvokeMethod", "obj", "Lcom/sun/jdi/ObjectReference;", "policy", "jdiNewInstance", "ctor", "invokeMethod", "invokeSpecial", "shouldInvokeMethodWithReflection", "isArrayOfInterfaces", "valueType", "expectedType", "invokeMethodWithReflection", "ownerType", "mirrorOfArgs", "disableCollection", "enableCollection", "mapArguments", "expectedTypes", "safeArgumentTypes", "intellij.kotlin.jvm.debugger.eval4j"})
@SourceDebugExtension(value={"SMAP\njdiEval.kt\nKotlin\n*S Kotlin\n*F\n+ 1 jdiEval.kt\norg/jetbrains/eval4j/jdi/JDIEval\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,525:1\n1123#2,3:526\n1#3:529\n777#4:530\n873#4,2:531\n1807#4,3:533\n1586#4:536\n1661#4,3:537\n1924#4,3:542\n1915#4,2:545\n1915#4,2:547\n1586#4:549\n1661#4,3:550\n1586#4:553\n1661#4,3:554\n37#5,2:540\n*S KotlinDebug\n*F\n+ 1 jdiEval.kt\norg/jetbrains/eval4j/jdi/JDIEval\n*L\n83#1:526,3\n225#1:530\n225#1:531,2\n384#1:533,3\n400#1:536\n400#1:537,3\n437#1:542,3\n446#1:545,2\n450#1:547,2\n455#1:549\n455#1:550,3\n464#1:553\n464#1:554,3\n400#1:540,2\n*E\n"})
public class JDIEval
implements Eval {
    @NotNull
    private final VirtualMachine vm;
    @Nullable
    private final ClassLoaderReference defaultClassLoader;
    @NotNull
    private final ThreadReference thread;
    private final int invokePolicy;
    @NotNull
    private final Map<String, com.sun.jdi.Type> primitiveTypes;
    private final boolean isJava8OrLater;

    public JDIEval(@NotNull VirtualMachine vm, @Nullable ClassLoaderReference defaultClassLoader, @NotNull ThreadReference thread, int invokePolicy) {
        Intrinsics.checkNotNullParameter((Object)vm, (String)"vm");
        Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
        this.vm = vm;
        this.defaultClassLoader = defaultClassLoader;
        this.thread = thread;
        this.invokePolicy = invokePolicy;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Type.BOOLEAN_TYPE.getClassName(), (Object)this.vm.mirrorOf(true).type()), TuplesKt.to((Object)Type.BYTE_TYPE.getClassName(), (Object)this.vm.mirrorOf((byte)1).type()), TuplesKt.to((Object)Type.SHORT_TYPE.getClassName(), (Object)this.vm.mirrorOf((short)1).type()), TuplesKt.to((Object)Type.INT_TYPE.getClassName(), (Object)this.vm.mirrorOf(1).type()), TuplesKt.to((Object)Type.CHAR_TYPE.getClassName(), (Object)this.vm.mirrorOf('1').type()), TuplesKt.to((Object)Type.LONG_TYPE.getClassName(), (Object)this.vm.mirrorOf(1L).type()), TuplesKt.to((Object)Type.FLOAT_TYPE.getClassName(), (Object)this.vm.mirrorOf(1.0f).type()), TuplesKt.to((Object)Type.DOUBLE_TYPE.getClassName(), (Object)this.vm.mirrorOf(1.0).type())};
        this.primitiveTypes = MapsKt.mapOf((Pair[])pairArray);
        this.isJava8OrLater = StringUtil.compareVersionNumbers((String)this.vm.version(), (String)"1.8") >= 0;
    }

    @NotNull
    protected final ThreadReference getThread() {
        return this.thread;
    }

    @Override
    @NotNull
    public Value loadClass(@NotNull Type classType) {
        Intrinsics.checkNotNullParameter((Object)classType, (String)"classType");
        return JdiValuesKt.asValue(this.loadType(classType, this.defaultClassLoader).classObject());
    }

    @NotNull
    public ReferenceType loadType(@NotNull Type classType, @Nullable ClassLoaderReference classLoader) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)classType, (String)"classType");
        List<ReferenceType> loadedClasses = this.vm.classesByName(classType.getClassName());
        Intrinsics.checkNotNull(loadedClasses);
        if (!((Collection)loadedClasses).isEmpty()) {
            for (ReferenceType loadedClass : loadedClasses) {
                if (!loadedClass.isPrepared() || !JdiEvalKt.access$getBOOTSTRAP_CLASS_DESCRIPTORS$p().contains(classType.getDescriptor()) && !Intrinsics.areEqual((Object)loadedClass.classLoader(), (Object)classLoader)) continue;
                Intrinsics.checkNotNull((Object)loadedClass);
                return loadedClass;
            }
        }
        if (classLoader == null) {
            String string = JdiEvalKt.access$getCLASS_TYPE$p().getInternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getInternalName(...)");
            ClassObjectReference classObjectReference = JdiValuesKt.getJdiClass(this.invokeStaticMethod(new MethodDescription(string, "forName", "(Ljava/lang/String;)Ljava/lang/Class;", true), CollectionsKt.listOf((Object)this.loadString(JdiEvalKt.getJdiName(classType)))));
            Intrinsics.checkNotNull((Object)classObjectReference);
            object = classObjectReference.reflectedType();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"reflectedType(...)");
            return object;
        }
        String string = JdiEvalKt.access$getCLASS_TYPE$p().getInternalName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getInternalName(...)");
        Object[] objectArray = new Value[]{this.loadString(JdiEvalKt.getJdiName(classType)), ValuesKt.boolean(true), JdiValuesKt.asValue(classLoader)};
        ClassObjectReference classObjectReference = JdiValuesKt.getJdiClass(this.invokeStaticMethod(new MethodDescription(string, "forName", "(Ljava/lang/String;ZLjava/lang/ClassLoader;)Ljava/lang/Class;", true), CollectionsKt.listOf((Object[])objectArray)));
        Intrinsics.checkNotNull((Object)classObjectReference);
        object = classObjectReference.reflectedType();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"reflectedType(...)");
        return object;
    }

    private final com.sun.jdi.Type loadClassByName(String name2, ClassLoaderReference classLoader) {
        com.sun.jdi.Type type2;
        com.sun.jdi.Type baseType;
        com.sun.jdi.Type type3;
        String baseTypeName;
        CharSequence $this$count$iv = name2;
        boolean $i$f$count = false;
        int count$iv = 0;
        for (int j = 0; j < $this$count$iv.length(); ++j) {
            char element$iv;
            char it = element$iv = $this$count$iv.charAt(j);
            boolean bl = false;
            if (!(it == '[')) continue;
            ++count$iv;
        }
        int dimensions = count$iv;
        if (dimensions > 0) {
            String string = name2.substring(0, StringsKt.indexOf$default((CharSequence)name2, (char)'[', (int)0, (boolean)false, (int)6, null));
            v1 = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        } else {
            v1 = baseTypeName = name2;
        }
        if ((type3 = this.primitiveTypes.get(baseTypeName)) == null) {
            Type type4 = Type.getType((String)("L" + baseTypeName + ";"));
            Intrinsics.checkNotNullExpressionValue((Object)type4, (String)"getType(...)");
            type3 = baseType = (com.sun.jdi.Type)this.asReferenceType(type4, classLoader);
        }
        if (dimensions == 0) {
            type2 = baseType;
        } else {
            Type type5 = Type.getType((String)(StringsKt.repeat((CharSequence)"[", (int)dimensions) + JdiValuesKt.asType(baseType).getDescriptor()));
            Intrinsics.checkNotNullExpressionValue((Object)type5, (String)"getType(...)");
            type2 = this.asReferenceType(type5, classLoader);
        }
        return type2;
    }

    @NotNull
    public StringReference jdiMirrorOfString(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        StringReference stringReference = this.vm.mirrorOf(str);
        Intrinsics.checkNotNullExpressionValue((Object)stringReference, (String)"mirrorOf(...)");
        return stringReference;
    }

    @Override
    @NotNull
    public Value loadString(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        return JdiValuesKt.asValue(this.jdiMirrorOfString(str));
    }

    @Override
    @NotNull
    public Value newInstance(@NotNull Type classType) {
        Intrinsics.checkNotNullParameter((Object)classType, (String)"classType");
        return new NewObjectValue(classType);
    }

    @Override
    public boolean isInstanceOf(@NotNull Value value, @NotNull Type targetType) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)targetType, (String)"targetType");
        boolean bl2 = bl = targetType.getSort() == 10 || targetType.getSort() == 9;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Can't check isInstanceOf() for non-object type " + targetType;
            throw new AssertionError((Object)string);
        }
        com.sun.jdi.Value value2 = JdiValuesKt.asJdiValue(value, this.vm, (Function0<Type>)((Function0)JDIEval::isInstanceOf$lambda$1));
        if (value2 == null) {
            return false;
        }
        com.sun.jdi.Value jdiValue = value2;
        return DebuggerUtilsImpl.instanceOf((ReferenceType)((ObjectReference)jdiValue).referenceType(), (ReferenceType)JDIEval.asReferenceType$default(this, targetType, null, 1, null));
    }

    private final ReferenceType asReferenceType(Type $this$asReferenceType, ClassLoaderReference classLoader) {
        return this.loadType($this$asReferenceType, classLoader);
    }

    static /* synthetic */ ReferenceType asReferenceType$default(JDIEval jDIEval, Type type2, ClassLoaderReference classLoaderReference, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: asReferenceType");
        }
        if ((n & 1) != 0) {
            classLoaderReference = jDIEval.defaultClassLoader;
        }
        return jDIEval.asReferenceType(type2, classLoaderReference);
    }

    private final ArrayType asArrayType(Type $this$asArrayType, ClassLoaderReference classLoader) {
        ReferenceType referenceType = this.asReferenceType($this$asArrayType, classLoader);
        Intrinsics.checkNotNull((Object)referenceType, (String)"null cannot be cast to non-null type com.sun.jdi.ArrayType");
        return (ArrayType)referenceType;
    }

    static /* synthetic */ ArrayType asArrayType$default(JDIEval jDIEval, Type type2, ClassLoaderReference classLoaderReference, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: asArrayType");
        }
        if ((n & 1) != 0) {
            classLoaderReference = jDIEval.defaultClassLoader;
        }
        return jDIEval.asArrayType(type2, classLoaderReference);
    }

    @NotNull
    public ArrayReference jdiNewArray(@NotNull ArrayType arrayType, int size) {
        Intrinsics.checkNotNullParameter((Object)arrayType, (String)"arrayType");
        ArrayReference arrayReference = arrayType.newInstance(size);
        Intrinsics.checkNotNullExpressionValue((Object)arrayReference, (String)"newInstance(...)");
        return arrayReference;
    }

    @Override
    @NotNull
    public Value newArray(@NotNull Type arrayType, int size) {
        Intrinsics.checkNotNullParameter((Object)arrayType, (String)"arrayType");
        ArrayType jdiArrayType = JDIEval.asArrayType$default(this, arrayType, null, 1, null);
        return JdiValuesKt.asValue(this.jdiNewArray(jdiArrayType, size));
    }

    private final Type getArrayElementType(Type $this$arrayElementType) {
        boolean bl;
        boolean bl2 = bl = $this$arrayElementType.getSort() == 9;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Not an array type: " + $this$arrayElementType;
            throw new AssertionError((Object)string);
        }
        String string = $this$arrayElementType.getDescriptor();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDescriptor(...)");
        String string2 = string;
        int n = 1;
        String string3 = string2.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        Type type2 = Type.getType((String)string3);
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"getType(...)");
        return type2;
    }

    private final Value fillArray(Type elementType, int size, List<Integer> nestedSizes) {
        Type type2 = Type.getType((String)("[" + elementType.getDescriptor()));
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"getType(...)");
        Value arr = this.newArray(type2, size);
        if (!((Collection)nestedSizes).isEmpty()) {
            Type nestedElementType = this.getArrayElementType(elementType);
            int nestedSize = ((Number)nestedSizes.get(0)).intValue();
            List tail = CollectionsKt.drop((Iterable)nestedSizes, (int)1);
            for (int i2 = 0; i2 < size; ++i2) {
                this.setArrayElement(arr, ValuesKt.int(i2), this.fillArray(nestedElementType, nestedSize, tail));
            }
        }
        return arr;
    }

    @Override
    @NotNull
    public Value newMultiDimensionalArray(@NotNull Type arrayType, @NotNull List<Integer> dimensionSizes) {
        Intrinsics.checkNotNullParameter((Object)arrayType, (String)"arrayType");
        Intrinsics.checkNotNullParameter(dimensionSizes, (String)"dimensionSizes");
        return this.fillArray(this.getArrayElementType(arrayType), ((Number)dimensionSizes.get(0)).intValue(), CollectionsKt.drop((Iterable)dimensionSizes, (int)1));
    }

    private final ArrayReference array(Value $this$array) {
        ObjectReference objectReference = ValuesKt.checkNull(JdiValuesKt.getJdiObj($this$array));
        Intrinsics.checkNotNull((Object)objectReference, (String)"null cannot be cast to non-null type com.sun.jdi.ArrayReference");
        return (ArrayReference)objectReference;
    }

    @Override
    @NotNull
    public Value getArrayLength(@NotNull Value array) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        return ValuesKt.int(this.array(array).length());
    }

    @Override
    @NotNull
    public Value getArrayElement(@NotNull Value array, @NotNull Value index2) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
        try {
            return JdiValuesKt.asValue(this.array(array).getValue(ValuesKt.getInt(index2)));
        }
        catch (IndexOutOfBoundsException e) {
            ValuesKt.throwInterpretingException(new ArrayIndexOutOfBoundsException(e.getMessage()));
            throw new KotlinNothingValueException();
        }
    }

    @Override
    public void setArrayElement(@NotNull Value array, @NotNull Value index2, @NotNull Value newValue) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
        Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
        try {
            this.array(array).setValue(ValuesKt.getInt(index2), JdiValuesKt.asJdiValue(newValue, this.vm, (Function0<Type>)((Function0)() -> JDIEval.setArrayElement$lambda$0(this, array))));
            return;
        }
        catch (IndexOutOfBoundsException e) {
            ValuesKt.throwInterpretingException(new ArrayIndexOutOfBoundsException(e.getMessage()));
            throw new KotlinNothingValueException();
        }
        catch (InvalidTypeException e) {
            ValuesKt.throwInterpretingException(new ArrayStoreException(e.getMessage()));
            throw new KotlinNothingValueException();
        }
    }

    private final Field findField(FieldDescription fieldDesc, ReferenceType receiver2) {
        if (receiver2 != null) {
            Field field2 = DebuggerUtils.findField((ReferenceType)receiver2, (String)fieldDesc.getName());
            if (field2 != null) {
                Field it = field2;
                boolean bl = false;
                return it;
            }
        }
        Field field3 = DebuggerUtils.findField((ReferenceType)JDIEval.asReferenceType$default(this, MembersKt.getOwnerType(fieldDesc), null, 1, null), (String)fieldDesc.getName());
        if (field3 != null) {
            Field it = field3;
            boolean bl = false;
            return it;
        }
        ValuesKt.throwBrokenCodeException(new NoSuchFieldError("Field not found: " + fieldDesc));
        throw new KotlinNothingValueException();
    }

    static /* synthetic */ Field findField$default(JDIEval jDIEval, FieldDescription fieldDescription, ReferenceType referenceType, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findField");
        }
        if ((n & 2) != 0) {
            referenceType = null;
        }
        return jDIEval.findField(fieldDescription, referenceType);
    }

    private final Field findStaticField(FieldDescription fieldDesc) {
        Field field2 = JDIEval.findField$default(this, fieldDesc, null, 2, null);
        if (!field2.isStatic()) {
            ValuesKt.throwBrokenCodeException(new NoSuchFieldError("Field is not static: " + fieldDesc));
            throw new KotlinNothingValueException();
        }
        return field2;
    }

    @Override
    @NotNull
    public Value getStaticField(@NotNull FieldDescription fieldDesc) {
        Intrinsics.checkNotNullParameter((Object)fieldDesc, (String)"fieldDesc");
        Field field2 = this.findStaticField(fieldDesc);
        return JdiValuesKt.asValue((com.sun.jdi.Value)JdiEvalKt.ifFail$default(JdiEvalKt.access$mayThrow(() -> JDIEval.getStaticField$lambda$0(field2)), field2, null, 2, null));
    }

    @Override
    public void setStaticField(@NotNull FieldDescription fieldDesc, @NotNull Value newValue) {
        Intrinsics.checkNotNullParameter((Object)fieldDesc, (String)"fieldDesc");
        Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
        Field field2 = this.findStaticField(fieldDesc);
        if (field2.isFinal()) {
            ValuesKt.throwBrokenCodeException(new NoSuchFieldError("Can't modify a final field: " + field2));
            throw new KotlinNothingValueException();
        }
        ReferenceType referenceType = field2.declaringType();
        ClassType classType = referenceType instanceof ClassType ? (ClassType)referenceType : null;
        if (classType == null) {
            ValuesKt.throwBrokenCodeException(new NoSuchFieldError("Can't a field in a non-class: " + field2));
            throw new KotlinNothingValueException();
        }
        ClassType clazz = classType;
        com.sun.jdi.Value jdiValue = JdiValuesKt.asJdiValue(newValue, this.vm, (Function0<Type>)((Function0)() -> JDIEval.setStaticField$lambda$0(field2)));
        JdiEvalKt.ifFail$default(JdiEvalKt.access$mayThrow(() -> JDIEval.setStaticField$lambda$1(clazz, field2, jdiValue)), field2, null, 2, null);
    }

    private final Method findMethod(MethodDescription methodDesc, ReferenceType clazz) {
        Method method = this.findMethodOrNull(methodDesc, clazz);
        if (method != null) {
            return method;
        }
        ValuesKt.throwBrokenCodeException(new NoSuchMethodError("Method not found: " + methodDesc));
        throw new KotlinNothingValueException();
    }

    static /* synthetic */ Method findMethod$default(JDIEval jDIEval, MethodDescription methodDescription, ReferenceType referenceType, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findMethod");
        }
        if ((n & 2) != 0) {
            referenceType = JDIEval.asReferenceType$default(jDIEval, MembersKt.getOwnerType(methodDescription), null, 1, null);
        }
        return jDIEval.findMethod(methodDescription, referenceType);
    }

    /*
     * WARNING - void declaration
     */
    private final Method findMethodOrNull(MethodDescription methodDesc, ReferenceType clazz) {
        Method method = DebuggerUtils.findMethod((ReferenceType)clazz, (String)methodDesc.getName(), (String)methodDesc.getDesc());
        if (method != null) {
            return method;
        }
        String internalNameWithoutSuffix = this.internalNameWithoutModuleSuffix(methodDesc.getName());
        if (internalNameWithoutSuffix != null) {
            void $this$filterTo$iv$iv;
            List<Method> list2 = clazz.visibleMethods();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"visibleMethods(...)");
            Iterable $this$filter$iv = list2;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Method it = (Method)element$iv$iv;
                boolean bl = false;
                String name2 = it.name();
                Intrinsics.checkNotNull((Object)name2);
                if (!(StringsKt.startsWith$default((String)name2, (String)internalNameWithoutSuffix, (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)name2, (char)'$', (boolean)false, (int)2, null) && Intrinsics.areEqual((Object)it.signature(), (Object)methodDesc.getDesc()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List internalMethods = (List)destination$iv$iv;
            if (!((Collection)internalMethods).isEmpty()) {
                Method method2 = (Method)CollectionsKt.singleOrNull((List)internalMethods);
                if (method2 == null) {
                    ValuesKt.throwBrokenCodeException(new Eval4JIllegalArgumentException("Several internal methods found for " + methodDesc));
                    throw new KotlinNothingValueException();
                }
                return method2;
            }
        }
        return null;
    }

    private final String internalNameWithoutModuleSuffix(String name2) {
        String demangledName;
        String string;
        int indexOfDollar = StringsKt.indexOf$default((CharSequence)name2, (char)'$', (int)0, (boolean)false, (int)6, null);
        if (indexOfDollar >= 0) {
            String string2 = name2.substring(0, indexOfDollar);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            string = null;
        }
        String string3 = demangledName = string;
        return string3 != null ? string3 + "$" : null;
    }

    @Nullable
    public com.sun.jdi.Value jdiInvokeStaticMethod(@NotNull ClassType type2, @NotNull Method method, @NotNull List<? extends com.sun.jdi.Value> args, int invokePolicy) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        return type2.invokeMethod(this.thread, method, args, invokePolicy);
    }

    @Nullable
    public com.sun.jdi.Value jdiInvokeStaticMethod(@NotNull InterfaceType type2, @NotNull Method method, @NotNull List<? extends com.sun.jdi.Value> args, int invokePolicy) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        return type2.invokeMethod(this.thread, method, args, invokePolicy);
    }

    @Override
    @NotNull
    public Value invokeStaticMethod(@NotNull MethodDescription methodDesc, @NotNull List<? extends Value> arguments2) {
        Intrinsics.checkNotNullParameter((Object)methodDesc, (String)"methodDesc");
        Intrinsics.checkNotNullParameter(arguments2, (String)"arguments");
        Method method = JDIEval.findMethod$default(this, methodDesc, null, 2, null);
        if (!method.isStatic()) {
            ValuesKt.throwBrokenCodeException(new NoSuchMethodError("Method is not static: " + methodDesc));
            throw new KotlinNothingValueException();
        }
        ReferenceType declaringType = method.declaringType();
        List<com.sun.jdi.Value> args = this.mapArguments(arguments2, this.safeArgumentTypes(method));
        if (this.shouldInvokeMethodWithReflection(method, args)) {
            Intrinsics.checkNotNull((Object)declaringType);
            return this.invokeMethodWithReflection(JdiValuesKt.asType(declaringType), ValuesKt.getNULL_VALUE(), args, methodDesc);
        }
        this.disableCollection(args);
        com.sun.jdi.Value result2 = (com.sun.jdi.Value)JdiEvalKt.ifFail$default(JdiEvalKt.access$mayThrow(() -> JDIEval.invokeStaticMethod$lambda$0(declaringType, this, method, args)), method, null, 2, null);
        this.enableCollection(args);
        return JdiValuesKt.asValue(result2);
    }

    @Override
    @NotNull
    public Value getField(@NotNull Value instance, @NotNull FieldDescription fieldDesc) {
        Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
        Intrinsics.checkNotNullParameter((Object)fieldDesc, (String)"fieldDesc");
        ObjectReference receiver2 = ValuesKt.checkNull(JdiValuesKt.getJdiObj(instance));
        Field field2 = this.findField(fieldDesc, receiver2.referenceType());
        return JdiValuesKt.asValue((com.sun.jdi.Value)JdiEvalKt.access$ifFail(JdiEvalKt.access$mayThrow(() -> JDIEval.getField$lambda$0(receiver2, field2)), field2, receiver2));
    }

    @Override
    public void setField(@NotNull Value instance, @NotNull FieldDescription fieldDesc, @NotNull Value newValue) {
        Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
        Intrinsics.checkNotNullParameter((Object)fieldDesc, (String)"fieldDesc");
        Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
        ObjectReference receiver2 = ValuesKt.checkNull(JdiValuesKt.getJdiObj(instance));
        Field field2 = this.findField(fieldDesc, receiver2.referenceType());
        com.sun.jdi.Value jdiValue = JdiValuesKt.asJdiValue(newValue, this.vm, (Function0<Type>)((Function0)() -> JDIEval.setField$lambda$0(field2)));
        JdiEvalKt.access$mayThrow(() -> JDIEval.setField$lambda$1(receiver2, field2, jdiValue));
    }

    private final Value unboxType(Value boxedValue, Type type2) {
        MethodDescription methodDescription;
        Type type3 = type2;
        if (Intrinsics.areEqual((Object)type3, (Object)Type.INT_TYPE)) {
            methodDescription = new MethodDescription("java/lang/Integer", "intValue", "()I", false);
        } else if (Intrinsics.areEqual((Object)type3, (Object)Type.BOOLEAN_TYPE)) {
            methodDescription = new MethodDescription("java/lang/Boolean", "booleanValue", "()Z", false);
        } else if (Intrinsics.areEqual((Object)type3, (Object)Type.CHAR_TYPE)) {
            methodDescription = new MethodDescription("java/lang/Character", "charValue", "()C", false);
        } else if (Intrinsics.areEqual((Object)type3, (Object)Type.SHORT_TYPE)) {
            methodDescription = new MethodDescription("java/lang/Character", "shortValue", "()S", false);
        } else if (Intrinsics.areEqual((Object)type3, (Object)Type.LONG_TYPE)) {
            methodDescription = new MethodDescription("java/lang/Long", "longValue", "()J", false);
        } else if (Intrinsics.areEqual((Object)type3, (Object)Type.BYTE_TYPE)) {
            methodDescription = new MethodDescription("java/lang/Byte", "byteValue", "()B", false);
        } else if (Intrinsics.areEqual((Object)type3, (Object)Type.FLOAT_TYPE)) {
            methodDescription = new MethodDescription("java/lang/Float", "floatValue", "()F", false);
        } else if (Intrinsics.areEqual((Object)type3, (Object)Type.DOUBLE_TYPE)) {
            methodDescription = new MethodDescription("java/lang/Double", "doubleValue", "()D", false);
        } else {
            throw new UnsupportedOperationException("Couldn't unbox non primitive type " + type2.getInternalName());
        }
        MethodDescription method = methodDescription;
        return this.invokeMethod(boxedValue, method, CollectionsKt.emptyList(), true);
    }

    @Nullable
    public com.sun.jdi.Value jdiInvokeMethod(@NotNull ObjectReference obj, @NotNull Method method, @NotNull List<? extends com.sun.jdi.Value> args, int policy) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        return obj.invokeMethod(this.thread, method, args, policy);
    }

    @Nullable
    public com.sun.jdi.Value jdiNewInstance(@NotNull ClassType clazz, @NotNull Method ctor, @NotNull List<? extends com.sun.jdi.Value> args, int policy) {
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)ctor, (String)"ctor");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        return clazz.newInstance(this.thread, ctor, args, policy);
    }

    @Override
    @NotNull
    public Value invokeMethod(@NotNull Value instance, @NotNull MethodDescription methodDesc, @NotNull List<? extends Value> arguments2, boolean invokeSpecial) {
        Value value;
        Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
        Intrinsics.checkNotNullParameter((Object)methodDesc, (String)"methodDesc");
        Intrinsics.checkNotNullParameter(arguments2, (String)"arguments");
        if (invokeSpecial && Intrinsics.areEqual((Object)methodDesc.getName(), (Object)"<init>")) {
            Method ctor = JDIEval.findMethod$default(this, methodDesc, null, 2, null);
            ReferenceType referenceType = JDIEval.asReferenceType$default(this, ((NewObjectValue)instance).getAsmType(), null, 1, null);
            Intrinsics.checkNotNull((Object)referenceType, (String)"null cannot be cast to non-null type com.sun.jdi.ClassType");
            ClassType clazz = (ClassType)referenceType;
            List<com.sun.jdi.Value> args = this.mapArguments(arguments2, this.safeArgumentTypes(ctor));
            this.disableCollection(args);
            com.sun.jdi.Value result2 = (com.sun.jdi.Value)JdiEvalKt.ifFail$default(JdiEvalKt.access$mayThrow(() -> JDIEval.invokeMethod$lambda$0(this, clazz, ctor, args)), ctor, null, 2, null);
            this.enableCollection(args);
            ((NewObjectValue)instance).setValue(result2);
            return JdiValuesKt.asValue(result2);
        }
        ObjectReference obj = ValuesKt.checkNull(JdiValuesKt.getJdiObj(instance));
        if (invokeSpecial) {
            Method method = JDIEval.findMethod$default(this, methodDesc, null, 2, null);
            value = JDIEval.invokeMethod$doInvokeMethod(this, arguments2, instance, methodDesc, obj, method, this.invokePolicy | 2);
        } else {
            ReferenceType referenceType = obj.referenceType();
            if (referenceType == null) {
                referenceType = JDIEval.asReferenceType$default(this, MembersKt.getOwnerType(methodDesc), null, 1, null);
            }
            Method method = this.findMethod(methodDesc, referenceType);
            value = JDIEval.invokeMethod$doInvokeMethod(this, arguments2, instance, methodDesc, obj, method, this.invokePolicy);
        }
        return value;
    }

    public boolean shouldInvokeMethodWithReflection(@NotNull Method method, @NotNull List<? extends com.sun.jdi.Value> args) {
        boolean bl;
        block6: {
            List<com.sun.jdi.Type> list2;
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            Intrinsics.checkNotNullParameter(args, (String)"args");
            if (method.isVarArgs()) {
                return false;
            }
            try {
                list2 = method.argumentTypes();
            }
            catch (ClassNotLoadedException e) {
                return false;
            }
            List<com.sun.jdi.Type> argumentTypes = list2;
            Iterable iterable = args;
            Intrinsics.checkNotNull(argumentTypes);
            Iterable $this$any$iv = CollectionsKt.zip((Iterable)iterable, (Iterable)argumentTypes);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Pair pair = (Pair)element$iv;
                    boolean bl2 = false;
                    com.sun.jdi.Value arg = (com.sun.jdi.Value)pair.component1();
                    com.sun.jdi.Type type2 = (com.sun.jdi.Type)pair.component2();
                    com.sun.jdi.Value value = arg;
                    if (!this.isArrayOfInterfaces(value != null ? value.type() : null, type2)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isArrayOfInterfaces(com.sun.jdi.Type valueType, com.sun.jdi.Type expectedType) {
        ArrayType arrayType = valueType instanceof ArrayType ? (ArrayType)valueType : null;
        if (!((arrayType != null ? arrayType.componentType() : null) instanceof InterfaceType)) return false;
        ArrayType arrayType2 = expectedType instanceof ArrayType ? (ArrayType)expectedType : null;
        if (!Intrinsics.areEqual((Object)(arrayType2 != null ? arrayType2.componentType() : null), (Object)JDIEval.asReferenceType$default(this, JdiEvalKt.access$getOBJECT_TYPE$p(), null, 1, null))) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final Value invokeMethodWithReflection(Type ownerType, Value instance, List<? extends com.sun.jdi.Value> args, MethodDescription methodDesc) {
        void $this$toTypedArray$iv;
        Collection<Value> collection;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        Eval eval2 = this;
        Value value = this.loadClass(ownerType);
        String string = JdiEvalKt.access$getCLASS_TYPE$p().getInternalName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getInternalName(...)");
        MethodDescription methodDescription = new MethodDescription(string, "getDeclaredMethod", "(Ljava/lang/String;[L" + JdiEvalKt.access$getCLASS_TYPE$p().getInternalName() + ";)Ljava/lang/reflect/Method;", true);
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        spreadBuilder.add((Object)this.loadString(methodDesc.getName()));
        Object[] objectArray = (Object[])MembersKt.getParameterTypes(methodDesc);
        SpreadBuilder spreadBuilder2 = spreadBuilder;
        MethodDescription methodDescription2 = methodDescription;
        Value value2 = value;
        Eval eval3 = eval2;
        boolean $i$f$map = false;
        void var9_12 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Type type2 = (Type)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.loadClass((Type)it));
        }
        collection = (List)destination$iv$iv;
        $this$map$iv = collection;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        spreadBuilder2.addSpread((Object)thisCollection$iv.toArray(new Value[0]));
        Value methodToInvoke = Eval.invokeMethod$default(eval3, value2, methodDescription2, CollectionsKt.listOf((Object[])spreadBuilder.toArray((Object[])new Value[spreadBuilder.size()])), false, 8, null);
        Eval eval4 = this;
        String string2 = Type.getType(AccessibleObject.class).getInternalName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getInternalName(...)");
        Eval.invokeMethod$default(eval4, methodToInvoke, new MethodDescription(string2, "setAccessible", "(Z)V", true), CollectionsKt.listOf((Object)JdiValuesKt.asValue(this.vm.mirrorOf(true))), false, 8, null);
        Eval eval5 = this;
        String string3 = methodToInvoke.getAsmType().getInternalName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getInternalName(...)");
        objectArray = new Value[]{instance, this.mirrorOfArgs(args)};
        Value invocationResult = Eval.invokeMethod$default(eval5, methodToInvoke, new MethodDescription(string3, "invoke", "(L" + JdiEvalKt.access$getOBJECT_TYPE$p().getInternalName() + ";[L" + JdiEvalKt.access$getOBJECT_TYPE$p().getInternalName() + ";)L" + JdiEvalKt.access$getOBJECT_TYPE$p().getInternalName() + ";", true), CollectionsKt.listOf((Object[])objectArray), false, 8, null);
        return MembersKt.getReturnType(methodDesc).getSort() != 10 && MembersKt.getReturnType(methodDesc).getSort() != 9 && MembersKt.getReturnType(methodDesc).getSort() != 0 ? this.unboxType(invocationResult, MembersKt.getReturnType(methodDesc)) : invocationResult;
    }

    /*
     * WARNING - void declaration
     */
    private final Value mirrorOfArgs(List<? extends com.sun.jdi.Value> args) {
        Type type2 = Type.getType((String)("[" + JdiEvalKt.access$getOBJECT_TYPE$p().getDescriptor()));
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"getType(...)");
        Value arrayObject = this.newArray(type2, args.size());
        Iterable $this$forEachIndexed$iv = args;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void value;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            com.sun.jdi.Value value2 = (com.sun.jdi.Value)item$iv;
            int index2 = n;
            boolean bl = false;
            Value indexValue = JdiValuesKt.asValue(this.vm.mirrorOf(index2));
            this.setArrayElement(arrayObject, indexValue, JdiValuesKt.asValue((com.sun.jdi.Value)value));
        }
        return arrayObject;
    }

    private final void disableCollection(List<? extends com.sun.jdi.Value> $this$disableCollection) {
        Iterable $this$forEach$iv = $this$disableCollection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            com.sun.jdi.Value it = (com.sun.jdi.Value)element$iv;
            boolean bl = false;
            ObjectReference objectReference = it instanceof ObjectReference ? (ObjectReference)it : null;
            if (objectReference == null) continue;
            objectReference.disableCollection();
        }
    }

    private final void enableCollection(List<? extends com.sun.jdi.Value> $this$enableCollection) {
        Iterable $this$forEach$iv = $this$enableCollection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            com.sun.jdi.Value it = (com.sun.jdi.Value)element$iv;
            boolean bl = false;
            ObjectReference objectReference = it instanceof ObjectReference ? (ObjectReference)it : null;
            if (objectReference == null) continue;
            objectReference.enableCollection();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<com.sun.jdi.Value> mapArguments(List<? extends Value> arguments2, List<? extends com.sun.jdi.Type> expectedTypes) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = CollectionsKt.zip((Iterable)arguments2, (Iterable)expectedTypes);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Value arg = (Value)pair.component1();
            com.sun.jdi.Type expectedType = (com.sun.jdi.Type)pair.component2();
            collection.add(JdiValuesKt.asJdiValue(arg, this.vm, (Function0<Type>)((Function0)() -> JDIEval.mapArguments$lambda$0$0(expectedType))));
        }
        return (List)destination$iv$iv;
    }

    /*
     * Unable to fully structure code
     */
    private final List<com.sun.jdi.Type> safeArgumentTypes(Method $this$safeArgumentTypes) {
        try {
            v0 = $this$safeArgumentTypes.argumentTypes();
            Intrinsics.checkNotNullExpressionValue(v0, (String)"argumentTypes(...)");
            return v0;
        }
        catch (ClassNotLoadedException e) {
            v1 = $this$safeArgumentTypes.argumentTypeNames();
            Intrinsics.checkNotNull(v1);
            $this$map$iv = v1;
            $i$f$map = false;
            var5_5 = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (T item$iv$iv : $this$mapTo$iv$iv) {
                block36: {
                    block35: {
                        var10_10 = (String)item$iv$iv;
                        var15_15 = destination$iv$iv;
                        $i$a$-map-JDIEval$safeArgumentTypes$1 = false;
                        v2 = $this$safeArgumentTypes.declaringType();
                        v3 = classLoader = v2 != null ? v2.classLoader() : null;
                        if (classLoader == null) break block35;
                        Intrinsics.checkNotNull((Object)name);
                        v4 = this.loadClassByName((String)name, classLoader);
                        break block36;
                    }
                    var13_13 = name;
                    if (var13_13 == null) ** GOTO lbl-1000
                    tmp = -1;
                    switch (var13_13.hashCode()) {
                        case 3625364: {
                            if (var13_13.equals("void")) {
                                tmp = 1;
                            }
                            break;
                        }
                        case 64711720: {
                            if (var13_13.equals("boolean")) {
                                tmp = 2;
                            }
                            break;
                        }
                        case 3039496: {
                            if (var13_13.equals("byte")) {
                                tmp = 3;
                            }
                            break;
                        }
                        case -1325958191: {
                            if (var13_13.equals("double")) {
                                tmp = 4;
                            }
                            break;
                        }
                        case 3052374: {
                            if (var13_13.equals("char")) {
                                tmp = 5;
                            }
                            break;
                        }
                        case 109413500: {
                            if (var13_13.equals("short")) {
                                tmp = 6;
                            }
                            break;
                        }
                        case 97526364: {
                            if (var13_13.equals("float")) {
                                tmp = 7;
                            }
                            break;
                        }
                        case 104431: {
                            if (var13_13.equals("int")) {
                                tmp = 8;
                            }
                            break;
                        }
                        case 3327612: {
                            if (var13_13.equals("long")) {
                                tmp = 9;
                            }
                            break;
                        }
                    }
                    switch (tmp) {
                        case 1: {
                            v5 = $this$safeArgumentTypes.virtualMachine().mirrorOfVoid().type();
                            break;
                        }
                        case 2: {
                            v5 = (com.sun.jdi.Type)MapsKt.getValue(this.primitiveTypes, (Object)Type.BOOLEAN_TYPE.getClassName());
                            break;
                        }
                        case 3: {
                            v5 = (com.sun.jdi.Type)MapsKt.getValue(this.primitiveTypes, (Object)Type.BYTE_TYPE.getClassName());
                            break;
                        }
                        case 5: {
                            v5 = (com.sun.jdi.Type)MapsKt.getValue(this.primitiveTypes, (Object)Type.CHAR_TYPE.getClassName());
                            break;
                        }
                        case 6: {
                            v5 = (com.sun.jdi.Type)MapsKt.getValue(this.primitiveTypes, (Object)Type.SHORT_TYPE.getClassName());
                            break;
                        }
                        case 8: {
                            v5 = (com.sun.jdi.Type)MapsKt.getValue(this.primitiveTypes, (Object)Type.INT_TYPE.getClassName());
                            break;
                        }
                        case 9: {
                            v5 = (com.sun.jdi.Type)MapsKt.getValue(this.primitiveTypes, (Object)Type.LONG_TYPE.getClassName());
                            break;
                        }
                        case 7: {
                            v5 = (com.sun.jdi.Type)MapsKt.getValue(this.primitiveTypes, (Object)Type.FLOAT_TYPE.getClassName());
                            break;
                        }
                        case 4: {
                            v5 = (com.sun.jdi.Type)MapsKt.getValue(this.primitiveTypes, (Object)Type.DOUBLE_TYPE.getClassName());
                            break;
                        }
                        default: lbl-1000:
                        // 2 sources

                        {
                            v6 = $this$safeArgumentTypes.virtualMachine().classesByName((String)name);
                            Intrinsics.checkNotNullExpressionValue(v6, (String)"classesByName(...)");
                            v7 = (ReferenceType)CollectionsKt.firstOrNull(v6);
                            if (v7 == null) {
                                throw new IllegalStateException("Unknown class " + (String)name);
                            }
                            v5 = v7;
                        }
                    }
                    var14_14 = v5;
                    Intrinsics.checkNotNull((Object)var14_14);
                    v4 = var14_14;
                }
                var15_15.add(v4);
            }
            return (List)destination$iv$iv;
        }
    }

    private static final Type isInstanceOf$lambda$1() {
        return JdiEvalKt.access$getOBJECT_TYPE$p();
    }

    private static final Type setArrayElement$lambda$0(JDIEval this$0, Value $array) {
        return this$0.getArrayElementType($array.getAsmType());
    }

    private static final com.sun.jdi.Value getStaticField$lambda$0(Field $field) {
        return $field.declaringType().getValue($field);
    }

    private static final Type setStaticField$lambda$0(Field $field) {
        com.sun.jdi.Type type2 = $field.type();
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"type(...)");
        return JdiValuesKt.asType(type2);
    }

    private static final Unit setStaticField$lambda$1(ClassType $clazz, Field $field, com.sun.jdi.Value $jdiValue) {
        $clazz.setValue($field, $jdiValue);
        return Unit.INSTANCE;
    }

    private static final com.sun.jdi.Value invokeStaticMethod$lambda$0(ReferenceType $declaringType, JDIEval this$0, Method $method, List $args) {
        com.sun.jdi.Value value;
        ReferenceType referenceType = $declaringType;
        if (referenceType instanceof ClassType) {
            value = this$0.jdiInvokeStaticMethod((ClassType)$declaringType, $method, (List<? extends com.sun.jdi.Value>)$args, this$0.invokePolicy);
        } else if (referenceType instanceof InterfaceType) {
            if (!this$0.isJava8OrLater) {
                String message2 = "Calling interface static methods is not supported in JVM " + this$0.vm.version() + " (" + $method + ")";
                ValuesKt.throwBrokenCodeException(new NoSuchMethodError(message2));
                throw new KotlinNothingValueException();
            }
            value = this$0.jdiInvokeStaticMethod((InterfaceType)$declaringType, $method, (List<? extends com.sun.jdi.Value>)$args, this$0.invokePolicy);
        } else {
            String message3 = "Calling static methods is only supported for classes and interfaces (" + $method + ")";
            ValuesKt.throwBrokenCodeException(new NoSuchMethodError(message3));
            throw new KotlinNothingValueException();
        }
        return value;
    }

    private static final com.sun.jdi.Value getField$lambda$0(ObjectReference $receiver, Field $field) {
        com.sun.jdi.Value value;
        try {
            value = $receiver.getValue($field);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Possibly incompatible types: field declaring type = " + $field.declaringType() + ", instance type = " + $receiver.referenceType());
        }
        return value;
    }

    private static final Type setField$lambda$0(Field $field) {
        com.sun.jdi.Type type2 = $field.type();
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"type(...)");
        return JdiValuesKt.asType(type2);
    }

    private static final Unit setField$lambda$1(ObjectReference $receiver, Field $field, com.sun.jdi.Value $jdiValue) {
        $receiver.setValue($field, $jdiValue);
        return Unit.INSTANCE;
    }

    private static final com.sun.jdi.Value invokeMethod$doInvokeMethod$lambda$1(JDIEval this$0, ObjectReference $obj, Method $method, List $args, int $policy) {
        return this$0.jdiInvokeMethod($obj, $method, $args, $policy);
    }

    private static final com.sun.jdi.Value invokeMethod$lambda$0(JDIEval this$0, ClassType $clazz, Method $ctor, List $args) {
        return this$0.jdiNewInstance($clazz, $ctor, $args, this$0.invokePolicy);
    }

    private static final Value invokeMethod$doInvokeMethod(JDIEval this$0, List<? extends Value> $arguments, Value $instance, MethodDescription $methodDesc, ObjectReference obj, Method method, int policy) {
        List<com.sun.jdi.Value> args = this$0.mapArguments($arguments, this$0.safeArgumentTypes(method));
        if (this$0.shouldInvokeMethodWithReflection(method, args)) {
            return this$0.invokeMethodWithReflection($instance.getAsmType(), $instance, args, $methodDesc);
        }
        this$0.disableCollection(args);
        com.sun.jdi.Value result2 = (com.sun.jdi.Value)JdiEvalKt.access$ifFail(JdiEvalKt.access$mayThrow(() -> JDIEval.invokeMethod$doInvokeMethod$lambda$1(this$0, obj, method, args, policy)), method, obj);
        this$0.enableCollection(args);
        return JdiValuesKt.asValue(result2);
    }

    private static final Type mapArguments$lambda$0$0(com.sun.jdi.Type $expectedType) {
        return JdiValuesKt.asType($expectedType);
    }
}

