/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.descriptors.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.descriptors.KaFe10Session;
import org.jetbrains.kotlin.analysis.api.descriptors.components.base.KaFe10SessionComponent;
import org.jetbrains.kotlin.analysis.api.descriptors.symbols.descriptorBased.base.Fe10DescUtilsKt;
import org.jetbrains.kotlin.analysis.api.impl.base.components.KaBaseSessionComponent;
import org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbol;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J#\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\"\b\b\u0000\u0010\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u0002H\r\u00a2\u0006\u0002\u0010\u0010J#\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\"\b\b\u0000\u0010\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u0002H\r\u00a2\u0006\u0002\u0010\u0010J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0016\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aJ\u0016\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/analysis/api/descriptors/components/KaFe10SymbolDeclarationOverridesProvider;", "Lorg/jetbrains/kotlin/analysis/api/impl/base/components/KaBaseSessionComponent;", "Lorg/jetbrains/kotlin/analysis/api/descriptors/KaFe10Session;", "Lorg/jetbrains/kotlin/analysis/api/descriptors/components/base/KaFe10SessionComponent;", "analysisSessionProvider", "Lkotlin/Function0;", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "getAnalysisSessionProvider", "()Lkotlin/jvm/functions/Function0;", "getAllOverriddenSymbols", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaCallableSymbol;", "T", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaSymbol;", "callableSymbol", "(Lorg/jetbrains/kotlin/analysis/api/symbols/KaSymbol;)Lkotlin/sequences/Sequence;", "getDirectlyOverriddenSymbols", "getOverriddenDescriptors", "", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "descriptor", "collectAllOverrides", "", "isSubClassOf", "subClass", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaClassSymbol;", "superClass", "isDirectSubClassOf", "analysis-api-fe10"})
@SourceDebugExtension(value={"SMAP\nKaFe10SymbolDeclarationOverridesProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KaFe10SymbolDeclarationOverridesProvider.kt\norg/jetbrains/kotlin/analysis/api/descriptors/components/KaFe10SymbolDeclarationOverridesProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,85:1\n1642#2,10:86\n1915#2:96\n1916#2:98\n1652#2:99\n1642#2,10:100\n1915#2:110\n1916#2:112\n1652#2:113\n1#3:97\n1#3:111\n1#3:114\n*S KotlinDebug\n*F\n+ 1 KaFe10SymbolDeclarationOverridesProvider.kt\norg/jetbrains/kotlin/analysis/api/descriptors/components/KaFe10SymbolDeclarationOverridesProvider\n*L\n28#1:86,10\n28#1:96\n28#1:98\n28#1:99\n37#1:100,10\n37#1:110\n37#1:112\n37#1:113\n28#1:97\n37#1:111\n*E\n"})
public final class KaFe10SymbolDeclarationOverridesProvider
extends KaBaseSessionComponent<KaFe10Session>
implements KaFe10SessionComponent {
    @NotNull
    private final Function0<KaFe10Session> analysisSessionProvider;

    public KaFe10SymbolDeclarationOverridesProvider(@NotNull Function0<KaFe10Session> analysisSessionProvider) {
        Intrinsics.checkNotNullParameter(analysisSessionProvider, (String)"analysisSessionProvider");
        this.analysisSessionProvider = analysisSessionProvider;
    }

    @Override
    @NotNull
    public Function0<KaFe10Session> getAnalysisSessionProvider() {
        return this.analysisSessionProvider;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T extends KaSymbol> Sequence<KaCallableSymbol> getAllOverriddenSymbols(@NotNull T callableSymbol) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(callableSymbol, (String)"callableSymbol");
        DeclarationDescriptor declarationDescriptor = Fe10DescUtilsKt.getSymbolDescriptor(callableSymbol);
        CallableMemberDescriptor callableMemberDescriptor = declarationDescriptor instanceof CallableMemberDescriptor ? (CallableMemberDescriptor)declarationDescriptor : null;
        if (callableMemberDescriptor == null) {
            return SequencesKt.emptySequence();
        }
        CallableMemberDescriptor descriptor2 = callableMemberDescriptor;
        Iterable $this$mapNotNull$iv = this.getOverriddenDescriptors(descriptor2, true);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            KaCallableSymbol it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            CallableMemberDescriptor it = (CallableMemberDescriptor)element$iv$iv;
            boolean bl2 = false;
            if (Fe10DescUtilsKt.toKtCallableSymbol((CallableDescriptor)it, this.getAnalysisContext()) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.asSequence((Iterable)CollectionsKt.distinct((Iterable)((List)destination$iv$iv)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T extends KaSymbol> Sequence<KaCallableSymbol> getDirectlyOverriddenSymbols(@NotNull T callableSymbol) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(callableSymbol, (String)"callableSymbol");
        DeclarationDescriptor declarationDescriptor = Fe10DescUtilsKt.getSymbolDescriptor(callableSymbol);
        CallableMemberDescriptor callableMemberDescriptor = declarationDescriptor instanceof CallableMemberDescriptor ? (CallableMemberDescriptor)declarationDescriptor : null;
        if (callableMemberDescriptor == null) {
            return SequencesKt.emptySequence();
        }
        CallableMemberDescriptor descriptor2 = callableMemberDescriptor;
        Iterable $this$mapNotNull$iv = this.getOverriddenDescriptors(descriptor2, false);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            KaCallableSymbol it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            CallableMemberDescriptor it = (CallableMemberDescriptor)element$iv$iv;
            boolean bl2 = false;
            if (Fe10DescUtilsKt.toKtCallableSymbol((CallableDescriptor)it, this.getAnalysisContext()) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.asSequence((Iterable)CollectionsKt.distinct((Iterable)((List)destination$iv$iv)));
    }

    private final Collection<CallableMemberDescriptor> getOverriddenDescriptors(CallableMemberDescriptor descriptor2, boolean collectAllOverrides) {
        ArrayDeque arrayDeque;
        LinkedHashSet<CallableMemberDescriptor> overriddenDescriptors = new LinkedHashSet<CallableMemberDescriptor>();
        ArrayDeque $this$getOverriddenDescriptors_u24lambda_u240 = arrayDeque = new ArrayDeque();
        boolean bl = false;
        Collection collection = descriptor2.getOverriddenDescriptors();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getOverriddenDescriptors(...)");
        $this$getOverriddenDescriptors_u24lambda_u240.addAll(collection);
        ArrayDeque queue = arrayDeque;
        while (!((Collection)queue).isEmpty()) {
            Collection overriddenDescriptorsForCurrent;
            CallableMemberDescriptor current = (CallableMemberDescriptor)queue.removeFirst();
            if (current.getKind() != CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
                overriddenDescriptors.add(current);
                if (!collectAllOverrides) continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)current.getOverriddenDescriptors(), (String)"getOverriddenDescriptors(...)");
            for (CallableMemberDescriptor overriddenDescriptor : overriddenDescriptorsForCurrent) {
                if (overriddenDescriptor.getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE) continue;
                overriddenDescriptors.add(overriddenDescriptor);
            }
            queue.addAll(overriddenDescriptorsForCurrent);
        }
        return overriddenDescriptors;
    }

    public final boolean isSubClassOf(@NotNull KaClassSymbol subClass, @NotNull KaClassSymbol superClass) {
        Intrinsics.checkNotNullParameter((Object)subClass, (String)"subClass");
        Intrinsics.checkNotNullParameter((Object)superClass, (String)"superClass");
        if (Intrinsics.areEqual((Object)subClass, (Object)superClass)) {
            return false;
        }
        DeclarationDescriptor declarationDescriptor = Fe10DescUtilsKt.getSymbolDescriptor(subClass);
        ClassDescriptor classDescriptor = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
        if (classDescriptor == null) {
            return false;
        }
        ClassDescriptor subClassDescriptor = classDescriptor;
        DeclarationDescriptor declarationDescriptor2 = Fe10DescUtilsKt.getSymbolDescriptor(superClass);
        ClassDescriptor classDescriptor2 = declarationDescriptor2 instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor2 : null;
        if (classDescriptor2 == null) {
            return false;
        }
        ClassDescriptor superClassDescriptor = classDescriptor2;
        return DescriptorUtilsKt.isSubclassOf((ClassDescriptor)subClassDescriptor, (ClassDescriptor)superClassDescriptor);
    }

    public final boolean isDirectSubClassOf(@NotNull KaClassSymbol subClass, @NotNull KaClassSymbol superClass) {
        Intrinsics.checkNotNullParameter((Object)subClass, (String)"subClass");
        Intrinsics.checkNotNullParameter((Object)superClass, (String)"superClass");
        DeclarationDescriptor declarationDescriptor = Fe10DescUtilsKt.getSymbolDescriptor(subClass);
        ClassDescriptor classDescriptor = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
        if (classDescriptor == null) {
            return false;
        }
        ClassDescriptor subClassDescriptor = classDescriptor;
        DeclarationDescriptor declarationDescriptor2 = Fe10DescUtilsKt.getSymbolDescriptor(superClass);
        ClassDescriptor classDescriptor2 = declarationDescriptor2 instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor2 : null;
        if (classDescriptor2 == null) {
            return false;
        }
        ClassDescriptor superClassDescriptor = classDescriptor2;
        return Intrinsics.areEqual((Object)DescriptorUtilsKt.getSuperClassOrAny((ClassDescriptor)subClassDescriptor), (Object)superClassDescriptor);
    }
}

