/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.evaluate;

import com.intellij.psi.PsiElement;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.UShort;
import kotlin.UnsignedKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.base.KaConstantValue;
import org.jetbrains.kotlin.analysis.api.impl.base.KaBooleanConstantValueImpl;
import org.jetbrains.kotlin.analysis.api.impl.base.KaByteConstantValueImpl;
import org.jetbrains.kotlin.analysis.api.impl.base.KaCharConstantValueImpl;
import org.jetbrains.kotlin.analysis.api.impl.base.KaDoubleConstantValueImpl;
import org.jetbrains.kotlin.analysis.api.impl.base.KaFloatConstantValueImpl;
import org.jetbrains.kotlin.analysis.api.impl.base.KaIntConstantValueImpl;
import org.jetbrains.kotlin.analysis.api.impl.base.KaLongConstantValueImpl;
import org.jetbrains.kotlin.analysis.api.impl.base.KaNullConstantValueImpl;
import org.jetbrains.kotlin.analysis.api.impl.base.KaShortConstantValueImpl;
import org.jetbrains.kotlin.analysis.api.impl.base.KaStringConstantValueImpl;
import org.jetbrains.kotlin.analysis.api.impl.base.KaUnsignedByteConstantValueImpl;
import org.jetbrains.kotlin.analysis.api.impl.base.KaUnsignedIntConstantValueImpl;
import org.jetbrains.kotlin.analysis.api.impl.base.KaUnsignedLongConstantValueImpl;
import org.jetbrains.kotlin.analysis.api.impl.base.KaUnsignedShortConstantValueImpl;
import org.jetbrains.kotlin.analysis.low.level.api.fir.util.ExceptionUtilsKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirEvaluatorResult;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionEvaluator;
import org.jetbrains.kotlin.fir.expressions.FirLiteralExpression;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.types.ConstantValueKind;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\t\u001a\u0004\u0018\u0001H\n\"\u0004\b\u0000\u0010\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u00072\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\n0\rH\u0082\b\u00a2\u0006\u0002\u0010\u000eJ\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0018\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\"\u0010\u0017\u001a\u0004\u0018\u00010\u0010*\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u001a\u001a\u0004\u0018\u00010\u0001*\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u0002RZ\u0010\u0004\u001aN\u0012 \u0012\u001e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007 \b*\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0018\u00010\u00060\u0006 \b*&\u0012 \u0012\u001e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007 \b*\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0018\u00010\u00060\u0006\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/evaluate/FirCompileTimeConstantEvaluator;", "", "<init>", "()V", "variablesInProcessOfEvaluation", "Ljava/lang/ThreadLocal;", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirVariableSymbol;", "kotlin.jvm.PlatformType", "withTrackingVariableEvaluation", "R", "variableSymbol", "f", "Lkotlin/Function0;", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirVariableSymbol;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "evaluate", "Lorg/jetbrains/kotlin/fir/expressions/FirLiteralExpression;", "fir", "Lorg/jetbrains/kotlin/fir/FirElement;", "firSession", "Lorg/jetbrains/kotlin/fir/FirSession;", "evaluateAsKtConstantValue", "Lorg/jetbrains/kotlin/analysis/api/base/KaConstantValue;", "evaluateRecursionAware", "expressionToEvaluate", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "adjustType", "Lorg/jetbrains/kotlin/types/ConstantValueKind;", "value", "analysis-api-fir"})
@SourceDebugExtension(value={"SMAP\nFirCompileTimeConstantEvaluator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirCompileTimeConstantEvaluator.kt\norg/jetbrains/kotlin/analysis/api/fir/evaluate/FirCompileTimeConstantEvaluator\n+ 2 FirAnnotationUtils.kt\norg/jetbrains/kotlin/fir/declarations/FirAnnotationUtilsKt\n*L\n1#1,171:1\n48#1,5:173\n54#1,2:179\n219#2:172\n219#2:178\n*S KotlinDebug\n*F\n+ 1 FirCompileTimeConstantEvaluator.kt\norg/jetbrains/kotlin/analysis/api/fir/evaluate/FirCompileTimeConstantEvaluator\n*L\n123#1:173,5\n123#1:179,2\n69#1:172\n124#1:178\n*E\n"})
public final class FirCompileTimeConstantEvaluator {
    @NotNull
    public static final FirCompileTimeConstantEvaluator INSTANCE = new FirCompileTimeConstantEvaluator();
    private static final ThreadLocal<Set<FirVariableSymbol<?>>> variablesInProcessOfEvaluation = ThreadLocal.withInitial(FirCompileTimeConstantEvaluator::variablesInProcessOfEvaluation$lambda$0);

    private FirCompileTimeConstantEvaluator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <R> R withTrackingVariableEvaluation(FirVariableSymbol<?> variableSymbol, Function0<? extends R> f) {
        Object object;
        boolean $i$f$withTrackingVariableEvaluation = false;
        if (!variablesInProcessOfEvaluation.get().add(variableSymbol)) {
            return null;
        }
        try {
            object = f.invoke();
        }
        finally {
            InlineMarker.finallyStart((int)1);
            variablesInProcessOfEvaluation.get().remove(variableSymbol);
            InlineMarker.finallyEnd((int)1);
        }
        return (R)object;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final FirLiteralExpression evaluate(@Nullable FirElement fir, @NotNull FirSession firSession) {
        FirLiteralExpression firLiteralExpression;
        Intrinsics.checkNotNullParameter((Object)((Object)firSession), (String)"firSession");
        FirElement firElement = fir;
        if (firElement instanceof FirPropertyAccessExpression) {
            FirVariableSymbol referredVariable = FirReferenceUtilsKt.toResolvedVariableSymbol$default(((FirPropertyAccessExpression)fir).getCalleeReference(), false, 1, null);
            firLiteralExpression = referredVariable instanceof FirPropertySymbol ? this.evaluateRecursionAware(referredVariable, (FirExpression)fir, firSession) : (referredVariable instanceof FirFieldSymbol ? this.evaluateRecursionAware(referredVariable, (FirExpression)fir, firSession) : null);
        } else if (firElement instanceof FirExpression) {
            void $this$evaluateAs$iv;
            FirExpression referredVariable = (FirExpression)fir;
            FirSession session$iv = firSession;
            boolean $i$f$evaluateAs = false;
            FirEvaluatorResult firEvaluatorResult = FirExpressionEvaluator.INSTANCE.evaluateExpression((FirExpression)$this$evaluateAs$iv, session$iv);
            FirElement firElement2 = firEvaluatorResult != null ? FirAnnotationUtilsKt.getResult(firEvaluatorResult) : null;
            if (!(firElement2 instanceof FirLiteralExpression)) {
                firElement2 = null;
            }
            firLiteralExpression = (FirLiteralExpression)((FirElement)((FirLiteralExpression)firElement2));
        } else {
            firLiteralExpression = null;
        }
        return firLiteralExpression;
    }

    @Nullable
    public final KaConstantValue evaluateAsKtConstantValue(@NotNull FirElement fir, @NotNull FirSession firSession) {
        KaConstantValue kaConstantValue;
        Intrinsics.checkNotNullParameter((Object)fir, (String)"fir");
        Intrinsics.checkNotNullParameter((Object)((Object)firSession), (String)"firSession");
        FirLiteralExpression firLiteralExpression = this.evaluate(fir, firSession);
        if (firLiteralExpression == null) {
            return null;
        }
        FirLiteralExpression evaluated = firLiteralExpression;
        ConstantValueKind kind2 = evaluated.getKind();
        Object value = this.adjustType(kind2, evaluated.getValue());
        PsiElement psiElement = UtilsKt.getPsi(evaluated);
        KtElement psi = psiElement instanceof KtElement ? (KtElement)psiElement : null;
        psiElement = evaluated.getKind();
        if (Intrinsics.areEqual((Object)psiElement, (Object)ConstantValueKind.Byte.INSTANCE)) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Byte");
            kaConstantValue = new KaByteConstantValueImpl((Byte)value, psi);
        } else if (Intrinsics.areEqual((Object)psiElement, (Object)ConstantValueKind.Int.INSTANCE)) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Int");
            kaConstantValue = new KaIntConstantValueImpl((Integer)value, psi);
        } else if (Intrinsics.areEqual((Object)psiElement, (Object)ConstantValueKind.Long.INSTANCE)) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Long");
            kaConstantValue = new KaLongConstantValueImpl((Long)value, psi);
        } else if (Intrinsics.areEqual((Object)psiElement, (Object)ConstantValueKind.Short.INSTANCE)) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Short");
            kaConstantValue = new KaShortConstantValueImpl((Short)value, psi);
        } else if (Intrinsics.areEqual((Object)psiElement, (Object)ConstantValueKind.UnsignedByte.INSTANCE)) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.UByte");
            kaConstantValue = new KaUnsignedByteConstantValueImpl(((UByte)value).unbox-impl(), psi, null);
        } else if (Intrinsics.areEqual((Object)psiElement, (Object)ConstantValueKind.UnsignedInt.INSTANCE)) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.UInt");
            kaConstantValue = new KaUnsignedIntConstantValueImpl(((UInt)value).unbox-impl(), psi, null);
        } else if (Intrinsics.areEqual((Object)psiElement, (Object)ConstantValueKind.UnsignedLong.INSTANCE)) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.ULong");
            kaConstantValue = new KaUnsignedLongConstantValueImpl(((ULong)value).unbox-impl(), psi, null);
        } else if (Intrinsics.areEqual((Object)psiElement, (Object)ConstantValueKind.UnsignedShort.INSTANCE)) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.UShort");
            kaConstantValue = new KaUnsignedShortConstantValueImpl(((UShort)value).unbox-impl(), psi, null);
        } else if (Intrinsics.areEqual((Object)psiElement, (Object)ConstantValueKind.Double.INSTANCE)) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Double");
            kaConstantValue = new KaDoubleConstantValueImpl((Double)value, psi);
        } else if (Intrinsics.areEqual((Object)psiElement, (Object)ConstantValueKind.Float.INSTANCE)) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Float");
            kaConstantValue = new KaFloatConstantValueImpl(((Float)value).floatValue(), psi);
        } else if (Intrinsics.areEqual((Object)psiElement, (Object)ConstantValueKind.Boolean.INSTANCE)) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Boolean");
            kaConstantValue = new KaBooleanConstantValueImpl((Boolean)value, psi);
        } else if (Intrinsics.areEqual((Object)psiElement, (Object)ConstantValueKind.Char.INSTANCE)) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Char");
            kaConstantValue = new KaCharConstantValueImpl(((Character)value).charValue(), psi);
        } else if (Intrinsics.areEqual((Object)psiElement, (Object)ConstantValueKind.String.INSTANCE)) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.String");
            kaConstantValue = new KaStringConstantValueImpl((String)value, psi);
        } else if (Intrinsics.areEqual((Object)psiElement, (Object)ConstantValueKind.Null.INSTANCE)) {
            kaConstantValue = new KaNullConstantValueImpl(psi);
        } else if (Intrinsics.areEqual((Object)psiElement, (Object)ConstantValueKind.IntegerLiteral.INSTANCE)) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Long");
            long l = (Long)value;
            kaConstantValue = (Integer.MIN_VALUE <= l ? l <= Integer.MAX_VALUE : false) ? (KaConstantValue)new KaIntConstantValueImpl((int)l, psi) : (KaConstantValue)new KaLongConstantValueImpl(l, psi);
        } else if (Intrinsics.areEqual((Object)psiElement, (Object)ConstantValueKind.UnsignedIntegerLiteral.INSTANCE)) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.ULong");
            long l = ((ULong)value).unbox-impl();
            kaConstantValue = (0 <= UnsignedKt.ulongCompare((long)l, (long)ULong.constructor-impl((long)(0L & 0xFFFFFFFFL))) ? UnsignedKt.ulongCompare((long)l, (long)ULong.constructor-impl((long)((long)-1 & 0xFFFFFFFFL))) <= 0 : false) ? (KaConstantValue)new KaUnsignedIntConstantValueImpl(UInt.constructor-impl((int)((int)l)), psi, null) : (KaConstantValue)new KaUnsignedLongConstantValueImpl(l, psi, null);
        } else {
            if (Intrinsics.areEqual((Object)psiElement, (Object)ConstantValueKind.Error.INSTANCE)) {
                ExceptionUtilsKt.errorWithFirSpecificEntries$default("Should not be possible to get from FIR tree", null, fir, null, null, null, 58, null);
                throw new KotlinNothingValueException();
            }
            throw new NoWhenBranchMatchedException();
        }
        return kaConstantValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final FirLiteralExpression evaluateRecursionAware(FirVariableSymbol<?> $this$evaluateRecursionAware, FirExpression expressionToEvaluate, FirSession firSession) {
        FirLiteralExpression firLiteralExpression;
        FirCompileTimeConstantEvaluator firCompileTimeConstantEvaluator = this;
        FirVariableSymbol<?> variableSymbol$iv = $this$evaluateRecursionAware;
        boolean $i$f$withTrackingVariableEvaluation = false;
        if (!variablesInProcessOfEvaluation.get().add(variableSymbol$iv)) {
            firLiteralExpression = null;
        } else {
            FirLiteralExpression firLiteralExpression2;
            try {
                void $this$evaluateAs$iv;
                boolean bl = false;
                FirExpression firExpression = expressionToEvaluate;
                FirSession session$iv = firSession;
                boolean $i$f$evaluateAs = false;
                FirEvaluatorResult firEvaluatorResult = FirExpressionEvaluator.INSTANCE.evaluateExpression((FirExpression)$this$evaluateAs$iv, session$iv);
                FirElement firElement = firEvaluatorResult != null ? FirAnnotationUtilsKt.getResult(firEvaluatorResult) : null;
                if (!(firElement instanceof FirLiteralExpression)) {
                    firElement = null;
                }
                firLiteralExpression2 = (FirLiteralExpression)((FirElement)((FirLiteralExpression)firElement));
            }
            finally {
                variablesInProcessOfEvaluation.get().remove(variableSymbol$iv);
            }
            firLiteralExpression = firLiteralExpression2;
        }
        return firLiteralExpression;
    }

    private final Object adjustType(ConstantValueKind $this$adjustType, Object value) {
        Comparable comparable;
        if (value == null) {
            return null;
        }
        ConstantValueKind constantValueKind = $this$adjustType;
        if (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.Boolean.INSTANCE)) {
            comparable = (Boolean)value;
        } else if (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.Char.INSTANCE)) {
            comparable = (Character)value;
        } else if (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.String.INSTANCE)) {
            comparable = (Comparable)((Object)((String)value));
        } else if (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.Byte.INSTANCE)) {
            comparable = ((Number)value).byteValue();
        } else if (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.Double.INSTANCE)) {
            comparable = ((Number)value).doubleValue();
        } else if (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.Float.INSTANCE)) {
            comparable = Float.valueOf(((Number)value).floatValue());
        } else if (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.Int.INSTANCE)) {
            comparable = ((Number)value).intValue();
        } else if (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.Long.INSTANCE)) {
            comparable = ((Number)value).longValue();
        } else if (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.Short.INSTANCE)) {
            comparable = ((Number)value).shortValue();
        } else if (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.UnsignedByte.INSTANCE)) {
            Object object = value;
            UByte uByte = object instanceof UByte ? (UByte)object : null;
            comparable = UByte.box-impl((byte)(uByte != null ? uByte.unbox-impl() : UByte.constructor-impl((byte)((byte)((Number)value).longValue()))));
        } else if (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.UnsignedShort.INSTANCE)) {
            Object object = value;
            UShort uShort = object instanceof UShort ? (UShort)object : null;
            comparable = UShort.box-impl((short)(uShort != null ? uShort.unbox-impl() : UShort.constructor-impl((short)((short)((Number)value).longValue()))));
        } else if (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.UnsignedInt.INSTANCE)) {
            Object object = value;
            UInt uInt = object instanceof UInt ? (UInt)object : null;
            comparable = UInt.box-impl((int)(uInt != null ? uInt.unbox-impl() : UInt.constructor-impl((int)((int)((Number)value).longValue()))));
        } else if (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.UnsignedLong.INSTANCE)) {
            Object object = value;
            ULong uLong = object instanceof ULong ? (ULong)object : null;
            comparable = ULong.box-impl((long)(uLong != null ? uLong.unbox-impl() : ULong.constructor-impl((long)((Number)value).longValue())));
        } else {
            Object object;
            Object object2;
            comparable = Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.UnsignedIntegerLiteral.INSTANCE) ? ULong.box-impl((long)((object2 = value) instanceof UInt ? ULong.constructor-impl((long)((long)((UInt)value).unbox-impl() & 0xFFFFFFFFL)) : (object2 instanceof ULong ? ((ULong)value).unbox-impl() : ULong.constructor-impl((long)((Number)value).longValue())))) : (Intrinsics.areEqual((Object)constantValueKind, (Object)ConstantValueKind.IntegerLiteral.INSTANCE) ? (Comparable)Long.valueOf((object = value) instanceof Integer ? (long)((Number)value).intValue() : (object instanceof Long ? ((Number)value).longValue() : ((Number)value).longValue())) : null);
        }
        return comparable;
    }

    private static final Set variablesInProcessOfEvaluation$lambda$0() {
        return new LinkedHashSet();
    }
}

