/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.impl.base.references;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.ContributedReferenceHost;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KotlinReferenceProvidersService;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.references.KotlinPsiReferenceProviderContributor;
import org.jetbrains.kotlin.utils.SmartList;
import org.jetbrains.kotlin.utils.exceptions.PlatformExceptionUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001b\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\rH\u0002\u00a2\u0006\u0002\u0010\u0019J\u001b\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u001b\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\u001cR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R5\u0010\b\u001a\u001c\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR.\u0010\u0012\u001a\"\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/analysis/api/impl/base/references/KotlinReferenceProvidersServiceImpl;", "Lorg/jetbrains/kotlin/psi/KotlinReferenceProvidersService;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "originalProvidersBinding", "Lcom/intellij/util/containers/MultiMap;", "Ljava/lang/Class;", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/references/KotlinPsiReferenceProviderContributor$ReferenceProvider;", "Lorg/jetbrains/kotlin/psi/KtElement;", "getOriginalProvidersBinding", "()Lcom/intellij/util/containers/MultiMap;", "originalProvidersBinding$delegate", "Lkotlin/Lazy;", "providersBindingCache", "", "", "doGetKotlinReferencesFromProviders", "", "Lcom/intellij/psi/PsiReference;", "context", "(Lorg/jetbrains/kotlin/psi/KtElement;)[Lcom/intellij/psi/PsiReference;", "getReferences", "psiElement", "(Lcom/intellij/psi/PsiElement;)[Lcom/intellij/psi/PsiReference;", "Companion", "analysis-api-impl-base"})
@SourceDebugExtension(value={"SMAP\nKotlinReferenceProvidersServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinReferenceProvidersServiceImpl.kt\norg/jetbrains/kotlin/analysis/api/impl/base/references/KotlinReferenceProvidersServiceImpl\n+ 2 smartCollectionsBuilder.kt\norg/jetbrains/kotlin/analysis/utils/collections/SmartCollectionsBuilderKt\n+ 3 KotlinReferenceProvidersServiceImpl.kt\norg/jetbrains/kotlin/analysis/api/impl/base/references/KotlinReferenceProvidersServiceImplKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 5 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 6 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 7 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,92:1\n11#2:93\n11#2:115\n85#3,6:94\n92#3:101\n85#3,6:106\n92#3:113\n15#4:100\n15#4:112\n207#5:102\n37#6,2:103\n1915#7:105\n1916#7:114\n*S KotlinDebug\n*F\n+ 1 KotlinReferenceProvidersServiceImpl.kt\norg/jetbrains/kotlin/analysis/api/impl/base/references/KotlinReferenceProvidersServiceImpl\n*L\n54#1:93\n41#1:115\n56#1:94,6\n56#1:101\n32#1:106,6\n32#1:113\n56#1:100\n32#1:112\n63#1:102\n63#1:103,2\n31#1:105\n31#1:114\n*E\n"})
public final class KotlinReferenceProvidersServiceImpl
extends KotlinReferenceProvidersService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Lazy originalProvidersBinding$delegate;
    @NotNull
    private final Map<Class<? extends PsiElement>, List<KotlinPsiReferenceProviderContributor.ReferenceProvider<KtElement>>> providersBindingCache;
    @NotNull
    private static final ExtensionPointName<KotlinPsiReferenceProviderContributor<? super KtElement>> EP_NAME = new ExtensionPointName("org.jetbrains.kotlin.psiReferenceProvider");

    public KotlinReferenceProvidersServiceImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.originalProvidersBinding$delegate = LazyKt.lazy(() -> KotlinReferenceProvidersServiceImpl.originalProvidersBinding_delegate$lambda$0(this));
        ConcurrentMap concurrentMap = ConcurrentFactoryMap.createMap(arg_0 -> KotlinReferenceProvidersServiceImpl.providersBindingCache$lambda$1(arg_0 -> KotlinReferenceProvidersServiceImpl.providersBindingCache$lambda$0(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createMap(...)");
        this.providersBindingCache = concurrentMap;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final MultiMap<Class<? extends PsiElement>, KotlinPsiReferenceProviderContributor.ReferenceProvider<KtElement>> getOriginalProvidersBinding() {
        Lazy lazy = this.originalProvidersBinding$delegate;
        return (MultiMap)lazy.getValue();
    }

    private final PsiReference[] doGetKotlinReferencesFromProviders(KtElement context2) {
        PsiReference[] psiReferenceArray;
        PsiReference[] psiReferenceArray2;
        List<KotlinPsiReferenceProviderContributor.ReferenceProvider<KtElement>> providers = this.providersBindingCache.get(context2.getClass());
        Collection collection = providers;
        if (collection == null || collection.isEmpty()) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return PsiReference.EMPTY_ARRAY;
        }
        boolean $i$f$buildSmartList = false;
        SmartList smartList = new SmartList();
        List $this$doGetKotlinReferencesFromProviders_u24lambda_u240 = (List)smartList;
        boolean bl = false;
        for (KotlinPsiReferenceProviderContributor.ReferenceProvider<KtElement> provider2 : providers) {
            boolean $i$f$runSafely = false;
            try {
                boolean bl2 = false;
                List references = (List)provider2.invoke((Object)context2);
                $this$doGetKotlinReferencesFromProviders_u24lambda_u240.addAll(references);
            }
            catch (Throwable e$iv) {
                PlatformExceptionUtilsKt.rethrowIntellijPlatformExceptionIfNeeded((Throwable)e$iv);
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(KotlinPsiReferenceProviderContributor.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error(e$iv);
            }
        }
        List result2 = (List)smartList;
        Collection $this$ifNotEmpty$iv = result2;
        boolean $i$f$ifNotEmpty = false;
        if (!$this$ifNotEmpty$iv.isEmpty()) {
            List $this$doGetKotlinReferencesFromProviders_u24lambda_u241 = (List)$this$ifNotEmpty$iv;
            boolean bl3 = false;
            Collection $this$toTypedArray$iv = $this$doGetKotlinReferencesFromProviders_u24lambda_u241;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            psiReferenceArray2 = thisCollection$iv.toArray(new PsiReference[0]);
        } else {
            psiReferenceArray2 = psiReferenceArray = null;
        }
        if (psiReferenceArray2 == null) {
            psiReferenceArray = PsiReference.EMPTY_ARRAY;
            Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
        }
        return psiReferenceArray;
    }

    @NotNull
    public PsiReference[] getReferences(@NotNull PsiElement psiElement) {
        PsiReference[] psiReferenceArray;
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        PsiElement psiElement2 = psiElement;
        if (psiElement2 instanceof ContributedReferenceHost) {
            PsiReference[] psiReferenceArray2 = ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)psiElement);
            psiReferenceArray = psiReferenceArray2;
            Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray2, (String)"getReferencesFromProviders(...)");
        } else if (!(psiElement2 instanceof KtElement)) {
            psiReferenceArray = PsiReference.EMPTY_ARRAY;
            Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
        } else {
            Object object = CachedValuesManager.getCachedValue((PsiElement)psiElement, () -> KotlinReferenceProvidersServiceImpl.getReferences$lambda$0(this, psiElement));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
            psiReferenceArray = (PsiReference[])object;
        }
        return psiReferenceArray;
    }

    private static final MultiMap originalProvidersBinding_delegate$lambda$0(KotlinReferenceProvidersServiceImpl this$0) {
        MultiMap multiMap;
        MultiMap $this$originalProvidersBinding_delegate_u24lambda_u240_u240 = multiMap = new MultiMap((Map)new LinkedHashMap());
        boolean bl = false;
        Iterable $this$forEach$iv = EP_NAME.getExtensionList((AreaInstance)this$0.project);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KotlinPsiReferenceProviderContributor contributor = (KotlinPsiReferenceProviderContributor)element$iv;
            boolean bl2 = false;
            boolean $i$f$runSafely = false;
            try {
                boolean bl3 = false;
                $this$originalProvidersBinding_delegate_u24lambda_u240_u240.putValue((Object)contributor.getElementClass(), (Object)contributor.getReferenceProvider());
            }
            catch (Throwable e$iv) {
                PlatformExceptionUtilsKt.rethrowIntellijPlatformExceptionIfNeeded((Throwable)e$iv);
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(KotlinPsiReferenceProviderContributor.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error(e$iv);
            }
        }
        return multiMap;
    }

    private static final List providersBindingCache$lambda$0(KotlinReferenceProvidersServiceImpl this$0, Class klass) {
        boolean $i$f$buildSmartList = false;
        SmartList smartList = new SmartList();
        List $this$providersBindingCache_u24lambda_u240_u240 = (List)smartList;
        boolean bl = false;
        for (Class bindingClass : this$0.getOriginalProvidersBinding().keySet()) {
            if (!bindingClass.isAssignableFrom(klass)) continue;
            Collection collection = this$0.getOriginalProvidersBinding().get((Object)bindingClass);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"get(...)");
            $this$providersBindingCache_u24lambda_u240_u240.addAll(collection);
        }
        return (List)smartList;
    }

    private static final List providersBindingCache$lambda$1(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final CachedValueProvider.Result getReferences$lambda$0(KotlinReferenceProvidersServiceImpl this$0, PsiElement $psiElement) {
        Object[] objectArray = new Object[]{PsiModificationTracker.MODIFICATION_COUNT};
        return CachedValueProvider.Result.create((Object)this$0.doGetKotlinReferencesFromProviders((KtElement)$psiElement), (Object[])objectArray);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0000\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/analysis/api/impl/base/references/KotlinReferenceProvidersServiceImpl$Companion;", "", "<init>", "()V", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lorg/jetbrains/kotlin/references/KotlinPsiReferenceProviderContributor;", "Lorg/jetbrains/kotlin/psi/KtElement;", "analysis-api-impl-base"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

