/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.util;

import java.util.List;
import java.util.Locale;
import jdk.jfr.EventType;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaImplementationDetail;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.FirDesignation;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.targets.LLFirResolveTarget;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.targets.LLPartialBodyAnalysisState;
import org.jetbrains.kotlin.analysis.low.level.api.fir.lazy.resolve.LLFirResolveDesignationCollector;
import org.jetbrains.kotlin.analysis.low.level.api.fir.util.LLFlightRecorderKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.util.LLPartialBodyAnalysisEvent;
import org.jetbrains.kotlin.analysis.low.level.api.fir.util.LLPhaseEvent;
import org.jetbrains.kotlin.analysis.low.level.api.fir.util.LLPhaseEventCompleter;
import org.jetbrains.kotlin.analysis.low.level.api.fir.util.LLPhaseSuspensionEvent;
import org.jetbrains.kotlin.analysis.low.level.api.fir.util.LLPhaseSuspensionEventCompleter;
import org.jetbrains.kotlin.analysis.low.level.api.fir.util.LLPhaseWithTraceEvent;
import org.jetbrains.kotlin.analysis.low.level.api.fir.util.LLReadyPhaseEvent;
import org.jetbrains.kotlin.analysis.low.level.api.fir.util.LLStopWorldInvalidation;
import org.jetbrains.kotlin.fir.FirElementWithResolveState;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousInitializer;
import org.jetbrains.kotlin.fir.declarations.FirBackingField;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirCodeFragment;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDanglingModifierList;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirReceiverParameter;
import org.jetbrains.kotlin.fir.declarations.FirReplSnippet;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirScript;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirValueParameterKind;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;

@KaImplementationDetail
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b\u0017J\u001d\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b\u001eJ\u001d\u0010 \u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b!J+\u0010 \u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b!J\u001f\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b%J\u0006\u0010'\u001a\u00020\u001aJ\u0006\u0010(\u001a\u00020\u001aJ\u0010\u0010)\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020\u0005H\u0002J\u0010\u0010+\u001a\u00020,2\u0006\u0010\u001b\u001a\u00020\u0011H\u0002J\u0010\u0010-\u001a\u00020,2\u0006\u0010\u001b\u001a\u00020.H\u0002J\u001e\u0010/\u001a\u00020,2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001f\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\"\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010&\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/util/LLFlightRecorder;", "", "<init>", "()V", "includePhaseTraces", "", "getIncludePhaseTraces", "()Z", "includePhaseTraces$delegate", "Lkotlin/Lazy;", "phaseEventType", "Ljdk/jfr/EventType;", "kotlin.jvm.PlatformType", "phaseWithTraceEventType", "phase", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/util/LLPhaseEventCompleter;", "target", "Lorg/jetbrains/kotlin/fir/FirElementWithResolveState;", "containingDeclarations", "", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "requestedPhase", "Lorg/jetbrains/kotlin/fir/declarations/FirResolvePhase;", "phase$low_level_api_fir", "partialBodyAnalysisEventType", "partialBodyAnalyzed", "", "declaration", "state", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/api/targets/LLPartialBodyAnalysisState;", "partialBodyAnalyzed$low_level_api_fir", "readyPhaseEventType", "readyPhase", "readyPhase$low_level_api_fir", "phaseSuspensionEventType", "phaseSuspension", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/util/LLPhaseSuspensionEventCompleter;", "phaseSuspension$low_level_api_fir", "stopWorldInvalidationEventType", "stopWorldSessionInvalidationScheduled", "stopWorldSessionInvalidationComplete", "stopWorldSessionInvalidation", "newState", "name", "", "signature", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "path", "low-level-api-fir"})
public final class LLFlightRecorder {
    @NotNull
    public static final LLFlightRecorder INSTANCE = new LLFlightRecorder();
    @NotNull
    private static final Lazy includePhaseTraces$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, LLFlightRecorder::includePhaseTraces_delegate$lambda$0);
    private static final EventType phaseEventType = EventType.getEventType(LLPhaseEvent.class);
    private static final EventType phaseWithTraceEventType = EventType.getEventType(LLPhaseWithTraceEvent.class);
    private static final EventType partialBodyAnalysisEventType = EventType.getEventType(LLPartialBodyAnalysisEvent.class);
    private static final EventType readyPhaseEventType = EventType.getEventType(LLReadyPhaseEvent.class);
    private static final EventType phaseSuspensionEventType = EventType.getEventType(LLPhaseSuspensionEvent.class);
    private static final EventType stopWorldInvalidationEventType = EventType.getEventType(LLStopWorldInvalidation.class);

    private LLFlightRecorder() {
    }

    private final boolean getIncludePhaseTraces() {
        Lazy lazy = includePhaseTraces$delegate;
        return (Boolean)lazy.getValue();
    }

    @Nullable
    public final LLPhaseEventCompleter phase$low_level_api_fir(@NotNull FirElementWithResolveState target, @NotNull List<? extends FirDeclaration> containingDeclarations, @NotNull FirResolvePhase requestedPhase) {
        LLPhaseEvent lLPhaseEvent;
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter(containingDeclarations, (String)"containingDeclarations");
        Intrinsics.checkNotNullParameter((Object)((Object)requestedPhase), (String)"requestedPhase");
        if (this.getIncludePhaseTraces()) {
            LLPhaseWithTraceEvent lLPhaseWithTraceEvent;
            if (!phaseWithTraceEventType.isEnabled()) {
                return null;
            }
            LLPhaseWithTraceEvent $this$phase_u24lambda_u240 = lLPhaseWithTraceEvent = new LLPhaseWithTraceEvent(this.path(containingDeclarations, target), System.identityHashCode(target), LLFlightRecorderKt.access$getPHASE_COMPACT_NAMES$p()[requestedPhase.ordinal()], LLFlightRecorderKt.access$computeModuleKind(target));
            boolean bl = false;
            $this$phase_u24lambda_u240.begin();
            return lLPhaseWithTraceEvent;
        }
        if (!phaseEventType.isEnabled()) {
            return null;
        }
        LLPhaseEvent $this$phase_u24lambda_u241 = lLPhaseEvent = new LLPhaseEvent(this.path(containingDeclarations, target), System.identityHashCode(target), LLFlightRecorderKt.access$getPHASE_COMPACT_NAMES$p()[requestedPhase.ordinal()], LLFlightRecorderKt.access$computeModuleKind(target));
        boolean bl = false;
        $this$phase_u24lambda_u241.begin();
        return lLPhaseEvent;
    }

    public final void partialBodyAnalyzed$low_level_api_fir(@NotNull FirElementWithResolveState declaration, @NotNull LLPartialBodyAnalysisState state) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (!partialBodyAnalysisEventType.isEnabled()) {
            return;
        }
        new LLPartialBodyAnalysisEvent(System.identityHashCode(declaration), state.getAnalyzedPsiStatementCount(), state.getPerformedAnalysesCount()).commit();
    }

    public final void readyPhase$low_level_api_fir(@NotNull FirElementWithResolveState target, @NotNull FirResolvePhase requestedPhase) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)((Object)requestedPhase), (String)"requestedPhase");
        if (!readyPhaseEventType.isEnabled()) {
            return;
        }
        Object object = LLFirResolveDesignationCollector.INSTANCE.getDesignationToResolve(target);
        if (object == null || (object = ((LLFirResolveTarget)object).getDesignation()) == null) {
            return;
        }
        Object designation = object;
        String string = this.path(((FirDesignation)designation).getPath(), target);
        int n = System.identityHashCode(target);
        byte by = LLFlightRecorderKt.access$getPHASE_COMPACT_NAMES$p()[requestedPhase.ordinal()];
        byte by2 = LLFlightRecorderKt.access$computeModuleKind(target);
        new LLReadyPhaseEvent(string, n, by2, by).commit();
    }

    public final void readyPhase$low_level_api_fir(@NotNull FirElementWithResolveState target, @NotNull List<? extends FirDeclaration> containingDeclarations, @NotNull FirResolvePhase requestedPhase) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter(containingDeclarations, (String)"containingDeclarations");
        Intrinsics.checkNotNullParameter((Object)((Object)requestedPhase), (String)"requestedPhase");
        if (!readyPhaseEventType.isEnabled()) {
            return;
        }
        String string = this.path(containingDeclarations, target);
        int n = System.identityHashCode(target);
        byte by = LLFlightRecorderKt.access$getPHASE_COMPACT_NAMES$p()[requestedPhase.ordinal()];
        byte by2 = LLFlightRecorderKt.access$computeModuleKind(target);
        new LLReadyPhaseEvent(string, n, by2, by).commit();
    }

    @Nullable
    public final LLPhaseSuspensionEventCompleter phaseSuspension$low_level_api_fir(@NotNull FirElementWithResolveState declaration, @NotNull FirResolvePhase requestedPhase) {
        LLPhaseSuspensionEvent lLPhaseSuspensionEvent;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)((Object)requestedPhase), (String)"requestedPhase");
        if (!phaseSuspensionEventType.isEnabled()) {
            return null;
        }
        LLPhaseSuspensionEvent $this$phaseSuspension_u24lambda_u240 = lLPhaseSuspensionEvent = new LLPhaseSuspensionEvent(System.identityHashCode(declaration), LLFlightRecorderKt.access$getPHASE_COMPACT_NAMES$p()[requestedPhase.ordinal()]);
        boolean bl = false;
        $this$phaseSuspension_u24lambda_u240.begin();
        return lLPhaseSuspensionEvent;
    }

    public final void stopWorldSessionInvalidationScheduled() {
        this.stopWorldSessionInvalidation(true);
    }

    public final void stopWorldSessionInvalidationComplete() {
        this.stopWorldSessionInvalidation(false);
    }

    private final void stopWorldSessionInvalidation(boolean newState) {
        if (!stopWorldInvalidationEventType.isEnabled()) {
            return;
        }
        new LLStopWorldInvalidation(newState).commit();
    }

    private final String name(FirElementWithResolveState declaration) {
        String string;
        FirElementWithResolveState firElementWithResolveState = declaration;
        if (firElementWithResolveState instanceof FirFile) {
            string = "fl/" + ((FirFile)declaration).getName();
        } else if (firElementWithResolveState instanceof FirScript) {
            string = "s/" + ((FirScript)declaration).getName().asString();
        } else if (firElementWithResolveState instanceof FirTypeParameter) {
            string = "tp/" + ((FirTypeParameter)declaration).getName().asString();
        } else if (firElementWithResolveState instanceof FirTypeAlias) {
            string = "ta/" + FirDeclarationUtilKt.getClassId((FirClassLikeDeclaration)declaration).asString();
        } else if (firElementWithResolveState instanceof FirClass) {
            string = "c/" + FirDeclarationUtilKt.getClassId((FirClassLikeDeclaration)declaration).asString();
        } else if (firElementWithResolveState instanceof FirEnumEntry) {
            string = "ee/" + ((FirEnumEntry)declaration).getName().asString();
        } else if (firElementWithResolveState instanceof FirField) {
            string = "fi/" + ((FirField)declaration).getName().asString();
        } else if (firElementWithResolveState instanceof FirProperty) {
            string = "p/" + ((FirProperty)declaration).getName().asString();
        } else if (firElementWithResolveState instanceof FirBackingField) {
            string = "bf/" + ((FirBackingField)declaration).getName().asString();
        } else if (firElementWithResolveState instanceof FirValueParameter) {
            String kind2 = ((FirValueParameter)declaration).getValueParameterKind() == FirValueParameterKind.Regular ? "vp/" : "cp/";
            string = kind2 + ((FirValueParameter)declaration).getName().asString();
        } else if (firElementWithResolveState instanceof FirVariable) {
            StringBuilder stringBuilder = new StringBuilder().append("v/").append(((FirVariable)declaration).getName().asString()).append('/');
            String string2 = declaration.getClass().getSimpleName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getSimpleName(...)");
            String string3 = string2.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            string = stringBuilder.append(string3).toString();
        } else if (firElementWithResolveState instanceof FirPropertyAccessor) {
            string = (((FirPropertyAccessor)declaration).isGetter() ? "pg/" : "ps/") + ((FirPropertyAccessor)declaration).getPropertySymbol().getName().asString();
        } else if (firElementWithResolveState instanceof FirConstructor) {
            string = "ctor/" + this.signature((FirFunction)declaration);
        } else if (firElementWithResolveState instanceof FirAnonymousFunction) {
            string = "lambda";
        } else if (firElementWithResolveState instanceof FirFunction) {
            String baseName = "f/" + FirDeclarationUtilKt.getNameOrSpecialName((FirMemberDeclaration)declaration).asString();
            string = baseName + '/' + this.signature((FirFunction)declaration);
        } else {
            string = firElementWithResolveState instanceof FirReplSnippet ? "repl" : (firElementWithResolveState instanceof FirCodeFragment ? "code" : (firElementWithResolveState instanceof FirReceiverParameter ? "recv" : (firElementWithResolveState instanceof FirDanglingModifierList ? "dml" : (firElementWithResolveState instanceof FirAnonymousInitializer ? "init" : "?/" + declaration.getClass().getSimpleName()))));
        }
        return string;
    }

    private final String signature(FirFunction declaration) {
        return CollectionsKt.joinToString$default((Iterable)declaration.getValueParameters(), (CharSequence)",", null, null, (int)0, null, LLFlightRecorder::signature$lambda$0, (int)30, null);
    }

    private final String path(List<? extends FirDeclaration> containingDeclarations, FirElementWithResolveState target) {
        StringBuilder stringBuilder;
        StringBuilder $this$path_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        for (FirDeclaration firDeclaration : containingDeclarations) {
            $this$path_u24lambda_u240.append(INSTANCE.name(firDeclaration));
            $this$path_u24lambda_u240.append(":");
        }
        $this$path_u24lambda_u240.append(INSTANCE.name(target));
        return stringBuilder.toString();
    }

    private static final boolean includePhaseTraces_delegate$lambda$0() {
        return Intrinsics.areEqual((Object)System.getProperty("kotlin.analysis.jfr.includePhaseTraces"), (Object)"true") || Intrinsics.areEqual((Object)System.getenv("KOTLIN_ANALYSIS_JFR_INCLUDE_PHASE_TRACES"), (Object)"true");
    }

    private static final CharSequence signature$lambda$0(FirValueParameter it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        return string;
    }
}

