/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.base.fe10.analysis.decompiler.konan;

import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.decompiler.konan.KlibLoadingMetadataCache;
import org.jetbrains.kotlin.konan.file.File;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.library.components.KlibMetadataComponentLayout;
import org.jetbrains.kotlin.library.metadata.CustomMetadataProtoLoader;
import org.jetbrains.kotlin.library.metadata.KlibMetadataProtoBuf;
import org.jetbrains.kotlin.metadata.ProtoBuf;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016J\"\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012H\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0015\u001a\u00020\u0012H\u0002J\u0014\u0010\u001c\u001a\u00020\u001d*\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u0014\u0010\u0017\u001a\u00020\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0018\u0010\u000f\u001a\u00020\u0010*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u001bR\u000e\u0010\u001e\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/base/fe10/analysis/decompiler/konan/CachingIdeKlibMetadataLoader;", "Lorg/jetbrains/kotlin/library/metadata/CustomMetadataProtoLoader;", "<init>", "()V", "loadModuleHeader", "Lorg/jetbrains/kotlin/library/metadata/KlibMetadataProtoBuf$Header;", "library", "Lorg/jetbrains/kotlin/library/KotlinLibrary;", "loadPackageFragment", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$PackageFragment;", "packageFqName", "", "partName", "getVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "isZipped", "", "file", "Lorg/jetbrains/kotlin/konan/file/File;", "asJarFileSystemFile", "jarFile", "localFile", "asLocalFile", "cache", "Lorg/jetbrains/kotlin/analysis/decompiler/konan/KlibLoadingMetadataCache;", "getCache", "()Lorg/jetbrains/kotlin/analysis/decompiler/konan/KlibLoadingMetadataCache;", "(Lorg/jetbrains/kotlin/library/KotlinLibrary;)Z", "metadataLayout", "Lorg/jetbrains/kotlin/library/components/KlibMetadataComponentLayout;", "ZIPPED_KLIB_METADATA_LAYOUT", "kotlin.base.fe10.analysis"})
@SourceDebugExtension(value={"SMAP\nCachingIdeKlibMetadataLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CachingIdeKlibMetadataLoader.kt\norg/jetbrains/kotlin/base/fe10/analysis/decompiler/konan/CachingIdeKlibMetadataLoader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,53:1\n1#2:54\n*E\n"})
public final class CachingIdeKlibMetadataLoader
implements CustomMetadataProtoLoader {
    @NotNull
    public static final CachingIdeKlibMetadataLoader INSTANCE = new CachingIdeKlibMetadataLoader();
    @NotNull
    private static final KlibMetadataComponentLayout ZIPPED_KLIB_METADATA_LAYOUT = new KlibMetadataComponentLayout(new File("/"));

    private CachingIdeKlibMetadataLoader() {
    }

    @NotNull
    public KlibMetadataProtoBuf.Header loadModuleHeader(@NotNull KotlinLibrary library) {
        VirtualFile virtualFile;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)library, (String)"library");
                boolean isZipped = this.isZipped(library);
                File moduleHeaderFile = this.metadataLayout(library, isZipped).getModuleHeaderFile();
                VirtualFile virtualFile2 = this.getVirtualFile(isZipped, library, moduleHeaderFile);
                virtualFile = virtualFile2;
                if (virtualFile == null) break block2;
                VirtualFile it = virtualFile;
                boolean bl = false;
                KlibMetadataProtoBuf.Header header = INSTANCE.getCache().getCachedModuleHeader(virtualFile2);
                virtualFile = header;
                if (header != null) break block3;
            }
            KlibMetadataProtoBuf.Header header = KlibMetadataProtoBuf.Header.getDefaultInstance();
            virtualFile = header;
            Intrinsics.checkNotNullExpressionValue((Object)header, (String)"getDefaultInstance(...)");
        }
        return virtualFile;
    }

    @NotNull
    public ProtoBuf.PackageFragment loadPackageFragment(@NotNull KotlinLibrary library, @NotNull String packageFqName, @NotNull String partName) {
        VirtualFile virtualFile;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)library, (String)"library");
                Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
                Intrinsics.checkNotNullParameter((Object)partName, (String)"partName");
                boolean isZipped = this.isZipped(library);
                File packageFragmentFile = this.metadataLayout(library, isZipped).getPackageFragmentFile(packageFqName, partName);
                VirtualFile virtualFile2 = this.getVirtualFile(isZipped, library, packageFragmentFile);
                virtualFile = virtualFile2;
                if (virtualFile == null) break block2;
                VirtualFile it = virtualFile;
                boolean bl = false;
                ProtoBuf.PackageFragment packageFragment2 = INSTANCE.getCache().getCachedPackageFragment(virtualFile2);
                virtualFile = packageFragment2;
                if (packageFragment2 != null) break block3;
            }
            ProtoBuf.PackageFragment packageFragment3 = ProtoBuf.PackageFragment.getDefaultInstance();
            virtualFile = packageFragment3;
            Intrinsics.checkNotNullExpressionValue((Object)packageFragment3, (String)"getDefaultInstance(...)");
        }
        return virtualFile;
    }

    private final VirtualFile getVirtualFile(boolean isZipped, KotlinLibrary library, File file) {
        return isZipped ? this.asJarFileSystemFile(library.getLibraryFile(), file) : this.asLocalFile(file);
    }

    private final VirtualFile asJarFileSystemFile(File jarFile, File localFile) {
        String fullPath = jarFile.getAbsolutePath() + "!" + PathUtil.toSystemIndependentName((String)localFile.getPath());
        return StandardFileSystems.jar().findFileByPath(fullPath);
    }

    private final VirtualFile asLocalFile(File localFile) {
        String fullPath = localFile.getAbsolutePath();
        return StandardFileSystems.local().findFileByPath(fullPath);
    }

    private final KlibLoadingMetadataCache getCache() {
        return KlibLoadingMetadataCache.Companion.getInstance();
    }

    private final boolean isZipped(KotlinLibrary $this$isZipped) {
        return $this$isZipped.getLocation().isFile();
    }

    private final KlibMetadataComponentLayout metadataLayout(KotlinLibrary $this$metadataLayout, boolean isZipped) {
        return isZipped ? ZIPPED_KLIB_METADATA_LAYOUT : new KlibMetadataComponentLayout($this$metadataLayout.getLocation());
    }
}

