/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.console;

import com.intellij.execution.Executor;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.task.ProjectTaskManager;
import com.intellij.task.impl.ProjectTaskManagerImpl;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.console.KotlinConsoleKeeper;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/console/ConsoleCompilerHelper;", "", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/openapi/module/Module;", "executor", "Lcom/intellij/execution/Executor;", "contentDescriptor", "Lcom/intellij/execution/ui/RunContentDescriptor;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/module/Module;Lcom/intellij/execution/Executor;Lcom/intellij/execution/ui/RunContentDescriptor;)V", "moduleIsUpToDate", "", "compileModule", "", "kotlin.repl"})
public final class ConsoleCompilerHelper {
    @NotNull
    private final Project project;
    @NotNull
    private final Module module;
    @NotNull
    private final Executor executor;
    @NotNull
    private final RunContentDescriptor contentDescriptor;

    public ConsoleCompilerHelper(@NotNull Project project, @NotNull Module module, @NotNull Executor executor, @NotNull RunContentDescriptor contentDescriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)contentDescriptor, (String)"contentDescriptor");
        this.project = project;
        this.module = module;
        this.executor = executor;
        this.contentDescriptor = contentDescriptor;
    }

    public final boolean moduleIsUpToDate() {
        CompilerManager compilerManager = CompilerManager.getInstance((Project)this.project);
        CompileScope compileScope = compilerManager.createModuleCompileScope(this.module, true);
        Intrinsics.checkNotNullExpressionValue((Object)compileScope, (String)"createModuleCompileScope(...)");
        CompileScope compilerScope = compileScope;
        return compilerManager.isUpToDate(compilerScope);
    }

    public final void compileModule() {
        if (RunContentManager.getInstance((Project)this.project).removeRunContent(this.executor, this.contentDescriptor)) {
            ProjectTaskManagerImpl.putBuildOriginator((Project)this.project, this.getClass());
            Module[] moduleArray = new Module[]{this.module};
            ProjectTaskManager.getInstance((Project)this.project).build(moduleArray).onSuccess(arg_0 -> ConsoleCompilerHelper.compileModule$lambda$1(arg_0 -> ConsoleCompilerHelper.compileModule$lambda$0(this, arg_0), arg_0));
        }
    }

    private static final Unit compileModule$lambda$0(ConsoleCompilerHelper this$0, ProjectTaskManager.Result it) {
        if (!this$0.module.isDisposed()) {
            KotlinConsoleKeeper.Companion.getInstance(this$0.project).run(this$0.module, it.hasErrors());
        }
        return Unit.INSTANCE;
    }

    private static final void compileModule$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

