/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.console.actions;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KotlinIdeaReplBundle;
import org.jetbrains.kotlin.console.KotlinConsoleKeeper;
import org.jetbrains.kotlin.console.actions.ConsoleModuleDialog;
import org.jetbrains.kotlin.console.actions.RunExecuteActionsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000-\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0004*\u0001\u000f\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000bH\u0002J\u0015\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/console/actions/ConsoleModuleDialog;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "showIfNeeded", "", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "getModule", "Lcom/intellij/openapi/module/Module;", "runConsole", "module", "createRunAction", "org/jetbrains/kotlin/console/actions/ConsoleModuleDialog$createRunAction$1", "(Lcom/intellij/openapi/module/Module;)Lorg/jetbrains/kotlin/console/actions/ConsoleModuleDialog$createRunAction$1;", "Companion", "kotlin.repl"})
@SourceDebugExtension(value={"SMAP\nConsoleModuleDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConsoleModuleDialog.kt\norg/jetbrains/kotlin/console/actions/ConsoleModuleDialog\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,66:1\n6624#2:67\n1586#3:68\n1661#3,3:69\n*S KotlinDebug\n*F\n+ 1 ConsoleModuleDialog.kt\norg/jetbrains/kotlin/console/actions/ConsoleModuleDialog\n*L\n27#1:67\n27#1:68\n27#1:69,3\n*E\n"})
public final class ConsoleModuleDialog {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;

    public ConsoleModuleDialog(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    /*
     * WARNING - void declaration
     */
    public final void showIfNeeded(@NotNull DataContext dataContext) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Module module;
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Module module2 = module = this.getModule(dataContext);
        if (module2 != null) {
            this.runConsole(module2);
            return;
        }
        Object[] modules2 = ModuleManager.Companion.getInstance(this.project).getModules();
        if (modules2.length == 0) {
            RunExecuteActionsKt.errorNotification(this.project, KotlinIdeaReplBundle.message("no.modules.were.found", new Object[0]));
            return;
        }
        if (modules2.length == 1) {
            this.runConsole((Module)ArraysKt.first((Object[])modules2));
            return;
        }
        Object $this$sortedBy$iv = modules2;
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = ArraysKt.sortedWith((Object[])$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Module it = (Module)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (Module)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
            }
        });
        boolean $i$f$map = false;
        void var7_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Module module3 = (Module)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.createRunAction((Module)it));
        }
        List moduleActions = (List)destination$iv$iv;
        DefaultActionGroup moduleGroup = new DefaultActionGroup(moduleActions);
        ListPopup listPopup = JBPopupFactory.getInstance().createActionGroupPopup(ConsoleModuleDialog.Companion.getTITLE(), (ActionGroup)moduleGroup, dataContext, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true, "EditorPopup");
        Intrinsics.checkNotNullExpressionValue((Object)listPopup, (String)"createActionGroupPopup(...)");
        ListPopup modulePopup = listPopup;
        modulePopup.showCenteredInCurrentWindow(this.project);
    }

    private final Module getModule(DataContext dataContext) {
        VirtualFile virtualFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile file = virtualFile;
        Module moduleForFile = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)this.project);
        if (moduleForFile != null) {
            return moduleForFile;
        }
        return null;
    }

    private final void runConsole(Module module) {
        Project project = this.project;
        String string = KotlinIdeaReplBundle.message("progress.starting.repl", new Object[0]);
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(module, project, string){
            final /* synthetic */ Module $module;
            {
                this.$module = $module;
                super($super_call_param$1, $super_call_param$2);
            }

            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                Project project = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                KotlinConsoleKeeper.run$default(KotlinConsoleKeeper.Companion.getInstance(project), this.$module, false, 2, null);
            }
        });
    }

    private final createRunAction.1 createRunAction(Module module) {
        String string = module.getName();
        return new AnAction(this, module, string){
            final /* synthetic */ ConsoleModuleDialog this$0;
            final /* synthetic */ Module $module;
            {
                this.this$0 = $receiver;
                this.$module = $module;
                super($super_call_param$1);
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                ConsoleModuleDialog.access$runConsole(this.this$0, this.$module);
            }
        };
    }

    public static final /* synthetic */ void access$runConsole(ConsoleModuleDialog $this, Module module) {
        $this.runConsole(module);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/console/actions/ConsoleModuleDialog$Companion;", "", "<init>", "()V", "TITLE", "", "getTITLE", "()Ljava/lang/String;", "kotlin.repl"})
    public static final class Companion {
        private Companion() {
        }

        private final String getTITLE() {
            return KotlinIdeaReplBundle.message("choose.context.module", new Object[0]);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

