/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.config;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.diagnostics.KtSourcelessDiagnosticFactory;
import org.jetbrains.kotlin.fir.analysis.checkers.config.FirLanguageVersionSettingsChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.diagnostics.CliFrontendDiagnostics;
import org.jetbrains.kotlin.fir.declarations.DeprecationsPerUseSite;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirDeprecationInfo;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.resolve.transformers.ImportUtilsKt;
import org.jetbrains.kotlin.fir.resolve.transformers.PackageResolutionResult;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.checkers.OptInNames;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationLevelValue;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J!\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0016R\u00020\u0006j\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\nJ)\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0002R\u00020\u0006j\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/config/FirOptInLanguageVersionSettingsChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/config/FirLanguageVersionSettingsChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;)V", "checkOptInMarkerArgument", "fqNameAsString", "", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Ljava/lang/String;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;)V", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirOptInLanguageVersionSettingsChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirOptInLanguageVersionSettingsChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/config/FirOptInLanguageVersionSettingsChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,66:1\n1915#2,2:67\n1#3:69\n*S KotlinDebug\n*F\n+ 1 FirOptInLanguageVersionSettingsChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/config/FirOptInLanguageVersionSettingsChecker\n*L\n24#1:67,2\n*E\n"})
public final class FirOptInLanguageVersionSettingsChecker
extends FirLanguageVersionSettingsChecker {
    @NotNull
    public static final FirOptInLanguageVersionSettingsChecker INSTANCE = new FirOptInLanguageVersionSettingsChecker();

    private FirOptInLanguageVersionSettingsChecker() {
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Iterable $this$forEach$iv = (Iterable)context2.getLanguageVersionSettings().getFlag(AnalysisFlags.getOptIn());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String fqNameAsString = (String)element$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)fqNameAsString, (Object)OptInNames.INSTANCE.getREQUIRES_OPT_IN_FQ_NAME().asString())) continue;
            INSTANCE.checkOptInMarkerArgument(context2, fqNameAsString, reporter);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkOptInMarkerArgument(CheckerContext context2, String fqNameAsString, DiagnosticReporter reporter) {
        String string;
        String string2;
        FirClassLikeSymbol<?> symbol;
        PackageResolutionResult packageOrClass = ImportUtilsKt.resolveToPackageOrClass(FirSymbolProviderKt.getSymbolProvider(context2.getSession()), new FqName(fqNameAsString));
        PackageResolutionResult.PackageOrClass packageOrClass2 = packageOrClass instanceof PackageResolutionResult.PackageOrClass ? (PackageResolutionResult.PackageOrClass)packageOrClass : null;
        FirClassLikeSymbol<Object> firClassLikeSymbol = symbol = packageOrClass2 != null ? packageOrClass2.getClassSymbol() : null;
        if (symbol == null) {
            KtDiagnosticReportHelpersKt.report$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (KtSourcelessDiagnosticFactory)CliFrontendDiagnostics.INSTANCE.getOPT_IN_REQUIREMENT_MARKER_IS_UNRESOLVED(), (String)("Opt-in requirement marker '" + fqNameAsString + "' is unresolved. Make sure it's present in the module dependencies."), null, (int)8, null);
            return;
        }
        if (!FirAnnotationUtilsKt.hasAnnotationWithClassId((FirBasedSymbol)symbol, OptInNames.INSTANCE.getREQUIRES_OPT_IN_CLASS_ID(), context2.getSession())) {
            KtDiagnosticReportHelpersKt.report$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (KtSourcelessDiagnosticFactory)CliFrontendDiagnostics.INSTANCE.getNOT_AN_OPT_IN_REQUIREMENT_MARKER(), (String)("Class '" + fqNameAsString + "' is not an opt-in requirement marker."), null, (int)8, null);
            return;
        }
        Object object = symbol.getOwnDeprecation(context2.getLanguageVersionSettings());
        if (object == null || (object = ((DeprecationsPerUseSite)object).getAll()) == null) {
            return;
        }
        Object deprecationInfo2 = object;
        KtSourcelessDiagnosticFactory diagnosticFactory = WhenMappings.$EnumSwitchMapping$0[((FirDeprecationInfo)deprecationInfo2).getDeprecationLevel().ordinal()] == 1 ? CliFrontendDiagnostics.INSTANCE.getOPT_IN_REQUIREMENT_MARKER_IS_DEPRECATED() : CliFrontendDiagnostics.INSTANCE.getOPT_IN_REQUIREMENT_MARKER_IS_DEPRECATED_ERROR();
        DiagnosticContext diagnosticContext = context2;
        DiagnosticReporter diagnosticReporter = reporter;
        KtSourcelessDiagnosticFactory ktSourcelessDiagnosticFactory = diagnosticFactory;
        StringBuilder stringBuilder = new StringBuilder().append("Opt-in requirement marker '").append(fqNameAsString).append("' is deprecated");
        String string3 = ((FirDeprecationInfo)deprecationInfo2).getMessage(context2.getSession());
        if (string3 != null) {
            void it;
            String string4 = string3;
            StringBuilder stringBuilder2 = stringBuilder;
            KtSourcelessDiagnosticFactory ktSourcelessDiagnosticFactory2 = ktSourcelessDiagnosticFactory;
            DiagnosticReporter diagnosticReporter2 = diagnosticReporter;
            DiagnosticContext diagnosticContext2 = diagnosticContext;
            boolean bl = false;
            String string5 = " (" + (String)it + ')';
            diagnosticContext = diagnosticContext2;
            diagnosticReporter = diagnosticReporter2;
            ktSourcelessDiagnosticFactory = ktSourcelessDiagnosticFactory2;
            stringBuilder = stringBuilder2;
            string2 = string5;
        } else {
            string2 = string = null;
        }
        if (string2 == null) {
            string = "";
        }
        KtDiagnosticReportHelpersKt.report$default((DiagnosticContext)diagnosticContext, (DiagnosticReporter)diagnosticReporter, (KtSourcelessDiagnosticFactory)ktSourcelessDiagnosticFactory, (String)stringBuilder.append(string).append('.').toString(), null, (int)8, null);
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DeprecationLevelValue.values().length];
            try {
                nArray[DeprecationLevelValue.WARNING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

