/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnostic;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory3;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.LanguageVersionUtilsKt;
import org.jetbrains.kotlin.fir.SessionHolder;
import org.jetbrains.kotlin.fir.analysis.FirSourceUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.ConeDiagnosticToFirDiagnosticKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.ConeSyntaxDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.FirDiagnosticHolder;
import org.jetbrains.kotlin.fir.expressions.FirComponentCall;
import org.jetbrains.kotlin.fir.expressions.FirErrorExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirSmartCastExpression;
import org.jetbrains.kotlin.fir.expressions.FirWrappedExpression;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.AbstractCallCandidate;
import org.jetbrains.kotlin.fir.resolve.calls.AbstractCandidate;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeAmbiguityError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeConstraintSystemHasContradiction;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeHiddenCandidateError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeInapplicableCandidateError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeInapplicableWrongReceiver;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedNameError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeVisibilityError;
import org.jetbrains.kotlin.fir.scopes.FirScopeKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.resolve.calls.tower.CandidateApplicability;
import org.jetbrains.kotlin.resolve.calls.tower.CandidateApplicabilityKt;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.model.TypeCheckerProviderContext;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003:\u0005EFGHIB\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ\u0014\u0010\u000e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000f2\u0006\u0010\f\u001a\u00020\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\f\u001a\u00020\u0002H\u0002J\u0014\u0010\u0012\u001a\u00020\u0013*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0011H\u0002J-\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0014H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0018J/\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0014H\u0000R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u001a\u0010\u0018J\u000e\u0010\u001b\u001a\u0004\u0018\u00010\u0014*\u00020\u0014H\u0002JE\u0010\u001c\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0017\u001a\u00020\u0014H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010!J/\u0010\"\u001a\u0004\u0018\u00010#*\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010$\u001a\u00020%H\u0002R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010&J7\u0010'\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00142\b\u0010(\u001a\u0004\u0018\u00010)H\u0002R\u00020\nR\u00020\bj\u0006\u0010\u000b\u001a\u00020\nj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010*J\u000e\u0010+\u001a\u00020,*\u0004\u0018\u00010-H\u0002JM\u0010.\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010/\u001a\u00020\u001e2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u00022\u0006\u00103\u001a\u000204H\u0002R\u00020\nR\u00020\bj\u0006\u0010\u000b\u001a\u00020\nj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u00105JE\u00106\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u00102\u001a\u00020\u00022\u0006\u00107\u001a\u00020\u00112\u0006\u00103\u001a\u000204H\u0002R\u00020\nR\u00020\bj\u0006\u0010\u000b\u001a\u00020\nj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u00108J5\u00109\u001a\u00020\u00072\u0006\u00100\u001a\u0002012\u0006\u00103\u001a\u000204H\u0002R\u00020\nR\u00020\bj\u0006\u0010\u000b\u001a\u00020\nj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010:R\u001a\u0010;\u001a\u0004\u0018\u00010<*\u00020)8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b=\u0010>R\u0018\u0010?\u001a\u00020)*\u00020)8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b@\u0010AR\u001a\u0010B\u001a\u0004\u0018\u00010\u0011*\u00020<8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bC\u0010D\u00a8\u0006J"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDestructuringDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirProperty;)V", "getDestructuringVariableIfEntry", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirVariableSymbol;", "getDestructuringVariableOfEntry", "Lorg/jetbrains/kotlin/fir/declarations/FirVariable;", "syntaxKind", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDestructuringDeclarationChecker$DestructuringSyntax;", "Lorg/jetbrains/kotlin/KtSourceElement;", "originalDestructuringDeclaration", "checkFullFormLanguageFeature", "source", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/KtSourceElement;)V", "checkSquareBracketsLanguageFeature", "checkSquareBracketsLanguageFeature$checkers", "findSquareBracket", "checkChangingMeaningOfShortSyntax", "originalDestructuringDeclarationType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "componentIndex", "", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirProperty;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;ILorg/jetbrains/kotlin/KtSourceElement;)V", "getProblem", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDestructuringDeclarationChecker$ProblemType;", "destructuredName", "Lorg/jetbrains/kotlin/name/Name;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;ILorg/jetbrains/kotlin/name/Name;)Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDestructuringDeclarationChecker$ProblemType;", "checkInitializer", "initializer", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/KtSourceElement;Lorg/jetbrains/kotlin/fir/expressions/FirExpression;)V", "isMissingInitializer", "", "Lorg/jetbrains/kotlin/fir/FirElement;", "reportGivenDiagnostic", "destructuringDeclarationType", "diagnostic", "Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "property", "componentCall", "Lorg/jetbrains/kotlin/fir/expressions/FirComponentCall;", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/KtSourceElement;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;Lorg/jetbrains/kotlin/fir/declarations/FirProperty;Lorg/jetbrains/kotlin/fir/expressions/FirComponentCall;)V", "checkComponentTypeMismatch", "destructuringDeclaration", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/KtSourceElement;Lorg/jetbrains/kotlin/fir/declarations/FirProperty;Lorg/jetbrains/kotlin/fir/declarations/FirVariable;Lorg/jetbrains/kotlin/fir/expressions/FirComponentCall;)V", "reportDefaultDiagnostics", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;Lorg/jetbrains/kotlin/fir/expressions/FirComponentCall;)V", "explicitReceiverOfQualifiedAccess", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "getExplicitReceiverOfQualifiedAccess", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;)Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "unwrapped", "getUnwrapped", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;)Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "resolvedVariable", "getResolvedVariable", "(Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;)Lorg/jetbrains/kotlin/fir/declarations/FirVariable;", "DestructuringSyntax", "ProblemType", "DataClassNameMismatch", "NonDataClass", "DataClassCustomComponent", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirDestructuringDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirDestructuringDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDestructuringDeclarationChecker\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 3 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,431:1\n245#2:432\n70#3:433\n70#3:436\n70#3:437\n296#4,2:434\n1586#4:438\n1661#4,3:439\n*S KotlinDebug\n*F\n+ 1 FirDestructuringDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDestructuringDeclarationChecker\n*L\n149#1:432\n254#1:433\n269#1:436\n270#1:437\n255#1:434,2\n329#1:438\n329#1:439,3\n*E\n"})
public final class FirDestructuringDeclarationChecker
extends FirDeclarationChecker<FirProperty> {
    @NotNull
    public static final FirDestructuringDeclarationChecker INSTANCE = new FirDestructuringDeclarationChecker();

    private FirDestructuringDeclarationChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirProperty declaration) {
        ConeDiagnostic diagnostic;
        FirElement firElement;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        KtSourceElement ktSourceElement = declaration.getSource();
        if (ktSourceElement == null) {
            return;
        }
        KtSourceElement source = ktSourceElement;
        if (Intrinsics.areEqual((Object)source.getElementType(), (Object)KtNodeTypes.DESTRUCTURING_DECLARATION)) {
            this.checkInitializer(reporter, context2, source, declaration.getInitializer());
            this.checkSquareBracketsLanguageFeature$checkers(context2, reporter, source);
            return;
        }
        if (Intrinsics.areEqual((Object)declaration.getName(), (Object)SpecialNames.DESTRUCT)) {
            this.checkSquareBracketsLanguageFeature$checkers(context2, reporter, source);
        }
        if (!Intrinsics.areEqual((Object)source.getElementType(), (Object)KtNodeTypes.DESTRUCTURING_DECLARATION_ENTRY)) {
            return;
        }
        FirExpression firExpression = declaration.getInitializer();
        FirQualifiedAccessExpression firQualifiedAccessExpression = firExpression instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)firExpression : null;
        if (firQualifiedAccessExpression == null) {
            return;
        }
        FirQualifiedAccessExpression initializer2 = firQualifiedAccessExpression;
        FirVariable firVariable = this.getDestructuringVariableOfEntry(declaration);
        if (firVariable == null) {
            return;
        }
        FirVariable originalDestructuringDeclaration = firVariable;
        FirVariable firVariable2 = originalDestructuringDeclaration;
        if (firVariable2 instanceof FirProperty) {
            FirExpression firExpression2;
            FirExpression firExpression3 = ((FirProperty)originalDestructuringDeclaration).getInitializer();
            if (Intrinsics.areEqual((Object)(firExpression3 != null && (firExpression3 = firExpression3.getSource()) != null ? firExpression3.getElementType() : null), (Object)KtNodeTypes.FOR)) {
                FirQualifiedAccessExpression iterator2;
                FirExpression firExpression4 = ((FirProperty)originalDestructuringDeclaration).getInitializer();
                FirQualifiedAccessExpression firQualifiedAccessExpression2 = iterator2 = firExpression4 != null ? this.getExplicitReceiverOfQualifiedAccess(firExpression4) : null;
                FirVariable firVariable3 = firQualifiedAccessExpression2 != null ? this.getResolvedVariable(firQualifiedAccessExpression2) : null;
                FirPureAbstractElement firPureAbstractElement = firVariable3 instanceof FirProperty ? (FirProperty)firVariable3 : null;
                firExpression2 = firPureAbstractElement != null && (firPureAbstractElement = firPureAbstractElement.getInitializer()) != null ? this.getExplicitReceiverOfQualifiedAccess((FirExpression)firPureAbstractElement) : null;
            } else {
                firExpression2 = ((FirProperty)originalDestructuringDeclaration).getInitializer();
            }
            firElement = firExpression2;
        } else {
            firElement = firVariable2 instanceof FirValueParameter ? (FirElement)originalDestructuringDeclaration : null;
        }
        if (firElement == null) {
            return;
        }
        FirElement originalDestructuringDeclarationOrInitializer = firElement;
        DestructuringSyntax syntax = this.syntaxKind(source, originalDestructuringDeclaration);
        if (syntax == DestructuringSyntax.ParensFull) {
            this.checkFullFormLanguageFeature(context2, reporter, source);
        }
        if (!(initializer2 instanceof FirComponentCall)) {
            return;
        }
        KtSingleValueToken ktSingleValueToken = KtTokens.EQ;
        Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken, (String)"EQ");
        KtSourceElement ktSourceElement2 = FirSourceUtilsKt.getChild$default(source, (IElementType)ktSingleValueToken, 0, 1, false, 10, null);
        if (ktSourceElement2 != null) {
            KtSourceElement it = ktSourceElement2;
            boolean bl = false;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)it), FirErrors.INSTANCE.getUNSUPPORTED_FEATURE(), (Object)TuplesKt.to((Object)LanguageFeature.EnableNameBasedDestructuringShortForm, (Object)context2.getLanguageVersionSettings()), null, (int)16, null);
        }
        if (this.isMissingInitializer(originalDestructuringDeclarationOrInitializer)) {
            return;
        }
        KtSourceElement ktSourceElement3 = originalDestructuringDeclarationOrInitializer.getSource();
        if (ktSourceElement3 == null) {
            return;
        }
        KtSourceElement originalDestructuringDeclarationOrInitializerSource = ktSourceElement3;
        FirElement bl = originalDestructuringDeclarationOrInitializer;
        ConeKotlinType coneKotlinType = bl instanceof FirVariable ? FirTypeUtilsKt.getConeType(((FirVariable)originalDestructuringDeclarationOrInitializer).getReturnTypeRef()) : (bl instanceof FirExpression ? FirTypeUtilsKt.getResolvedType((FirExpression)originalDestructuringDeclarationOrInitializer) : null);
        if (coneKotlinType == null) {
            return;
        }
        ConeKotlinType originalDestructuringDeclarationType = coneKotlinType;
        FirNamedReference reference = ((FirComponentCall)initializer2).getCalleeReference();
        ConeDiagnostic coneDiagnostic = diagnostic = FirReferenceUtilsKt.isError(reference) ? ((FirDiagnosticHolder)((Object)reference)).getDiagnostic() : null;
        if (diagnostic != null) {
            this.reportGivenDiagnostic(reporter, context2, originalDestructuringDeclarationOrInitializerSource, originalDestructuringDeclarationType, diagnostic, declaration, (FirComponentCall)initializer2);
        }
        this.checkComponentTypeMismatch(reporter, context2, originalDestructuringDeclarationOrInitializerSource, declaration, originalDestructuringDeclaration, (FirComponentCall)initializer2);
        if (syntax == DestructuringSyntax.ParensShort) {
            this.checkChangingMeaningOfShortSyntax(context2, reporter, declaration, originalDestructuringDeclarationType, ((FirComponentCall)initializer2).getComponentIndex(), source);
        }
    }

    @Nullable
    public final FirVariableSymbol<?> getDestructuringVariableIfEntry(@NotNull FirProperty declaration) {
        FirVariableSymbol<FirVariable> firVariableSymbol;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        KtSourceElement ktSourceElement = declaration.getSource();
        boolean condition$iv = Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getElementType() : null), (Object)KtNodeTypes.DESTRUCTURING_DECLARATION_ENTRY);
        boolean $i$f$runIf = false;
        if (condition$iv) {
            boolean bl = false;
            FirVariable firVariable = INSTANCE.getDestructuringVariableOfEntry(declaration);
            firVariableSymbol = firVariable != null ? firVariable.getSymbol() : null;
        } else {
            firVariableSymbol = null;
        }
        return firVariableSymbol;
    }

    private final FirVariable getDestructuringVariableOfEntry(FirProperty declaration) {
        FirExpression firExpression = declaration.getInitializer();
        return firExpression != null && (firExpression = this.getExplicitReceiverOfQualifiedAccess(firExpression)) != null ? this.getResolvedVariable((FirQualifiedAccessExpression)firExpression) : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final DestructuringSyntax syntaxKind(KtSourceElement $this$syntaxKind, FirVariable originalDestructuringDeclaration) {
        DestructuringSyntax destructuringSyntax;
        KtSourceElement ktSourceElement = originalDestructuringDeclaration.getSource();
        boolean hasOpeningSquareBracket = (ktSourceElement != null ? this.findSquareBracket(ktSourceElement) : null) != null;
        TokenSet tokenSet = KtTokens.VAL_VAR;
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"VAL_VAR");
        boolean hasValVar = FirSourceUtilsKt.getChild$default($this$syntaxKind, tokenSet, 0, 1, false, 10, null) != null;
        boolean bl = hasOpeningSquareBracket;
        if (bl) {
            boolean bl2 = hasValVar;
            if (bl2) {
                destructuringSyntax = DestructuringSyntax.SquareBracketsFull;
                return destructuringSyntax;
            } else {
                if (bl2) throw new NoWhenBranchMatchedException();
                destructuringSyntax = DestructuringSyntax.SquareBracketsShort;
            }
            return destructuringSyntax;
        } else {
            if (bl) throw new NoWhenBranchMatchedException();
            boolean bl3 = hasValVar;
            if (bl3) {
                destructuringSyntax = DestructuringSyntax.ParensFull;
                return destructuringSyntax;
            } else {
                if (bl3) throw new NoWhenBranchMatchedException();
                destructuringSyntax = DestructuringSyntax.ParensShort;
            }
        }
        return destructuringSyntax;
    }

    private final void checkFullFormLanguageFeature(CheckerContext context2, DiagnosticReporter reporter, KtSourceElement source) {
        block1: {
            if (LanguageVersionUtilsKt.isEnabled(context2, LanguageFeature.NameBasedDestructuring)) {
                return;
            }
            TokenSet tokenSet = KtTokens.VAL_VAR;
            Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"VAL_VAR");
            KtSourceElement ktSourceElement = FirSourceUtilsKt.getChild$default(source, tokenSet, 0, 1, false, 10, null);
            if (ktSourceElement == null) break block1;
            KtSourceElement it = ktSourceElement;
            boolean bl = false;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)it), FirErrors.INSTANCE.getUNSUPPORTED_FEATURE(), (Object)TuplesKt.to((Object)LanguageFeature.NameBasedDestructuring, (Object)context2.getLanguageVersionSettings()), null, (int)16, null);
        }
    }

    public final void checkSquareBracketsLanguageFeature$checkers(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull KtSourceElement source) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (LanguageVersionUtilsKt.isEnabled(context2, LanguageFeature.NameBasedDestructuring)) {
            return;
        }
        KtSourceElement lBracket = this.findSquareBracket(source);
        if (lBracket != null) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)lBracket), FirErrors.INSTANCE.getUNSUPPORTED_FEATURE(), (Object)TuplesKt.to((Object)LanguageFeature.NameBasedDestructuring, (Object)context2.getLanguageVersionSettings()), null, (int)16, null);
        }
    }

    private final KtSourceElement findSquareBracket(KtSourceElement $this$findSquareBracket) {
        Object object;
        IElementType iElementType = $this$findSquareBracket.getElementType();
        if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.DESTRUCTURING_DECLARATION)) {
            KtSingleValueToken ktSingleValueToken = KtTokens.LBRACKET;
            Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken, (String)"LBRACKET");
            object = FirSourceUtilsKt.getChild$default($this$findSquareBracket, (IElementType)ktSingleValueToken, 0, 1, false, 10, null);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.VALUE_PARAMETER)) {
            IElementType iElementType2 = KtNodeTypes.DESTRUCTURING_DECLARATION;
            Intrinsics.checkNotNullExpressionValue((Object)iElementType2, (String)"DESTRUCTURING_DECLARATION");
            KtSourceElement ktSourceElement = FirSourceUtilsKt.getChild$default($this$findSquareBracket, iElementType2, 0, 1, false, 10, null);
            object = ktSourceElement != null ? this.findSquareBracket(ktSourceElement) : null;
        } else {
            object = null;
        }
        return object;
    }

    private final void checkChangingMeaningOfShortSyntax(CheckerContext context2, DiagnosticReporter reporter, FirProperty declaration, ConeKotlinType originalDestructuringDeclarationType, int componentIndex, KtSourceElement source) {
        if (!LanguageVersionUtilsKt.isEnabled(context2, LanguageFeature.DeprecateNameMismatchInShortDestructuringWithParentheses) || LanguageVersionUtilsKt.isEnabled(context2, LanguageFeature.EnableNameBasedDestructuringShortForm)) {
            return;
        }
        if (Intrinsics.areEqual((Object)declaration.getName(), (Object)SpecialNames.UNDERSCORE_FOR_UNUSED_VAR)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)source), (KtDiagnosticFactory0)FirErrors.INSTANCE.getDESTRUCTURING_SHORT_FORM_UNDERSCORE(), null, (int)8, null);
            return;
        }
        ProblemType problemType = this.getProblem(context2, originalDestructuringDeclarationType, componentIndex, declaration.getName());
        if (problemType == null) {
            return;
        }
        ProblemType problem = problemType;
        ProblemType problemType2 = problem;
        if (Intrinsics.areEqual((Object)problemType2, (Object)NonDataClass.INSTANCE) || Intrinsics.areEqual((Object)problemType2, (Object)DataClassCustomComponent.INSTANCE)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)source), FirErrors.INSTANCE.getDESTRUCTURING_SHORT_FORM_OF_NON_DATA_CLASS(), (Object)originalDestructuringDeclarationType, (Object)declaration.getName(), (Object)(problem instanceof NonDataClass ? "non-data class" : "custom component operators of data class"), null, (int)64, null);
        } else if (problemType2 instanceof DataClassNameMismatch) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)source), FirErrors.INSTANCE.getDESTRUCTURING_SHORT_FORM_NAME_MISMATCH(), (Object)declaration.getName(), (Object)((DataClassNameMismatch)problem).getPropertyName(), null, (int)32, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final ProblemType getProblem(CheckerContext context2, ConeKotlinType $this$getProblem, int componentIndex, Name destructuredName) {
        ProblemType problemType;
        Object object;
        FirRegularClassSymbol firRegularClassSymbol = ToSymbolUtilsKt.toRegularClassSymbol((SessionHolder)context2, TypeExpansionUtilsKt.fullyExpandedType((SessionHolder)context2, $this$getProblem));
        if (firRegularClassSymbol == null) {
            return null;
        }
        FirRegularClassSymbol classSymbol = firRegularClassSymbol;
        FirClassLikeSymbol $this$isData$iv = classSymbol;
        boolean $i$f$isData = false;
        if ($this$isData$iv.getRawStatus().isData()) {
            FirConstructorSymbol constructor;
            Object object2;
            Object v1;
            block12: {
                Iterable $this$firstOrNull$iv = FirScopeKt.getDeclaredConstructors(FirHelpersKt.declaredMemberScope(context2, classSymbol));
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    FirConstructorSymbol it = (FirConstructorSymbol)element$iv;
                    boolean bl = false;
                    if (!it.isPrimary()) continue;
                    v1 = element$iv;
                    break block12;
                }
                v1 = null;
            }
            object = (object2 = (constructor = (FirConstructorSymbol)v1)) != null && (object2 = ((FirFunctionSymbol)object2).getValueParameterSymbols()) != null && (object2 = (FirValueParameterSymbol)CollectionsKt.getOrNull((List)object2, (int)(componentIndex - 1))) != null ? ((FirVariableSymbol)object2).getName() : null;
        } else if (Intrinsics.areEqual((Object)classSymbol.getClassId(), (Object)StandardClassIds.INSTANCE.getMapEntry())) {
            switch (componentIndex) {
                case 1: {
                    object = StandardNames.MAP_ENTRY_KEY;
                    break;
                }
                case 2: {
                    object = StandardNames.MAP_ENTRY_VALUE;
                    break;
                }
                default: {
                    object = null;
                    break;
                }
            }
        } else {
            object = null;
        }
        Name propertyName = object;
        $this$isData$iv = classSymbol;
        $i$f$isData = false;
        if (!$this$isData$iv.getRawStatus().isData() && propertyName == null && componentIndex == 1) {
            problemType = NonDataClass.INSTANCE;
        } else {
            $this$isData$iv = classSymbol;
            $i$f$isData = false;
            problemType = $this$isData$iv.getRawStatus().isData() && propertyName == null ? (ProblemType)DataClassCustomComponent.INSTANCE : (propertyName != null && !Intrinsics.areEqual((Object)propertyName, (Object)destructuredName) ? (ProblemType)new DataClassNameMismatch(propertyName) : null);
        }
        return problemType;
    }

    private final void checkInitializer(DiagnosticReporter reporter, CheckerContext context2, KtSourceElement source, FirExpression initializer2) {
        if (this.isMissingInitializer(initializer2)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)source), (KtDiagnosticFactory0)FirErrors.INSTANCE.getINITIALIZER_REQUIRED_FOR_DESTRUCTURING_DECLARATION(), null, (int)8, null);
        }
    }

    private final boolean isMissingInitializer(FirElement $this$isMissingInitializer) {
        return $this$isMissingInitializer == null || $this$isMissingInitializer instanceof FirErrorExpression && ((FirErrorExpression)$this$isMissingInitializer).getDiagnostic() instanceof ConeSyntaxDiagnostic;
    }

    /*
     * WARNING - void declaration
     */
    private final void reportGivenDiagnostic(DiagnosticReporter reporter, CheckerContext context2, KtSourceElement source, ConeKotlinType destructuringDeclarationType, ConeDiagnostic diagnostic, FirProperty property, FirComponentCall componentCall) {
        ConeDiagnostic coneDiagnostic = diagnostic;
        if (coneDiagnostic instanceof ConeUnresolvedNameError) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)source), FirErrors.INSTANCE.getCOMPONENT_FUNCTION_MISSING(), (Object)((ConeUnresolvedNameError)diagnostic).getName(), (Object)destructuringDeclarationType, null, (int)32, null);
        } else if (coneDiagnostic instanceof ConeHiddenCandidateError) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)source), FirErrors.INSTANCE.getCOMPONENT_FUNCTION_MISSING(), (Object)((ConeHiddenCandidateError)diagnostic).getCandidate().getCallInfo().getName(), (Object)destructuringDeclarationType, null, (int)32, null);
        } else if (coneDiagnostic instanceof ConeInapplicableWrongReceiver) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)source), FirErrors.INSTANCE.getCOMPONENT_FUNCTION_MISSING(), (Object)((AbstractCallCandidate)CollectionsKt.first((Iterable)((ConeInapplicableWrongReceiver)diagnostic).getCandidates())).getCallInfo().getName(), (Object)destructuringDeclarationType, null, (int)32, null);
        } else if (coneDiagnostic instanceof ConeAmbiguityError && CandidateApplicabilityKt.isSuccess((CandidateApplicability)((ConeAmbiguityError)diagnostic).getApplicability())) {
            Collection<FirBasedSymbol<?>> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = ((ConeAmbiguityError)diagnostic).getCandidates();
            Name name2 = ((ConeAmbiguityError)diagnostic).getName();
            KtDiagnosticFactory3<Name, Collection<FirBasedSymbol<?>>, ConeKotlinType> ktDiagnosticFactory3 = FirErrors.INSTANCE.getCOMPONENT_FUNCTION_AMBIGUITY();
            AbstractKtSourceElement abstractKtSourceElement = (AbstractKtSourceElement)source;
            DiagnosticReporter diagnosticReporter = reporter;
            DiagnosticContext diagnosticContext = context2;
            boolean $i$f$map = false;
            void var11_17 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                AbstractCandidate abstractCandidate = (AbstractCandidate)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getSymbol());
            }
            collection = (List)destination$iv$iv;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)diagnosticContext, (DiagnosticReporter)diagnosticReporter, (AbstractKtSourceElement)abstractKtSourceElement, ktDiagnosticFactory3, (Object)name2, collection, (Object)destructuringDeclarationType, null, (int)64, null);
        } else if (coneDiagnostic instanceof ConeAmbiguityError) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)source), FirErrors.INSTANCE.getCOMPONENT_FUNCTION_MISSING(), (Object)((ConeAmbiguityError)diagnostic).getName(), (Object)destructuringDeclarationType, null, (int)32, null);
        } else if (coneDiagnostic instanceof ConeInapplicableCandidateError) {
            if (ConeTypeUtilsKt.isMarkedNullable(TypeExpansionUtilsKt.fullyExpandedType((SessionHolder)context2, destructuringDeclarationType))) {
                DiagnosticContext diagnosticContext = context2;
                AbstractKtSourceElement abstractKtSourceElement = (AbstractKtSourceElement)source;
                KtDiagnosticFactory2<Name, ConeKotlinType> ktDiagnosticFactory2 = FirErrors.INSTANCE.getCOMPONENT_FUNCTION_ON_NULLABLE();
                FirBasedSymbol<?> firBasedSymbol = ((ConeInapplicableCandidateError)diagnostic).getCandidate().getSymbol();
                Intrinsics.checkNotNull(firBasedSymbol, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol");
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)diagnosticContext, (DiagnosticReporter)reporter, (AbstractKtSourceElement)abstractKtSourceElement, ktDiagnosticFactory2, (Object)((FirNamedFunctionSymbol)firBasedSymbol).getCallableId().getCallableName(), (Object)destructuringDeclarationType, null, (int)32, null);
            } else {
                this.reportDefaultDiagnostics(reporter, context2, diagnostic, componentCall);
            }
        } else if (coneDiagnostic instanceof ConeConstraintSystemHasContradiction) {
            ConeKotlinType componentType = FirTypeUtilsKt.getResolvedType(componentCall);
            if (componentType instanceof ConeErrorType) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)source), FirErrors.INSTANCE.getCOMPONENT_FUNCTION_MISSING(), (Object)((AbstractCallCandidate)CollectionsKt.first((Iterable)((ConeConstraintSystemHasContradiction)diagnostic).getCandidates())).getCallInfo().getName(), (Object)destructuringDeclarationType, null, (int)32, null);
                return;
            }
        } else if (coneDiagnostic instanceof ConeVisibilityError) {
            reporter.report(ConeDiagnosticToFirDiagnosticKt.toInvisibleReferenceDiagnostic(((ConeVisibilityError)diagnostic).getSymbol(), property.getSource(), context2.getSession()), (DiagnosticContext)context2);
        } else {
            this.reportDefaultDiagnostics(reporter, context2, diagnostic, componentCall);
        }
    }

    private final void checkComponentTypeMismatch(DiagnosticReporter reporter, CheckerContext context2, KtSourceElement source, FirProperty property, FirVariable destructuringDeclaration, FirComponentCall componentCall) {
        ConeKotlinType componentType = FirTypeUtilsKt.getResolvedType(componentCall);
        ConeKotlinType expectedType = FirTypeUtilsKt.getConeType(property.getReturnTypeRef());
        if (!AbstractTypeChecker.isSubtypeOf$default((AbstractTypeChecker)AbstractTypeChecker.INSTANCE, (TypeCheckerProviderContext)TypeComponentsKt.getTypeContext(context2.getSession()), (KotlinTypeMarker)componentType, (KotlinTypeMarker)expectedType, (boolean)false, (int)8, null)) {
            KtSourceElement typeMismatchSource = destructuringDeclaration instanceof FirValueParameter ? property.getSource() : source;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)typeMismatchSource), FirErrors.INSTANCE.getCOMPONENT_FUNCTION_RETURN_TYPE_MISMATCH(), (Object)componentCall.getCalleeReference().getName(), (Object)componentType, (Object)expectedType, null, (int)64, null);
        }
    }

    private final void reportDefaultDiagnostics(DiagnosticReporter reporter, CheckerContext context2, ConeDiagnostic diagnostic, FirComponentCall componentCall) {
        for (KtDiagnostic coneDiagnostic : ConeDiagnosticToFirDiagnosticKt.toFirDiagnostics$default(diagnostic, context2.getSession(), componentCall.getSource(), null, null, 8, null)) {
            reporter.report(coneDiagnostic, (DiagnosticContext)context2);
        }
    }

    private final FirQualifiedAccessExpression getExplicitReceiverOfQualifiedAccess(FirExpression $this$explicitReceiverOfQualifiedAccess) {
        FirExpression firExpression = $this$explicitReceiverOfQualifiedAccess instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)$this$explicitReceiverOfQualifiedAccess : null;
        FirExpression firExpression2 = firExpression != null && (firExpression = firExpression.getExplicitReceiver()) != null ? this.getUnwrapped(firExpression) : null;
        return firExpression2 instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)firExpression2 : null;
    }

    private final FirExpression getUnwrapped(FirExpression $this$unwrapped) {
        FirExpression firExpression = $this$unwrapped;
        return firExpression instanceof FirSmartCastExpression ? ((FirSmartCastExpression)$this$unwrapped).getOriginalExpression() : (firExpression instanceof FirWrappedExpression ? ((FirWrappedExpression)$this$unwrapped).getExpression() : $this$unwrapped);
    }

    private final FirVariable getResolvedVariable(FirQualifiedAccessExpression $this$resolvedVariable) {
        FirVariableSymbol firVariableSymbol = FirReferenceUtilsKt.toResolvedVariableSymbol$default($this$resolvedVariable.getCalleeReference(), false, 1, null);
        if (firVariableSymbol == null) {
            return null;
        }
        FirVariableSymbol symbol = firVariableSymbol;
        FirLazyDeclarationResolverKt.lazyResolveToPhase(symbol, FirResolvePhase.BODY_RESOLVE);
        return (FirVariable)symbol.getFir();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDestructuringDeclarationChecker$DataClassCustomComponent;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDestructuringDeclarationChecker$ProblemType;", "<init>", "()V", "checkers"})
    private static final class DataClassCustomComponent
    extends ProblemType {
        @NotNull
        public static final DataClassCustomComponent INSTANCE = new DataClassCustomComponent();

        private DataClassCustomComponent() {
            super(null);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDestructuringDeclarationChecker$DataClassNameMismatch;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDestructuringDeclarationChecker$ProblemType;", "propertyName", "Lorg/jetbrains/kotlin/name/Name;", "<init>", "(Lorg/jetbrains/kotlin/name/Name;)V", "getPropertyName", "()Lorg/jetbrains/kotlin/name/Name;", "checkers"})
    private static final class DataClassNameMismatch
    extends ProblemType {
        @NotNull
        private final Name propertyName;

        public DataClassNameMismatch(@NotNull Name propertyName) {
            Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
            super(null);
            this.propertyName = propertyName;
        }

        @NotNull
        public final Name getPropertyName() {
            return this.propertyName;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDestructuringDeclarationChecker$DestructuringSyntax;", "", "<init>", "(Ljava/lang/String;I)V", "ParensShort", "ParensFull", "SquareBracketsShort", "SquareBracketsFull", "checkers"})
    private static final class DestructuringSyntax
    extends Enum<DestructuringSyntax> {
        public static final /* enum */ DestructuringSyntax ParensShort = new DestructuringSyntax();
        public static final /* enum */ DestructuringSyntax ParensFull = new DestructuringSyntax();
        public static final /* enum */ DestructuringSyntax SquareBracketsShort = new DestructuringSyntax();
        public static final /* enum */ DestructuringSyntax SquareBracketsFull = new DestructuringSyntax();
        private static final /* synthetic */ DestructuringSyntax[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static DestructuringSyntax[] values() {
            return (DestructuringSyntax[])$VALUES.clone();
        }

        public static DestructuringSyntax valueOf(String value) {
            return Enum.valueOf(DestructuringSyntax.class, value);
        }

        @NotNull
        public static EnumEntries<DestructuringSyntax> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = destructuringSyntaxArray = new DestructuringSyntax[]{DestructuringSyntax.ParensShort, DestructuringSyntax.ParensFull, DestructuringSyntax.SquareBracketsShort, DestructuringSyntax.SquareBracketsFull};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDestructuringDeclarationChecker$NonDataClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDestructuringDeclarationChecker$ProblemType;", "<init>", "()V", "checkers"})
    private static final class NonDataClass
    extends ProblemType {
        @NotNull
        public static final NonDataClass INSTANCE = new NonDataClass();

        private NonDataClass() {
            super(null);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0003\u0004\u0005\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDestructuringDeclarationChecker$ProblemType;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDestructuringDeclarationChecker$DataClassCustomComponent;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDestructuringDeclarationChecker$DataClassNameMismatch;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDestructuringDeclarationChecker$NonDataClass;", "checkers"})
    private static abstract class ProblemType {
        private ProblemType() {
        }

        public /* synthetic */ ProblemType(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

