/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.SessionHolder;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirNamedFunction;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirTypeParametersOwner;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirLocalPropertySymbol;
import org.jetbrains.kotlin.fir.types.AbbreviatedTypeAttributeKt;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImplicitNothingReturnTypeChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirCallableDeclarationChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;)V", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirImplicitNothingReturnTypeChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirImplicitNothingReturnTypeChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImplicitNothingReturnTypeChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,57:1\n38#2:58\n*S KotlinDebug\n*F\n+ 1 FirImplicitNothingReturnTypeChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImplicitNothingReturnTypeChecker\n*L\n30#1:58\n*E\n"})
public final class FirImplicitNothingReturnTypeChecker
extends FirDeclarationChecker<FirCallableDeclaration> {
    @NotNull
    public static final FirImplicitNothingReturnTypeChecker INSTANCE = new FirImplicitNothingReturnTypeChecker();

    private FirImplicitNothingReturnTypeChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirCallableDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (!(declaration instanceof FirNamedFunction) && !(declaration instanceof FirProperty)) {
            return;
        }
        if (declaration instanceof FirProperty && ((FirProperty)declaration).getSymbol() instanceof FirLocalPropertySymbol) {
            return;
        }
        FirMemberDeclaration $this$isOverride$iv = declaration;
        boolean $i$f$isOverride = false;
        if ($this$isOverride$iv.getStatus().isOverride()) {
            return;
        }
        if (Intrinsics.areEqual((Object)declaration.getOrigin(), (Object)FirDeclarationOrigin.ScriptCustomization.ResultProperty.INSTANCE)) {
            return;
        }
        if (DeclarationUtilsKt.getHasExplicitReturnType(declaration.getSymbol())) {
            boolean notDeclaredAsNothing = !ConeBuiltinTypeUtilsKt.isNothing(AbbreviatedTypeAttributeKt.getAbbreviatedTypeOrSelf(FirTypeUtilsKt.getConeType(declaration.getReturnTypeRef())));
            boolean expandedNothing = ConeBuiltinTypeUtilsKt.isNothing(TypeExpansionUtilsKt.fullyExpandedType((SessionHolder)context2, FirTypeUtilsKt.getConeType(declaration.getReturnTypeRef())));
            if (notDeclaredAsNothing && expandedNothing) {
                KtDiagnosticFactory0 ktDiagnosticFactory0;
                FirCallableDeclaration firCallableDeclaration = declaration;
                if (firCallableDeclaration instanceof FirNamedFunction) {
                    ktDiagnosticFactory0 = FirErrors.INSTANCE.getABBREVIATED_NOTHING_RETURN_TYPE();
                } else if (firCallableDeclaration instanceof FirProperty) {
                    ktDiagnosticFactory0 = FirErrors.INSTANCE.getABBREVIATED_NOTHING_PROPERTY_TYPE();
                } else {
                    throw new IllegalStateException("Should not be here".toString());
                }
                KtDiagnosticFactory0 factory2 = ktDiagnosticFactory0;
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)((FirTypeParametersOwner)((Object)declaration)).getSource()), (KtDiagnosticFactory0)factory2, null, (int)8, null);
            }
            return;
        }
        if (ConeBuiltinTypeUtilsKt.isNothing(FirTypeUtilsKt.getConeType(declaration.getReturnTypeRef()))) {
            KtDiagnosticFactory0 ktDiagnosticFactory0;
            FirCallableDeclaration firCallableDeclaration = declaration;
            if (firCallableDeclaration instanceof FirNamedFunction) {
                ktDiagnosticFactory0 = FirErrors.INSTANCE.getIMPLICIT_NOTHING_RETURN_TYPE();
            } else if (firCallableDeclaration instanceof FirProperty) {
                ktDiagnosticFactory0 = FirErrors.INSTANCE.getIMPLICIT_NOTHING_PROPERTY_TYPE();
            } else {
                throw new IllegalStateException("Should not be here".toString());
            }
            KtDiagnosticFactory0 factory3 = ktDiagnosticFactory0;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)((FirTypeParametersOwner)((Object)declaration)).getSource()), (KtDiagnosticFactory0)factory3, null, (int)8, null);
        }
    }
}

