/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.LanguageVersionUtilsKt;
import org.jetbrains.kotlin.fir.SessionHolder;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.scopes.impl.FirStandardOverrideChecker;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003:\u0001\u000eB\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOperatorOfChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirRegularClassChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;)V", "CheckerImpl", "checkers"})
public final class FirOperatorOfChecker
extends FirDeclarationChecker<FirRegularClass> {
    @NotNull
    public static final FirOperatorOfChecker INSTANCE = new FirOperatorOfChecker();

    private FirOperatorOfChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirRegularClass declaration) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (LanguageVersionUtilsKt.isDisabled(context2, LanguageFeature.CollectionLiterals)) {
            return;
        }
        FirRegularClassSymbol firRegularClassSymbol = declaration.getCompanionObjectSymbol();
        if (firRegularClassSymbol == null) {
            return;
        }
        FirRegularClassSymbol companion = firRegularClassSymbol;
        new CheckerImpl(companion).check(context2, reporter);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001:\u0002%&B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\b\u001a\u00020\t*\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u00020\nj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0011J=\u0010\u0012\u001a\u00020\u0013*\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u00020\nR\u00020\u0014R\u00020\u0016j\u0006\u0010\u000b\u001a\u00020\nj\u0006\u0010\u0015\u001a\u00020\u0014j\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u001aJ5\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u00020\u0014R\u00020\u0016j\u0006\u0010\u0015\u001a\u00020\u0014j\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u001dJ3\u0010\u001e\u001a\u00020\t2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0002R\u00020\u0014R\u00020\u0016j\u0006\u0010\u0015\u001a\u00020\u0014j\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\"J#\u0010#\u001a\u00020\u0013R\u00020\u0014R\u00020\u0016j\u0006\u0010\u0015\u001a\u00020\u0014j\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0002\u0010$R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOperatorOfChecker$CheckerImpl;", "", "companion", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "<init>", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;)V", "getCompanion", "()Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "isMatchingParameter", "", "Lorg/jetbrains/kotlin/fir/scopes/impl/FirStandardOverrideChecker;", "overrideChecker", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOperatorOfChecker$CheckerImpl$MainOfOverload;", "valueParameter", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirValueParameterSymbol;", "substitutor", "Lorg/jetbrains/kotlin/fir/resolve/substitution/ConeSubstitutor;", "(Lorg/jetbrains/kotlin/fir/scopes/impl/FirStandardOverrideChecker;Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOperatorOfChecker$CheckerImpl$MainOfOverload;Lorg/jetbrains/kotlin/fir/symbols/impl/FirValueParameterSymbol;Lorg/jetbrains/kotlin/fir/resolve/substitution/ConeSubstitutor;)Z", "checkOverload", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "overload", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "(Lorg/jetbrains/kotlin/fir/scopes/impl/FirStandardOverrideChecker;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOperatorOfChecker$CheckerImpl$MainOfOverload;Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;)V", "checkStatus", "main", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;)V", "checkNumberOfMainOverloads", "overloads", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOperatorOfChecker$CheckerImpl$OfOverload;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Ljava/util/List;)Z", "check", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;)V", "OfOverload", "MainOfOverload", "checkers"})
    @SourceDebugExtension(value={"SMAP\nFirOperatorOfChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirOperatorOfChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOperatorOfChecker$CheckerImpl\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,170:1\n22#2:171\n22#2:172\n35#2:173\n35#2:206\n30#2:207\n1834#3,4:174\n1915#3,2:178\n812#3,12:180\n1915#3,2:192\n812#3,12:194\n296#3,2:208\n*S KotlinDebug\n*F\n+ 1 FirOperatorOfChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOperatorOfChecker$CheckerImpl\n*L\n105#1:171\n106#1:172\n108#1:173\n109#1:206\n146#1:207\n124#1:174,4\n127#1:178,2\n133#1:180,12\n133#1:192,2\n162#1:194,12\n148#1:208,2\n*E\n"})
    private static final class CheckerImpl {
        @NotNull
        private final FirRegularClassSymbol companion;

        public CheckerImpl(@NotNull FirRegularClassSymbol companion) {
            Intrinsics.checkNotNullParameter((Object)companion, (String)"companion");
            this.companion = companion;
        }

        @NotNull
        public final FirRegularClassSymbol getCompanion() {
            return this.companion;
        }

        private final boolean isMatchingParameter(FirStandardOverrideChecker overrideChecker, MainOfOverload $this$isMatchingParameter, FirValueParameterSymbol valueParameter, ConeSubstitutor substitutor2) {
            if ($this$isMatchingParameter.getMainParameter() == valueParameter) {
                return true;
            }
            Object object = $this$isMatchingParameter.getMainParameterElementType();
            if (object == null || (object = UtilsKt.toFirResolvedTypeRef$default((ConeKotlinType)object, null, null, 3, null)) == null) {
                return true;
            }
            Object mainParameterElementTypeRef = object;
            return overrideChecker.isEqualTypes((FirTypeRef)mainParameterElementTypeRef, valueParameter.getResolvedReturnTypeRef(), substitutor2);
        }

        private final void checkOverload(FirStandardOverrideChecker overrideChecker, CheckerContext context2, DiagnosticReporter reporter, MainOfOverload $this$checkOverload, FirNamedFunctionSymbol overload) {
            ConeSubstitutor substitutor2 = overrideChecker.buildTypeParametersSubstitutorIfCompatible((FirCallableDeclaration)$this$checkOverload.getFunction().getFir(), (FirCallableDeclaration)overload.getFir(), true);
            if (substitutor2 == null) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)overload.getSource()), FirErrors.INSTANCE.getINCONSISTENT_TYPE_PARAMETERS_IN_OF_OVERLOADS(), (Object)$this$checkOverload.getFunction(), null, (int)16, null);
                return;
            }
            for (FirValueParameterSymbol valueParameter : overload.getValueParameterSymbols()) {
                if (this.isMatchingParameter(overrideChecker, $this$checkOverload, valueParameter, substitutor2)) continue;
                DiagnosticContext diagnosticContext = context2;
                AbstractKtSourceElement abstractKtSourceElement = (AbstractKtSourceElement)valueParameter.getSource();
                KtDiagnosticFactory1<ConeKotlinType> ktDiagnosticFactory1 = FirErrors.INSTANCE.getINCONSISTENT_PARAMETER_TYPES_IN_OF_OVERLOADS();
                SessionHolder sessionHolder = context2;
                ConeKotlinType coneKotlinType = $this$checkOverload.getMainParameterElementType();
                Intrinsics.checkNotNull((Object)coneKotlinType);
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)diagnosticContext, (DiagnosticReporter)reporter, (AbstractKtSourceElement)abstractKtSourceElement, ktDiagnosticFactory1, (Object)substitutor2.substituteOrSelf(TypeExpansionUtilsKt.fullyExpandedType(sessionHolder, coneKotlinType)), null, (int)16, null);
            }
            if ($this$checkOverload.getFunction() == overload) {
                return;
            }
            if (!overrideChecker.isEqualTypes($this$checkOverload.getFunction().getResolvedReturnTypeRef(), overload.getResolvedReturnTypeRef(), substitutor2)) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)overload.getSource()), FirErrors.INSTANCE.getINCONSISTENT_RETURN_TYPES_IN_OF_OVERLOADS(), (Object)substitutor2.substituteOrSelf(TypeExpansionUtilsKt.fullyExpandedType((SessionHolder)context2, $this$checkOverload.getFunction().getResolvedReturnType())), null, (int)16, null);
            }
            this.checkStatus(context2, reporter, $this$checkOverload.getFunction(), overload);
        }

        private final void checkStatus(CheckerContext context2, DiagnosticReporter reporter, FirNamedFunctionSymbol main, FirNamedFunctionSymbol overload) {
            FirCallableSymbol $this$visibility$iv = main;
            boolean $i$f$getVisibility = false;
            Visibility visibility2 = $this$visibility$iv.getResolvedStatus().getVisibility();
            $this$visibility$iv = overload;
            $i$f$getVisibility = false;
            if (!Intrinsics.areEqual((Object)visibility2, (Object)$this$visibility$iv.getResolvedStatus().getVisibility())) {
                $this$visibility$iv = main;
                $i$f$getVisibility = false;
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)overload.getSource()), FirErrors.INSTANCE.getINCONSISTENT_VISIBILITY_IN_OF_OVERLOADS(), (Object)$this$visibility$iv.getResolvedStatus().getVisibility(), null, (int)16, null);
            }
            FirCallableSymbol $this$isSuspend$iv = main;
            boolean $i$f$isSuspend = false;
            boolean bl = $this$isSuspend$iv.getRawStatus().isSuspend();
            $this$isSuspend$iv = overload;
            $i$f$isSuspend = false;
            if (bl != $this$isSuspend$iv.getRawStatus().isSuspend()) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)overload.getSource()), FirErrors.INSTANCE.getINCONSISTENT_SUSPEND_IN_OF_OVERLOADS(), (Object)CheckerImpl.checkStatus$suspendString(overload), (Object)CheckerImpl.checkStatus$suspendString(main), null, (int)32, null);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final boolean checkNumberOfMainOverloads(CheckerContext context2, DiagnosticReporter reporter, List<? extends OfOverload> overloads) {
            boolean bl;
            int n;
            Iterable $this$count$iv = overloads;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    OfOverload it = (OfOverload)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof MainOfOverload) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            switch (n) {
                case 1: {
                    bl = true;
                    break;
                }
                case 0: {
                    Iterable $this$forEach$iv = overloads;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        OfOverload overload = (OfOverload)element$iv;
                        boolean bl3 = false;
                        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)overload.getFunction().getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getNO_VARARG_OVERLOAD_OF_OPERATOR_OF(), null, (int)8, null);
                    }
                    bl = false;
                    break;
                }
                default: {
                    void $this$filterIsInstanceTo$iv$iv;
                    Iterable $this$forEach$iv;
                    Iterable $this$filterIsInstance$iv = overloads;
                    boolean $i$f$filterIsInstance = false;
                    Iterable count$iv = $this$filterIsInstance$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof MainOfOverload)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filterIsInstance$iv = (List)destination$iv$iv;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        MainOfOverload overload = (MainOfOverload)element$iv;
                        boolean bl4 = false;
                        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)overload.getFunction().getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getMULTIPLE_VARARG_OVERLOADS_OF_OPERATOR_OF(), null, (int)8, null);
                    }
                    bl = false;
                }
            }
            return bl;
        }

        /*
         * WARNING - void declaration
         */
        public final void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
            void $this$filterIsInstanceTo$iv$iv;
            List list2;
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            List $this$check_u24lambda_u240 = list2 = CollectionsKt.createListBuilder();
            boolean bl = false;
            FirHelpersKt.declaredMemberScope(context2, this.companion).processFunctionsByName(OperatorNameConventions.OF, (Function1<? super FirNamedFunctionSymbol, Unit>)((Function1)arg_0 -> CheckerImpl.check$lambda$0$0($this$check_u24lambda_u240, arg_0)));
            List allOverloads = CollectionsKt.build((List)list2);
            if (allOverloads.isEmpty()) {
                return;
            }
            if (!this.checkNumberOfMainOverloads(context2, reporter, allOverloads)) {
                return;
            }
            Iterable $this$filterIsInstance$iv = allOverloads;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof MainOfOverload)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            MainOfOverload mainOverload = (MainOfOverload)CollectionsKt.single((List)((List)destination$iv$iv));
            FirStandardOverrideChecker firStandardOverrideChecker = new FirStandardOverrideChecker(context2.getSession());
            boolean bl2 = false;
            for (OfOverload overload : allOverloads) {
                this.checkOverload(firStandardOverrideChecker, context2, reporter, mainOverload, overload.getFunction());
            }
        }

        private static final String checkStatus$suspendString(FirNamedFunctionSymbol $this$checkStatus_u24suspendString) {
            FirCallableSymbol $this$isSuspend$iv = $this$checkStatus_u24suspendString;
            boolean $i$f$isSuspend = false;
            return $this$isSuspend$iv.getRawStatus().isSuspend() ? "suspend " : "not suspend";
        }

        private static final Unit check$lambda$0$0(List $this_buildList, FirNamedFunctionSymbol functionSymbol) {
            Object v0;
            block2: {
                Intrinsics.checkNotNullParameter((Object)functionSymbol, (String)"functionSymbol");
                FirCallableSymbol $this$isOperator$iv = functionSymbol;
                boolean $i$f$isOperator = false;
                if (!$this$isOperator$iv.getResolvedStatus().isOperator()) {
                    return Unit.INSTANCE;
                }
                Iterable $this$firstOrNull$iv = functionSymbol.getValueParameterSymbols();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    FirValueParameterSymbol it = (FirValueParameterSymbol)element$iv;
                    boolean bl = false;
                    if (!it.isVararg()) continue;
                    v0 = element$iv;
                    break block2;
                }
                v0 = null;
            }
            FirValueParameterSymbol mainParameter = v0;
            boolean bl = mainParameter != null ? $this_buildList.add(new MainOfOverload(functionSymbol, mainParameter)) : $this_buildList.add(new OfOverload(functionSymbol));
            return Unit.INSTANCE;
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOperatorOfChecker$CheckerImpl$MainOfOverload;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOperatorOfChecker$CheckerImpl$OfOverload;", "function", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "mainParameter", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirValueParameterSymbol;", "<init>", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;Lorg/jetbrains/kotlin/fir/symbols/impl/FirValueParameterSymbol;)V", "getMainParameter", "()Lorg/jetbrains/kotlin/fir/symbols/impl/FirValueParameterSymbol;", "mainParameterElementType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "getMainParameterElementType", "()Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "checkers"})
        public static final class MainOfOverload
        extends OfOverload {
            @NotNull
            private final FirValueParameterSymbol mainParameter;

            public MainOfOverload(@NotNull FirNamedFunctionSymbol function, @NotNull FirValueParameterSymbol mainParameter) {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                Intrinsics.checkNotNullParameter((Object)mainParameter, (String)"mainParameter");
                super(function);
                this.mainParameter = mainParameter;
            }

            @NotNull
            public final FirValueParameterSymbol getMainParameter() {
                return this.mainParameter;
            }

            @Nullable
            public final ConeKotlinType getMainParameterElementType() {
                return FirTypeUtilsKt.arrayElementType$default(this.mainParameter.getResolvedReturnType(), false, 1, null);
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOperatorOfChecker$CheckerImpl$OfOverload;", "", "function", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "<init>", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;)V", "getFunction", "()Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "checkers"})
        public static class OfOverload {
            @NotNull
            private final FirNamedFunctionSymbol function;

            public OfOverload(@NotNull FirNamedFunctionSymbol function) {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            @NotNull
            public final FirNamedFunctionSymbol getFunction() {
                return this.function;
            }
        }
    }
}

