/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.SessionHolder;
import org.jetbrains.kotlin.fir.analysis.checkers.FirPrimaryConstructorSuperTypeCheckerPlatformComponentKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.SourceNavigator;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirDelegatedConstructorCall;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.AbbreviatedTypeAttributeKt;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitAnyTypeRef;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ5\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0012J-\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0002H\u0002R\u00020\nR\u00020\bj\u0006\u0010\u000b\u001a\u00020\nj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPrimaryConstructorSuperTypeChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirClass;)V", "checkSuperTypeNotInitialized", "primaryConstructorSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirConstructorSymbol;", "regularClass", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/symbols/impl/FirConstructorSymbol;Lorg/jetbrains/kotlin/fir/declarations/FirClass;)V", "checkSupertypeInitializedWithoutPrimaryConstructor", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/declarations/FirClass;)V", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirPrimaryConstructorSuperTypeChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirPrimaryConstructorSuperTypeChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPrimaryConstructorSuperTypeChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n+ 4 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,149:1\n63#2:150\n34#3:151\n40#3:152\n71#4,11:153\n23#4,2:164\n1807#5,3:166\n*S KotlinDebug\n*F\n+ 1 FirPrimaryConstructorSuperTypeChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPrimaryConstructorSuperTypeChecker\n*L\n39#1:150\n39#1:151\n50#1:152\n75#1:153,11\n75#1:164,2\n112#1:166,3\n*E\n"})
public final class FirPrimaryConstructorSuperTypeChecker
extends FirDeclarationChecker<FirClass> {
    @NotNull
    public static final FirPrimaryConstructorSuperTypeChecker INSTANCE = new FirPrimaryConstructorSuperTypeChecker();

    private FirPrimaryConstructorSuperTypeChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirClass declaration) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        FirClass $this$isInterface$iv = declaration;
        boolean $i$f$isInterface = false;
        ClassKind $this$isInterface$iv$iv = $this$isInterface$iv.getClassKind();
        boolean $i$f$isInterface2 = false;
        boolean bl = $this$isInterface$iv$iv == ClassKind.INTERFACE;
        if (bl) {
            SourceNavigator $this$check_u24lambda_u240 = SourceNavigator.Companion.forElement(declaration);
            boolean bl2 = false;
            for (FirTypeRef superTypeRef : declaration.getSuperTypeRefs()) {
                if (!$this$check_u24lambda_u240.isInConstructorCallee(superTypeRef)) continue;
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)superTypeRef.getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getSUPERTYPE_INITIALIZED_IN_INTERFACE(), null, (int)8, null);
            }
            return;
        }
        ClassKind $this$isEnumEntry$iv = declaration.getClassKind();
        boolean $i$f$isEnumEntry = false;
        if ($this$isEnumEntry$iv == ClassKind.ENUM_ENTRY) {
            return;
        }
        FirConstructorSymbol primaryConstructorSymbol = org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt.primaryConstructorIfAny(declaration, context2.getSession());
        if (primaryConstructorSymbol == null || FirDeclarationUtilKt.isErrorPrimaryConstructor(primaryConstructorSymbol)) {
            this.checkSupertypeInitializedWithoutPrimaryConstructor(reporter, context2, declaration);
        } else {
            this.checkSuperTypeNotInitialized(context2, reporter, primaryConstructorSymbol, declaration);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void checkSuperTypeNotInitialized(CheckerContext context2, DiagnosticReporter reporter, FirConstructorSymbol primaryConstructorSymbol, FirClass regularClass) {
        Object v0;
        block19: {
            Iterable $this$lastIsInstanceOrNull$iv = context2.getContainingDeclarations();
            boolean $i$f$lastIsInstanceOrNull = false;
            if ($this$lastIsInstanceOrNull$iv instanceof List) {
                int n = ((Collection)$this$lastIsInstanceOrNull$iv).size() + -1;
                if (0 <= n) {
                    do {
                        int i$iv;
                        Object e;
                        if (!((e = ((List)$this$lastIsInstanceOrNull$iv).get(i$iv = n--)) instanceof FirRegularClassSymbol)) continue;
                        v0 = e;
                        break block19;
                    } while (0 <= n);
                }
                v0 = null;
            } else {
                Iterable $this$firstIsInstanceOrNull$iv$iv = CollectionsKt.reversed((Iterable)$this$lastIsInstanceOrNull$iv);
                boolean $i$f$firstIsInstanceOrNull = false;
                for (Object element$iv$iv : $this$firstIsInstanceOrNull$iv$iv) {
                    if (!(element$iv$iv instanceof FirRegularClassSymbol)) continue;
                    v0 = element$iv$iv;
                    break block19;
                }
                v0 = null;
            }
        }
        FirRegularClassSymbol containingClass = v0;
        FirDelegatedConstructorCall firDelegatedConstructorCall = primaryConstructorSymbol.getResolvedDelegatedConstructorCall();
        if (firDelegatedConstructorCall == null) {
            return;
        }
        FirDelegatedConstructorCall delegatedConstructorCall = firDelegatedConstructorCall;
        FirTypeRef constructedTypeRef = delegatedConstructorCall.getConstructedTypeRef();
        if (constructedTypeRef instanceof FirImplicitAnyTypeRef) return;
        KtSourceElement ktSourceElement = constructedTypeRef.getSource();
        if (Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.PluginGenerated.INSTANCE)) {
            return;
        }
        FirRegularClassSymbol firRegularClassSymbol = ToSymbolUtilsKt.toRegularClassSymbol((SessionHolder)context2, FirTypeUtilsKt.getConeType(constructedTypeRef));
        if (firRegularClassSymbol == null) {
            return;
        }
        FirRegularClassSymbol superClassSymbol = firRegularClassSymbol;
        if (superClassSymbol.getClassKind().isSingleton()) {
            return;
        }
        if (DeclarationUtilsKt.isEffectivelyExpect(context2, regularClass, (FirClassSymbol)containingClass)) return;
        if (DeclarationUtilsKt.isEffectivelyExternal(context2, regularClass, (FirClassSymbol)containingClass)) {
            return;
        }
        KtSourceElement ktSourceElement2 = delegatedConstructorCall.getSource();
        if (ktSourceElement2 == null) {
            return;
        }
        KtSourceElement delegatedCallSource = ktSourceElement2;
        if (!(delegatedCallSource.getKind() instanceof KtFakeSourceElementKind)) {
            return;
        }
        Set<ClassId> set = FirPrimaryConstructorSuperTypeCheckerPlatformComponentKt.getPrimaryConstructorSuperTypePlatformSupport(context2.getSession()).getSupertypesThatDontNeedInitializationInSubtypesConstructors();
        if (set.contains(superClassSymbol.getClassId())) {
            return;
        }
        if (Intrinsics.areEqual((Object)delegatedCallSource.getElementType(), (Object)KtNodeTypes.SUPER_TYPE_CALL_ENTRY)) return;
        if (FirLanguageSettingsComponentKt.getLanguageVersionSettings(context2.getSession()).supportsFeature(LanguageFeature.AllowAnyAsAnActualTypeForExpectInterface) && ConeBuiltinTypeUtilsKt.isAny(FirTypeUtilsKt.getConeType(delegatedConstructorCall.getConstructedTypeRef()))) {
            boolean bl;
            Iterable $this$any$iv = FirDeclarationUtilKt.getSuperConeTypes(regularClass);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ConeClassLikeType it = (ConeClassLikeType)element$iv;
                    boolean bl2 = false;
                    if (AbbreviatedTypeAttributeKt.getAbbreviatedType(it) != null && ConeBuiltinTypeUtilsKt.isAny(it)) {
                        return;
                    }
                    boolean bl3 = false;
                    if (!bl3) continue;
                    return;
                }
                bl = false;
            }
            if (bl) {
                return;
            }
        }
        boolean bl = false;
        boolean allowUsingClassTypeAsInterface = bl;
        if (allowUsingClassTypeAsInterface) return;
        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)constructedTypeRef.getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getSUPERTYPE_NOT_INITIALIZED(), null, (int)8, null);
    }

    private final void checkSupertypeInitializedWithoutPrimaryConstructor(DiagnosticReporter reporter, CheckerContext context2, FirClass regularClass) {
        SourceNavigator $this$checkSupertypeInitializedWithoutPrimaryConstructor_u24lambda_u240 = SourceNavigator.Companion.forElement(regularClass);
        boolean bl = false;
        for (FirTypeRef superTypeRef : regularClass.getSuperTypeRefs()) {
            if (!$this$checkSupertypeInitializedWithoutPrimaryConstructor_u24lambda_u240.isInConstructorCallee(superTypeRef)) continue;
            DiagnosticContext diagnosticContext = context2;
            KtSourceElement ktSourceElement = superTypeRef.getSource();
            if (ktSourceElement == null) {
                ktSourceElement = regularClass.getSource();
            }
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)diagnosticContext, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)ktSourceElement), (KtDiagnosticFactory0)FirErrors.INSTANCE.getSUPERTYPE_INITIALIZED_WITHOUT_PRIMARY_CONSTRUCTOR(), null, (int)8, null);
        }
    }
}

