/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.ReturnValueCheckerMode;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\b\u001a\u00020\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0014\u0010\r\u001a\u00020\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0014\u0010\u000e\u001a\u00020\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J-\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0002H\u0016R\u00020\u0011R\u00020\u0013j\u0006\u0010\u0012\u001a\u00020\u0011j\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirReturnValueAnnotationsChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "<init>", "()V", "oldMustUse", "Lorg/jetbrains/kotlin/name/ClassId;", "isMustUseReturnValue", "", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "isOldMustUse", "isIgnorableValue", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)V", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirUnusedReturnValueChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirUnusedReturnValueChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirReturnValueAnnotationsChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,195:1\n1915#2,2:196\n*S KotlinDebug\n*F\n+ 1 FirUnusedReturnValueChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirReturnValueAnnotationsChecker\n*L\n85#1:196,2\n*E\n"})
public final class FirReturnValueAnnotationsChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirReturnValueAnnotationsChecker INSTANCE = new FirReturnValueAnnotationsChecker();
    @NotNull
    private static final ClassId oldMustUse;

    private FirReturnValueAnnotationsChecker() {
        super(MppCheckerKind.Common);
    }

    private final boolean isMustUseReturnValue(FirAnnotation $this$isMustUseReturnValue, FirSession session2) {
        return Intrinsics.areEqual((Object)FirAnnotationUtilsKt.toAnnotationClassId($this$isMustUseReturnValue, session2), (Object)StandardClassIds.Annotations.INSTANCE.getMustUseReturnValues());
    }

    private final boolean isOldMustUse(FirAnnotation $this$isOldMustUse, FirSession session2) {
        return Intrinsics.areEqual((Object)FirAnnotationUtilsKt.toAnnotationClassId($this$isOldMustUse, session2), (Object)oldMustUse);
    }

    private final boolean isIgnorableValue(FirAnnotation $this$isIgnorableValue, FirSession session2) {
        return Intrinsics.areEqual((Object)FirAnnotationUtilsKt.toAnnotationClassId($this$isIgnorableValue, session2), (Object)StandardClassIds.Annotations.INSTANCE.getIgnorableReturnValue());
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (context2.getLanguageVersionSettings().getFlag(AnalysisFlags.getReturnValueCheckerMode()) != ReturnValueCheckerMode.DISABLED) {
            return;
        }
        FirSession session2 = context2.getSession();
        Iterable $this$forEach$iv = declaration.getAnnotations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirAnnotation annotation = (FirAnnotation)element$iv;
            boolean bl = false;
            if (!INSTANCE.isMustUseReturnValue(annotation, session2) && !INSTANCE.isIgnorableValue(annotation, session2) && !INSTANCE.isOldMustUse(annotation, session2)) continue;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)annotation.getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getIGNORABILITY_ANNOTATIONS_WITH_CHECKER_DISABLED(), null, (int)8, null);
        }
    }

    static {
        FqName fqName2 = StandardClassIds.INSTANCE.getBASE_KOTLIN_PACKAGE();
        Name name2 = Name.identifier((String)"MustUseReturnValue");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        oldMustUse = new ClassId(fqName2, name2);
    }
}

