/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.ReturnValueCheckerMode;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirUnusedReturnValueCheckerKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.resolve.ContainingClassUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.resolve.ReturnValueStatus;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirReturnValueOverrideChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirCallableDeclarationChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;)V", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirUnusedReturnValueChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirUnusedReturnValueChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirReturnValueOverrideChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,195:1\n38#2:196\n*S KotlinDebug\n*F\n+ 1 FirUnusedReturnValueChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirReturnValueOverrideChecker\n*L\n46#1:196\n*E\n"})
public final class FirReturnValueOverrideChecker
extends FirDeclarationChecker<FirCallableDeclaration> {
    @NotNull
    public static final FirReturnValueOverrideChecker INSTANCE = new FirReturnValueOverrideChecker();

    private FirReturnValueOverrideChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirCallableDeclaration declaration) {
        Object v0;
        FirCallableSymbol<FirCallableDeclaration> symbol;
        block7: {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            if (context2.getLanguageVersionSettings().getFlag(AnalysisFlags.getReturnValueCheckerMode()) == ReturnValueCheckerMode.DISABLED) {
                return;
            }
            FirMemberDeclaration $this$isOverride$iv = declaration;
            boolean $i$f$isOverride = false;
            if (!$this$isOverride$iv.getStatus().isOverride()) {
                return;
            }
            if (declaration.getStatus().getReturnValueStatus() != ReturnValueStatus.MustUse) {
                return;
            }
            if (FirUnusedReturnValueCheckerKt.access$isIgnorable(context2, FirTypeUtilsKt.getConeType(declaration.getReturnTypeRef()))) {
                return;
            }
            symbol = declaration.getSymbol();
            List<FirCallableSymbol<?>> overriddenSymbols = FirHelpersKt.directOverriddenSymbolsSafe(context2, symbol);
            Iterable iterable = overriddenSymbols;
            for (Object t : iterable) {
                FirCallableSymbol it = (FirCallableSymbol)t;
                boolean bl = false;
                if (!(it.getResolvedStatus().getReturnValueStatus() == ReturnValueStatus.ExplicitlyIgnorable)) continue;
                v0 = t;
                break block7;
            }
            v0 = null;
        }
        FirCallableSymbol firCallableSymbol = v0;
        if (firCallableSymbol == null) {
            return;
        }
        FirCallableSymbol ignorableBaseSymbol = firCallableSymbol;
        FirClassLikeSymbol<?> firClassLikeSymbol = ContainingClassUtilsKt.getContainingClassSymbol(ignorableBaseSymbol);
        if (firClassLikeSymbol == null) {
            throw new IllegalStateException(("Overridden symbol " + ignorableBaseSymbol.getCallableId() + " does not have containing class symbol").toString());
        }
        FirClassLikeSymbol<?> containingClass = firClassLikeSymbol;
        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)declaration.getSource()), FirErrors.INSTANCE.getOVERRIDING_IGNORABLE_WITH_MUST_USE(), symbol, containingClass, null, (int)32, null);
    }
}

