/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.config.MavenComparableVersion;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.diagnostics.AbstractSourceElementPositioningStrategy;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.diagnostics.SourceElementPositioningStrategies;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirAnonymousObjectExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ContainingClassUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FunctionalTypeUtilsKt;
import org.jetbrains.kotlin.fir.visitors.FirDefaultVisitor;
import org.jetbrains.kotlin.fir.visitors.FirDefaultVisitorVoid;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003:\u0002\"#B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016R\u00020\nR\u00020\fj\u0006\u0010\u000b\u001a\u00020\nj\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0002\u0010\u000fJ\u001d\u0010\u0010\u001a\u00020\u0011*\u00020\u0012H\u0002R\u00020\nj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0013J\u001f\u0010\u0014\u001a\u0004\u0018\u00010\u0015*\u00020\u0012H\u0002R\u00020\nj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0016J-\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u0002H\u0002R\u00020\nR\u00020\fj\u0006\u0010\u000b\u001a\u00020\nj\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0002\u0010\u0018J=\u0010\u0019\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001b\u0012\u0004\u0012\u00020\u001c0\u001a2\u0006\u0010\u000e\u001a\u00020\u0002H\u0002R\u00020\nR\u00020\fj\u0006\u0010\u000b\u001a\u00020\nj\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0002\u0010\u001dJ\u0019\u0010\u001e\u001a\u00020\u0011*\u0004\u0018\u00010\u001c2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001cH\u0082\u0004J\u0019\u0010 \u001a\u00020\u0011*\u0004\u0018\u00010\u001c2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001cH\u0082\u0004J\f\u0010!\u001a\u00020\u0011*\u00020\u0002H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirVersionOverloadsChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFunctionChecker;", "<init>", "()V", "versionArgument", "Lorg/jetbrains/kotlin/name/Name;", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirFunction;)V", "hasIntroducedAtAnnotation", "", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)Z", "getIntroducedAtAnnotation", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "checkDeclarationOrContainingClass", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirFunction;)Z", "computeAndCheckParameterVersions", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "Lorg/jetbrains/kotlin/config/MavenComparableVersion;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirFunction;)Ljava/util/Map;", "lessThanOrEqual", "other", "greaterThan", "isCopyMethod", "DependencyChecker", "ComplexExpressionChecker", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirVersionOverloadsChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirVersionOverloadsChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirVersionOverloadsChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 4 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,232:1\n2792#2,3:233\n18#3,2:236\n46#4:238\n63#4:240\n57#4,4:241\n70#4:245\n1#5:239\n*S KotlinDebug\n*F\n+ 1 FirVersionOverloadsChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirVersionOverloadsChecker\n*L\n62#1:233,3\n89#1:236,2\n101#1:238\n147#1:240\n147#1:241,4\n231#1:245\n*E\n"})
public final class FirVersionOverloadsChecker
extends FirDeclarationChecker<FirFunction> {
    @NotNull
    public static final FirVersionOverloadsChecker INSTANCE = new FirVersionOverloadsChecker();
    @NotNull
    private static final Name versionArgument;

    private FirVersionOverloadsChecker() {
        super(MppCheckerKind.Platform);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirFunction declaration) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (this.isCopyMethod(declaration)) {
            return;
        }
        boolean contextWithImplicitParameter = false;
        for (FirDeclaration implicitParameter : CollectionsKt.plus((Collection)declaration.getContextParameters(), (Iterable)CollectionsKt.listOfNotNull((Object)declaration.getReceiverParameter()))) {
            FirAnnotation versionAnnotation = this.getIntroducedAtAnnotation(context2, implicitParameter);
            if (versionAnnotation == null) continue;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)versionAnnotation.getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getINVALID_VERSIONING_ON_RECEIVER_OR_CONTEXT_PARAMETER_POSITION(), null, (int)8, null);
            contextWithImplicitParameter = true;
        }
        if (!contextWithImplicitParameter) {
            boolean bl;
            block8: {
                Iterable $this$none$iv = declaration.getValueParameters();
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        FirValueParameter it = (FirValueParameter)element$iv;
                        boolean bl2 = false;
                        if (!INSTANCE.hasIntroducedAtAnnotation(context2, it)) continue;
                        bl = false;
                        break block8;
                    }
                    bl = true;
                }
            }
            if (bl) {
                return;
            }
        }
        this.checkDeclarationOrContainingClass(context2, reporter, declaration);
        Map<FirCallableSymbol<?>, MavenComparableVersion> paramVersions = this.computeAndCheckParameterVersions(context2, reporter, declaration);
        DependencyChecker dependencyChecker = new DependencyChecker(context2, reporter, paramVersions);
        ComplexExpressionChecker complexExpressionChecker = new ComplexExpressionChecker(context2, reporter);
        for (FirValueParameter param : declaration.getValueParameters()) {
            FirExpression defaultValue;
            if (param.getDefaultValue() == null) continue;
            defaultValue.accept(dependencyChecker, paramVersions.get(param.getSymbol()));
            defaultValue.accept(complexExpressionChecker);
        }
    }

    private final boolean hasIntroducedAtAnnotation(CheckerContext context2, FirDeclaration $this$hasIntroducedAtAnnotation) {
        return FirAnnotationUtilsKt.hasAnnotation($this$hasIntroducedAtAnnotation, StandardClassIds.Annotations.INSTANCE.getIntroducedAt(), context2.getSession());
    }

    private final FirAnnotation getIntroducedAtAnnotation(CheckerContext context2, FirDeclaration $this$getIntroducedAtAnnotation) {
        return FirAnnotationUtilsKt.getAnnotationByClassId($this$getIntroducedAtAnnotation, StandardClassIds.Annotations.INSTANCE.getIntroducedAt(), context2.getSession());
    }

    /*
     * Enabled aggressive block sorting
     */
    private final boolean checkDeclarationOrContainingClass(CheckerContext context2, DiagnosticReporter reporter, FirFunction declaration) {
        Modality modality$iv;
        FirClassLikeSymbol<?> containingClassSymbol = ContainingClassUtilsKt.getContainingClassSymbol(declaration);
        Object $this$isFinal$iv = declaration;
        boolean $i$f$isFinal = false;
        Modality modality2 = ((FirMemberDeclaration)$this$isFinal$iv).getStatus().getModality();
        if (!(modality2 == null ? true : (modality$iv = modality2) == Modality.FINAL)) {
            KtDiagnosticReportHelpersKt.reportOn((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)declaration.getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getINVALID_VERSIONING_ON_NONFINAL_FUNCTION(), (AbstractSourceElementPositioningStrategy)((AbstractSourceElementPositioningStrategy)SourceElementPositioningStrategies.INSTANCE.getDECLARATION_NAME()));
            return true;
        }
        if (declaration.isLocal()) {
            KtDiagnosticReportHelpersKt.reportOn((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)declaration.getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getINVALID_VERSIONING_ON_LOCAL_FUNCTION(), (AbstractSourceElementPositioningStrategy)((AbstractSourceElementPositioningStrategy)SourceElementPositioningStrategies.INSTANCE.getDECLARATION_NAME()));
            return true;
        }
        if (!(declaration instanceof FirConstructor)) {
            boolean bl;
            FirClassLikeSymbol<?> firClassLikeSymbol = containingClassSymbol;
            if (firClassLikeSymbol != null) {
                $this$isFinal$iv = firClassLikeSymbol;
                $i$f$isFinal = false;
                bl = !(((FirClassLikeSymbol)$this$isFinal$iv).getResolvedStatus().getModality() == Modality.FINAL);
            } else {
                bl = false;
            }
            if (bl) {
                KtDiagnosticReportHelpersKt.reportOn((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)declaration.getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getINVALID_VERSIONING_ON_NONFINAL_CLASS(), (AbstractSourceElementPositioningStrategy)((AbstractSourceElementPositioningStrategy)SourceElementPositioningStrategies.INSTANCE.getDECLARATION_NAME()));
                return true;
            }
        }
        FirClassLikeSymbol<?> firClassLikeSymbol = containingClassSymbol;
        if ((firClassLikeSymbol != null ? FirHelpersKt.getClassKind(firClassLikeSymbol) : null) != ClassKind.ANNOTATION_CLASS) return false;
        KtDiagnosticReportHelpersKt.reportOn((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)declaration.getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getINVALID_VERSIONING_ON_ANNOTATION_CLASS(), (AbstractSourceElementPositioningStrategy)((AbstractSourceElementPositioningStrategy)SourceElementPositioningStrategies.INSTANCE.getDECLARATION_NAME()));
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private final Map<FirCallableSymbol<?>, MavenComparableVersion> computeAndCheckParameterVersions(CheckerContext context, DiagnosticReporter reporter, FirFunction declaration) {
        containingClassSymbol = ContainingClassUtilsKt.getContainingClassSymbol(declaration);
        highestVersionUntilNow = null;
        paramVersions = new LinkedHashMap<K, V>();
        var7_7 = ((Iterable)declaration.getValueParameters()).iterator();
        var8_8 = 0;
        while (var7_7.hasNext()) {
            block14: {
                block16: {
                    block18: {
                        block17: {
                            block15: {
                                i = var8_8++;
                                param = (FirValueParameter)var7_7.next();
                                versionAnnotation = FirAnnotationUtilsKt.getAnnotationByClassId(param, StandardClassIds.Annotations.INSTANCE.getIntroducedAt(), context.getSession());
                                v0 = versionAnnotation;
                                if (v0 != null && (v0 = FirAnnotationUtilsKt.getStringArgument((FirAnnotation)v0, FirVersionOverloadsChecker.versionArgument, context.getSession())) != null) {
                                    p0 = v0;
                                    $i$a$-let-FirVersionOverloadsChecker$computeAndCheckParameterVersions$version$1 = false;
                                    v1 = new MavenComparableVersion((String)p0);
                                } else {
                                    v1 = version = null;
                                }
                                if (version == null) {
                                    v2 = mayBeTrailingLambda = i == CollectionsKt.getLastIndex(declaration.getValueParameters()) && FunctionalTypeUtilsKt.isSomeFunctionType(FirTypeUtilsKt.getConeType(param.getReturnTypeRef()), context.getSession()) != false;
                                    if (param.getDefaultValue() != null || highestVersionUntilNow == null || mayBeTrailingLambda) continue;
                                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)param.getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getINVALID_NON_OPTIONAL_PARAMETER_POSITION(), null, (int)8, null);
                                    continue;
                                }
                                paramVersions.put(param.getSymbol(), version);
                                if (!param.isVararg()) break block15;
                                v3 = context;
                                v4 = versionAnnotation.getSource();
                                if (v4 == null) {
                                    v4 = param.getSource();
                                }
                                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)v3, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)v4), (KtDiagnosticFactory0)FirErrors.INSTANCE.getINVALID_VERSIONING_ON_VARARG(), null, (int)8, null);
                                break block16;
                            }
                            if (!param.isVal() || !(declaration instanceof FirConstructor)) ** GOTO lbl-1000
                            if (containingClassSymbol == null) break block17;
                            $i$f$isInlineOrValue = false;
                            $this$isInline$iv$iv = $this$isInlineOrValue$iv;
                            $i$f$isInline = false;
                            if ($this$isInline$iv$iv.getRawStatus().isInline()) ** GOTO lbl-1000
                            $this$isValue$iv$iv = $this$isInlineOrValue$iv;
                            $i$f$isValue = false;
                            if ($this$isValue$iv$iv.getRawStatus().isValue()) lbl-1000:
                            // 2 sources

                            {
                                v5 = true;
                            } else {
                                v5 = false;
                            }
                            v6 = v5;
                            break block18;
                        }
                        v6 = false;
                    }
                    if (v6) {
                        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)versionAnnotation.getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getINVALID_VERSIONING_ON_VALUE_CLASS_PARAMETER(), null, (int)8, null);
                    } else if (param.getDefaultValue() == null) {
                        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)versionAnnotation.getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getINVALID_VERSIONING_ON_NON_OPTIONAL(), null, (int)8, null);
                    }
                }
                if (this.lessThanOrEqual(highestVersionUntilNow, version)) {
                    highestVersionUntilNow = version;
                    continue;
                }
                var13_15 = paramVersions;
                var27_30 = highestVersionUntilNow;
                var26_29 = version;
                var25_28 = FirErrors.INSTANCE.getNON_ASCENDING_VERSION_ANNOTATION();
                var24_27 = (AbstractKtSourceElement)versionAnnotation.getSource();
                var23_26 = reporter;
                var22_25 = context;
                for (Map.Entry<K, V> var15_18 : var13_15.entrySet()) {
                    $i$a$-firstNotNullOf-FirVersionOverloadsChecker$computeAndCheckParameterVersions$1 = false;
                    symbol = (FirCallableSymbol<D>)var15_18.getKey();
                    version = (MavenComparableVersion)var15_18.getValue();
                    it = var19_22 = symbol;
                    $i$a$-takeIf-FirVersionOverloadsChecker$computeAndCheckParameterVersions$1$1 = false;
                    v7 = Intrinsics.areEqual((Object)version, (Object)highestVersionUntilNow) ? var19_22 : null;
                    v8 = v7;
                    if (v7 == null) {
                        continue;
                    }
                    break block14;
                }
                v8 = null;
            }
            if (v8 == null) {
                throw new NoSuchElementException("No element of the map was transformed to a non-null value.");
            }
            var28_31 = v8;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)var22_25, (DiagnosticReporter)var23_26, (AbstractKtSourceElement)var24_27, var25_28, (Object)var26_29, (Object)var27_30, var28_31, null, (int)64, null);
        }
        return paramVersions;
    }

    private final boolean lessThanOrEqual(MavenComparableVersion $this$lessThanOrEqual, MavenComparableVersion other) {
        if ($this$lessThanOrEqual == null) {
            return true;
        }
        if (other == null) {
            return false;
        }
        return $this$lessThanOrEqual.compareTo(other) <= 0;
    }

    private final boolean greaterThan(MavenComparableVersion $this$greaterThan, MavenComparableVersion other) {
        return !this.lessThanOrEqual($this$greaterThan, other);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isCopyMethod(FirFunction $this$isCopyMethod) {
        if (!Intrinsics.areEqual((Object)$this$isCopyMethod.getOrigin(), (Object)FirDeclarationOrigin.Synthetic.DataClassMember.INSTANCE)) return false;
        if (!Intrinsics.areEqual((Object)FirDeclarationUtilKt.getNameOrSpecialName($this$isCopyMethod), (Object)StandardNames.DATA_CLASS_COPY)) return false;
        FirClassLikeSymbol<?> firClassLikeSymbol = ContainingClassUtilsKt.getContainingClassSymbol($this$isCopyMethod);
        if (firClassLikeSymbol == null) return false;
        FirClassLikeSymbol<?> $this$isData$iv = firClassLikeSymbol;
        boolean $i$f$isData = false;
        if (!$this$isData$iv.getRawStatus().isData()) return false;
        return true;
    }

    static {
        Name name2 = Name.identifier((String)"version");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        versionArgument = name2;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\n\u0010\u0013\u001a\u00020\r*\u00020\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirVersionOverloadsChecker$ComplexExpressionChecker;", "Lorg/jetbrains/kotlin/fir/visitors/FirDefaultVisitorVoid;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "<init>", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;)V", "getContext", "()Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "getReporter", "()Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "visitElement", "", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "visitAnonymousObjectExpression", "anonymousObjectExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirAnonymousObjectExpression;", "tooComplex", "checkers"})
    private static final class ComplexExpressionChecker
    extends FirDefaultVisitorVoid {
        @NotNull
        private final CheckerContext context;
        @NotNull
        private final DiagnosticReporter reporter;

        public ComplexExpressionChecker(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            this.context = context2;
            this.reporter = reporter;
        }

        @NotNull
        public final CheckerContext getContext() {
            return this.context;
        }

        @NotNull
        public final DiagnosticReporter getReporter() {
            return this.reporter;
        }

        @Override
        public void visitElement(@NotNull FirElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            element.acceptChildren(this);
        }

        @Override
        public void visitAnonymousObjectExpression(@NotNull FirAnonymousObjectExpression anonymousObjectExpression) {
            Intrinsics.checkNotNullParameter((Object)anonymousObjectExpression, (String)"anonymousObjectExpression");
            this.tooComplex(anonymousObjectExpression);
        }

        public final void tooComplex(@NotNull FirElement $this$tooComplex) {
            Intrinsics.checkNotNullParameter((Object)$this$tooComplex, (String)"<this>");
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)this.reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)$this$tooComplex.getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getVERSION_OVERLOADS_TOO_COMPLEX_EXPRESSION(), (DiagnosticContext)this.context, null, (int)8, null);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001B/\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0016\u0010\b\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001a\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R!\u0010\b\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirVersionOverloadsChecker$DependencyChecker;", "Lorg/jetbrains/kotlin/fir/visitors/FirDefaultVisitor;", "", "Lorg/jetbrains/kotlin/config/MavenComparableVersion;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "symbolVersions", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "<init>", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Ljava/util/Map;)V", "getContext", "()Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "getReporter", "()Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "getSymbolVersions", "()Ljava/util/Map;", "visitElement", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "data", "visitQualifiedAccessExpression", "qualifiedAccessExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "checkers"})
    private static final class DependencyChecker
    extends FirDefaultVisitor<Unit, MavenComparableVersion> {
        @NotNull
        private final CheckerContext context;
        @NotNull
        private final DiagnosticReporter reporter;
        @NotNull
        private final Map<FirCallableSymbol<?>, MavenComparableVersion> symbolVersions;

        public DependencyChecker(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull Map<FirCallableSymbol<?>, ? extends MavenComparableVersion> symbolVersions) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            Intrinsics.checkNotNullParameter(symbolVersions, (String)"symbolVersions");
            this.context = context2;
            this.reporter = reporter;
            this.symbolVersions = symbolVersions;
        }

        @NotNull
        public final CheckerContext getContext() {
            return this.context;
        }

        @NotNull
        public final DiagnosticReporter getReporter() {
            return this.reporter;
        }

        @NotNull
        public final Map<FirCallableSymbol<?>, MavenComparableVersion> getSymbolVersions() {
            return this.symbolVersions;
        }

        @Override
        public void visitElement(@NotNull FirElement element, @Nullable MavenComparableVersion data) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            element.acceptChildren(this, data);
        }

        @Override
        public void visitQualifiedAccessExpression(@NotNull FirQualifiedAccessExpression qualifiedAccessExpression, @Nullable MavenComparableVersion data) {
            Intrinsics.checkNotNullParameter((Object)qualifiedAccessExpression, (String)"qualifiedAccessExpression");
            FirCallableSymbol<?> firCallableSymbol = ReferenceUtilsKt.toResolvedCallableSymbol(qualifiedAccessExpression);
            if (firCallableSymbol == null) {
                return;
            }
            FirCallableSymbol<?> dependOnSymbol = firCallableSymbol;
            MavenComparableVersion dependVersion = this.symbolVersions.get(dependOnSymbol);
            if (INSTANCE.greaterThan(dependVersion, data)) {
                CheckerContext $this$visitQualifiedAccessExpression_u24lambda_u240 = this.context;
                boolean bl = false;
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)$this$visitQualifiedAccessExpression_u24lambda_u240, (DiagnosticReporter)this.reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)qualifiedAccessExpression.getSource()), FirErrors.INSTANCE.getINVALID_DEFAULT_VALUE_DEPENDENCY(), (Object)data, (Object)dependVersion, null, (int)32, null);
            }
        }
    }
}

