/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.experimental;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKt;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.experimental.RedundantInterpolationPrefixCheckerLiteralKt;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.expressions.FirLiteralExpression;
import org.jetbrains.kotlin.types.ConstantValueKind;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016R\u00020\nR\u00020\fj\u0006\u0010\u000b\u001a\u00020\nj\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0002\u0010\u000fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/experimental/RedundantInterpolationPrefixCheckerLiteral;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirLiteralExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirLiteralExpressionChecker;", "<init>", "()V", "redundancyRegex", "Lkotlin/text/Regex;", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirLiteralExpression;)V", "checkers"})
public final class RedundantInterpolationPrefixCheckerLiteral
extends FirExpressionChecker<FirLiteralExpression> {
    @NotNull
    public static final RedundantInterpolationPrefixCheckerLiteral INSTANCE = new RedundantInterpolationPrefixCheckerLiteral();
    @NotNull
    private static final Regex redundancyRegex = new Regex("(\\$+)(\\w|\\{|`[^`])");

    private RedundantInterpolationPrefixCheckerLiteral() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirLiteralExpression expression) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        String string = expression.getPrefix();
        if (string == null) {
            return;
        }
        int prefixLength = string.length();
        if (prefixLength == 1) {
            RedundantInterpolationPrefixCheckerLiteralKt.access$reportRedundantInterpolationPrefix(context2, reporter, expression);
        } else if (Intrinsics.areEqual((Object)expression.getKind(), (Object)ConstantValueKind.String.INSTANCE)) {
            CharSequence charSequence = KtSourceElementKt.getText((KtSourceElement)expression.getSource());
            if (charSequence == null || (charSequence = StringsKt.drop((CharSequence)charSequence, (int)prefixLength)) == null) {
                return;
            }
            CharSequence value = charSequence;
            if (!redundancyRegex.containsMatchIn(value)) {
                RedundantInterpolationPrefixCheckerLiteralKt.access$reportRedundantInterpolationPrefix(context2, reporter, expression);
            }
        }
    }
}

