/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.SessionHolder;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.resolve.AnnotationTargetList;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirDslMarkerUseSiteChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirAnnotationChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;)V", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirDslMarkerUseSiteChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirDslMarkerUseSiteChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirDslMarkerUseSiteChecker\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,37:1\n23#2,2:38\n*S KotlinDebug\n*F\n+ 1 FirDslMarkerUseSiteChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirDslMarkerUseSiteChecker\n*L\n30#1:38,2\n*E\n"})
public final class FirDslMarkerUseSiteChecker
extends FirExpressionChecker<FirAnnotation> {
    @NotNull
    public static final FirDslMarkerUseSiteChecker INSTANCE = new FirDslMarkerUseSiteChecker();

    private FirDslMarkerUseSiteChecker() {
        super(MppCheckerKind.Platform);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirAnnotation expression) {
        Object v0;
        FirRegularClassSymbol annotationClass;
        block6: {
            FirRegularClassSymbol firRegularClassSymbol;
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            FirRegularClassSymbol firRegularClassSymbol2 = TypeUtilsKt.toRegularClassSymbol(expression.getAnnotationTypeRef(), context2.getSession());
            if (firRegularClassSymbol2 == null || (firRegularClassSymbol = DeclarationUtilsKt.fullyExpandedClass(context2, firRegularClassSymbol2)) == null) {
                return;
            }
            annotationClass = firRegularClassSymbol;
            if (!FirAnnotationUtilsKt.hasAnnotation(annotationClass, StandardClassIds.Annotations.INSTANCE.getDslMarker(), context2.getSession())) {
                return;
            }
            Iterable $this$firstIsInstanceOrNull$iv = CollectionsKt.drop((Iterable)CollectionsKt.asReversed(context2.getContainingElements()), (int)1);
            boolean $i$f$firstIsInstanceOrNull = false;
            for (Object element$iv : $this$firstIsInstanceOrNull$iv) {
                if (!(element$iv instanceof FirAnnotationContainer)) continue;
                v0 = element$iv;
                break block6;
            }
            v0 = null;
        }
        FirAnnotationContainer firAnnotationContainer = v0;
        if (firAnnotationContainer == null) {
            return;
        }
        FirAnnotationContainer container = firAnnotationContainer;
        if (!(container instanceof FirClassLikeDeclaration) && !(container instanceof FirTypeRef)) {
            AnnotationTargetList actualTargets = FirHelpersKt.getActualTargetList((SessionHolder)context2, container);
            Object object = (KotlinTarget)CollectionsKt.firstOrNull((List)actualTargets.getDefaultTargets());
            if (object == null || (object = object.getDescription()) == null) {
                object = "unidentified target";
            }
            Object targetDescription = object;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)expression.getSource()), FirErrors.INSTANCE.getDSL_MARKER_APPLIED_TO_WRONG_TARGET(), (Object)annotationClass, (Object)targetDescription, null, (int)32, null);
        }
    }
}

