/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0002H\u0016R\u00020\rR\u00020\u000fj\u0006\u0010\u000e\u001a\u00020\rj\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0012R\u001a\u0010\u0006\u001a\u00020\u0007*\u0004\u0018\u00010\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirRecursiveProblemChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirBasicExpressionChecker;", "<init>", "()V", "shouldBeReported", "", "Lorg/jetbrains/kotlin/KtSourceElementKind;", "getShouldBeReported", "(Lorg/jetbrains/kotlin/KtSourceElementKind;)Z", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirStatement;)V", "checkers"})
public final class FirRecursiveProblemChecker
extends FirExpressionChecker<FirStatement> {
    @NotNull
    public static final FirRecursiveProblemChecker INSTANCE = new FirRecursiveProblemChecker();

    private FirRecursiveProblemChecker() {
        super(MppCheckerKind.Common);
    }

    private final boolean getShouldBeReported(KtSourceElementKind $this$shouldBeReported) {
        KtSourceElementKind ktSourceElementKind = $this$shouldBeReported;
        return !(ktSourceElementKind instanceof KtFakeSourceElementKind) ? true : ktSourceElementKind instanceof KtFakeSourceElementKind.OperatorOfCall;
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirStatement expression) {
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                if (!(expression instanceof FirExpression)) break block2;
                KtSourceElement ktSourceElement = ((FirExpression)expression).getSource();
                if (this.getShouldBeReported((KtSourceElementKind)(ktSourceElement != null ? ktSourceElement.getKind() : null))) break block3;
            }
            return;
        }
        FirRecursiveProblemChecker.check$checkConeType(expression, context2, reporter, FirTypeUtilsKt.getResolvedType((FirExpression)expression));
    }

    private static final void check$checkConeType(FirStatement $expression, CheckerContext $context, DiagnosticReporter $reporter, ConeKotlinType coneType) {
        ConeKotlinType coneKotlinType = coneType;
        boolean bl = coneKotlinType != null ? FirHelpersKt.hasDiagnosticKind(coneKotlinType, DiagnosticKind.RecursionInImplicitTypes) : false;
        if (bl) {
            KtSourceElement source = ((FirExpression)$expression).getSource();
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)$context, (DiagnosticReporter)$reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)source), (KtDiagnosticFactory0)FirErrors.INSTANCE.getTYPECHECKER_HAS_RUN_INTO_RECURSIVE_PROBLEM(), null, (int)8, null);
        } else if (coneType instanceof ConeClassLikeType) {
            for (ConeTypeProjection typeArgument : ((ConeClassLikeType)coneType).getTypeArguments()) {
                FirRecursiveProblemChecker.check$checkConeType($expression, $context, $reporter, ConeTypeProjectionKt.getType(typeArgument));
            }
        }
    }
}

