/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.extra;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.ImmutableCollection;
import kotlinx.collections.immutable.PersistentMap;
import kotlinx.collections.immutable.PersistentSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.analysis.cfa.AbstractFirPropertyInitializationChecker;
import org.jetbrains.kotlin.fir.analysis.cfa.FirPropertyInitializationAnalyzerKt;
import org.jetbrains.kotlin.fir.analysis.cfa.util.CfgTraverseDirection;
import org.jetbrains.kotlin.fir.analysis.cfa.util.CfgTraverserKt;
import org.jetbrains.kotlin.fir.analysis.cfa.util.PathAwareControlFlowGraphVisitor;
import org.jetbrains.kotlin.fir.analysis.cfa.util.VariableInitializationInfoData;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.extra.PropertyAccessType;
import org.jetbrains.kotlin.fir.analysis.checkers.extra.UnusedVariableAssignmentCheckerKt;
import org.jetbrains.kotlin.fir.analysis.checkers.extra.VariableAssignmentData;
import org.jetbrains.kotlin.fir.analysis.checkers.extra.VariableWriteData;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirImplicitInvokeCall;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNodeWithSubgraphs;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CapturedByValue;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraph;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraphVisitorVoid;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.Edge;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.EdgeLabel;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.FunctionCallExitNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.QualifiedAccessNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.VariableAssignmentNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.VariableDeclarationExitNode;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.visitors.FirVisitorVoid;
import org.jetbrains.kotlin.name.SpecialNames;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0004\u0012\u0013\u0014\u0015B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u00020\u0006R\u00020\bj\u0006\u0010\u0007\u001a\u00020\u0006j\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\fR\u0018\u0010\r\u001a\u00020\u000e*\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/UnusedVariableAssignmentChecker;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/AbstractFirPropertyInitializationChecker;", "<init>", "()V", "analyze", "", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "data", "Lorg/jetbrains/kotlin/fir/analysis/cfa/util/VariableInitializationInfoData;", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/analysis/cfa/util/VariableInitializationInfoData;)V", "ignoreWarnings", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "getIgnoreWarnings", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;)Z", "AddAllWrites", "FindCapturedWrites", "FindVisibleWrites", "RemoveVisibleWrites", "checkers"})
public final class UnusedVariableAssignmentChecker
extends AbstractFirPropertyInitializationChecker {
    @NotNull
    public static final UnusedVariableAssignmentChecker INSTANCE = new UnusedVariableAssignmentChecker();

    private UnusedVariableAssignmentChecker() {
        super(MppCheckerKind.Common);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void analyze(@NotNull DiagnosticReporter reporter, @NotNull CheckerContext context2, @NotNull VariableInitializationInfoData data) {
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Set<FirVariableSymbol<?>> set = data.getProperties();
        Intrinsics.checkNotNull(set, (String)"null cannot be cast to non-null type kotlin.collections.Set<org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol>");
        Set<FirVariableSymbol<?>> properties = set;
        VariableAssignmentData ownData = new VariableAssignmentData(properties);
        data.getGraph().traverse(new AddAllWrites(ownData));
        if (!((Collection)ownData.getUnreadWrites()).isEmpty()) {
            Map capturedWrites = CfgTraverserKt.traverseToFixedPoint(data.getGraph(), new FindCapturedWrites(properties));
            ownData.setWritesByNode(CfgTraverserKt.traverseToFixedPoint(data.getGraph(), new FindVisibleWrites(capturedWrites, properties)));
        }
        data.getGraph().traverse(new RemoveVisibleWrites(ownData));
        Set variablesWithUnobservedWrites = new LinkedHashSet();
        for (FirStatement firStatement : ownData.getUnreadWrites()) {
            if (firStatement instanceof FirVariableAssignment) {
                Object object = ReferenceUtilsKt.getCalleeReference((FirVariableAssignment)firStatement);
                if (object == null || (object = FirReferenceUtilsKt.toResolvedPropertySymbol$default((FirReference)object, false, 1, null)) == null) continue;
                Object variableSymbol = object;
                variablesWithUnobservedWrites.add(variableSymbol);
                if (DeclarationAttributesKt.isDelegatedProperty((FirPropertySymbol)variableSymbol)) continue;
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)((FirVariableAssignment)firStatement).getLValue().getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getASSIGNED_VALUE_IS_NEVER_READ(), null, (int)8, null);
                continue;
            }
            if (!(firStatement instanceof FirProperty) || ownData.getVariablesWithoutReads().containsKey(((FirProperty)firStatement).getSymbol()) || this.getIgnoreWarnings(((FirProperty)firStatement).getSymbol())) continue;
            FirExpression firExpression = ((FirProperty)firStatement).getInitializer();
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)(firExpression != null ? firExpression.getSource() : null)), (KtDiagnosticFactory0)FirErrors.INSTANCE.getVARIABLE_INITIALIZER_IS_REDUNDANT(), null, (int)8, null);
        }
        for (Map.Entry entry : ownData.getVariablesWithoutReads().entrySet()) {
            KtDiagnosticFactory0 error;
            KtDiagnosticFactory0 ktDiagnosticFactory0;
            FirPropertySymbol symbol = (FirPropertySymbol)entry.getKey();
            FirProperty fir = (FirProperty)entry.getValue();
            if (this.getIgnoreWarnings(symbol)) continue;
            FirExpression firExpression = fir.getInitializer();
            FirFunctionCall firFunctionCall = firExpression instanceof FirFunctionCall ? (FirFunctionCall)firExpression : null;
            if ((firFunctionCall != null ? FirHelpersKt.isIterator(firFunctionCall) : false) || Intrinsics.areEqual((Object)ClassMembersKt.isCatchParameter(fir), (Object)true)) continue;
            if (variablesWithUnobservedWrites.contains(symbol)) {
                boolean bl = DeclarationAttributesKt.isDelegatedProperty(symbol);
                if (!bl) {
                    ktDiagnosticFactory0 = FirErrors.INSTANCE.getVARIABLE_NEVER_READ();
                } else {
                    if (!bl) throw new NoWhenBranchMatchedException();
                    ktDiagnosticFactory0 = null;
                }
            } else {
                ktDiagnosticFactory0 = FirErrors.INSTANCE.getUNUSED_VARIABLE();
            }
            if ((error = ktDiagnosticFactory0) == null) continue;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)fir.getSource()), (KtDiagnosticFactory0)error, null, (int)8, null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean getIgnoreWarnings(FirPropertySymbol $this$ignoreWarnings) {
        if (Intrinsics.areEqual((Object)$this$ignoreWarnings.getName(), (Object)SpecialNames.UNDERSCORE_FOR_UNUSED_VAR)) return true;
        if ($this$ignoreWarnings.getSource() == null) return true;
        KtSourceElement ktSourceElement = $this$ignoreWarnings.getSource();
        if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind.DesugaredAugmentedAssign) return true;
        KtSourceElement ktSourceElement2 = $this$ignoreWarnings.getSource();
        if (Intrinsics.areEqual((Object)(ktSourceElement2 != null ? ktSourceElement2.getElementType() : null), (Object)KtNodeTypes.DESTRUCTURING_DECLARATION)) return true;
        KtSourceElement ktSourceElement3 = $this$ignoreWarnings.getInitializerSource();
        if (!Intrinsics.areEqual((Object)(ktSourceElement3 != null ? ktSourceElement3.getKind() : null), (Object)KtFakeSourceElementKind.DesugaredForLoop.INSTANCE)) return false;
        return true;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/UnusedVariableAssignmentChecker$AddAllWrites;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraphVisitorVoid;", "data", "Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/VariableAssignmentData;", "<init>", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/VariableAssignmentData;)V", "visitNode", "", "node", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "visitVariableDeclarationExitNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableDeclarationExitNode;", "visitVariableAssignmentNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableAssignmentNode;", "checkers"})
    private static final class AddAllWrites
    extends ControlFlowGraphVisitorVoid {
        @NotNull
        private final VariableAssignmentData data;

        public AddAllWrites(@NotNull VariableAssignmentData data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            this.data = data;
        }

        @Override
        public void visitNode(@NotNull CFGNode<?> node) {
            Intrinsics.checkNotNullParameter(node, (String)"node");
        }

        @Override
        public void visitVariableDeclarationExitNode(@NotNull VariableDeclarationExitNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (node.getFir().getName().isSpecial()) {
                return;
            }
            ControlFlowGraph graph = FirPropertyInitializationAnalyzerKt.nearestNonInPlaceGraph(node.getOwner());
            if (node.getFir().getInitializer() != null) {
                this.data.getUnreadWrites().add(node.getFir());
            }
            this.data.getVariableScopes().put(node.getFir().getSymbol(), graph);
            this.data.getVariablesWithoutReads().put(node.getFir().getSymbol(), node.getFir());
        }

        @Override
        public void visitVariableAssignmentNode(@NotNull VariableAssignmentNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Object object = ReferenceUtilsKt.getCalleeReference(node.getFir());
            if (object == null || (object = FirReferenceUtilsKt.toResolvedPropertySymbol$default((FirReference)object, false, 1, null)) == null) {
                return;
            }
            Object propertySymbol = object;
            if (((FirVariableSymbol)propertySymbol).getName().isSpecial()) {
                return;
            }
            if (this.data.getLocalProperties().contains(propertySymbol)) {
                this.data.getUnreadWrites().add(node.getFir());
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJx\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\nj\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\u000b2\"\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\nj\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\u000b2\"\u0010\r\u001a\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\nj\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\u000b2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0016J\u00a0\u0001\u0010\u0010\u001a:\u0012\u0004\u0012\u00020\u0011\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\nj\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\u000b0\nj\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\u00122\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u000f2\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0015\u001a\u00020\u00162>\u0010\u0017\u001a:\u0012\u0004\u0012\u00020\u0011\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\nj\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\u000b0\nj\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\u0012H\u0016J\u0088\u0001\u0010\u0018\u001a:\u0012\u0004\u0012\u00020\u0011\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\nj\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\u000b0\nj\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\u00122\u0006\u0010\u000e\u001a\u00020\u00192>\u0010\u0017\u001a:\u0012\u0004\u0012\u00020\u0011\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\nj\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\u000b0\nj\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\u0012H\u0016J\u0088\u0001\u0010\u001a\u001a:\u0012\u0004\u0012\u00020\u0011\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\nj\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\u000b0\nj\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\u00122\u0006\u0010\u000e\u001a\u00020\u001b2>\u0010\u0017\u001a:\u0012\u0004\u0012\u00020\u0011\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\nj\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\u000b0\nj\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\u0012H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/UnusedVariableAssignmentChecker$FindCapturedWrites;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/util/PathAwareControlFlowGraphVisitor;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/PropertyAccessType;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/VariableWriteData;", "properties", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "<init>", "(Ljava/util/Set;)V", "mergeInfo", "Lkotlinx/collections/immutable/PersistentMap;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/util/ControlFlowInfo;", "a", "b", "node", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "visitEdge", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/EdgeLabel;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/util/PathAwareControlFlowInfo;", "from", "to", "metadata", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/Edge;", "data", "visitVariableDeclarationExitNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableDeclarationExitNode;", "visitVariableAssignmentNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableAssignmentNode;", "checkers"})
    @SourceDebugExtension(value={"SMAP\nUnusedVariableAssignmentChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnusedVariableAssignmentChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/extra/UnusedVariableAssignmentChecker$FindCapturedWrites\n+ 2 PathAwareControlFlowGraphVisitor.kt\norg/jetbrains/kotlin/fir/analysis/cfa/util/PathAwareControlFlowGraphVisitorKt\n+ 3 extensions.kt\nkotlinx/collections/immutable/ExtensionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,428:1\n83#2:429\n84#2:431\n85#2:435\n87#2:438\n53#3:430\n415#4:432\n1266#5,2:433\n1269#5:437\n1#6:436\n1#6:439\n*S KotlinDebug\n*F\n+ 1 UnusedVariableAssignmentChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/extra/UnusedVariableAssignmentChecker$FindCapturedWrites\n*L\n178#1:429\n178#1:431\n178#1:435\n178#1:438\n178#1:430\n178#1:432\n178#1:433,2\n178#1:437\n178#1:436\n*E\n"})
    private static final class FindCapturedWrites
    extends PathAwareControlFlowGraphVisitor<PropertyAccessType, VariableWriteData> {
        @NotNull
        private final Set<FirPropertySymbol> properties;

        public FindCapturedWrites(@NotNull Set<? extends FirPropertySymbol> properties) {
            Intrinsics.checkNotNullParameter(properties, (String)"properties");
            super(CfgTraverseDirection.Backward);
            this.properties = properties;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public PersistentMap<PropertyAccessType, VariableWriteData> mergeInfo(@NotNull PersistentMap<PropertyAccessType, VariableWriteData> a, @NotNull PersistentMap<PropertyAccessType, VariableWriteData> b, @NotNull CFGNode<?> node) {
            void $this$associateByTo$iv$iv$iv;
            void $this$mapValuesTo$iv$iv;
            void $this$merge$iv;
            Intrinsics.checkNotNullParameter(a, (String)"a");
            Intrinsics.checkNotNullParameter(b, (String)"b");
            Intrinsics.checkNotNullParameter(node, (String)"node");
            PersistentMap<PropertyAccessType, VariableWriteData> persistentMap = a;
            PersistentMap<PropertyAccessType, VariableWriteData> other$iv = b;
            boolean $i$f$merge = false;
            void $this$mutate$iv$iv = $this$merge$iv;
            boolean $i$f$mutate = false;
            PersistentMap.Builder builder2 = $this$mutate$iv$iv.builder();
            Map it$iv = (Map)builder2;
            boolean bl = false;
            Map map2 = (Map)other$iv;
            Map destination$iv$iv = it$iv;
            boolean $i$f$mapValuesTo = false;
            Iterable iterable = $this$mapValuesTo$iv$iv.entrySet();
            Map destination$iv$iv$iv = destination$iv$iv;
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                Object object;
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map3 = destination$iv$iv$iv;
                boolean bl2 = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                Map map4 = map3;
                boolean bl3 = false;
                Object label$iv = entry2.getKey();
                Object rightValue$iv = entry2.getValue();
                if ($this$merge$iv.get(label$iv) != null) {
                    void p1;
                    Object leftValue$iv;
                    boolean bl4 = false;
                    PersistentMap persistentMap2 = ((VariableWriteData)rightValue$iv).unbox-impl();
                    PersistentMap p0 = ((VariableWriteData)leftValue$iv).unbox-impl();
                    boolean bl5 = false;
                    object = VariableWriteData.box-impl(VariableWriteData.plus-JgvPeUI(p0, p1));
                } else {
                    object = rightValue$iv;
                }
                Object v = object;
                map4.put(k, v);
            }
            return builder2.build();
        }

        @Override
        @NotNull
        public PersistentMap<EdgeLabel, PersistentMap<PropertyAccessType, VariableWriteData>> visitEdge(@NotNull CFGNode<?> from, @NotNull CFGNode<?> to2, @NotNull Edge metadata, @NotNull PersistentMap<EdgeLabel, ? extends PersistentMap<PropertyAccessType, VariableWriteData>> data) {
            Intrinsics.checkNotNullParameter(from, (String)"from");
            Intrinsics.checkNotNullParameter(to2, (String)"to");
            Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
            Intrinsics.checkNotNullParameter(data, (String)"data");
            if (Intrinsics.areEqual((Object)metadata.getLabel(), (Object)CapturedByValue.INSTANCE)) {
                return ExtensionsKt.persistentMapOf();
            }
            return from instanceof VariableDeclarationExitNode ? super.visitEdge(from, to2, metadata, UnusedVariableAssignmentCheckerKt.access$remove(data, ((VariableDeclarationExitNode)from).getFir().getSymbol())) : super.visitEdge(from, to2, metadata, data);
        }

        @Override
        @NotNull
        public PersistentMap<EdgeLabel, PersistentMap<PropertyAccessType, VariableWriteData>> visitVariableDeclarationExitNode(@NotNull VariableDeclarationExitNode node, @NotNull PersistentMap<EdgeLabel, ? extends PersistentMap<PropertyAccessType, VariableWriteData>> data) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter(data, (String)"data");
            return node.getFir().getName().isSpecial() || node.getFir().getInitializer() == null ? data : UnusedVariableAssignmentCheckerKt.access$add(data, PropertyAccessType.Captured, node.getFir().getSymbol(), node);
        }

        @Override
        @NotNull
        public PersistentMap<EdgeLabel, PersistentMap<PropertyAccessType, VariableWriteData>> visitVariableAssignmentNode(@NotNull VariableAssignmentNode node, @NotNull PersistentMap<EdgeLabel, ? extends PersistentMap<PropertyAccessType, VariableWriteData>> data) {
            Object object;
            block5: {
                block4: {
                    Object object2;
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    Intrinsics.checkNotNullParameter(data, (String)"data");
                    object = ReferenceUtilsKt.getCalleeReference(node.getFir());
                    if (object == null || (object = FirReferenceUtilsKt.toResolvedPropertySymbol$default((FirReference)object, false, 1, null)) == null) break block4;
                    Object it = object2 = object;
                    boolean bl = false;
                    object = this.properties.contains(it) ? object2 : null;
                    if (object != null) break block5;
                }
                return data;
            }
            Object symbol = object;
            if (((FirVariableSymbol)symbol).getName().isSpecial()) {
                return data;
            }
            return UnusedVariableAssignmentCheckerKt.access$add(data, PropertyAccessType.Captured, (FirPropertySymbol)symbol, node);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001Be\u0012N\u0010\u0004\u001aJ\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012<\u0012:\u0012\u0004\u0012\u00020\b\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0007j\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\t0\u0007j\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\n0\u0005\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJx\u0010\u0010\u001a\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0007j\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\t2\"\u0010\u0011\u001a\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0007j\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\t2\"\u0010\u0012\u001a\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0007j\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\t2\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0016J\u00a0\u0001\u0010\u0014\u001a:\u0012\u0004\u0012\u00020\b\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0007j\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\t0\u0007j\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\n2\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u00062\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0017\u001a\u00020\u00182>\u0010\u0019\u001a:\u0012\u0004\u0012\u00020\b\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0007j\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\t0\u0007j\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\nH\u0016J\u0088\u0001\u0010\u001a\u001a:\u0012\u0004\u0012\u00020\b\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0007j\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\t0\u0007j\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\n2\u0006\u0010\u0013\u001a\u00020\u001b2>\u0010\u0019\u001a:\u0012\u0004\u0012\u00020\b\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0007j\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\t0\u0007j\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\nH\u0016J\u0088\u0001\u0010\u001c\u001a:\u0012\u0004\u0012\u00020\b\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0007j\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\t0\u0007j\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\n2\u0006\u0010\u0013\u001a\u00020\u001d2>\u0010\u0019\u001a:\u0012\u0004\u0012\u00020\b\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0007j\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\t0\u0007j\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\nH\u0016RV\u0010\u0004\u001aJ\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012<\u0012:\u0012\u0004\u0012\u00020\b\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0007j\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\t0\u0007j\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\n0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/UnusedVariableAssignmentChecker$FindVisibleWrites;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/util/PathAwareControlFlowGraphVisitor;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/PropertyAccessType;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/VariableWriteData;", "futureWrites", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "Lkotlinx/collections/immutable/PersistentMap;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/EdgeLabel;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/util/ControlFlowInfo;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/util/PathAwareControlFlowInfo;", "properties", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "<init>", "(Ljava/util/Map;Ljava/util/Set;)V", "mergeInfo", "a", "b", "node", "visitEdge", "from", "to", "metadata", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/Edge;", "data", "visitVariableDeclarationExitNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableDeclarationExitNode;", "visitVariableAssignmentNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableAssignmentNode;", "checkers"})
    @SourceDebugExtension(value={"SMAP\nUnusedVariableAssignmentChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnusedVariableAssignmentChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/extra/UnusedVariableAssignmentChecker$FindVisibleWrites\n+ 2 PathAwareControlFlowGraphVisitor.kt\norg/jetbrains/kotlin/fir/analysis/cfa/util/PathAwareControlFlowGraphVisitorKt\n+ 3 extensions.kt\nkotlinx/collections/immutable/ExtensionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,428:1\n83#2:429\n84#2:431\n85#2:435\n87#2:438\n83#2:439\n84#2:441\n85#2:445\n87#2:448\n83#2:449\n84#2:451\n85#2:455\n87#2:458\n53#3:430\n53#3:440\n53#3:450\n415#4:432\n415#4:442\n415#4:452\n1266#5,2:433\n1269#5:437\n1266#5,2:443\n1269#5:447\n1266#5,2:453\n1269#5:457\n1#6:436\n1#6:446\n1#6:456\n1#6:459\n*S KotlinDebug\n*F\n+ 1 UnusedVariableAssignmentChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/extra/UnusedVariableAssignmentChecker$FindVisibleWrites\n*L\n229#1:429\n229#1:431\n229#1:435\n229#1:438\n249#1:439\n249#1:441\n249#1:445\n249#1:448\n259#1:449\n259#1:451\n259#1:455\n259#1:458\n229#1:430\n249#1:440\n259#1:450\n229#1:432\n249#1:442\n259#1:452\n229#1:433,2\n229#1:437\n249#1:443,2\n249#1:447\n259#1:453,2\n259#1:457\n229#1:436\n249#1:446\n259#1:456\n*E\n"})
    private static final class FindVisibleWrites
    extends PathAwareControlFlowGraphVisitor<PropertyAccessType, VariableWriteData> {
        @NotNull
        private final Map<CFGNode<?>, PersistentMap<EdgeLabel, PersistentMap<PropertyAccessType, VariableWriteData>>> futureWrites;
        @NotNull
        private final Set<FirPropertySymbol> properties;

        public FindVisibleWrites(@NotNull Map<CFGNode<?>, ? extends PersistentMap<EdgeLabel, ? extends PersistentMap<PropertyAccessType, VariableWriteData>>> futureWrites, @NotNull Set<? extends FirPropertySymbol> properties) {
            Intrinsics.checkNotNullParameter(futureWrites, (String)"futureWrites");
            Intrinsics.checkNotNullParameter(properties, (String)"properties");
            super(null, 1, null);
            this.futureWrites = futureWrites;
            this.properties = properties;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public PersistentMap<PropertyAccessType, VariableWriteData> mergeInfo(@NotNull PersistentMap<PropertyAccessType, VariableWriteData> a, @NotNull PersistentMap<PropertyAccessType, VariableWriteData> b, @NotNull CFGNode<?> node) {
            void $this$associateByTo$iv$iv$iv;
            void $this$mapValuesTo$iv$iv;
            void $this$merge$iv;
            Intrinsics.checkNotNullParameter(a, (String)"a");
            Intrinsics.checkNotNullParameter(b, (String)"b");
            Intrinsics.checkNotNullParameter(node, (String)"node");
            PersistentMap<PropertyAccessType, VariableWriteData> persistentMap = a;
            PersistentMap<PropertyAccessType, VariableWriteData> other$iv = b;
            boolean $i$f$merge = false;
            void $this$mutate$iv$iv = $this$merge$iv;
            boolean $i$f$mutate = false;
            PersistentMap.Builder builder2 = $this$mutate$iv$iv.builder();
            Map it$iv = (Map)builder2;
            boolean bl = false;
            Map map2 = (Map)other$iv;
            Map destination$iv$iv = it$iv;
            boolean $i$f$mapValuesTo = false;
            Iterable iterable = $this$mapValuesTo$iv$iv.entrySet();
            Map destination$iv$iv$iv = destination$iv$iv;
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                Object object;
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map3 = destination$iv$iv$iv;
                boolean bl2 = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                Map map4 = map3;
                boolean bl3 = false;
                Object label$iv = entry2.getKey();
                Object rightValue$iv = entry2.getValue();
                if ($this$merge$iv.get(label$iv) != null) {
                    void p1;
                    Object leftValue$iv;
                    boolean bl4 = false;
                    PersistentMap persistentMap2 = ((VariableWriteData)rightValue$iv).unbox-impl();
                    PersistentMap p0 = ((VariableWriteData)leftValue$iv).unbox-impl();
                    boolean bl5 = false;
                    object = VariableWriteData.box-impl(VariableWriteData.plus-JgvPeUI(p0, p1));
                } else {
                    object = rightValue$iv;
                }
                Object v = object;
                map4.put(k, v);
            }
            return builder2.build();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public PersistentMap<EdgeLabel, PersistentMap<PropertyAccessType, VariableWriteData>> visitEdge(@NotNull CFGNode<?> from, @NotNull CFGNode<?> to2, @NotNull Edge metadata, @NotNull PersistentMap<EdgeLabel, ? extends PersistentMap<PropertyAccessType, VariableWriteData>> data) {
            PersistentMap result2;
            block13: {
                ControlFlowGraph fromGraph2;
                block12: {
                    void $this$associateByTo$iv$iv$iv;
                    void $this$mapValuesTo$iv$iv;
                    void $this$merge$iv;
                    Intrinsics.checkNotNullParameter(from, (String)"from");
                    Intrinsics.checkNotNullParameter(to2, (String)"to");
                    Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
                    Intrinsics.checkNotNullParameter(data, (String)"data");
                    if (Intrinsics.areEqual((Object)metadata.getLabel(), (Object)CapturedByValue.INSTANCE)) {
                        return ExtensionsKt.persistentMapOf();
                    }
                    result2 = super.visitEdge(from, to2, metadata, data);
                    fromGraph2 = FirPropertyInitializationAnalyzerKt.nearestNonInPlaceGraph(from.getOwner());
                    ControlFlowGraph toGraph = FirPropertyInitializationAnalyzerKt.nearestNonInPlaceGraph(to2.getOwner());
                    if (Intrinsics.areEqual((Object)fromGraph2, (Object)toGraph)) break block12;
                    PersistentMap<EdgeLabel, PersistentMap<PropertyAccessType, VariableWriteData>> capturedWrites = this.futureWrites.get(from);
                    if (capturedWrites == null) break block13;
                    PersistentMap<EdgeLabel, PersistentMap<PropertyAccessType, VariableWriteData>> parentInfo = super.visitEdge(from, to2, metadata, capturedWrites);
                    PersistentMap persistentMap = result2;
                    PersistentMap<EdgeLabel, PersistentMap<PropertyAccessType, VariableWriteData>> other$iv = parentInfo;
                    boolean $i$f$merge = false;
                    void $this$mutate$iv$iv = $this$merge$iv;
                    boolean $i$f$mutate = false;
                    PersistentMap.Builder builder2 = $this$mutate$iv$iv.builder();
                    Map it$iv = (Map)builder2;
                    boolean bl = false;
                    Map map2 = (Map)other$iv;
                    Map destination$iv$iv = it$iv;
                    boolean $i$f$mapValuesTo = false;
                    Iterable iterable = $this$mapValuesTo$iv$iv.entrySet();
                    Map destination$iv$iv$iv = destination$iv$iv;
                    boolean $i$f$associateByTo = false;
                    for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                        PersistentMap<PropertyAccessType, VariableWriteData> persistentMap2;
                        Map map3;
                        Object k;
                        block15: {
                            Object rightValue$iv;
                            block14: {
                                void b;
                                void it$iv$iv;
                                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                                Map map4 = destination$iv$iv$iv;
                                boolean bl2 = false;
                                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                                k = it$iv$iv.getKey();
                                map3 = map4;
                                boolean bl3 = false;
                                Object label$iv = entry2.getKey();
                                rightValue$iv = entry2.getValue();
                                persistentMap2 = $this$merge$iv.get(label$iv);
                                if (persistentMap2 == null) break block14;
                                PersistentMap<PropertyAccessType, VariableWriteData> leftValue$iv = persistentMap2;
                                boolean bl4 = false;
                                PersistentMap persistentMap3 = (PersistentMap)rightValue$iv;
                                PersistentMap a = (PersistentMap)leftValue$iv;
                                boolean bl5 = false;
                                PersistentMap<PropertyAccessType, VariableWriteData> persistentMap4 = this.mergeInfo((PersistentMap<PropertyAccessType, VariableWriteData>)a, (PersistentMap<PropertyAccessType, VariableWriteData>)b, to2);
                                persistentMap2 = persistentMap4;
                                if (persistentMap4 != null) break block15;
                            }
                            persistentMap2 = rightValue$iv;
                        }
                        PersistentMap<PropertyAccessType, VariableWriteData> persistentMap5 = persistentMap2;
                        map3.put(k, persistentMap5);
                    }
                    result2 = builder2.build();
                    break block13;
                }
                if (!(from instanceof CFGNodeWithSubgraphs)) break block13;
                for (ControlFlowGraph subGraph : ((CFGNodeWithSubgraphs)from).getSubGraphs()) {
                    void $this$associateByTo$iv$iv$iv;
                    void $this$mapValuesTo$iv$iv;
                    void $this$merge$iv;
                    if (Intrinsics.areEqual((Object)fromGraph2, (Object)FirPropertyInitializationAnalyzerKt.nearestNonInPlaceGraph(subGraph))) continue;
                    CFGNode<?> node = subGraph.getEnterNode();
                    PersistentMap<EdgeLabel, PersistentMap<PropertyAccessType, VariableWriteData>> persistentMap = this.futureWrites.get(node);
                    if (persistentMap == null) continue;
                    PersistentMap<EdgeLabel, PersistentMap<PropertyAccessType, VariableWriteData>> nodeData = super.visitEdge(from, node, metadata, persistentMap);
                    PersistentMap $i$f$merge = result2;
                    PersistentMap<EdgeLabel, PersistentMap<PropertyAccessType, VariableWriteData>> other$iv = nodeData;
                    boolean $i$f$merge2 = false;
                    void $this$mutate$iv$iv = $this$merge$iv;
                    boolean $i$f$mutate = false;
                    PersistentMap.Builder builder3 = $this$mutate$iv$iv.builder();
                    Map it$iv = (Map)builder3;
                    boolean bl = false;
                    Map $i$f$mapValuesTo = (Map)other$iv;
                    Map destination$iv$iv = it$iv;
                    boolean $i$f$mapValuesTo2 = false;
                    Iterable $i$f$associateByTo = $this$mapValuesTo$iv$iv.entrySet();
                    Map destination$iv$iv$iv = destination$iv$iv;
                    boolean $i$f$associateByTo2 = false;
                    for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                        PersistentMap<PropertyAccessType, VariableWriteData> persistentMap6;
                        Map map5;
                        Object k;
                        block17: {
                            Object rightValue$iv;
                            block16: {
                                void b;
                                void it$iv$iv;
                                Map.Entry bl2 = (Map.Entry)element$iv$iv$iv;
                                Map map6 = destination$iv$iv$iv;
                                boolean $i$a$-associateByTo-MapsKt__MapsKt$mapValuesTo$1$iv$iv2 = false;
                                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                                k = it$iv$iv.getKey();
                                map5 = map6;
                                boolean bl6 = false;
                                Object label$iv = entry.getKey();
                                rightValue$iv = entry.getValue();
                                persistentMap6 = $this$merge$iv.get(label$iv);
                                if (persistentMap6 == null) break block16;
                                PersistentMap<PropertyAccessType, VariableWriteData> leftValue$iv = persistentMap6;
                                boolean bl7 = false;
                                PersistentMap bl5 = (PersistentMap)rightValue$iv;
                                PersistentMap a = (PersistentMap)leftValue$iv;
                                boolean bl8 = false;
                                PersistentMap<PropertyAccessType, VariableWriteData> persistentMap7 = this.mergeInfo((PersistentMap<PropertyAccessType, VariableWriteData>)a, (PersistentMap<PropertyAccessType, VariableWriteData>)b, to2);
                                persistentMap6 = persistentMap7;
                                if (persistentMap7 != null) break block17;
                            }
                            persistentMap6 = rightValue$iv;
                        }
                        PersistentMap<PropertyAccessType, VariableWriteData> persistentMap8 = persistentMap6;
                        map5.put(k, persistentMap8);
                    }
                    result2 = builder3.build();
                }
            }
            return result2;
        }

        @Override
        @NotNull
        public PersistentMap<EdgeLabel, PersistentMap<PropertyAccessType, VariableWriteData>> visitVariableDeclarationExitNode(@NotNull VariableDeclarationExitNode node, @NotNull PersistentMap<EdgeLabel, ? extends PersistentMap<PropertyAccessType, VariableWriteData>> data) {
            PersistentMap persistentMap;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter(data, (String)"data");
            if (node.getFir().getName().isSpecial()) {
                persistentMap = data;
            } else {
                PersistentSet persistentSet;
                PersistentMap persistentMap2 = UnusedVariableAssignmentCheckerKt.access$remove(data, node.getFir().getSymbol());
                FirPropertySymbol firPropertySymbol = node.getFir().getSymbol();
                if (node.getFir().getInitializer() != null) {
                    Object[] objectArray = new VariableDeclarationExitNode[]{node};
                    persistentSet = ExtensionsKt.persistentSetOf((Object[])objectArray);
                } else {
                    persistentSet = ExtensionsKt.persistentSetOf();
                }
                persistentMap = UnusedVariableAssignmentCheckerKt.access$overwrite(persistentMap2, firPropertySymbol, persistentSet);
            }
            return persistentMap;
        }

        @Override
        @NotNull
        public PersistentMap<EdgeLabel, PersistentMap<PropertyAccessType, VariableWriteData>> visitVariableAssignmentNode(@NotNull VariableAssignmentNode node, @NotNull PersistentMap<EdgeLabel, ? extends PersistentMap<PropertyAccessType, VariableWriteData>> data) {
            Object object;
            block5: {
                block4: {
                    Object object2;
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    Intrinsics.checkNotNullParameter(data, (String)"data");
                    object = ReferenceUtilsKt.getCalleeReference(node.getFir());
                    if (object == null || (object = FirReferenceUtilsKt.toResolvedPropertySymbol$default((FirReference)object, false, 1, null)) == null) break block4;
                    Object it = object2 = object;
                    boolean bl = false;
                    object = this.properties.contains(it) ? object2 : null;
                    if (object != null) break block5;
                }
                return data;
            }
            Object symbol = object;
            if (((FirVariableSymbol)symbol).getName().isSpecial()) {
                return data;
            }
            Object[] objectArray = new VariableAssignmentNode[]{node};
            return UnusedVariableAssignmentCheckerKt.access$overwrite(data, (FirPropertySymbol)symbol, ExtensionsKt.persistentSetOf((Object[])objectArray));
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\rH\u0016J\u0014\u0010\u000e\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0002J\u001c\u0010\u000f\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/UnusedVariableAssignmentChecker$RemoveVisibleWrites;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraphVisitorVoid;", "data", "Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/VariableAssignmentData;", "<init>", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/VariableAssignmentData;)V", "visitNode", "", "node", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "visitQualifiedAccessNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/QualifiedAccessNode;", "visitFunctionCallExitNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/FunctionCallExitNode;", "visitAnnotations", "visitQualifiedAccess", "fir", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "checkers"})
    @SourceDebugExtension(value={"SMAP\nUnusedVariableAssignmentChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnusedVariableAssignmentChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/extra/UnusedVariableAssignmentChecker$RemoveVisibleWrites\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,428:1\n1#2:429\n1915#3,2:430\n1915#3,2:432\n*S KotlinDebug\n*F\n+ 1 UnusedVariableAssignmentChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/extra/UnusedVariableAssignmentChecker$RemoveVisibleWrites\n*L\n307#1:430,2\n325#1:432,2\n*E\n"})
    private static final class RemoveVisibleWrites
    extends ControlFlowGraphVisitorVoid {
        @NotNull
        private final VariableAssignmentData data;

        public RemoveVisibleWrites(@NotNull VariableAssignmentData data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            this.data = data;
        }

        @Override
        public void visitNode(@NotNull CFGNode<?> node) {
            Intrinsics.checkNotNullParameter(node, (String)"node");
            this.visitAnnotations(node);
        }

        @Override
        public void visitQualifiedAccessNode(@NotNull QualifiedAccessNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            this.visitAnnotations(node);
            this.visitQualifiedAccess(node, node.getFir());
        }

        @Override
        public void visitFunctionCallExitNode(@NotNull FunctionCallExitNode node) {
            block0: {
                FirQualifiedAccessExpression firQualifiedAccessExpression;
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                this.visitAnnotations(node);
                FirFunctionCall firFunctionCall = node.getFir();
                FirExpression firExpression = firFunctionCall instanceof FirImplicitInvokeCall ? (FirImplicitInvokeCall)firFunctionCall : null;
                FirExpression firExpression2 = firExpression != null && (firExpression = firExpression.getExplicitReceiver()) != null ? FirExpressionUtilKt.unwrapSmartcastExpression(firExpression) : null;
                FirQualifiedAccessExpression firQualifiedAccessExpression2 = firQualifiedAccessExpression = firExpression2 instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)firExpression2 : null;
                if (firQualifiedAccessExpression == null) break block0;
                FirQualifiedAccessExpression it = firQualifiedAccessExpression;
                boolean bl = false;
                this.visitQualifiedAccess(node, it);
            }
        }

        private final void visitAnnotations(CFGNode<?> node) {
            block1: {
                Object obj = node.getFir();
                Object object = obj instanceof FirAnnotationContainer ? (FirAnnotationContainer)obj : null;
                if (object == null || (object = object.getAnnotations()) == null) break block1;
                Iterable $this$forEach$iv = (Iterable)object;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    FirAnnotation call = (FirAnnotation)element$iv;
                    boolean bl = false;
                    call.accept(new FirVisitorVoid(this, node){
                        final /* synthetic */ RemoveVisibleWrites this$0;
                        final /* synthetic */ CFGNode<?> $node;
                        {
                            this.this$0 = $receiver;
                            this.$node = $node;
                        }

                        public void visitElement(FirElement element) {
                            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                            if (element instanceof FirQualifiedAccessExpression) {
                                RemoveVisibleWrites.access$visitQualifiedAccess(this.this$0, this.$node, (FirQualifiedAccessExpression)element);
                            }
                            element.acceptChildren(this);
                        }
                    });
                }
            }
        }

        private final void visitQualifiedAccess(CFGNode<?> node, FirQualifiedAccessExpression fir) {
            FirPropertySymbol firPropertySymbol = FirReferenceUtilsKt.toResolvedPropertySymbol$default(fir.getCalleeReference(), false, 1, null);
            if (firPropertySymbol == null) {
                return;
            }
            FirPropertySymbol symbol = firPropertySymbol;
            if (symbol.getName().isSpecial()) {
                return;
            }
            this.data.getVariablesWithoutReads().remove(symbol);
            PersistentMap<EdgeLabel, PersistentMap<PropertyAccessType, VariableWriteData>> persistentMap = this.data.getWritesByNode().get(node);
            Collection collection = (Collection)(persistentMap != null ? (ImmutableCollection)persistentMap.values() : null);
            if (collection == null) {
                collection = CollectionsKt.emptyList();
            }
            for (PersistentMap visibleByLabel : collection) {
                Iterator iterator2 = ((ImmutableCollection)visibleByLabel.values()).iterator();
                while (iterator2.hasNext()) {
                    PersistentMap visible = ((VariableWriteData)iterator2.next()).unbox-impl();
                    PersistentSet<CFGNode<?>> persistentSet = VariableWriteData.get-impl(visible, symbol);
                    if (persistentSet == null) continue;
                    Iterable $this$forEach$iv = (Iterable)persistentSet;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        CFGNode it = (CFGNode)element$iv;
                        boolean bl = false;
                        Collection collection2 = this.data.getUnreadWrites();
                        Object e = it.getFir();
                        TypeIntrinsics.asMutableCollection((Object)collection2).remove(e);
                    }
                }
            }
        }

        public static final /* synthetic */ void access$visitQualifiedAccess(RemoveVisibleWrites $this, CFGNode node, FirQualifiedAccessExpression fir) {
            $this.visitQualifiedAccess(node, fir);
        }
    }
}

