/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.js.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.diagnostics.js.FirJsErrors;
import org.jetbrains.kotlin.fir.analysis.js.checkers.declaration.FirJsAbstractNativeIndexerChecker;
import org.jetbrains.kotlin.fir.declarations.FirNamedFunction;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.name.JsStandardClassIds;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u00020\u0006R\u00020\bj\u0006\u0010\u0007\u001a\u00020\u0006j\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsNativeSetterChecker;", "Lorg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsAbstractNativeIndexerChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirNamedFunction;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirNamedFunction;)V", "checkers.js"})
public final class FirJsNativeSetterChecker
extends FirJsAbstractNativeIndexerChecker {
    @NotNull
    public static final FirJsNativeSetterChecker INSTANCE = new FirJsNativeSetterChecker();

    private FirJsNativeSetterChecker() {
        super(JsStandardClassIds.Annotations.JsNativeSetter, "setter", 2);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirNamedFunction declaration) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (!this.hasRequiredAnnotation(context2, declaration)) {
            return;
        }
        super.check(context2, reporter, declaration);
        ConeKotlinType returnType = FirTypeUtilsKt.getConeType(declaration.getReturnTypeRef());
        if (ConeBuiltinTypeUtilsKt.isUnit(returnType)) {
            return;
        }
        if (declaration.getValueParameters().size() < 2) {
            return;
        }
        ConeKotlinType secondParameterType = FirTypeUtilsKt.getConeType(declaration.getValueParameters().get(1).getReturnTypeRef());
        if (TypeUtilsKt.isSubtypeOf$default(secondParameterType, returnType, context2.getSession(), false, 4, null)) {
            return;
        }
        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)declaration.getSource()), (KtDiagnosticFactory0)FirJsErrors.INSTANCE.getNATIVE_SETTER_WRONG_RETURN_TYPE(), null, (int)8, null);
    }
}

