/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.expression;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.LanguageVersionUtilsKt;
import org.jetbrains.kotlin.fir.SessionHolder;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u001d\u0010\u0002\u001a\u00020\u0003*\u00020\u0006H\u0000R\u00020\u0004j\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0007\u001a\u001d\u0010\b\u001a\u00020\u0003*\u00020\u0006H\u0000R\u00020\u0004j\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0007\u001a\u001d\u0010\t\u001a\u00020\u0003*\u00020\u0006H\u0000R\u00020\u0004j\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0007\u001a\f\u0010\n\u001a\u00020\u0003*\u00020\u0006H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"jdkInternalValueBasedAnnotationClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "isJavaValueBasedClass", "", "Lorg/jetbrains/kotlin/fir/SessionHolder;", "sessionHolder", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "(Lorg/jetbrains/kotlin/fir/SessionHolder;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)Z", "isJavaValueBasedClassAndWarningsEnabled", "isValueTypeAndWarningsEnabled", "isFlexiblePrimitive", "checkers.jvm"})
public final class FirJavaValueBasedClassUtilsKt {
    @NotNull
    private static final ClassId jdkInternalValueBasedAnnotationClassId = ClassId.Companion.fromString$default((ClassId.Companion)ClassId.Companion, (String)"jdk/internal/ValueBased", (boolean)false, (int)2, null);

    public static final boolean isJavaValueBasedClass(@NotNull SessionHolder sessionHolder, @NotNull ConeKotlinType $this$isJavaValueBasedClass) {
        Intrinsics.checkNotNullParameter((Object)sessionHolder, (String)"sessionHolder");
        Intrinsics.checkNotNullParameter((Object)$this$isJavaValueBasedClass, (String)"<this>");
        FirClassSymbol<?> firClassSymbol = ToSymbolUtilsKt.toClassSymbol(sessionHolder, $this$isJavaValueBasedClass);
        if (firClassSymbol == null) {
            return false;
        }
        FirClassSymbol<?> classSymbol = firClassSymbol;
        return FirAnnotationUtilsKt.hasAnnotation((FirBasedSymbol)classSymbol, jdkInternalValueBasedAnnotationClassId, sessionHolder.getSession());
    }

    public static final boolean isJavaValueBasedClassAndWarningsEnabled(@NotNull SessionHolder sessionHolder, @NotNull ConeKotlinType $this$isJavaValueBasedClassAndWarningsEnabled) {
        Intrinsics.checkNotNullParameter((Object)sessionHolder, (String)"sessionHolder");
        Intrinsics.checkNotNullParameter((Object)$this$isJavaValueBasedClassAndWarningsEnabled, (String)"<this>");
        return LanguageVersionUtilsKt.enableWarningsForValueBasedJavaClasses(sessionHolder) && FirJavaValueBasedClassUtilsKt.isJavaValueBasedClass(sessionHolder, $this$isJavaValueBasedClassAndWarningsEnabled);
    }

    public static final boolean isValueTypeAndWarningsEnabled(@NotNull SessionHolder sessionHolder, @NotNull ConeKotlinType $this$isValueTypeAndWarningsEnabled) {
        Intrinsics.checkNotNullParameter((Object)sessionHolder, (String)"sessionHolder");
        Intrinsics.checkNotNullParameter((Object)$this$isValueTypeAndWarningsEnabled, (String)"<this>");
        if (LanguageVersionUtilsKt.enableWarningsForIdentitySensitiveOperationsOnValueClassesAndPrimitives(sessionHolder) && (ConeBuiltinTypeUtilsKt.isPrimitiveOrNullablePrimitive($this$isValueTypeAndWarningsEnabled) || FirHelpersKt.isValueClass($this$isValueTypeAndWarningsEnabled, sessionHolder.getSession()) || FirJavaValueBasedClassUtilsKt.isFlexiblePrimitive($this$isValueTypeAndWarningsEnabled))) {
            return true;
        }
        return FirJavaValueBasedClassUtilsKt.isJavaValueBasedClassAndWarningsEnabled(sessionHolder, $this$isValueTypeAndWarningsEnabled);
    }

    public static final boolean isFlexiblePrimitive(@NotNull ConeKotlinType $this$isFlexiblePrimitive) {
        Intrinsics.checkNotNullParameter((Object)$this$isFlexiblePrimitive, (String)"<this>");
        return $this$isFlexiblePrimitive instanceof ConeFlexibleType && ConeBuiltinTypeUtilsKt.isPrimitiveOrNullablePrimitive(((ConeFlexibleType)$this$isFlexiblePrimitive).getLowerBound()) && ConeBuiltinTypeUtilsKt.isPrimitiveOrNullablePrimitive(((ConeFlexibleType)$this$isFlexiblePrimitive).getUpperBound());
    }
}

