/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.backend.utils.VariousUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirNamedFunction;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.ir.symbols.IrLocalDelegatedPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrVariableSymbol;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003BY\b\u0016\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\u0005\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u0005\u0012\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u0005\u00a2\u0006\u0004\b\u0002\u0010\u0011J\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001d\u001a\u00020\u0006J\u0016\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u0007J\u0010\u0010\"\u001a\u0004\u0018\u00010\n2\u0006\u0010#\u001a\u00020\tJ\u0016\u0010$\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020\t2\u0006\u0010&\u001a\u00020\nJ\u0010\u0010'\u001a\u0004\u0018\u00010\r2\u0006\u0010(\u001a\u00020\fJ\u0016\u0010)\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020\f2\u0006\u0010*\u001a\u00020\rJ\u0010\u0010+\u001a\u0004\u0018\u00010\u00102\u0006\u0010,\u001a\u00020\u000fJ\u0016\u0010-\u001a\u00020\u001f2\u0006\u0010.\u001a\u00020\u000f2\u0006\u0010/\u001a\u00020\u0010J\u0006\u00100\u001a\u000201J\u0018\u00102\u001a\u00020\u00002\u0010\u00103\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030504J\u0006\u00106\u001a\u00020\u001fR\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015R\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0015R\u001a\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0015\u00a8\u00067"}, d2={"Lorg/jetbrains/kotlin/fir/backend/Fir2IrScopeCache;", "", "<init>", "()V", "parameters", "", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "Lorg/jetbrains/kotlin/ir/symbols/IrValueParameterSymbol;", "variables", "Lorg/jetbrains/kotlin/fir/declarations/FirVariable;", "Lorg/jetbrains/kotlin/ir/symbols/IrVariableSymbol;", "localFunctions", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "delegatedProperties", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "Lorg/jetbrains/kotlin/ir/symbols/IrLocalDelegatedPropertySymbol;", "(Ljava/util/Map;Ljava/util/Map;Ljava/util/Map;Ljava/util/Map;)V", "parameterCache", "", "getParameters", "()Ljava/util/Map;", "variableCache", "getVariables", "localFunctionCache", "getLocalFunctions", "delegatedPropertyCache", "getDelegatedProperties", "getParameter", "parameter", "putParameter", "", "firParameter", "irParameterSymbol", "getVariable", "variable", "putVariable", "firVariable", "irVariableSymbol", "getLocalFunction", "localFunction", "putLocalFunction", "irFunctionSymbol", "getDelegatedProperty", "property", "putDelegatedProperty", "firProperty", "irPropertySymbol", "isEmpty", "", "cloneFilteringSymbols", "filterOutSymbols", "", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "clear", "fir2ir"})
@SourceDebugExtension(value={"SMAP\nFir2IrScopeCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Fir2IrScopeCache.kt\norg/jetbrains/kotlin/fir/backend/Fir2IrScopeCache\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,108:1\n22#2:109\n*S KotlinDebug\n*F\n+ 1 Fir2IrScopeCache.kt\norg/jetbrains/kotlin/fir/backend/Fir2IrScopeCache\n*L\n70#1:109\n*E\n"})
public final class Fir2IrScopeCache {
    @NotNull
    private final Map<FirValueParameter, IrValueParameterSymbol> parameterCache;
    @NotNull
    private final Map<FirVariable, IrVariableSymbol> variableCache;
    @NotNull
    private final Map<FirFunction, IrSimpleFunctionSymbol> localFunctionCache;
    @NotNull
    private final Map<FirProperty, IrLocalDelegatedPropertySymbol> delegatedPropertyCache;

    public Fir2IrScopeCache() {
        this.parameterCache = new LinkedHashMap();
        this.variableCache = new LinkedHashMap();
        this.localFunctionCache = new LinkedHashMap();
        this.delegatedPropertyCache = new LinkedHashMap();
    }

    @NotNull
    public final Map<FirValueParameter, IrValueParameterSymbol> getParameters() {
        return this.parameterCache;
    }

    @NotNull
    public final Map<FirVariable, IrVariableSymbol> getVariables() {
        return this.variableCache;
    }

    @NotNull
    public final Map<FirFunction, IrSimpleFunctionSymbol> getLocalFunctions() {
        return this.localFunctionCache;
    }

    @NotNull
    public final Map<FirProperty, IrLocalDelegatedPropertySymbol> getDelegatedProperties() {
        return this.delegatedPropertyCache;
    }

    public Fir2IrScopeCache(@NotNull Map<FirValueParameter, ? extends IrValueParameterSymbol> parameters2, @NotNull Map<FirVariable, ? extends IrVariableSymbol> variables, @NotNull Map<FirFunction, ? extends IrSimpleFunctionSymbol> localFunctions, @NotNull Map<FirProperty, ? extends IrLocalDelegatedPropertySymbol> delegatedProperties) {
        Intrinsics.checkNotNullParameter(parameters2, (String)"parameters");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        Intrinsics.checkNotNullParameter(localFunctions, (String)"localFunctions");
        Intrinsics.checkNotNullParameter(delegatedProperties, (String)"delegatedProperties");
        this();
        this.parameterCache.putAll(parameters2);
        this.variableCache.putAll(variables);
        this.localFunctionCache.putAll(localFunctions);
        this.delegatedPropertyCache.putAll(delegatedProperties);
    }

    @Nullable
    public final IrValueParameterSymbol getParameter(@NotNull FirValueParameter parameter) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        return this.parameterCache.get(parameter);
    }

    public final void putParameter(@NotNull FirValueParameter firParameter, @NotNull IrValueParameterSymbol irParameterSymbol) {
        Intrinsics.checkNotNullParameter((Object)firParameter, (String)"firParameter");
        Intrinsics.checkNotNullParameter((Object)irParameterSymbol, (String)"irParameterSymbol");
        this.parameterCache.put(firParameter, irParameterSymbol);
    }

    @Nullable
    public final IrVariableSymbol getVariable(@NotNull FirVariable variable) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        return this.variableCache.get(variable);
    }

    public final void putVariable(@NotNull FirVariable firVariable, @NotNull IrVariableSymbol irVariableSymbol) {
        Intrinsics.checkNotNullParameter((Object)firVariable, (String)"firVariable");
        Intrinsics.checkNotNullParameter((Object)irVariableSymbol, (String)"irVariableSymbol");
        this.variableCache.put(firVariable, irVariableSymbol);
    }

    @Nullable
    public final IrSimpleFunctionSymbol getLocalFunction(@NotNull FirFunction localFunction) {
        Intrinsics.checkNotNullParameter((Object)localFunction, (String)"localFunction");
        return this.localFunctionCache.get(localFunction);
    }

    /*
     * Unable to fully structure code
     */
    public final void putLocalFunction(@NotNull FirFunction localFunction, @NotNull IrSimpleFunctionSymbol irFunctionSymbol) {
        Intrinsics.checkNotNullParameter((Object)localFunction, (String)"localFunction");
        Intrinsics.checkNotNullParameter((Object)irFunctionSymbol, (String)"irFunctionSymbol");
        if (!(localFunction instanceof FirNamedFunction)) ** GOTO lbl-1000
        $this$visibility$iv = localFunction;
        $i$f$getVisibility = false;
        if (Intrinsics.areEqual((Object)$this$visibility$iv.getStatus().getVisibility(), (Object)Visibilities.Local.INSTANCE)) lbl-1000:
        // 2 sources

        {
            v0 = true;
        } else {
            v0 = false;
        }
        if (!v0) {
            $i$a$-require-Fir2IrScopeCache$putLocalFunction$1 = false;
            var4_5 = "Function is not local: " + UtilsKt.render(localFunction);
            throw new IllegalArgumentException(var4_5.toString());
        }
        this.localFunctionCache.put(localFunction, irFunctionSymbol);
    }

    @Nullable
    public final IrLocalDelegatedPropertySymbol getDelegatedProperty(@NotNull FirProperty property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        return this.delegatedPropertyCache.get(property);
    }

    public final void putDelegatedProperty(@NotNull FirProperty firProperty, @NotNull IrLocalDelegatedPropertySymbol irPropertySymbol) {
        Intrinsics.checkNotNullParameter((Object)firProperty, (String)"firProperty");
        Intrinsics.checkNotNullParameter((Object)irPropertySymbol, (String)"irPropertySymbol");
        this.delegatedPropertyCache.put(firProperty, irPropertySymbol);
    }

    public final boolean isEmpty() {
        return this.parameterCache.isEmpty() && this.variableCache.isEmpty() && this.localFunctionCache.isEmpty() && this.delegatedPropertyCache.isEmpty();
    }

    @NotNull
    public final Fir2IrScopeCache cloneFilteringSymbols(@NotNull Set<? extends FirBasedSymbol<?>> filterOutSymbols) {
        Intrinsics.checkNotNullParameter(filterOutSymbols, (String)"filterOutSymbols");
        return new Fir2IrScopeCache(VariousUtilsKt.filterOutSymbolsFromCache(this.getParameters(), filterOutSymbols), VariousUtilsKt.filterOutSymbolsFromCache(this.variableCache, filterOutSymbols), VariousUtilsKt.filterOutSymbolsFromCache(this.localFunctionCache, filterOutSymbols), VariousUtilsKt.filterOutSymbolsFromCache(this.delegatedPropertyCache, filterOutSymbols));
    }

    public final void clear() {
        this.parameterCache.clear();
        this.variableCache.clear();
        this.localFunctionCache.clear();
        this.delegatedPropertyCache.clear();
    }
}

