/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.declarations;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.Check;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirNamedFunction;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.OperatorDiagnostic;
import org.jetbrains.kotlin.fir.declarations.ValueClassesUtilsKt;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.resolve.ContainingClassUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.ScopeUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.scopes.ScopesKt;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeRigidType;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirImplicitTypeRef;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeConstructionUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.fir.types.impl.ConeClassLikeTypeImpl;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c2\u0002\u0018\u00002\u00020\u0001:\u0004'()*B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J<\u0010\u0004\u001a\u00020\u00052\u0018\b\u0002\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\t\u0018\u00010\u00072\u001a\u0010\n\u001a\u0016\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\r0\u000bJB\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0018\b\u0002\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\t\u0018\u00010\u00072\u0018\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00120\u000bR\u0011\u0010\u0013\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015R\u0011\u0010\u0018\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0015R\u0011\u0010\u001a\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0015R\u0011\u0010\u001c\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0015R\u0011\u0010\u001e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0015R\u0011\u0010 \u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0015R\u0011\u0010\"\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0015R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010&\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0015\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/fir/declarations/Checks;", "", "<init>", "()V", "full", "Lorg/jetbrains/kotlin/fir/declarations/Check;", "requiredResolvePhase", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/fir/declarations/FirNamedFunction;", "Lorg/jetbrains/kotlin/fir/declarations/FirResolvePhase;", "implementation", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/fir/FirSession;", "Lorg/jetbrains/kotlin/fir/declarations/OperatorDiagnostic;", "simple", "message", "", "predicate", "", "memberOrExtension", "getMemberOrExtension", "()Lorg/jetbrains/kotlin/fir/declarations/Check;", "member", "getMember", "notExtension", "getNotExtension", "noContextParameters", "getNoContextParameters", "nonSuspend", "getNonSuspend", "noDefaults", "getNoDefaults", "onlyLastVararg", "getOnlyLastVararg", "noDefaultAndVarargs", "getNoDefaultAndVarargs", "kPropertyType", "Lorg/jetbrains/kotlin/fir/types/impl/ConeClassLikeTypeImpl;", "isKProperty", "ValueParametersCount", "Returns", "EqualsOverridesEqualsOfAny", "FeatureIsSupported", "providers"})
@SourceDebugExtension(value={"SMAP\nOperatorFunctionChecks.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OperatorFunctionChecks.kt\norg/jetbrains/kotlin/fir/declarations/Checks\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,380:1\n54#2:381\n1786#3,3:382\n1786#3,3:385\n*S KotlinDebug\n*F\n+ 1 OperatorFunctionChecks.kt\norg/jetbrains/kotlin/fir/declarations/Checks\n*L\n218#1:381\n312#1:382,3\n320#1:385,3\n*E\n"})
final class Checks {
    @NotNull
    public static final Checks INSTANCE = new Checks();
    @NotNull
    private static final Check memberOrExtension = Checks.simple$default(INSTANCE, "must be a member or an extension function", null, Checks::memberOrExtension$lambda$0, 2, null);
    @NotNull
    private static final Check member = Checks.simple$default(INSTANCE, "must be a member function", null, Checks::member$lambda$0, 2, null);
    @NotNull
    private static final Check notExtension = Checks.simple$default(INSTANCE, "must not have an extension receiver", null, Checks::notExtension$lambda$0, 2, null);
    @NotNull
    private static final Check noContextParameters = Checks.simple$default(INSTANCE, "must not have context parameters", null, Checks::noContextParameters$lambda$0, 2, null);
    @NotNull
    private static final Check nonSuspend = INSTANCE.simple("must not be suspend", (Function1<? super FirNamedFunction, ? extends FirResolvePhase>)((Function1)Checks::nonSuspend$lambda$0), (Function2<? super FirNamedFunction, ? super FirSession, Boolean>)((Function2)Checks::nonSuspend$lambda$1));
    @NotNull
    private static final Check noDefaults = INSTANCE.simple("must not have parameters with default values", (Function1<? super FirNamedFunction, ? extends FirResolvePhase>)((Function1)Checks::noDefaults$lambda$0), (Function2<? super FirNamedFunction, ? super FirSession, Boolean>)((Function2)Checks::noDefaults$lambda$1));
    @NotNull
    private static final Check onlyLastVararg = INSTANCE.simple("must not have vararg parameters other than the last one", (Function1<? super FirNamedFunction, ? extends FirResolvePhase>)((Function1)Checks::onlyLastVararg$lambda$0), (Function2<? super FirNamedFunction, ? super FirSession, Boolean>)((Function2)Checks::onlyLastVararg$lambda$1));
    @NotNull
    private static final Check noDefaultAndVarargs = INSTANCE.full((Function1<? super FirNamedFunction, ? extends FirResolvePhase>)((Function1)Checks::noDefaultAndVarargs$lambda$0), (Function2<? super FirNamedFunction, ? super FirSession, ? extends OperatorDiagnostic>)((Function2)Checks::noDefaultAndVarargs$lambda$1));
    @NotNull
    private static final ConeClassLikeTypeImpl kPropertyType;
    @NotNull
    private static final Check isKProperty;

    private Checks() {
    }

    @NotNull
    public final Check full(@Nullable Function1<? super FirNamedFunction, ? extends FirResolvePhase> requiredResolvePhase, @NotNull Function2<? super FirNamedFunction, ? super FirSession, ? extends OperatorDiagnostic> implementation) {
        Intrinsics.checkNotNullParameter(implementation, (String)"implementation");
        return new Check(requiredResolvePhase, implementation){
            final /* synthetic */ Function1<FirNamedFunction, FirResolvePhase> $requiredResolvePhase;
            final /* synthetic */ Function2<FirNamedFunction, FirSession, OperatorDiagnostic> $implementation;
            {
                this.$requiredResolvePhase = $requiredResolvePhase;
                this.$implementation = $implementation;
            }

            public OperatorDiagnostic check(FirNamedFunction function, FirSession session2, ScopeSession scopeSession) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                    Intrinsics.checkNotNullParameter((Object)((Object)session2), (String)"session");
                    Object object = this.$requiredResolvePhase;
                    if (object == null || (object = (FirResolvePhase)((Object)object.invoke((Object)function))) == null) break block0;
                    Object it = object;
                    boolean bl = false;
                    FirLazyDeclarationResolverKt.lazyResolveToPhase(function, it);
                }
                return (OperatorDiagnostic)this.$implementation.invoke((Object)function, (Object)((Object)session2));
            }
        };
    }

    public static /* synthetic */ Check full$default(Checks checks, Function1 function1, Function2 function2, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = null;
        }
        return checks.full((Function1<? super FirNamedFunction, ? extends FirResolvePhase>)function1, (Function2<? super FirNamedFunction, ? super FirSession, ? extends OperatorDiagnostic>)function2);
    }

    @NotNull
    public final Check simple(@NotNull String message2, @Nullable Function1<? super FirNamedFunction, ? extends FirResolvePhase> requiredResolvePhase, @NotNull Function2<? super FirNamedFunction, ? super FirSession, Boolean> predicate2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter(predicate2, (String)"predicate");
        return this.full(requiredResolvePhase, (Function2<? super FirNamedFunction, ? super FirSession, ? extends OperatorDiagnostic>)((Function2)(arg_0, arg_1) -> Checks.simple$lambda$0(predicate2, message2, arg_0, arg_1)));
    }

    public static /* synthetic */ Check simple$default(Checks checks, String string, Function1 function1, Function2 function2, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = null;
        }
        return checks.simple(string, (Function1<? super FirNamedFunction, ? extends FirResolvePhase>)function1, (Function2<? super FirNamedFunction, ? super FirSession, Boolean>)function2);
    }

    @NotNull
    public final Check getMemberOrExtension() {
        return memberOrExtension;
    }

    @NotNull
    public final Check getMember() {
        return member;
    }

    @NotNull
    public final Check getNotExtension() {
        return notExtension;
    }

    @NotNull
    public final Check getNoContextParameters() {
        return noContextParameters;
    }

    @NotNull
    public final Check getNonSuspend() {
        return nonSuspend;
    }

    @NotNull
    public final Check getNoDefaults() {
        return noDefaults;
    }

    @NotNull
    public final Check getOnlyLastVararg() {
        return onlyLastVararg;
    }

    @NotNull
    public final Check getNoDefaultAndVarargs() {
        return noDefaultAndVarargs;
    }

    @NotNull
    public final Check isKProperty() {
        return isKProperty;
    }

    private static final OperatorDiagnostic simple$lambda$0(Function2 $predicate, String $message, FirNamedFunction function, FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        Intrinsics.checkNotNullParameter((Object)((Object)session2), (String)"session");
        return (Boolean)$predicate.invoke((Object)function, (Object)session2) != false ? null : (OperatorDiagnostic)new OperatorDiagnostic.IllegalOperatorDiagnostic($message);
    }

    private static final boolean memberOrExtension$lambda$0(FirNamedFunction function, FirSession firSession) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        Intrinsics.checkNotNullParameter((Object)((Object)firSession), (String)"<unused var>");
        return function.getDispatchReceiverType() != null || function.getReceiverParameter() != null;
    }

    private static final boolean member$lambda$0(FirNamedFunction function, FirSession firSession) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        Intrinsics.checkNotNullParameter((Object)((Object)firSession), (String)"<unused var>");
        return function.getDispatchReceiverType() != null;
    }

    private static final boolean notExtension$lambda$0(FirNamedFunction function, FirSession firSession) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        Intrinsics.checkNotNullParameter((Object)((Object)firSession), (String)"<unused var>");
        return !FirDeclarationUtilKt.isExtension(function);
    }

    private static final boolean noContextParameters$lambda$0(FirNamedFunction function, FirSession firSession) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        Intrinsics.checkNotNullParameter((Object)((Object)firSession), (String)"<unused var>");
        return function.getContextParameters().isEmpty();
    }

    private static final FirResolvePhase nonSuspend$lambda$0(FirNamedFunction it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return FirResolvePhase.STATUS;
    }

    private static final boolean nonSuspend$lambda$1(FirNamedFunction function, FirSession firSession) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        Intrinsics.checkNotNullParameter((Object)((Object)firSession), (String)"<unused var>");
        FirMemberDeclaration $this$isSuspend$iv = function;
        boolean $i$f$isSuspend = false;
        return !$this$isSuspend$iv.getStatus().isSuspend();
    }

    private static final FirResolvePhase noDefaults$lambda$0(FirNamedFunction it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return FirResolvePhase.BODY_RESOLVE;
    }

    private static final boolean noDefaults$lambda$1(FirNamedFunction it, FirSession firSession) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Intrinsics.checkNotNullParameter((Object)((Object)firSession), (String)"<unused var>");
            Iterable $this$all$iv = it.getValueParameters();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    FirValueParameter param = (FirValueParameter)element$iv;
                    boolean bl2 = false;
                    if (param.getDefaultValue() == null) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private static final FirResolvePhase onlyLastVararg$lambda$0(FirNamedFunction it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return FirResolvePhase.BODY_RESOLVE;
    }

    private static final boolean onlyLastVararg$lambda$1(FirNamedFunction function, FirSession firSession) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)function, (String)"function");
            Intrinsics.checkNotNullParameter((Object)((Object)firSession), (String)"<unused var>");
            Iterable $this$all$iv = CollectionsKt.dropLast(function.getValueParameters(), (int)1);
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    FirValueParameter param = (FirValueParameter)element$iv;
                    boolean bl2 = false;
                    if (!param.isVararg()) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private static final FirResolvePhase noDefaultAndVarargs$lambda$0(FirNamedFunction it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return FirResolvePhase.BODY_RESOLVE;
    }

    private static final OperatorDiagnostic noDefaultAndVarargs$lambda$1(FirNamedFunction function, FirSession firSession) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        Intrinsics.checkNotNullParameter((Object)((Object)firSession), (String)"<unused var>");
        for (FirValueParameter parameter : function.getValueParameters()) {
            if (parameter.getDefaultValue() != null) {
                return new OperatorDiagnostic.IllegalOperatorDiagnostic("must not have parameters with default values");
            }
            if (!parameter.isVararg()) continue;
            return new OperatorDiagnostic.IllegalOperatorDiagnostic("must not have varargs");
        }
        return null;
    }

    private static final FirResolvePhase isKProperty$lambda$0(FirNamedFunction it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return FirResolvePhase.TYPES;
    }

    private static final boolean isKProperty$lambda$1(FirNamedFunction function, FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        Intrinsics.checkNotNullParameter((Object)((Object)session2), (String)"session");
        Object object = (FirValueParameter)CollectionsKt.getOrNull(function.getValueParameters(), (int)1);
        if (object == null || (object = ((FirValueParameter)object).getReturnTypeRef()) == null || (object = FirTypeUtilsKt.getConeType((FirTypeRef)object)) == null) {
            return false;
        }
        Object paramType = object;
        return TypeUtilsKt.isSubtypeOf(kPropertyType, (ConeKotlinType)paramType, session2, true);
    }

    static {
        ConeStarProjection[] coneStarProjectionArray = new ConeStarProjection[]{ConeStarProjection.INSTANCE};
        kPropertyType = new ConeClassLikeTypeImpl(TypeConstructionUtilsKt.toLookupTag(StandardClassIds.INSTANCE.getKProperty()), coneStarProjectionArray, false, null, 8, null);
        isKProperty = INSTANCE.simple("second parameter must be of type KProperty<*> or its supertype", (Function1<? super FirNamedFunction, ? extends FirResolvePhase>)((Function1)Checks::isKProperty$lambda$0), (Function2<? super FirNamedFunction, ? super FirSession, Boolean>)((Function2)Checks::isKProperty$lambda$1));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/declarations/Checks$EqualsOverridesEqualsOfAny;", "Lorg/jetbrains/kotlin/fir/declarations/Check;", "<init>", "()V", "check", "Lorg/jetbrains/kotlin/fir/declarations/OperatorDiagnostic;", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirNamedFunction;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "providers"})
    @SourceDebugExtension(value={"SMAP\nOperatorFunctionChecks.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OperatorFunctionChecks.kt\norg/jetbrains/kotlin/fir/declarations/Checks$EqualsOverridesEqualsOfAny\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n*L\n1#1,380:1\n1807#2,3:381\n63#3:384\n57#3,4:385\n*S KotlinDebug\n*F\n+ 1 OperatorFunctionChecks.kt\norg/jetbrains/kotlin/fir/declarations/Checks$EqualsOverridesEqualsOfAny\n*L\n352#1:381,3\n360#1:384\n360#1:385,4\n*E\n"})
    public static final class EqualsOverridesEqualsOfAny
    extends Check {
        @NotNull
        public static final EqualsOverridesEqualsOfAny INSTANCE = new EqualsOverridesEqualsOfAny();

        private EqualsOverridesEqualsOfAny() {
        }

        /*
         * Unable to fully structure code
         */
        @Override
        @Nullable
        public OperatorDiagnostic check(@NotNull FirNamedFunction function, @NotNull FirSession session, @Nullable ScopeSession scopeSession) {
            block10: {
                block9: {
                    Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                    Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                    if (scopeSession == null) {
                        return null;
                    }
                    v0 = ClassMembersKt.containingClassLookupTag(function);
                    if (v0 == null || (v0 = ToSymbolUtilsKt.toRegularClassSymbol((ConeClassLikeLookupTag)v0, session)) == null) {
                        return null;
                    }
                    containingClassSymbol = v0;
                    customEqualsSupported = FirLanguageSettingsComponentKt.getLanguageVersionSettings(session).supportsFeature(LanguageFeature.CustomEqualsInValueClasses);
                    var6_6 = ScopesKt.overriddenFunctions(function.getSymbol(), (FirClassSymbol)containingClassSymbol, session, scopeSession);
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        v1 = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            it = (FirFunctionSymbol)element$iv;
                            $i$a$-any-Checks$EqualsOverridesEqualsOfAny$check$1 = false;
                            v2 = ClassMembersKt.containingClassLookupTag(it);
                            if (!Intrinsics.areEqual((Object)(v2 != null ? v2.getClassId() : null), (Object)StandardClassIds.INSTANCE.getAny())) continue;
                            v1 = true;
                            break block9;
                        }
                        v1 = false;
                    }
                }
                if (v1 || customEqualsSupported && ValueClassesUtilsKt.isTypedEqualsInValueClass(function.getSymbol(), session) || Intrinsics.areEqual((Object)containingClassSymbol.getClassId(), (Object)StandardClassIds.INSTANCE.getAny())) {
                    return null;
                }
                $this$check_u24lambda_u241 = var7_8 = new StringBuilder();
                $i$a$-buildString-Checks$EqualsOverridesEqualsOfAny$check$message$1 = false;
                $this$check_u24lambda_u241.append("must override 'equals()' in Any");
                if (!customEqualsSupported) break block10;
                $this$isInlineOrValue$iv = (FirClassLikeSymbol)containingClassSymbol;
                $i$f$isInlineOrValue = false;
                $this$isInline$iv$iv = $this$isInlineOrValue$iv;
                $i$f$isInline = false;
                if ($this$isInline$iv$iv.getRawStatus().isInline()) ** GOTO lbl-1000
                $this$isValue$iv$iv = $this$isInlineOrValue$iv;
                $i$f$isValue = false;
                if ($this$isValue$iv$iv.getRawStatus().isValue()) lbl-1000:
                // 2 sources

                {
                    v3 = true;
                } else {
                    v3 = false;
                }
                if (v3) {
                    expectedParameterTypeRendered = ConeTypeUtilsKt.renderReadable(ConeTypeUtilsKt.replaceArgumentsWithStarProjections(ScopeUtilsKt.defaultType((FirClassLikeSymbol)containingClassSymbol)));
                    $this$check_u24lambda_u241.append(" or define 'equals(other: " + expectedParameterTypeRendered + "): Boolean'");
                }
            }
            message = var7_8.toString();
            return new OperatorDiagnostic.IllegalOperatorDiagnostic(message);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J$\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/fir/declarations/Checks$FeatureIsSupported;", "Lorg/jetbrains/kotlin/fir/declarations/Check;", "feature", "Lorg/jetbrains/kotlin/config/LanguageFeature;", "<init>", "(Lorg/jetbrains/kotlin/config/LanguageFeature;)V", "getFeature", "()Lorg/jetbrains/kotlin/config/LanguageFeature;", "check", "Lorg/jetbrains/kotlin/fir/declarations/OperatorDiagnostic;", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirNamedFunction;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "providers"})
    public static final class FeatureIsSupported
    extends Check {
        @NotNull
        private final LanguageFeature feature;

        public FeatureIsSupported(@NotNull LanguageFeature feature) {
            Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
            this.feature = feature;
        }

        @NotNull
        public final LanguageFeature getFeature() {
            return this.feature;
        }

        @Override
        @Nullable
        public OperatorDiagnostic check(@NotNull FirNamedFunction function, @NotNull FirSession session2, @Nullable ScopeSession scopeSession) {
            Intrinsics.checkNotNullParameter((Object)function, (String)"function");
            Intrinsics.checkNotNullParameter((Object)((Object)session2), (String)"session");
            return FirLanguageSettingsComponentKt.getLanguageVersionSettings(session2).supportsFeature(this.feature) ? null : (OperatorDiagnostic)new OperatorDiagnostic.Unsupported(this.feature);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\tR\u0011\u0010\r\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0012\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000fR\u0011\u0010\u0014\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/fir/declarations/Checks$Returns;", "", "<init>", "()V", "returnsCheck", "Lorg/jetbrains/kotlin/fir/declarations/Check;", "message", "", "predicate", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/fir/declarations/FirNamedFunction;", "Lorg/jetbrains/kotlin/fir/FirSession;", "", "boolean", "getBoolean", "()Lorg/jetbrains/kotlin/fir/declarations/Check;", "int", "getInt", "unit", "getUnit", "outerOfCompanionWhereDefined", "getOuterOfCompanionWhereDefined", "providers"})
    @SourceDebugExtension(value={"SMAP\nOperatorFunctionChecks.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OperatorFunctionChecks.kt\norg/jetbrains/kotlin/fir/declarations/Checks$Returns\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n*L\n1#1,380:1\n69#2:381\n*S KotlinDebug\n*F\n+ 1 OperatorFunctionChecks.kt\norg/jetbrains/kotlin/fir/declarations/Checks$Returns\n*L\n287#1:381\n*E\n"})
    public static final class Returns {
        @NotNull
        public static final Returns INSTANCE = new Returns();
        @NotNull
        private static final Check boolean = INSTANCE.returnsCheck("must return 'Boolean'", (Function2<? super FirNamedFunction, ? super FirSession, Boolean>)((Function2)Returns::boolean$lambda$0));
        @NotNull
        private static final Check int = INSTANCE.returnsCheck("must return 'Int'", (Function2<? super FirNamedFunction, ? super FirSession, Boolean>)((Function2)Returns::int$lambda$0));
        @NotNull
        private static final Check unit = INSTANCE.returnsCheck("must return 'Unit'", (Function2<? super FirNamedFunction, ? super FirSession, Boolean>)((Function2)Returns::unit$lambda$0));
        @NotNull
        private static final Check outerOfCompanionWhereDefined = INSTANCE.full((Function1<? super FirNamedFunction, ? extends FirResolvePhase>)((Function1)Returns::outerOfCompanionWhereDefined$lambda$0), (Function2<? super FirNamedFunction, ? super FirSession, ? extends OperatorDiagnostic>)((Function2)Returns::outerOfCompanionWhereDefined$lambda$1));

        private Returns() {
        }

        @NotNull
        public final Check returnsCheck(@NotNull String message2, @NotNull Function2<? super FirNamedFunction, ? super FirSession, Boolean> predicate2) {
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            Intrinsics.checkNotNullParameter(predicate2, (String)"predicate");
            return INSTANCE.simple(message2, (Function1<? super FirNamedFunction, ? extends FirResolvePhase>)((Function1)Returns::returnsCheck$lambda$0), predicate2);
        }

        @NotNull
        public final Check getBoolean() {
            return boolean;
        }

        @NotNull
        public final Check getInt() {
            return int;
        }

        @NotNull
        public final Check getUnit() {
            return unit;
        }

        @NotNull
        public final Check getOuterOfCompanionWhereDefined() {
            return outerOfCompanionWhereDefined;
        }

        private static final FirResolvePhase returnsCheck$lambda$0(FirNamedFunction fn) {
            Intrinsics.checkNotNullParameter((Object)fn, (String)"fn");
            FirTypeRef firTypeRef = fn.getReturnTypeRef();
            return firTypeRef instanceof FirResolvedTypeRef ? null : (firTypeRef instanceof FirImplicitTypeRef ? FirResolvePhase.IMPLICIT_TYPES_BODY_RESOLVE : FirResolvePhase.TYPES);
        }

        private static final boolean boolean$lambda$0(FirNamedFunction function, FirSession session2) {
            Intrinsics.checkNotNullParameter((Object)function, (String)"function");
            Intrinsics.checkNotNullParameter((Object)((Object)session2), (String)"session");
            return ConeBuiltinTypeUtilsKt.isBoolean(TypeExpansionUtilsKt.fullyExpandedType$default(FirTypeUtilsKt.getConeType(function.getReturnTypeRef()), session2, null, 2, null));
        }

        private static final boolean int$lambda$0(FirNamedFunction function, FirSession session2) {
            Intrinsics.checkNotNullParameter((Object)function, (String)"function");
            Intrinsics.checkNotNullParameter((Object)((Object)session2), (String)"session");
            return ConeBuiltinTypeUtilsKt.isInt(TypeExpansionUtilsKt.fullyExpandedType$default(FirTypeUtilsKt.getConeType(function.getReturnTypeRef()), session2, null, 2, null));
        }

        private static final boolean unit$lambda$0(FirNamedFunction function, FirSession session2) {
            Intrinsics.checkNotNullParameter((Object)function, (String)"function");
            Intrinsics.checkNotNullParameter((Object)((Object)session2), (String)"session");
            return ConeBuiltinTypeUtilsKt.isUnit(TypeExpansionUtilsKt.fullyExpandedType$default(FirTypeUtilsKt.getConeType(function.getReturnTypeRef()), session2, null, 2, null));
        }

        private static final FirResolvePhase outerOfCompanionWhereDefined$lambda$0(FirNamedFunction fn) {
            Intrinsics.checkNotNullParameter((Object)fn, (String)"fn");
            FirTypeRef firTypeRef = fn.getReturnTypeRef();
            return firTypeRef instanceof FirResolvedTypeRef ? FirResolvePhase.STATUS : (firTypeRef instanceof FirImplicitTypeRef ? FirResolvePhase.IMPLICIT_TYPES_BODY_RESOLVE : FirResolvePhase.TYPES);
        }

        private static final OperatorDiagnostic outerOfCompanionWhereDefined$lambda$1(FirNamedFunction function, FirSession session2) {
            boolean bl;
            FirRegularClassSymbol dispatch;
            Intrinsics.checkNotNullParameter((Object)function, (String)"function");
            Intrinsics.checkNotNullParameter((Object)((Object)session2), (String)"session");
            ConeSimpleKotlinType coneSimpleKotlinType = function.getDispatchReceiverType();
            FirRegularClassSymbol firRegularClassSymbol = dispatch = coneSimpleKotlinType != null ? ToSymbolUtilsKt.toRegularClassSymbol(coneSimpleKotlinType, session2) : null;
            if (firRegularClassSymbol != null) {
                FirClassLikeSymbol $this$isCompanion$iv = firRegularClassSymbol;
                boolean $i$f$isCompanion = false;
                bl = $this$isCompanion$iv.getRawStatus().isCompanion();
            } else {
                bl = false;
            }
            if (!bl) {
                return new OperatorDiagnostic.IllegalOperatorDiagnostic("must be a member of companion");
            }
            FirClassLikeSymbol<?> firClassLikeSymbol = ContainingClassUtilsKt.getContainingClassSymbol(dispatch);
            FirRegularClassSymbol firRegularClassSymbol2 = firClassLikeSymbol instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firClassLikeSymbol : null;
            if (firRegularClassSymbol2 == null) {
                return null;
            }
            FirRegularClassSymbol outerClass = firRegularClassSymbol2;
            ConeKotlinType returnType = TypeExpansionUtilsKt.fullyExpandedType$default(FirTypeUtilsKt.getConeType(function.getReturnTypeRef()), session2, null, 2, null);
            ConeRigidType lowerBound = ConeTypeUtilsKt.lowerBoundIfFlexible(returnType);
            return lowerBound instanceof ConeErrorType ? null : (!(lowerBound instanceof ConeClassLikeType) || !Intrinsics.areEqual((Object)ConeTypeUtilsKt.getClassId((ConeClassLikeType)lowerBound), (Object)outerClass.getClassId()) ? (OperatorDiagnostic)new OperatorDiagnostic.ReturnTypeMismatchWithOuterClass(outerClass, false, false, 6, null) : (((ConeClassLikeType)lowerBound).isMarkedNullable() ? (OperatorDiagnostic)new OperatorDiagnostic.ReturnTypeMismatchWithOuterClass(outerClass, true, false, 4, null) : (returnType instanceof ConeFlexibleType ? (OperatorDiagnostic)new OperatorDiagnostic.ReturnTypeMismatchWithOuterClass(outerClass, false, true, 2, null) : null)));
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u000bR\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/fir/declarations/Checks$ValueParametersCount;", "", "<init>", "()V", "atLeast", "Lorg/jetbrains/kotlin/fir/declarations/Check;", "n", "", "exactly", "atMost", "feature", "Lorg/jetbrains/kotlin/config/LanguageFeature;", "single", "getSingle", "()Lorg/jetbrains/kotlin/fir/declarations/Check;", "none", "getNone", "providers"})
    public static final class ValueParametersCount {
        @NotNull
        public static final ValueParametersCount INSTANCE = new ValueParametersCount();
        @NotNull
        private static final Check single = Checks.simple$default(INSTANCE, "must have a single value parameter", null, ValueParametersCount::single$lambda$0, 2, null);
        @NotNull
        private static final Check none = Checks.simple$default(INSTANCE, "must have no value parameters", null, ValueParametersCount::none$lambda$0, 2, null);

        private ValueParametersCount() {
        }

        @NotNull
        public final Check atLeast(int n) {
            return Checks.simple$default(INSTANCE, "must have at least " + n + " value parameter" + (n > 1 ? "s" : ""), null, (arg_0, arg_1) -> ValueParametersCount.atLeast$lambda$0(n, arg_0, arg_1), 2, null);
        }

        @NotNull
        public final Check exactly(int n) {
            return Checks.simple$default(INSTANCE, "must have exactly " + n + " value parameters", null, (arg_0, arg_1) -> ValueParametersCount.exactly$lambda$0(n, arg_0, arg_1), 2, null);
        }

        @NotNull
        public final Check atMost(int n, @Nullable LanguageFeature feature) {
            return Checks.full$default(INSTANCE, null, (arg_0, arg_1) -> ValueParametersCount.atMost$lambda$0(n, feature, arg_0, arg_1), 1, null);
        }

        @NotNull
        public final Check getSingle() {
            return single;
        }

        @NotNull
        public final Check getNone() {
            return none;
        }

        private static final boolean atLeast$lambda$0(int $n, FirNamedFunction function, FirSession firSession) {
            Intrinsics.checkNotNullParameter((Object)function, (String)"function");
            Intrinsics.checkNotNullParameter((Object)((Object)firSession), (String)"<unused var>");
            return function.getValueParameters().size() >= $n;
        }

        private static final boolean exactly$lambda$0(int $n, FirNamedFunction function, FirSession firSession) {
            Intrinsics.checkNotNullParameter((Object)function, (String)"function");
            Intrinsics.checkNotNullParameter((Object)((Object)firSession), (String)"<unused var>");
            return function.getValueParameters().size() == $n;
        }

        private static final OperatorDiagnostic atMost$lambda$0(int $n, LanguageFeature $feature, FirNamedFunction function, FirSession firSession) {
            Intrinsics.checkNotNullParameter((Object)function, (String)"function");
            Intrinsics.checkNotNullParameter((Object)((Object)firSession), (String)"<unused var>");
            if (function.getValueParameters().size() <= $n) {
                return null;
            }
            String message2 = "must have at most " + $n + " value parameter" + ($n > 1 ? "s" : "");
            return $feature != null ? (OperatorDiagnostic)new OperatorDiagnostic.DeprecatedOperatorDiagnostic(message2, $feature) : (OperatorDiagnostic)new OperatorDiagnostic.IllegalOperatorDiagnostic(message2);
        }

        private static final boolean single$lambda$0(FirNamedFunction function, FirSession firSession) {
            Intrinsics.checkNotNullParameter((Object)function, (String)"function");
            Intrinsics.checkNotNullParameter((Object)((Object)firSession), (String)"<unused var>");
            return function.getValueParameters().size() == 1;
        }

        private static final boolean none$lambda$0(FirNamedFunction function, FirSession firSession) {
            Intrinsics.checkNotNullParameter((Object)function, (String)"function");
            Intrinsics.checkNotNullParameter((Object)((Object)firSession), (String)"<unused var>");
            return function.getValueParameters().isEmpty();
        }
    }
}

