/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.declarations;

import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.Check;
import org.jetbrains.kotlin.fir.declarations.CheckResult;
import org.jetbrains.kotlin.fir.declarations.Checks;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirNamedFunction;
import org.jetbrains.kotlin.fir.declarations.FirReceiverParameter;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.OperatorDiagnostic;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ?\u0010\u0014\u001a\u00020\u0015*\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u00162\u0006\u0010\u0017\u001a\u00020\u000e2\u0012\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u0019\"\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010\u001aJE\u0010\u0014\u001a\u00020\u0015*\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u00162\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001c2\u0012\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u0019\"\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010\u001dJE\u0010\u0014\u001a\u00020\u0015*\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u00120\u001e2\u0006\u0010\u001f\u001a\u00020\u00132\u0012\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u0019\"\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010 R \u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0011\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u00120\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/fir/declarations/OperatorFunctionChecks;", "", "<init>", "()V", "isOperator", "Lorg/jetbrains/kotlin/fir/declarations/CheckResult;", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "checksByName", "", "Lorg/jetbrains/kotlin/name/Name;", "", "Lorg/jetbrains/kotlin/fir/declarations/Check;", "regexChecks", "Lkotlin/Pair;", "Lkotlin/text/Regex;", "checkFor", "", "", "name", "checks", "", "(Ljava/util/Map;Lorg/jetbrains/kotlin/name/Name;[Lorg/jetbrains/kotlin/fir/declarations/Check;)V", "names", "", "(Ljava/util/Map;Ljava/util/Set;[Lorg/jetbrains/kotlin/fir/declarations/Check;)V", "", "regex", "(Ljava/util/List;Lkotlin/text/Regex;[Lorg/jetbrains/kotlin/fir/declarations/Check;)V", "providers"})
@SourceDebugExtension(value={"SMAP\nOperatorFunctionChecks.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OperatorFunctionChecks.kt\norg/jetbrains/kotlin/fir/declarations/OperatorFunctionChecks\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,380:1\n1#2:381\n1915#3,2:382\n*S KotlinDebug\n*F\n+ 1 OperatorFunctionChecks.kt\norg/jetbrains/kotlin/fir/declarations/OperatorFunctionChecks\n*L\n168#1:382,2\n*E\n"})
public final class OperatorFunctionChecks {
    @NotNull
    public static final OperatorFunctionChecks INSTANCE = new OperatorFunctionChecks();
    @NotNull
    private static final Map<Name, List<Check>> checksByName;
    @NotNull
    private static final List<Pair<Regex, List<Check>>> regexChecks;

    private OperatorFunctionChecks() {
    }

    @NotNull
    public final CheckResult isOperator(@NotNull FirFunction function, @NotNull FirSession session2, @Nullable ScopeSession scopeSession) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        Intrinsics.checkNotNullParameter((Object)((Object)session2), (String)"session");
        if (!(function instanceof FirNamedFunction)) {
            return CheckResult.AnonymousOperatorFunction.INSTANCE;
        }
        Map<Name, List<Check>> map2 = checksByName;
        List list2 = map2.get(((FirNamedFunction)function).getName());
        if (list2 == null) {
            Object v3;
            block5: {
                boolean bl = false;
                Iterable iterable = regexChecks;
                for (Object t : iterable) {
                    Pair it = (Pair)t;
                    boolean bl2 = false;
                    Regex regex = (Regex)it.getFirst();
                    String string = ((FirNamedFunction)function).getName().asString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
                    if (!regex.matches((CharSequence)string)) continue;
                    v3 = t;
                    break block5;
                }
                v3 = null;
            }
            Pair pair = v3;
            list2 = pair != null ? (List)pair.getSecond() : null;
        }
        if (list2 == null) {
            return CheckResult.IllegalFunctionName.INSTANCE;
        }
        List checks = list2;
        for (Check check2 : checks) {
            OperatorDiagnostic operatorDiagnostic = check2.check((FirNamedFunction)function, session2, scopeSession);
            if (operatorDiagnostic == null) continue;
            OperatorDiagnostic it = operatorDiagnostic;
            boolean bl = false;
            return new CheckResult.IllegalSignature(it);
        }
        return CheckResult.SuccessCheck.INSTANCE;
    }

    private final void checkFor(Map<Name, List<Check>> $this$checkFor, Name name2, Check ... checks) {
        $this$checkFor.put(name2, ArraysKt.asList((Object[])checks));
    }

    private final void checkFor(Map<Name, List<Check>> $this$checkFor, Set<Name> names, Check ... checks) {
        Iterable $this$forEach$iv = names;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Name it = (Name)element$iv;
            boolean bl = false;
            $this$checkFor.put(it, ArraysKt.asList((Object[])checks));
        }
    }

    private final void checkFor(List<Pair<Regex, List<Check>>> $this$checkFor, Regex regex, Check ... checks) {
        $this$checkFor.add((Pair<Regex, List<Check>>)TuplesKt.to((Object)regex, (Object)ArraysKt.asList((Object[])checks)));
    }

    private static final boolean checksByName$lambda$0$0(FirNamedFunction it, FirSession firSession) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Intrinsics.checkNotNullParameter((Object)((Object)firSession), (String)"<unused var>");
        FirValueParameter firValueParameter = (FirValueParameter)CollectionsKt.lastOrNull(it.getValueParameters());
        if (firValueParameter != null) {
            FirValueParameter param = firValueParameter;
            boolean bl2 = false;
            bl = param.getDefaultValue() == null && !param.isVararg();
        } else {
            bl = false;
        }
        return bl;
    }

    private static final boolean checksByName$lambda$0$1(FirNamedFunction function, FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        Intrinsics.checkNotNullParameter((Object)((Object)session2), (String)"session");
        Object object = function.getReceiverParameter();
        if (object == null || (object = ((FirReceiverParameter)object).getTypeRef()) == null || (object = FirTypeUtilsKt.getConeType((FirTypeRef)object)) == null) {
            ConeSimpleKotlinType coneSimpleKotlinType = function.getDispatchReceiverType();
            if (coneSimpleKotlinType != null) {
                object = coneSimpleKotlinType;
            } else {
                return false;
            }
        }
        Object receiver2 = object;
        return TypeUtilsKt.isSubtypeOf(FirTypeUtilsKt.getConeType(function.getReturnTypeRef()), TypeComponentsKt.getTypeContext(session2), (KotlinTypeMarker)receiver2);
    }

    static {
        Object object = MapsKt.createMapBuilder();
        Map $this$checksByName_u24lambda_u240 = object;
        boolean bl = false;
        Object[] objectArray = new Check[]{Checks.INSTANCE.getMemberOrExtension(), Checks.ValueParametersCount.INSTANCE.atLeast(1)};
        INSTANCE.checkFor((Map<Name, List<Check>>)$this$checksByName_u24lambda_u240, OperatorNameConventions.GET, (Check[])objectArray);
        objectArray = new Check[]{Checks.INSTANCE.getMemberOrExtension(), Checks.ValueParametersCount.INSTANCE.atLeast(2), Checks.simple$default(Checks.INSTANCE, "last parameter must not have a default value or be a vararg", null, OperatorFunctionChecks::checksByName$lambda$0$0, 2, null)};
        INSTANCE.checkFor((Map<Name, List<Check>>)$this$checksByName_u24lambda_u240, OperatorNameConventions.SET, (Check[])objectArray);
        objectArray = new Check[]{Checks.INSTANCE.getMemberOrExtension(), Checks.INSTANCE.getNoDefaultAndVarargs(), Checks.ValueParametersCount.INSTANCE.atLeast(2), Checks.ValueParametersCount.INSTANCE.atMost(2, LanguageFeature.ForbidGetSetValueWithTooManyParameters), Checks.INSTANCE.isKProperty(), Checks.INSTANCE.getNonSuspend()};
        INSTANCE.checkFor((Map<Name, List<Check>>)$this$checksByName_u24lambda_u240, OperatorNameConventions.GET_VALUE, (Check[])objectArray);
        objectArray = new Check[]{Checks.INSTANCE.getMemberOrExtension(), Checks.INSTANCE.getNoDefaultAndVarargs(), Checks.ValueParametersCount.INSTANCE.atLeast(3), Checks.ValueParametersCount.INSTANCE.atMost(3, LanguageFeature.ForbidGetSetValueWithTooManyParameters), Checks.INSTANCE.isKProperty(), Checks.INSTANCE.getNonSuspend()};
        INSTANCE.checkFor((Map<Name, List<Check>>)$this$checksByName_u24lambda_u240, OperatorNameConventions.SET_VALUE, (Check[])objectArray);
        objectArray = new Check[]{Checks.INSTANCE.getMemberOrExtension(), Checks.INSTANCE.getNoDefaultAndVarargs(), Checks.ValueParametersCount.INSTANCE.exactly(2), Checks.INSTANCE.isKProperty(), Checks.INSTANCE.getNonSuspend()};
        INSTANCE.checkFor((Map<Name, List<Check>>)$this$checksByName_u24lambda_u240, OperatorNameConventions.PROVIDE_DELEGATE, (Check[])objectArray);
        objectArray = new Check[]{Checks.INSTANCE.getMemberOrExtension()};
        INSTANCE.checkFor((Map<Name, List<Check>>)$this$checksByName_u24lambda_u240, OperatorNameConventions.INVOKE, (Check[])objectArray);
        objectArray = new Check[]{Checks.INSTANCE.getMemberOrExtension(), Checks.ValueParametersCount.INSTANCE.getSingle(), Checks.INSTANCE.getNoDefaultAndVarargs(), Checks.Returns.INSTANCE.getBoolean()};
        INSTANCE.checkFor((Map<Name, List<Check>>)$this$checksByName_u24lambda_u240, OperatorNameConventions.CONTAINS, (Check[])objectArray);
        objectArray = new Check[]{Checks.INSTANCE.getMemberOrExtension(), Checks.ValueParametersCount.INSTANCE.getNone()};
        INSTANCE.checkFor((Map<Name, List<Check>>)$this$checksByName_u24lambda_u240, OperatorNameConventions.ITERATOR, (Check[])objectArray);
        objectArray = new Check[]{Checks.INSTANCE.getMemberOrExtension(), Checks.ValueParametersCount.INSTANCE.getNone()};
        INSTANCE.checkFor((Map<Name, List<Check>>)$this$checksByName_u24lambda_u240, OperatorNameConventions.NEXT, (Check[])objectArray);
        objectArray = new Check[]{Checks.INSTANCE.getMemberOrExtension(), Checks.ValueParametersCount.INSTANCE.getNone(), Checks.Returns.INSTANCE.getBoolean()};
        INSTANCE.checkFor((Map<Name, List<Check>>)$this$checksByName_u24lambda_u240, OperatorNameConventions.HAS_NEXT, (Check[])objectArray);
        objectArray = new Check[]{Checks.INSTANCE.getMemberOrExtension(), Checks.ValueParametersCount.INSTANCE.getSingle(), Checks.INSTANCE.getNoDefaultAndVarargs()};
        INSTANCE.checkFor((Map<Name, List<Check>>)$this$checksByName_u24lambda_u240, OperatorNameConventions.RANGE_TO, (Check[])objectArray);
        objectArray = new Check[]{Checks.INSTANCE.getMemberOrExtension(), Checks.ValueParametersCount.INSTANCE.getSingle(), Checks.INSTANCE.getNoDefaultAndVarargs()};
        INSTANCE.checkFor((Map<Name, List<Check>>)$this$checksByName_u24lambda_u240, OperatorNameConventions.RANGE_UNTIL, (Check[])objectArray);
        objectArray = new Check[]{Checks.INSTANCE.getMember(), Checks.EqualsOverridesEqualsOfAny.INSTANCE};
        INSTANCE.checkFor((Map<Name, List<Check>>)$this$checksByName_u24lambda_u240, OperatorNameConventions.EQUALS, (Check[])objectArray);
        objectArray = new Check[]{Checks.INSTANCE.getMemberOrExtension(), Checks.Returns.INSTANCE.getInt(), Checks.ValueParametersCount.INSTANCE.getSingle(), Checks.INSTANCE.getNoDefaultAndVarargs()};
        INSTANCE.checkFor((Map<Name, List<Check>>)$this$checksByName_u24lambda_u240, OperatorNameConventions.COMPARE_TO, (Check[])objectArray);
        objectArray = new Check[]{Checks.INSTANCE.getMemberOrExtension(), Checks.ValueParametersCount.INSTANCE.getSingle(), Checks.INSTANCE.getNoDefaultAndVarargs()};
        INSTANCE.checkFor((Map<Name, List<Check>>)$this$checksByName_u24lambda_u240, OperatorNameConventions.BINARY_OPERATION_NAMES, (Check[])objectArray);
        objectArray = new Check[]{Checks.INSTANCE.getMemberOrExtension(), Checks.ValueParametersCount.INSTANCE.getNone()};
        INSTANCE.checkFor((Map<Name, List<Check>>)$this$checksByName_u24lambda_u240, OperatorNameConventions.SIMPLE_UNARY_OPERATION_NAMES, (Check[])objectArray);
        objectArray = new Name[]{OperatorNameConventions.INC, OperatorNameConventions.DEC};
        Set set = SetsKt.setOf((Object[])objectArray);
        objectArray = new Check[]{Checks.INSTANCE.getMemberOrExtension(), Checks.simple$default(Checks.INSTANCE, "receiver must be a supertype of the return type", null, OperatorFunctionChecks::checksByName$lambda$0$1, 2, null)};
        INSTANCE.checkFor((Map<Name, List<Check>>)$this$checksByName_u24lambda_u240, set, (Check[])objectArray);
        objectArray = new Check[]{Checks.INSTANCE.getMemberOrExtension(), Checks.Returns.INSTANCE.getUnit(), Checks.ValueParametersCount.INSTANCE.getSingle(), Checks.INSTANCE.getNoDefaultAndVarargs()};
        INSTANCE.checkFor((Map<Name, List<Check>>)$this$checksByName_u24lambda_u240, OperatorNameConventions.ASSIGNMENT_OPERATIONS, (Check[])objectArray);
        objectArray = new Check[]{new Checks.FeatureIsSupported(LanguageFeature.CollectionLiterals), Checks.INSTANCE.getNotExtension(), Checks.INSTANCE.getNoContextParameters(), Checks.INSTANCE.getNoDefaults(), Checks.INSTANCE.getOnlyLastVararg(), Checks.Returns.INSTANCE.getOuterOfCompanionWhereDefined()};
        INSTANCE.checkFor((Map<Name, List<Check>>)$this$checksByName_u24lambda_u240, OperatorNameConventions.OF, (Check[])objectArray);
        checksByName = MapsKt.build((Map)object);
        Object $this$regexChecks_u24lambda_u240 = object = CollectionsKt.createListBuilder();
        boolean bl2 = false;
        objectArray = new Check[]{Checks.INSTANCE.getMemberOrExtension(), Checks.ValueParametersCount.INSTANCE.getNone()};
        INSTANCE.checkFor((List<Pair<Regex, List<Check>>>)$this$regexChecks_u24lambda_u240, OperatorNameConventions.COMPONENT_REGEX, (Check[])objectArray);
        regexChecks = CollectionsKt.build((List)object);
    }
}

