/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.expressions.FirCollectionLiteral;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.resolve.BodyResolveComponents;
import org.jetbrains.kotlin.fir.resolve.ResolutionMode;
import org.jetbrains.kotlin.fir.resolve.calls.ConeAtomWithCandidate;
import org.jetbrains.kotlin.fir.resolve.calls.ConeCollectionLiteralAtom;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionContext;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.FirNamedReferenceWithCandidate;
import org.jetbrains.kotlin.fir.resolve.inference.FirCallCompleter;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J$\u0010\u0014\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H$R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/CollectionLiteralResolver;", "", "context", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;", "<init>", "(Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;)V", "getContext", "()Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;", "components", "Lorg/jetbrains/kotlin/fir/resolve/BodyResolveComponents;", "getComponents", "()Lorg/jetbrains/kotlin/fir/resolve/BodyResolveComponents;", "resolveCollectionLiteral", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "collectionLiteralAtom", "Lorg/jetbrains/kotlin/fir/resolve/calls/ConeCollectionLiteralAtom;", "topLevelCandidate", "Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;", "expectedType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "prepareRawCall", "collectionLiteral", "Lorg/jetbrains/kotlin/fir/expressions/FirCollectionLiteral;", "resolve"})
public abstract class CollectionLiteralResolver {
    @NotNull
    private final ResolutionContext context;

    public CollectionLiteralResolver(@NotNull ResolutionContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
    }

    @NotNull
    protected final ResolutionContext getContext() {
        return this.context;
    }

    @NotNull
    protected final BodyResolveComponents getComponents() {
        return this.context.getBodyResolveComponents();
    }

    @Nullable
    public final FirFunctionCall resolveCollectionLiteral(@NotNull ConeCollectionLiteralAtom collectionLiteralAtom, @NotNull Candidate topLevelCandidate, @Nullable ConeKotlinType expectedType) {
        FirFunctionCall firFunctionCall;
        Intrinsics.checkNotNullParameter((Object)collectionLiteralAtom, (String)"collectionLiteralAtom");
        Intrinsics.checkNotNullParameter((Object)topLevelCandidate, (String)"topLevelCandidate");
        FirFunctionCall firFunctionCall2 = this.prepareRawCall(collectionLiteralAtom.getExpression(), topLevelCandidate, expectedType);
        if (firFunctionCall2 == null) {
            return null;
        }
        FirFunctionCall call = firFunctionCall2;
        call = this.getComponents().getCallResolver().resolveCallAndSelectCandidate(call, ResolutionMode.ContextDependent.Companion, topLevelCandidate);
        call = (FirFunctionCall)FirCallCompleter.completeCall$default(this.context.getBodyResolveComponents().getCallCompleter(), call, ResolutionMode.ContextDependent.Companion, false, 4, null);
        FirNamedReference calleeRef = call.getCalleeReference();
        if (calleeRef instanceof FirNamedReferenceWithCandidate) {
            topLevelCandidate.getSystem().replaceContentWith(((FirNamedReferenceWithCandidate)calleeRef).getCandidate().getSystem().currentStorage());
            collectionLiteralAtom.setSubAtom(new ConeAtomWithCandidate(collectionLiteralAtom.getExpression(), ((FirNamedReferenceWithCandidate)calleeRef).getCandidate()));
            firFunctionCall = call;
        } else {
            firFunctionCall = call;
        }
        return firFunctionCall;
    }

    @Nullable
    protected abstract FirFunctionCall prepareRawCall(@NotNull FirCollectionLiteral var1, @NotNull Candidate var2, @Nullable ConeKotlinType var3);
}

