/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve;

import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKt;
import org.jetbrains.kotlin.fir.SessionHolder;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.expressions.FirCollectionLiteral;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCallOrigin;
import org.jetbrains.kotlin.fir.expressions.builder.FirFunctionCallBuilder;
import org.jetbrains.kotlin.fir.references.builder.FirSimpleNamedReferenceBuilder;
import org.jetbrains.kotlin.fir.resolve.CollectionLiteralResolver;
import org.jetbrains.kotlin.fir.resolve.ResolveUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionContext;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.Candidate;
import org.jetbrains.kotlin.fir.symbols.impl.FirAnonymousObjectSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\u0004\u0018\u00010\u0007*\u00020\bH\u0002J\u0018\u0010\t\u001a\u00020\n*\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0002J$\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\bH\u0014R\u001a\u0010\r\u001a\u0004\u0018\u00010\u0007*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/CollectionLiteralResolverThroughCompanion;", "Lorg/jetbrains/kotlin/fir/resolve/CollectionLiteralResolver;", "context", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;", "<init>", "(Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;)V", "getClassRepresentativeForCollectionLiteralResolution", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "canBeMainOperatorOfOverload", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "outerClass", "companionObjectIfDefinedOperatorOf", "getCompanionObjectIfDefinedOperatorOf", "(Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "prepareRawCall", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "collectionLiteral", "Lorg/jetbrains/kotlin/fir/expressions/FirCollectionLiteral;", "topLevelCandidate", "Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;", "expectedType", "resolve"})
@SourceDebugExtension(value={"SMAP\nCollectionLiteralResolution.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CollectionLiteralResolution.kt\norg/jetbrains/kotlin/fir/resolve/CollectionLiteralResolverThroughCompanion\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 5 FirFunctionCallBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirFunctionCallBuilderKt\n+ 6 FirSimpleNamedReferenceBuilder.kt\norg/jetbrains/kotlin/fir/references/builder/FirSimpleNamedReferenceBuilderKt\n*L\n1#1,178:1\n30#2:179\n2792#3,3:180\n294#4:183\n66#5:184\n41#6:185\n*S KotlinDebug\n*F\n+ 1 CollectionLiteralResolution.kt\norg/jetbrains/kotlin/fir/resolve/CollectionLiteralResolverThroughCompanion\n*L\n85#1:179\n85#1:180,3\n106#1:183\n116#1:184\n123#1:185\n*E\n"})
public final class CollectionLiteralResolverThroughCompanion
extends CollectionLiteralResolver {
    public CollectionLiteralResolverThroughCompanion(@NotNull ResolutionContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super(context2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final FirRegularClassSymbol getClassRepresentativeForCollectionLiteralResolution(ConeKotlinType $this$getClassRepresentativeForCollectionLiteralResolution) {
        FirRegularClassSymbol firRegularClassSymbol;
        ResolutionContext resolutionContext = this.getContext();
        boolean bl = false;
        if (!($this$getClassRepresentativeForCollectionLiteralResolution instanceof ConeLookupTagBasedType)) return null;
        FirClassifierSymbol<?> symbol = ToSymbolUtilsKt.toSymbol((SessionHolder)resolutionContext, ((ConeLookupTagBasedType)$this$getClassRepresentativeForCollectionLiteralResolution).getLookupTag());
        if (symbol instanceof FirTypeParameterSymbol) return null;
        if (symbol instanceof FirAnonymousObjectSymbol) return null;
        if (symbol == null) {
            return null;
        }
        if (symbol instanceof FirRegularClassSymbol) {
            firRegularClassSymbol = (FirRegularClassSymbol)symbol;
            return firRegularClassSymbol;
        } else {
            if (!(symbol instanceof FirTypeAliasSymbol)) throw new NoWhenBranchMatchedException();
            firRegularClassSymbol = this.getClassRepresentativeForCollectionLiteralResolution(TypeExpansionUtilsKt.fullyExpandedType((SessionHolder)resolutionContext, (ConeSimpleKotlinType)$this$getClassRepresentativeForCollectionLiteralResolution));
        }
        return firRegularClassSymbol;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean canBeMainOperatorOfOverload(FirCallableSymbol<?> $this$canBeMainOperatorOfOverload, FirRegularClassSymbol outerClass) {
        FirValueParameterSymbol it;
        if (!($this$canBeMainOperatorOfOverload instanceof FirNamedFunctionSymbol)) {
            return false;
        }
        FirCallableSymbol<?> $this$isOperator$iv = $this$canBeMainOperatorOfOverload;
        boolean $i$f$isOperator = false;
        if (!$this$isOperator$iv.getResolvedStatus().isOperator()) return false;
        if (!Intrinsics.areEqual((Object)((FirNamedFunctionSymbol)$this$canBeMainOperatorOfOverload).getName(), (Object)OperatorNameConventions.OF)) return false;
        Iterable $this$none$iv = ((FirNamedFunctionSymbol)$this$canBeMainOperatorOfOverload).getValueParameterSymbols();
        boolean $i$f$none = false;
        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$none$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            it = (FirValueParameterSymbol)element$iv;
            boolean bl = false;
        } while (!it.isVararg());
        boolean bl = false;
        if (bl) {
            return false;
        }
        ConeKotlinType returnType = this.getContext().getReturnTypeCalculator().tryCalculateReturnType($this$canBeMainOperatorOfOverload).getConeType();
        if (returnType instanceof ConeClassLikeType && Intrinsics.areEqual((Object)TypeExpansionUtilsKt.fullyExpandedType$default((ConeClassLikeType)returnType, this.getContext().getSession(), null, 2, null).getLookupTag(), (Object)outerClass.toLookupTag())) {
            return true;
        }
        if (!(returnType instanceof ConeErrorType)) return false;
        return true;
    }

    private final FirRegularClassSymbol getCompanionObjectIfDefinedOperatorOf(ConeKotlinType $this$companionObjectIfDefinedOperatorOf) {
        FirRegularClassSymbol firRegularClassSymbol;
        FirRegularClassSymbol firRegularClassSymbol2 = this.getClassRepresentativeForCollectionLiteralResolution($this$companionObjectIfDefinedOperatorOf);
        if (firRegularClassSymbol2 == null) {
            return null;
        }
        FirRegularClassSymbol classSymbol = firRegularClassSymbol2;
        FirRegularClassSymbol firRegularClassSymbol3 = classSymbol.getResolvedCompanionObjectSymbol();
        if (firRegularClassSymbol3 == null) {
            return null;
        }
        FirRegularClassSymbol companionObjectSymbol = firRegularClassSymbol3;
        Ref.BooleanRef overloadFound = new Ref.BooleanRef();
        DeclarationUtilsKt.processAllDeclaredCallables$default(companionObjectSymbol, this.getContext().getSession(), null, arg_0 -> CollectionLiteralResolverThroughCompanion._get_companionObjectIfDefinedOperatorOf_$lambda$0(this, classSymbol, overloadFound, arg_0), 2, null);
        boolean $this$ifTrue$iv = overloadFound.element;
        boolean $i$f$ifTrue = false;
        if ($this$ifTrue$iv) {
            boolean bl = false;
            firRegularClassSymbol = companionObjectSymbol;
        } else {
            firRegularClassSymbol = null;
        }
        return firRegularClassSymbol;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    protected FirFunctionCall prepareRawCall(@NotNull FirCollectionLiteral collectionLiteral, @NotNull Candidate topLevelCandidate, @Nullable ConeKotlinType expectedType) {
        void $this$prepareRawCall_u24lambda_u240_u240;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder;
        FirFunctionCallBuilder firFunctionCallBuilder;
        Intrinsics.checkNotNullParameter((Object)collectionLiteral, (String)"collectionLiteral");
        Intrinsics.checkNotNullParameter((Object)topLevelCandidate, (String)"topLevelCandidate");
        Object object = expectedType;
        if (object == null || (object = this.getCompanionObjectIfDefinedOperatorOf((ConeKotlinType)object)) == null) {
            return null;
        }
        Object companion = object;
        boolean $i$f$buildFunctionCall = false;
        FirFunctionCallBuilder $this$prepareRawCall_u24lambda_u240 = firFunctionCallBuilder = new FirFunctionCallBuilder();
        boolean bl = false;
        KtSourceElement ktSourceElement = collectionLiteral.getSource();
        $this$prepareRawCall_u24lambda_u240.setExplicitReceiver(ResolveUtilsKt.toImplicitResolvedQualifierReceiver((FirRegularClassSymbol)companion, this.getComponents(), ktSourceElement != null ? KtSourceElementKt.fakeElement$default((KtSourceElement)ktSourceElement, (KtFakeSourceElementKind)((KtFakeSourceElementKind)KtFakeSourceElementKind.CompanionObjectForOperatorOfCall.INSTANCE), null, (int)2, null) : null));
        KtSourceElement ktSourceElement2 = collectionLiteral.getSource();
        $this$prepareRawCall_u24lambda_u240.setSource(ktSourceElement2 != null ? KtSourceElementKt.fakeElement$default((KtSourceElement)ktSourceElement2, (KtFakeSourceElementKind)((KtFakeSourceElementKind)KtFakeSourceElementKind.OperatorOfCall.INSTANCE), null, (int)2, null) : null);
        boolean $i$f$buildSimpleNamedReference = false;
        FirSimpleNamedReferenceBuilder firSimpleNamedReferenceBuilder2 = firSimpleNamedReferenceBuilder = new FirSimpleNamedReferenceBuilder();
        FirFunctionCallBuilder firFunctionCallBuilder2 = $this$prepareRawCall_u24lambda_u240;
        boolean bl2 = false;
        $this$prepareRawCall_u24lambda_u240_u240.setSource(collectionLiteral.getSource());
        $this$prepareRawCall_u24lambda_u240_u240.setName(OperatorNameConventions.OF);
        firFunctionCallBuilder2.setCalleeReference(firSimpleNamedReferenceBuilder.build());
        $this$prepareRawCall_u24lambda_u240.setArgumentList(collectionLiteral.getArgumentList());
        $this$prepareRawCall_u24lambda_u240.setOrigin(FirFunctionCallOrigin.Operator);
        FirFunctionCall functionCall = firFunctionCallBuilder.build();
        return functionCall;
    }

    private static final Unit _get_companionObjectIfDefinedOperatorOf_$lambda$0(CollectionLiteralResolverThroughCompanion this$0, FirRegularClassSymbol $classSymbol, Ref.BooleanRef $overloadFound, FirCallableSymbol declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (this$0.canBeMainOperatorOfOverload(declaration, $classSymbol)) {
            $overloadFound.element = true;
        }
        return Unit.INSTANCE;
    }
}

