/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.ArrayFqNames;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a$\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\t2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u000b"}, d2={"toArrayOfFactoryName", "Lorg/jetbrains/kotlin/name/Name;", "expectedType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "eagerlyReturnNonPrimitive", "", "toCollectionOfFactoryPackageAndName", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/name/FqName;", "resolve"})
@SourceDebugExtension(value={"SMAP\nStdlibFactoryFunctionsUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StdlibFactoryFunctionsUtils.kt\norg/jetbrains/kotlin/fir/resolve/StdlibFactoryFunctionsUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ConeTypes.kt\norg/jetbrains/kotlin/fir/types/ConeTypesKt\n*L\n1#1,77:1\n1#2:78\n50#3:79\n*S KotlinDebug\n*F\n+ 1 StdlibFactoryFunctionsUtils.kt\norg/jetbrains/kotlin/fir/resolve/StdlibFactoryFunctionsUtilsKt\n*L\n66#1:79\n*E\n"})
public final class StdlibFactoryFunctionsUtilsKt {
    @Nullable
    public static final Name toArrayOfFactoryName(@NotNull ConeKotlinType expectedType, @NotNull FirSession session2, boolean eagerlyReturnNonPrimitive) {
        Name name2;
        Intrinsics.checkNotNullParameter((Object)expectedType, (String)"expectedType");
        Intrinsics.checkNotNullParameter((Object)((Object)session2), (String)"session");
        ConeKotlinType coneType = TypeExpansionUtilsKt.fullyExpandedType$default(expectedType, session2, null, 2, null);
        if (ConeBuiltinTypeUtilsKt.isPrimitiveArray(coneType)) {
            ClassId arrayElementClassId;
            ConeKotlinType coneKotlinType = FirTypeUtilsKt.arrayElementType$default(coneType, false, 1, null);
            Intrinsics.checkNotNull((Object)coneKotlinType);
            ClassId classId = arrayElementClassId = ConeTypeUtilsKt.getClassId(coneKotlinType);
            Intrinsics.checkNotNull((Object)classId);
            String string = classId.getShortClassName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            PrimitiveType primitiveType = PrimitiveType.Companion.getByShortName(string);
            Object v = ArrayFqNames.INSTANCE.getPRIMITIVE_TYPE_TO_ARRAY().get(primitiveType);
            Intrinsics.checkNotNull(v);
            name2 = (Name)v;
        } else if (ConeBuiltinTypeUtilsKt.isUnsignedArray(coneType)) {
            ConeKotlinType coneKotlinType = FirTypeUtilsKt.arrayElementType$default(coneType, false, 1, null);
            Intrinsics.checkNotNull((Object)coneKotlinType);
            ClassId arrayElementClassId = ConeTypeUtilsKt.getClassId(coneKotlinType);
            Map map2 = ArrayFqNames.INSTANCE.getUNSIGNED_TYPE_TO_ARRAY();
            ClassId classId = arrayElementClassId;
            Intrinsics.checkNotNull((Object)classId);
            Object v = map2.get(classId.asSingleFqName());
            Intrinsics.checkNotNull(v);
            name2 = (Name)v;
        } else if (ConeBuiltinTypeUtilsKt.isNonPrimitiveArray(coneType)) {
            name2 = ArrayFqNames.INSTANCE.getARRAY_OF_FUNCTION();
        } else {
            if (!eagerlyReturnNonPrimitive) {
                return null;
            }
            name2 = ArrayFqNames.INSTANCE.getARRAY_OF_FUNCTION();
        }
        return name2;
    }

    @Nullable
    public static final Pair<FqName, Name> toCollectionOfFactoryPackageAndName(@NotNull ConeKotlinType expectedType, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)expectedType, (String)"expectedType");
        Intrinsics.checkNotNullParameter((Object)((Object)session2), (String)"session");
        Name name2 = StdlibFactoryFunctionsUtilsKt.toArrayOfFactoryName(expectedType, session2, false);
        if (name2 != null) {
            Name it = name2;
            boolean bl = false;
            return TuplesKt.to((Object)StandardNames.BUILT_INS_PACKAGE_FQ_NAME, (Object)it);
        }
        ConeInferenceContext $this$toCollectionOfFactoryPackageAndName_u24lambda_u241 = TypeComponentsKt.getTypeContext(session2);
        boolean bl = false;
        KotlinTypeMarker $this$asCone$iv = $this$toCollectionOfFactoryPackageAndName_u24lambda_u241.withNullability(TypeExpansionUtilsKt.fullyExpandedType$default(expectedType, session2, null, 2, null), false);
        boolean $i$f$asCone = false;
        ConeKotlinType coneType = (ConeKotlinType)$this$asCone$iv;
        return ConeBuiltinTypeUtilsKt.isList(coneType) ? TuplesKt.to((Object)StandardNames.COLLECTIONS_PACKAGE_FQ_NAME, (Object)Name.identifier((String)"listOf")) : (ConeBuiltinTypeUtilsKt.isMutableList(coneType) ? TuplesKt.to((Object)StandardNames.COLLECTIONS_PACKAGE_FQ_NAME, (Object)Name.identifier((String)"mutableListOf")) : (ConeBuiltinTypeUtilsKt.isSet(coneType) ? TuplesKt.to((Object)StandardNames.COLLECTIONS_PACKAGE_FQ_NAME, (Object)Name.identifier((String)"setOf")) : (ConeBuiltinTypeUtilsKt.isMutableSet(coneType) ? TuplesKt.to((Object)StandardNames.COLLECTIONS_PACKAGE_FQ_NAME, (Object)Name.identifier((String)"mutableSetOf")) : (ConeBuiltinTypeUtilsKt.isSequence(coneType) ? TuplesKt.to((Object)StandardNames.SEQUENCES_PACKAGE_FQ_NAME, (Object)Name.identifier((String)"sequenceOf")) : null))));
    }
}

