/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.RequiresOptIn;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKt;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirThisReceiverExpression;
import org.jetbrains.kotlin.fir.expressions.builder.FirSmartCastExpressionBuilder;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.builder.FirResolvedTypeRefBuilder;
import org.jetbrains.kotlin.types.SmartcastStability;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\u00020\u0003:\u0001#B!\b\u0004\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0014\u001a\u00020\u0015H$J\u0006\u0010\u001c\u001a\u00020\u0015J\u000e\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u0015J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\"\u001a\u00020\bH&R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0012\u0010\u000f\u001a\u00028\u0000X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\fR\u001b\u0010\u0016\u001a\u00020\u00158DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u001b\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0002$%\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/ImplicitValue;", "S", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "", "type", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "originalType", "mutable", "", "<init>", "(Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Z)V", "getOriginalType", "()Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "getMutable", "()Z", "boundSymbol", "getBoundSymbol", "()Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "value", "getType", "computeOriginalExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "originalExpression", "getOriginalExpression", "()Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "originalExpression$delegate", "Lkotlin/Lazy;", "isSmartCasted", "computeExpression", "isSameImplicitReceiverInstance", "other", "updateTypeFromSmartcast", "", "createSnapshot", "keepMutable", "ImplicitValueInternals", "Lorg/jetbrains/kotlin/fir/resolve/calls/ImplicitContextParameterValue;", "Lorg/jetbrains/kotlin/fir/resolve/calls/ImplicitReceiverValue;", "providers"})
@SourceDebugExtension(value={"SMAP\nImplicitValue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImplicitValue.kt\norg/jetbrains/kotlin/fir/resolve/calls/ImplicitValue\n+ 2 FirSmartCastExpressionBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirSmartCastExpressionBuilderKt\n+ 3 FirResolvedTypeRefBuilder.kt\norg/jetbrains/kotlin/fir/types/builder/FirResolvedTypeRefBuilderKt\n+ 4 FirReferenceUtils.kt\norg/jetbrains/kotlin/fir/references/FirReferenceUtilsKt\n*L\n1#1,150:1\n66#2:151\n52#3:152\n29#4,7:153\n*S KotlinDebug\n*F\n+ 1 ImplicitValue.kt\norg/jetbrains/kotlin/fir/resolve/calls/ImplicitValue\n*L\n73#1:151\n75#1:152\n92#1:153,7\n*E\n"})
public abstract class ImplicitValue<S extends FirBasedSymbol<?>> {
    @NotNull
    private final ConeKotlinType originalType;
    private final boolean mutable;
    @NotNull
    private ConeKotlinType type;
    @NotNull
    private final Lazy originalExpression$delegate;
    private boolean isSmartCasted;

    private ImplicitValue(ConeKotlinType type2, ConeKotlinType originalType, boolean mutable) {
        this.originalType = originalType;
        this.mutable = mutable;
        this.type = type2;
        this.originalExpression$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, (Function0)((Function0)new Function0<FirExpression>((Object)this){

            public final FirExpression invoke() {
                return ((ImplicitValue)this.receiver).computeOriginalExpression();
            }
        }));
        this.isSmartCasted = !Intrinsics.areEqual((Object)type2, (Object)this.originalType);
    }

    @NotNull
    public final ConeKotlinType getOriginalType() {
        return this.originalType;
    }

    protected final boolean getMutable() {
        return this.mutable;
    }

    @NotNull
    public abstract S getBoundSymbol();

    @NotNull
    public final ConeKotlinType getType() {
        return this.type;
    }

    @NotNull
    protected abstract FirExpression computeOriginalExpression();

    @NotNull
    protected final FirExpression getOriginalExpression() {
        Lazy lazy = this.originalExpression$delegate;
        return (FirExpression)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final FirExpression computeExpression() {
        FirExpression firExpression;
        if (this.isSmartCasted) {
            void $this$computeExpression_u24lambda_u240_u240;
            FirResolvedTypeRefBuilder firResolvedTypeRefBuilder;
            FirSmartCastExpressionBuilder firSmartCastExpressionBuilder;
            boolean $i$f$buildSmartCastExpression = false;
            FirSmartCastExpressionBuilder $this$computeExpression_u24lambda_u240 = firSmartCastExpressionBuilder = new FirSmartCastExpressionBuilder();
            boolean bl = false;
            $this$computeExpression_u24lambda_u240.setOriginalExpression(this.getOriginalExpression());
            boolean $i$f$buildResolvedTypeRef = false;
            FirResolvedTypeRefBuilder firResolvedTypeRefBuilder2 = firResolvedTypeRefBuilder = new FirResolvedTypeRefBuilder();
            FirSmartCastExpressionBuilder firSmartCastExpressionBuilder2 = $this$computeExpression_u24lambda_u240;
            boolean bl2 = false;
            KtSourceElement ktSourceElement = this.getOriginalExpression().getSource();
            $this$computeExpression_u24lambda_u240_u240.setSource(ktSourceElement != null ? KtSourceElementKt.fakeElement$default((KtSourceElement)ktSourceElement, (KtFakeSourceElementKind)((KtFakeSourceElementKind)KtFakeSourceElementKind.SmartCastedTypeRef.INSTANCE), null, (int)2, null) : null);
            $this$computeExpression_u24lambda_u240_u240.setConeType(this.type);
            firSmartCastExpressionBuilder2.setSmartcastType(firResolvedTypeRefBuilder.build());
            $this$computeExpression_u24lambda_u240.setUpperTypesFromSmartCast(CollectionsKt.listOf((Object)this.type));
            $this$computeExpression_u24lambda_u240.setSmartcastStability(SmartcastStability.STABLE_VALUE);
            $this$computeExpression_u24lambda_u240.setConeTypeOrNull(this.type);
            $this$computeExpression_u24lambda_u240.setLowerTypesFromSmartCast(CollectionsKt.emptyList());
            firExpression = firSmartCastExpressionBuilder.build();
        } else {
            firExpression = this.getOriginalExpression();
        }
        return firExpression;
    }

    public final boolean isSameImplicitReceiverInstance(@NotNull FirExpression other) {
        FirBasedSymbol<Object> firBasedSymbol;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        FirExpression otherOriginal = FirExpressionUtilKt.unwrapSmartcastExpression(other);
        if (otherOriginal instanceof FirThisReceiverExpression) {
            firBasedSymbol = (FirBasedSymbol<?>)((FirThisReceiverExpression)otherOriginal).getCalleeReference().getBoundSymbol();
        } else if (otherOriginal instanceof FirPropertyAccessExpression) {
            FirReference $this$toResolvedSymbol_u24default$iv = ((FirPropertyAccessExpression)otherOriginal).getCalleeReference();
            boolean discardErrorReference$iv = false;
            boolean $i$f$toResolvedSymbol = false;
            FirResolvedNamedReference firResolvedNamedReference = FirReferenceUtilsKt.getResolved($this$toResolvedSymbol_u24default$iv);
            firBasedSymbol = firResolvedNamedReference != null ? firResolvedNamedReference.getResolvedSymbol() : null;
            if (!(firBasedSymbol instanceof FirBasedSymbol)) {
                firBasedSymbol = null;
            }
        } else {
            firBasedSymbol = null;
        }
        FirBasedSymbol<?> otherBoundSymbol = firBasedSymbol;
        return this.getBoundSymbol() == otherBoundSymbol;
    }

    @ImplicitValueInternals
    public void updateTypeFromSmartcast(@NotNull ConeKotlinType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        if (Intrinsics.areEqual((Object)type2, (Object)this.type)) {
            return;
        }
        if (!this.mutable) {
            throw new IllegalStateException("Cannot mutate an immutable ImplicitReceiverValue".toString());
        }
        this.type = type2;
        this.isSmartCasted = !Intrinsics.areEqual((Object)type2, (Object)this.originalType);
    }

    @NotNull
    public abstract ImplicitValue<S> createSnapshot(boolean var1);

    public /* synthetic */ ImplicitValue(ConeKotlinType type2, ConeKotlinType originalType, boolean mutable, DefaultConstructorMarker $constructor_marker) {
        this(type2, originalType, mutable);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\b\u0087\u0002\u0018\u00002\u00020\u0001B\u0000\u00a8\u0006\u0002"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/ImplicitValue$ImplicitValueInternals;", "", "providers"})
    @RequiresOptIn
    public static @interface ImplicitValueInternals {
    }
}

