/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls.stages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.fir.LanguageVersionUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirValueParameterKind;
import org.jetbrains.kotlin.fir.diagnostics.ConeSimpleDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.ConeUnreportedDuplicateDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.resolve.calls.AmbiguousContextArgument;
import org.jetbrains.kotlin.fir.resolve.calls.ArgumentUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.ConeResolutionAtom;
import org.jetbrains.kotlin.fir.resolve.calls.ConeSimpleLeafResolutionAtom;
import org.jetbrains.kotlin.fir.resolve.calls.ImplicitValue;
import org.jetbrains.kotlin.fir.resolve.calls.ImplicitValueKt;
import org.jetbrains.kotlin.fir.resolve.calls.NoContextArgument;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionContext;
import org.jetbrains.kotlin.fir.resolve.calls.UnsupportedContextualDeclarationCall;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.CheckerSink;
import org.jetbrains.kotlin.fir.resolve.calls.stages.ImplicitArgumentDescription;
import org.jetbrains.kotlin.fir.resolve.calls.stages.ResolutionStage;
import org.jetbrains.kotlin.fir.resolve.calls.stages.ResolutionStagesKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilder;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilderKt;
import org.jetbrains.kotlin.resolve.calls.inference.model.ConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.inference.model.SimpleConstraintSystemConstraintPosition;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0096@R\u00020\u0006R\u00020\bj\u0006\u0010\u0007\u001a\u00020\u0006j\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\fJ\u0014\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e*\u00020\u000bH\u0002J\u0014\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e*\u00020\u000bH\u0002J?\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u000e*\u00020\u000b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002R\u00020\u0006R\u00020\bj\u0006\u0010\u0007\u001a\u00020\u0006j\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0014J.\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u000e*\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00182\u0012\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u000e0\u000eH\u0002J$\u0010\u001b\u001a\u00020\u0005*\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001d2\u000e\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u000eH\u0002J\f\u0010\u001f\u001a\u00020\u0012*\u00020\u0012H\u0002\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/stages/CheckContextArguments;", "Lorg/jetbrains/kotlin/fir/resolve/calls/stages/ResolutionStage;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CheckerSink;", "sink", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;", "context", "candidate", "Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;", "(Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CheckerSink;Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "obtainInvokeContextParametersOrNull", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirValueParameterSymbol;", "obtainRegularContextParametersOrNull", "mapContextArgumentsOrNull", "Lorg/jetbrains/kotlin/fir/resolve/calls/ConeResolutionAtom;", "contextSymbols", "(Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CheckerSink;Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;Ljava/util/List;)Ljava/util/List;", "findClosestMatchingContextArguments", "Lorg/jetbrains/kotlin/fir/resolve/calls/stages/ImplicitArgumentDescription;", "expectedType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "implicitGroups", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "replaceArgumentPrefixForInvokeWithImplicitlyMappedContextValues", "count", "", "resultingContextArguments", "copyImplicitValueExpression", "resolve"})
@SourceDebugExtension(value={"SMAP\nResolutionStages.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResolutionStages.kt\norg/jetbrains/kotlin/fir/resolve/calls/stages/CheckContextArguments\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,1140:1\n1#2:1141\n1525#3:1142\n1557#3,3:1143\n1560#3,3:1153\n1586#3:1156\n1661#3,2:1157\n832#3:1159\n862#3,2:1160\n1663#3:1162\n1586#3:1163\n1661#3,3:1164\n777#3:1167\n873#3,2:1168\n383#4,7:1146\n*S KotlinDebug\n*F\n+ 1 ResolutionStages.kt\norg/jetbrains/kotlin/fir/resolve/calls/stages/CheckContextArguments\n*L\n245#1:1142\n245#1:1143,3\n245#1:1153,3\n248#1:1156\n248#1:1157,2\n248#1:1159\n248#1:1160,2\n248#1:1162\n299#1:1163\n299#1:1164,3\n300#1:1167\n300#1:1168,2\n245#1:1146,7\n*E\n"})
public final class CheckContextArguments
extends ResolutionStage {
    @NotNull
    public static final CheckContextArguments INSTANCE = new CheckContextArguments();

    private CheckContextArguments() {
    }

    @Override
    @Nullable
    public Object check(@NotNull CheckerSink sink, @NotNull ResolutionContext context2, @NotNull Candidate candidate, @NotNull Continuation<? super Unit> $completion) {
        List<FirValueParameterSymbol> list2 = this.obtainInvokeContextParametersOrNull(candidate);
        if (list2 == null && (list2 = this.obtainRegularContextParametersOrNull(candidate)) == null) {
            return Unit.INSTANCE;
        }
        List<FirValueParameterSymbol> contextSymbols = list2;
        if (!LanguageVersionUtilsKt.isEnabled(context2, LanguageFeature.ContextParameters) && !LanguageVersionUtilsKt.isEnabled(context2, LanguageFeature.ContextReceivers)) {
            sink.reportDiagnostic(UnsupportedContextualDeclarationCall.INSTANCE);
            return Unit.INSTANCE;
        }
        List<ConeResolutionAtom> resultingContextArguments = this.mapContextArgumentsOrNull(sink, context2, candidate, contextSymbols);
        Integer contextParameterCountForInvoke = candidate.getExpectedContextParameterCountForInvoke();
        if (contextParameterCountForInvoke == null) {
            candidate.setContextArguments(resultingContextArguments);
        } else {
            this.replaceArgumentPrefixForInvokeWithImplicitlyMappedContextValues(candidate, contextParameterCountForInvoke, resultingContextArguments);
        }
        return Unit.INSTANCE;
    }

    private final List<FirValueParameterSymbol> obtainInvokeContextParametersOrNull(Candidate $this$obtainInvokeContextParametersOrNull) {
        Integer n = $this$obtainInvokeContextParametersOrNull.getExpectedContextParameterCountForInvoke();
        if (n == null) {
            return null;
        }
        int count = n;
        FirBasedSymbol<?> firBasedSymbol = $this$obtainInvokeContextParametersOrNull.getSymbol();
        Object object = firBasedSymbol instanceof FirFunctionSymbol ? (FirFunctionSymbol)firBasedSymbol : null;
        return object != null && (object = ((FirFunctionSymbol)object).getValueParameterSymbols()) != null ? CollectionsKt.take((Iterable)((Iterable)object), (int)count) : null;
    }

    private final List<FirValueParameterSymbol> obtainRegularContextParametersOrNull(Candidate $this$obtainRegularContextParametersOrNull) {
        FirBasedSymbol<?> firBasedSymbol;
        FirCallableSymbol firCallableSymbol;
        FirBasedSymbol<?> firBasedSymbol2 = $this$obtainRegularContextParametersOrNull.getSymbol();
        FirCallableSymbol firCallableSymbol2 = firCallableSymbol = firBasedSymbol2 instanceof FirCallableSymbol ? (FirCallableSymbol)firBasedSymbol2 : null;
        if (firCallableSymbol != null && (firBasedSymbol2 = firCallableSymbol.getContextParameterSymbols()) != null) {
            FirBasedSymbol<?> firBasedSymbol3;
            FirBasedSymbol<?> it = firBasedSymbol3 = firBasedSymbol2;
            boolean bl = false;
            firBasedSymbol = !it.isEmpty() ? firBasedSymbol3 : null;
        } else {
            firBasedSymbol = null;
        }
        return firBasedSymbol;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ConeResolutionAtom> mapContextArgumentsOrNull(CheckerSink sink, ResolutionContext context2, Candidate $this$mapContextArgumentsOrNull, List<FirValueParameterSymbol> contextSymbols) {
        void $this$mapTo$iv$iv;
        Object object;
        Object key$iv$iv$iv;
        Iterable $this$groupByTo$iv$iv;
        void $this$groupBy$iv;
        Iterable iterable = context2.getBodyResolveContext().getImplicitValueStorage().getImplicitValues();
        boolean $i$f$groupBy = false;
        void var8_7 = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            void it2;
            Object object2;
            void $this$getOrPut$iv$iv$iv;
            ImplicitValue implicitValue = (ImplicitValue)element$iv$iv;
            boolean $i$a$-groupBy-CheckContextArguments$mapContextArgumentsOrNull$implicitsGroupedByScope$332 = false;
            FirBasedSymbol key$iv$iv = ResolutionStagesKt.access$containingDeclarationIfParameter(implicitValue.getBoundSymbol());
            Map map2 = destination$iv$iv;
            key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list2 = (List)object2;
            ImplicitValue $i$a$-groupBy-CheckContextArguments$mapContextArgumentsOrNull$implicitsGroupedByScope$332 = (ImplicitValue)element$iv$iv;
            object = list2;
            boolean bl = false;
            object.add(it2.computeExpression());
        }
        Iterable $this$map$iv = destination$iv$iv.values();
        boolean $i$f$map = false;
        $this$groupByTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$filterNotTo$iv$iv;
            List list3 = (List)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            Iterable $this$filterNot$iv = list3;
            boolean $i$f$filterNot = false;
            key$iv$iv$iv = $this$filterNot$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                FirExpression p0 = (FirExpression)element$iv$iv;
                boolean bl2 = false;
                if (ArgumentUtilsKt.isInaccessibleAndInapplicable(p0)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            object.add((List)destination$iv$iv2);
        }
        List implicitsGroupedByScope = CollectionsKt.reversed((Iterable)((List)destination$iv$iv));
        List resultingContextArguments = new ArrayList();
        boolean errorReported = false;
        Object object3 = MapsKt.createMapBuilder();
        Map $this$mapContextArgumentsOrNull_u24lambda_u243 = object3;
        boolean bl = false;
        for (Map.Entry entry : ((Map)$this$mapContextArgumentsOrNull.getArgumentMapping()).entrySet()) {
            ConeResolutionAtom key = (ConeResolutionAtom)entry.getKey();
            FirValueParameter value = (FirValueParameter)entry.getValue();
            if (value.getValueParameterKind() == FirValueParameterKind.Regular) continue;
            $this$mapContextArgumentsOrNull_u24lambda_u243.put(value.getSymbol(), key);
        }
        Map contextArgumentsByParameterSymbol = MapsKt.build((Map)object3);
        object3 = contextSymbols.iterator();
        block8: while (object3.hasNext()) {
            FirValueParameterSymbol symbol = (FirValueParameterSymbol)object3.next();
            ConeResolutionAtom argument2 = (ConeResolutionAtom)contextArgumentsByParameterSymbol.get(symbol);
            if (argument2 != null) {
                resultingContextArguments.add(argument2);
                continue;
            }
            ConeKotlinType expectedType = $this$mapContextArgumentsOrNull.getSubstitutor().substituteOrSelf(symbol.getResolvedReturnType());
            List<ImplicitArgumentDescription> list4 = this.findClosestMatchingContextArguments($this$mapContextArgumentsOrNull, expectedType, implicitsGroupedByScope);
            switch (list4.size()) {
                case 0: {
                    sink.reportDiagnostic(new NoContextArgument(symbol));
                    errorReported = true;
                    continue block8;
                }
                case 1: {
                    ImplicitArgumentDescription matchingReceiver = (ImplicitArgumentDescription)CollectionsKt.single(list4);
                    resultingContextArguments.add(matchingReceiver.getAtom());
                    $this$mapContextArgumentsOrNull.getSystem().addSubtypeConstraint((KotlinTypeMarker)matchingReceiver.getType(), (KotlinTypeMarker)expectedType, (ConstraintPosition)SimpleConstraintSystemConstraintPosition.INSTANCE);
                    continue block8;
                }
            }
            sink.reportDiagnostic(new AmbiguousContextArgument(symbol));
            errorReported = true;
        }
        Object it4 = object3 = resultingContextArguments;
        boolean bl3 = false;
        return !errorReported ? object3 : null;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ImplicitArgumentDescription> findClosestMatchingContextArguments(Candidate $this$findClosestMatchingContextArguments, ConeKotlinType expectedType, List<? extends List<? extends FirExpression>> implicitGroups) {
        for (List<? extends FirExpression> list2 : implicitGroups) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            ImplicitArgumentDescription it;
            boolean bl;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Iterable iterable = list2;
            boolean $i$f$map = false;
            void var9_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                FirExpression firExpression = (FirExpression)item$iv$iv;
                Collection collection = destination$iv$iv;
                bl = false;
                collection.add(ResolutionStagesKt.access$prepareImplicitArgument(ConeResolutionAtom.Companion.createRawAtom((FirExpression)((Object)it)), expectedType, $this$findClosestMatchingContextArguments.getCallInfo().getSession()));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (ImplicitArgumentDescription)element$iv$iv;
                bl = false;
                if (!ConstraintSystemBuilderKt.isSubtypeConstraintCompatible((ConstraintSystemBuilder)((ConstraintSystemBuilder)$this$findClosestMatchingContextArguments.getSystem()), (KotlinTypeMarker)it.getType(), (KotlinTypeMarker)expectedType)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List currentResult = (List)destination$iv$iv;
            if (!(!((Collection)currentResult).isEmpty())) continue;
            return currentResult;
        }
        return CollectionsKt.emptyList();
    }

    private final void replaceArgumentPrefixForInvokeWithImplicitlyMappedContextValues(Candidate $this$replaceArgumentPrefixForInvokeWithImplicitlyMappedContextValues, int count, List<? extends ConeResolutionAtom> resultingContextArguments) {
        List newArgumentPrefix = new ArrayList();
        for (int j = 0; j < count; ++j) {
            int index2 = j;
            boolean bl = false;
            List<? extends ConeResolutionAtom> list2 = resultingContextArguments;
            if (list2 == null || (list2 = list2.get(index2)) == null || (list2 = INSTANCE.copyImplicitValueExpression((ConeResolutionAtom)((Object)list2))) == null) {
                list2 = ConeResolutionAtom.Companion.createRawAtom(FirExpressionUtilKt.buildErrorExpression$default($this$replaceArgumentPrefixForInvokeWithImplicitlyMappedContextValues.getCallInfo().getCallSite().getSource(), new ConeUnreportedDuplicateDiagnostic(new ConeSimpleDiagnostic("Unresolved context argument", DiagnosticKind.Other)), null, 4, null));
            }
            List<? extends ConeResolutionAtom> newValue = list2;
            newArgumentPrefix.add(newValue);
        }
        $this$replaceArgumentPrefixForInvokeWithImplicitlyMappedContextValues.replaceArgumentPrefix(newArgumentPrefix);
    }

    private final ConeResolutionAtom copyImplicitValueExpression(ConeResolutionAtom $this$copyImplicitValueExpression) {
        if (!($this$copyImplicitValueExpression instanceof ConeSimpleLeafResolutionAtom)) {
            return $this$copyImplicitValueExpression;
        }
        return ConeResolutionAtom.Companion.createRawAtom(ImplicitValueKt.copyImplicitValueExpression(((ConeSimpleLeafResolutionAtom)$this$copyImplicitValueExpression).getExpression()));
    }
}

