/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls.stages;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.expressions.FirImplicitInvokeCall;
import org.jetbrains.kotlin.fir.resolve.calls.ConeResolutionAtom;
import org.jetbrains.kotlin.fir.resolve.calls.NoReceiverAllowed;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionContext;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.candidate.CheckerSink;
import org.jetbrains.kotlin.fir.resolve.calls.stages.ArgumentCheckingProcessor;
import org.jetbrains.kotlin.fir.resolve.calls.stages.ImplicitArgumentDescription;
import org.jetbrains.kotlin.fir.resolve.calls.stages.ResolutionStage;
import org.jetbrains.kotlin.fir.resolve.calls.stages.ResolutionStagesKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0096@R\u00020\u0006R\u00020\bj\u0006\u0010\u0007\u001a\u00020\u0006j\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\fJ>\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0082@R\u00020\u0006R\u00020\bj\u0006\u0010\u0007\u001a\u00020\u0006j\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0012J\u000e\u0010\u0013\u001a\u0004\u0018\u00010\u0011*\u00020\u000bH\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/stages/CheckExtensionReceiver;", "Lorg/jetbrains/kotlin/fir/resolve/calls/stages/ResolutionStage;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CheckerSink;", "sink", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;", "context", "candidate", "Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;", "(Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CheckerSink;Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "resolveExtensionReceiver", "receiver", "Lorg/jetbrains/kotlin/fir/resolve/calls/stages/ImplicitArgumentDescription;", "expectedType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "(Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/CheckerSink;Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;Lorg/jetbrains/kotlin/fir/resolve/calls/stages/ImplicitArgumentDescription;Lorg/jetbrains/kotlin/fir/resolve/calls/candidate/Candidate;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getExpectedReceiverType", "resolve"})
@SourceDebugExtension(value={"SMAP\nResolutionStages.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResolutionStages.kt\norg/jetbrains/kotlin/fir/resolve/calls/stages/CheckExtensionReceiver\n+ 2 CheckerSink.kt\norg/jetbrains/kotlin/fir/resolve/calls/candidate/CheckerSinkKt\n*L\n1#1,1140:1\n23#2,4:1141\n*S KotlinDebug\n*F\n+ 1 ResolutionStages.kt\norg/jetbrains/kotlin/fir/resolve/calls/stages/CheckExtensionReceiver\n*L\n109#1:1141,4\n*E\n"})
public final class CheckExtensionReceiver
extends ResolutionStage {
    @NotNull
    public static final CheckExtensionReceiver INSTANCE = new CheckExtensionReceiver();

    private CheckExtensionReceiver() {
    }

    @Override
    @Nullable
    public Object check(@NotNull CheckerSink sink, @NotNull ResolutionContext context2, @NotNull Candidate candidate, @NotNull Continuation<? super Unit> $completion) {
        FirElement callSite = candidate.getCallInfo().getCallSite();
        if (callSite instanceof FirImplicitInvokeCall) {
            boolean isInvokeFromExtensionFunctionType = ResolutionStagesKt.isInvokeFromExtensionFunctionType(candidate);
            boolean isImplicitInvokeCallWithExplicitReceiver = ((FirImplicitInvokeCall)callSite).isCallWithExplicitReceiver();
            if (!isInvokeFromExtensionFunctionType && isImplicitInvokeCallWithExplicitReceiver) {
                sink.reportDiagnostic(NoReceiverAllowed.INSTANCE);
            }
        }
        ConeKotlinType coneKotlinType = this.getExpectedReceiverType(candidate);
        if (coneKotlinType == null) {
            return Unit.INSTANCE;
        }
        ConeKotlinType expectedReceiverType = coneKotlinType;
        ConeKotlinType expectedType = candidate.getSubstitutor().substituteOrSelf(expectedReceiverType);
        if (candidate.getGivenExtensionReceiver() == null) {
            return Unit.INSTANCE;
        }
        ImplicitArgumentDescription preparedReceiver = ResolutionStagesKt.access$prepareImplicitArgument(candidate.getGivenExtensionReceiver(), expectedType, context2.getSession());
        Object object = this.resolveExtensionReceiver(sink, context2, preparedReceiver, candidate, expectedType, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final Object resolveExtensionReceiver(CheckerSink sink, ResolutionContext context2, ImplicitArgumentDescription receiver2, Candidate candidate, ConeKotlinType expectedType, Continuation<? super Unit> $completion) {
        ConeResolutionAtom atom = receiver2.component1();
        ConeKotlinType type2 = receiver2.component2();
        ArgumentCheckingProcessor.INSTANCE.resolvePlainArgumentType(candidate, atom, type2, expectedType, sink, context2, true, false, candidate.getCallInfo().getCallSite().getSource());
        candidate.setChosenExtensionReceiver(atom);
        CheckerSink $this$yieldIfNeed$iv = sink;
        boolean $i$f$yieldIfNeed = false;
        if ($this$yieldIfNeed$iv.getNeedYielding()) {
            Object object = $this$yieldIfNeed$iv.yield($completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
        }
        return Unit.INSTANCE;
    }

    private final ConeKotlinType getExpectedReceiverType(Candidate $this$getExpectedReceiverType) {
        FirBasedSymbol<?> firBasedSymbol = $this$getExpectedReceiverType.getSymbol();
        FirCallableSymbol firCallableSymbol = firBasedSymbol instanceof FirCallableSymbol ? (FirCallableSymbol)firBasedSymbol : null;
        if (firCallableSymbol == null) {
            return null;
        }
        FirCallableSymbol callableSymbol = firCallableSymbol;
        FirPureAbstractElement firPureAbstractElement = ((FirCallableDeclaration)callableSymbol.getFir()).getReceiverParameter();
        return firPureAbstractElement != null && (firPureAbstractElement = firPureAbstractElement.getTypeRef()) != null ? FirTypeUtilsKt.getConeType((FirTypeRef)firPureAbstractElement) : null;
    }

    public static final /* synthetic */ Object access$resolveExtensionReceiver(CheckExtensionReceiver $this, CheckerSink sink, ResolutionContext context2, ImplicitArgumentDescription receiver2, Candidate candidate, ConeKotlinType expectedType, Continuation $completion) {
        return $this.resolveExtensionReceiver(sink, context2, receiver2, candidate, expectedType, (Continuation<? super Unit>)$completion);
    }
}

