/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.SessionAndScopeSessionHolder;
import org.jetbrains.kotlin.fir.SessionHolder;
import org.jetbrains.kotlin.fir.declarations.FirNamedFunction;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.expressions.FirIntegerLiteralOperatorCall;
import org.jetbrains.kotlin.fir.expressions.FirLiteralExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.builder.FirFunctionCallBuilder;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirResolvedErrorReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.references.builder.FirResolvedErrorReferenceBuilder;
import org.jetbrains.kotlin.fir.references.builder.FirResolvedNamedReferenceBuilder;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.ScopeUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.scopes.CallableCopyTypeCalculator;
import org.jetbrains.kotlin.fir.scopes.FirScopeKt;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.impl.FirIntegerConstantOperatorScopeKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitBuiltinTypeRef;
import org.jetbrains.kotlin.fir.visitors.FirTransformer;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.ConstantValueKind;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 )2\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00012\u00020\u0003:\u0001)B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J)\u0010\u001c\u001a\u0002H\u001d\"\b\b\u0000\u0010\u001d*\u00020\u001e2\u0006\u0010\u001f\u001a\u0002H\u001d2\b\u0010 \u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0002\u0010!J\u001a\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\b\u0010 \u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010&\u001a\u00020#2\u0006\u0010'\u001a\u00020(2\b\u0010 \u001a\u0004\u0018\u00010\u0002H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001b\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R\u001b\u0010\u0014\u001a\u00020\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0013\u001a\u0004\b\u0015\u0010\u0011\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/IntegerLiteralAndOperatorApproximationTransformer;", "Lorg/jetbrains/kotlin/fir/visitors/FirTransformer;", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "Lorg/jetbrains/kotlin/fir/SessionAndScopeSessionHolder;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;)V", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "getScopeSession", "()Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "toLongSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "getToLongSymbol", "()Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "toLongSymbol$delegate", "Lkotlin/Lazy;", "toULongSymbol", "getToULongSymbol", "toULongSymbol$delegate", "findConversionFunction", "receiverType", "Lorg/jetbrains/kotlin/fir/types/impl/FirImplicitBuiltinTypeRef;", "name", "Lorg/jetbrains/kotlin/name/Name;", "transformElement", "E", "Lorg/jetbrains/kotlin/fir/FirElement;", "element", "data", "(Lorg/jetbrains/kotlin/fir/FirElement;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)Lorg/jetbrains/kotlin/fir/FirElement;", "transformLiteralExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "literalExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirLiteralExpression;", "transformIntegerLiteralOperatorCall", "integerLiteralOperatorCall", "Lorg/jetbrains/kotlin/fir/expressions/FirIntegerLiteralOperatorCall;", "Companion", "resolve"})
@SourceDebugExtension(value={"SMAP\nIntegerLiteralAndOperatorApproximationTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntegerLiteralAndOperatorApproximationTransformer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/IntegerLiteralAndOperatorApproximationTransformer\n+ 2 BodyResolveUtils.kt\norg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/BodyResolveUtilsKt\n+ 3 FirResolvedErrorReferenceBuilder.kt\norg/jetbrains/kotlin/fir/references/builder/FirResolvedErrorReferenceBuilderKt\n+ 4 FirResolvedNamedReferenceBuilder.kt\norg/jetbrains/kotlin/fir/references/builder/FirResolvedNamedReferenceBuilderKt\n+ 5 FirFunctionCallBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirFunctionCallBuilderKt\n*L\n1#1,136:1\n32#2,2:137\n32#2,2:139\n48#3:141\n45#4:142\n45#4:144\n66#5:143\n*S KotlinDebug\n*F\n+ 1 IntegerLiteralAndOperatorApproximationTransformer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/IntegerLiteralAndOperatorApproximationTransformer\n*L\n65#1:137,2\n84#1:139,2\n93#1:141\n99#1:142\n123#1:144\n117#1:143\n*E\n"})
public final class IntegerLiteralAndOperatorApproximationTransformer
extends FirTransformer<ConeKotlinType>
implements SessionAndScopeSessionHolder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FirSession session;
    @NotNull
    private final ScopeSession scopeSession;
    @NotNull
    private final Lazy toLongSymbol$delegate;
    @NotNull
    private final Lazy toULongSymbol$delegate;
    @NotNull
    private static final Name TO_LONG;
    @NotNull
    private static final Name TO_U_LONG;

    public IntegerLiteralAndOperatorApproximationTransformer(@NotNull FirSession session2, @NotNull ScopeSession scopeSession) {
        Intrinsics.checkNotNullParameter((Object)((Object)session2), (String)"session");
        Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
        this.session = session2;
        this.scopeSession = scopeSession;
        this.toLongSymbol$delegate = LazyKt.lazy(() -> IntegerLiteralAndOperatorApproximationTransformer.toLongSymbol_delegate$lambda$0(this));
        this.toULongSymbol$delegate = LazyKt.lazy(() -> IntegerLiteralAndOperatorApproximationTransformer.toULongSymbol_delegate$lambda$0(this));
    }

    @Override
    @NotNull
    public FirSession getSession() {
        return this.session;
    }

    @Override
    @NotNull
    public ScopeSession getScopeSession() {
        return this.scopeSession;
    }

    private final FirNamedFunctionSymbol getToLongSymbol() {
        Lazy lazy = this.toLongSymbol$delegate;
        return (FirNamedFunctionSymbol)lazy.getValue();
    }

    private final FirNamedFunctionSymbol getToULongSymbol() {
        Lazy lazy = this.toULongSymbol$delegate;
        return (FirNamedFunctionSymbol)lazy.getValue();
    }

    private final FirNamedFunctionSymbol findConversionFunction(FirImplicitBuiltinTypeRef receiverType, Name name2) {
        FirTypeScope firTypeScope = ScopeUtilsKt.scope(this, receiverType.getConeType(), CallableCopyTypeCalculator.DoNothing.INSTANCE, FirResolvePhase.STATUS);
        Intrinsics.checkNotNull((Object)firTypeScope);
        return (FirNamedFunctionSymbol)CollectionsKt.single(FirScopeKt.getFunctions(firTypeScope, name2));
    }

    @Override
    @NotNull
    public <E extends FirElement> E transformElement(@NotNull E element, @Nullable ConeKotlinType data) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        return element;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public FirStatement transformLiteralExpression(@NotNull FirLiteralExpression literalExpression, @Nullable ConeKotlinType data) {
        void $this$resultType$iv;
        Intrinsics.checkNotNullParameter((Object)literalExpression, (String)"literalExpression");
        Object object = FirTypeUtilsKt.getResolvedType(literalExpression);
        ConeIntegerLiteralType coneIntegerLiteralType = object instanceof ConeIntegerLiteralType ? (ConeIntegerLiteralType)object : null;
        if (coneIntegerLiteralType == null) {
            return literalExpression;
        }
        ConeIntegerLiteralType type2 = coneIntegerLiteralType;
        ConeClassLikeType approximatedType = type2.getApproximatedType(data != null ? TypeExpansionUtilsKt.fullyExpandedType((SessionHolder)this, data) : null);
        object = literalExpression;
        ConeKotlinType type$iv = approximatedType;
        boolean $i$f$setResultType = false;
        $this$resultType$iv.replaceConeTypeOrNull(type$iv);
        ConstantValueKind constantValueKind = FirTypeUtilsKt.toConstKind(approximatedType);
        Intrinsics.checkNotNull((Object)constantValueKind, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.types.ConstantValueKind");
        ConstantValueKind kind2 = constantValueKind;
        literalExpression.replaceKind(kind2);
        return literalExpression;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public FirStatement transformIntegerLiteralOperatorCall(@NotNull FirIntegerLiteralOperatorCall integerLiteralOperatorCall, @Nullable ConeKotlinType data) {
        void $this$transformIntegerLiteralOperatorCall_u24lambda_u242_u240;
        FirResolvedNamedReferenceBuilder firResolvedNamedReferenceBuilder;
        FirFunctionCallBuilder firFunctionCallBuilder;
        void $this$resultType$iv;
        Intrinsics.checkNotNullParameter((Object)integerLiteralOperatorCall, (String)"integerLiteralOperatorCall");
        FirIntegerLiteralOperatorCall call = integerLiteralOperatorCall;
        Object object = FirTypeUtilsKt.getResolvedType(call);
        ConeIntegerLiteralType coneIntegerLiteralType = object instanceof ConeIntegerLiteralType ? (ConeIntegerLiteralType)object : null;
        if (coneIntegerLiteralType == null) {
            return call;
        }
        ConeIntegerLiteralType operatorType = coneIntegerLiteralType;
        ConeClassLikeType approximatedType = operatorType.getApproximatedType(data != null ? TypeExpansionUtilsKt.fullyExpandedType((SessionHolder)this, data) : null);
        call.transformDispatchReceiver(this, null);
        call.transformExtensionReceiver(this, null);
        call.getArgumentList().transformArguments(this, null);
        object = call;
        ConeKotlinType type$iv = approximatedType;
        boolean $i$f$setResultType = false;
        $this$resultType$iv.replaceConeTypeOrNull(type$iv);
        FirNamedReference calleeReference = call.getCalleeReference();
        if (calleeReference instanceof FirResolvedNamedReference) {
            FirResolvedNamedReference firResolvedNamedReference;
            Object object2;
            FirBasedSymbol<?> firBasedSymbol = ((FirResolvedNamedReference)calleeReference).getResolvedSymbol();
            Intrinsics.checkNotNull(firBasedSymbol, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol");
            FirNamedFunctionSymbol wrappedFunctionSymbol = (FirNamedFunctionSymbol)firBasedSymbol;
            FirNamedFunctionSymbol firNamedFunctionSymbol = FirIntegerConstantOperatorScopeKt.getOriginalForWrappedIntegerOperator((FirNamedFunction)wrappedFunctionSymbol.getFir());
            Intrinsics.checkNotNull((Object)firNamedFunctionSymbol);
            FirNamedFunctionSymbol originalFunctionSymbol = firNamedFunctionSymbol;
            if ((FirResolvedNamedReference)calleeReference instanceof FirResolvedErrorReference) {
                boolean $i$f$buildResolvedErrorReference = false;
                Object $this$transformIntegerLiteralOperatorCall_u24lambda_u240 = object2 = new FirResolvedErrorReferenceBuilder();
                boolean bl = false;
                ((FirResolvedErrorReferenceBuilder)$this$transformIntegerLiteralOperatorCall_u24lambda_u240).setName(((FirResolvedErrorReference)calleeReference).getName());
                ((FirResolvedErrorReferenceBuilder)$this$transformIntegerLiteralOperatorCall_u24lambda_u240).setSource(((FirResolvedErrorReference)calleeReference).getSource());
                ((FirResolvedErrorReferenceBuilder)$this$transformIntegerLiteralOperatorCall_u24lambda_u240).setResolvedSymbol(originalFunctionSymbol);
                ((FirResolvedErrorReferenceBuilder)$this$transformIntegerLiteralOperatorCall_u24lambda_u240).setDiagnostic(((FirResolvedErrorReference)calleeReference).getDiagnostic());
                firResolvedNamedReference = ((FirResolvedErrorReferenceBuilder)object2).build();
            } else {
                boolean $i$f$buildResolvedNamedReference = false;
                Object $this$transformIntegerLiteralOperatorCall_u24lambda_u241 = object2 = new FirResolvedNamedReferenceBuilder();
                boolean bl = false;
                ((FirResolvedNamedReferenceBuilder)$this$transformIntegerLiteralOperatorCall_u24lambda_u241).setName(((FirResolvedNamedReference)calleeReference).getName());
                ((FirResolvedNamedReferenceBuilder)$this$transformIntegerLiteralOperatorCall_u24lambda_u241).setSource(((FirResolvedNamedReference)calleeReference).getSource());
                ((FirResolvedNamedReferenceBuilder)$this$transformIntegerLiteralOperatorCall_u24lambda_u241).setResolvedSymbol(originalFunctionSymbol);
                firResolvedNamedReference = ((FirResolvedNamedReferenceBuilder)object2).build();
            }
            FirResolvedNamedReference newCalleeReference = firResolvedNamedReference;
            call.replaceCalleeReference(newCalleeReference);
        }
        if (ConeBuiltinTypeUtilsKt.isInt(approximatedType) || ConeBuiltinTypeUtilsKt.isUInt(approximatedType)) {
            return call;
        }
        ConeClassLikeType typeBeforeConversion = operatorType.isUnsigned() ? this.getSession().getBuiltinTypes().getUIntType().getConeType() : this.getSession().getBuiltinTypes().getIntType().getConeType();
        call.replaceConeTypeOrNull(typeBeforeConversion);
        boolean $i$f$buildFunctionCall = false;
        FirFunctionCallBuilder $this$transformIntegerLiteralOperatorCall_u24lambda_u242 = firFunctionCallBuilder = new FirFunctionCallBuilder();
        boolean bl = false;
        KtSourceElement ktSourceElement = call.getSource();
        KtSourceElement fakeSource = ktSourceElement != null ? KtSourceElementKt.fakeElement$default((KtSourceElement)ktSourceElement, (KtFakeSourceElementKind)((KtFakeSourceElementKind)KtFakeSourceElementKind.IntToLongConversion.INSTANCE), null, (int)2, null) : null;
        $this$transformIntegerLiteralOperatorCall_u24lambda_u242.setSource(fakeSource);
        $this$transformIntegerLiteralOperatorCall_u24lambda_u242.setConeTypeOrNull(this.getSession().getBuiltinTypes().getLongType().getConeType());
        $this$transformIntegerLiteralOperatorCall_u24lambda_u242.setExplicitReceiver(call);
        $this$transformIntegerLiteralOperatorCall_u24lambda_u242.setDispatchReceiver(call);
        boolean $i$f$buildResolvedNamedReference = false;
        FirResolvedNamedReferenceBuilder firResolvedNamedReferenceBuilder2 = firResolvedNamedReferenceBuilder = new FirResolvedNamedReferenceBuilder();
        FirFunctionCallBuilder firFunctionCallBuilder2 = $this$transformIntegerLiteralOperatorCall_u24lambda_u242;
        boolean bl2 = false;
        $this$transformIntegerLiteralOperatorCall_u24lambda_u242_u240.setSource(fakeSource);
        if (operatorType.isUnsigned()) {
            $this$transformIntegerLiteralOperatorCall_u24lambda_u242_u240.setName(TO_U_LONG);
            $this$transformIntegerLiteralOperatorCall_u24lambda_u242_u240.setResolvedSymbol(this.getToULongSymbol());
        } else {
            $this$transformIntegerLiteralOperatorCall_u24lambda_u242_u240.setName(TO_LONG);
            $this$transformIntegerLiteralOperatorCall_u24lambda_u242_u240.setResolvedSymbol(this.getToLongSymbol());
        }
        firFunctionCallBuilder2.setCalleeReference(firResolvedNamedReferenceBuilder.build());
        return firFunctionCallBuilder.build();
    }

    private static final FirNamedFunctionSymbol toLongSymbol_delegate$lambda$0(IntegerLiteralAndOperatorApproximationTransformer this$0) {
        return this$0.findConversionFunction(this$0.getSession().getBuiltinTypes().getIntType(), TO_LONG);
    }

    private static final FirNamedFunctionSymbol toULongSymbol_delegate$lambda$0(IntegerLiteralAndOperatorApproximationTransformer this$0) {
        return this$0.findConversionFunction(this$0.getSession().getBuiltinTypes().getUIntType(), TO_U_LONG);
    }

    static {
        Name name2 = Name.identifier((String)"toLong");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        TO_LONG = name2;
        Name name3 = Name.identifier((String)"toULong");
        Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"identifier(...)");
        TO_U_LONG = name3;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/IntegerLiteralAndOperatorApproximationTransformer$Companion;", "", "<init>", "()V", "TO_LONG", "Lorg/jetbrains/kotlin/name/Name;", "TO_U_LONG", "resolve"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

