/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers.body.resolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.synthetic.FirSyntheticProperty;
import org.jetbrains.kotlin.fir.resolve.transformers.body.resolve.ImplicitBodyResolveComputationStatus;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirSyntheticPropertySymbol;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010#\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\r\u001a\u00020\u00072\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0000\u00a2\u0006\u0002\b\u000fJ1\u0010\u0010\u001a\u0002H\u0011\"\b\b\u0000\u0010\u0011*\u00020\u00122\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u00062\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0014H\u0014\u00a2\u0006\u0002\u0010\u0015J3\u0010\u0016\u001a\u0002H\u0011\"\b\b\u0000\u0010\u0011*\u00020\u00122\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u00062\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0014H\u0000\u00a2\u0006\u0004\b\u0017\u0010\u0015J\u0014\u0010\u0018\u001a\u00020\u00192\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0002J\u001c\u0010\u001a\u001a\u00020\u00192\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u001b\u001a\u00020\u0012H\u0002J\u0012\u0010\u001c\u001a\u00020\u00192\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u0006J\u0012\u0010\u001d\u001a\u00020\u001e2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u0006R2\u0010\u0004\u001a&\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/ImplicitBodyResolveComputationSession;", "", "<init>", "()V", "implicitBodyResolveStatusMap", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/ImplicitBodyResolveComputationStatus;", "Lkotlin/collections/HashMap;", "computingSymbolsStack", "", "nonTrivialLoops", "", "getStatus", "symbol", "getStatus$resolve", "executeTransformation", "D", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "transformation", "Lkotlin/Function0;", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;Lkotlin/jvm/functions/Function0;)Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "compute", "compute$resolve", "startComputing", "", "storeResult", "transformedDeclaration", "calculateAndStoreNonTrivialLoop", "belongToSomeNonTrivialLoop", "", "resolve"})
@SourceDebugExtension(value={"SMAP\nFirImplicitBodyResolve.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirImplicitBodyResolve.kt\norg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/ImplicitBodyResolveComputationSession\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,483:1\n952#2,15:484\n1#3:499\n*S KotlinDebug\n*F\n+ 1 FirImplicitBodyResolve.kt\norg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/ImplicitBodyResolveComputationSession\n*L\n458#1:484,15\n*E\n"})
public class ImplicitBodyResolveComputationSession {
    @NotNull
    private final HashMap<FirCallableSymbol<?>, ImplicitBodyResolveComputationStatus> implicitBodyResolveStatusMap = new HashMap();
    @NotNull
    private final List<FirCallableSymbol<?>> computingSymbolsStack = new ArrayList();
    @NotNull
    private final Set<FirCallableSymbol<?>> nonTrivialLoops = new LinkedHashSet();

    @NotNull
    public final ImplicitBodyResolveComputationStatus getStatus$resolve(@NotNull FirCallableSymbol<?> symbol) {
        FirProperty fir;
        Intrinsics.checkNotNullParameter(symbol, (String)"symbol");
        if (symbol instanceof FirSyntheticPropertySymbol && (fir = (FirProperty)((FirSyntheticPropertySymbol)symbol).getFir()) instanceof FirSyntheticProperty) {
            return this.getStatus$resolve(((FirSyntheticProperty)fir).getGetter().getDelegate().getSymbol());
        }
        ImplicitBodyResolveComputationStatus implicitBodyResolveComputationStatus = this.implicitBodyResolveStatusMap.get(symbol);
        if (implicitBodyResolveComputationStatus == null) {
            implicitBodyResolveComputationStatus = ImplicitBodyResolveComputationStatus.NotComputed.INSTANCE;
        }
        return implicitBodyResolveComputationStatus;
    }

    @NotNull
    protected <D extends FirCallableDeclaration> D executeTransformation(@NotNull FirCallableSymbol<?> symbol, @NotNull Function0<? extends D> transformation) {
        Intrinsics.checkNotNullParameter(symbol, (String)"symbol");
        Intrinsics.checkNotNullParameter(transformation, (String)"transformation");
        return (D)((FirCallableDeclaration)transformation.invoke());
    }

    @NotNull
    public final <D extends FirCallableDeclaration> D compute$resolve(@NotNull FirCallableSymbol<?> symbol, @NotNull Function0<? extends D> transformation) {
        Intrinsics.checkNotNullParameter(symbol, (String)"symbol");
        Intrinsics.checkNotNullParameter(transformation, (String)"transformation");
        this.startComputing(symbol);
        D result2 = this.executeTransformation(symbol, transformation);
        this.storeResult(symbol, (FirCallableDeclaration)result2);
        return result2;
    }

    private final void startComputing(FirCallableSymbol<?> symbol) {
        if (!(this.implicitBodyResolveStatusMap.get(symbol) == null)) {
            boolean bl = false;
            String string = "Unexpected static in startComputing for " + symbol + ": " + this.implicitBodyResolveStatusMap.get(symbol);
            throw new IllegalArgumentException(string.toString());
        }
        ((Map)this.implicitBodyResolveStatusMap).put(symbol, ImplicitBodyResolveComputationStatus.Computing.INSTANCE);
        this.computingSymbolsStack.add(symbol);
    }

    private final void storeResult(FirCallableSymbol<?> symbol, FirCallableDeclaration transformedDeclaration) {
        if (!Intrinsics.areEqual((Object)this.implicitBodyResolveStatusMap.get(symbol), (Object)ImplicitBodyResolveComputationStatus.Computing.INSTANCE)) {
            boolean bl = false;
            String string = "Unexpected static in storeResult for " + symbol + ": " + this.implicitBodyResolveStatusMap.get(symbol);
            throw new IllegalArgumentException(string.toString());
        }
        FirTypeRef returnTypeRef = transformedDeclaration.getReturnTypeRef();
        if (!(returnTypeRef instanceof FirResolvedTypeRef)) {
            boolean bl = false;
            String string = "Not FirResolvedTypeRef (" + UtilsKt.render(transformedDeclaration.getReturnTypeRef()) + ") in storeResult for: " + UtilsKt.render((FirElement)symbol.getFir());
            throw new IllegalArgumentException(string.toString());
        }
        CollectionsKt.removeLast(this.computingSymbolsStack);
        ((Map)this.implicitBodyResolveStatusMap).put(symbol, new ImplicitBodyResolveComputationStatus.Computed((FirResolvedTypeRef)returnTypeRef, transformedDeclaration));
    }

    /*
     * WARNING - void declaration
     */
    public final void calculateAndStoreNonTrivialLoop(@NotNull FirCallableSymbol<?> symbol) {
        void $this$calculateAndStoreNonTrivialLoop_u24lambda_u242;
        List list2;
        Collection $this$takeLastWhile$iv;
        block7: {
            Intrinsics.checkNotNullParameter(symbol, (String)"symbol");
            $this$takeLastWhile$iv = this.computingSymbolsStack;
            boolean $i$f$takeLastWhile = false;
            if ($this$takeLastWhile$iv.isEmpty()) {
                list2 = CollectionsKt.emptyList();
            } else {
                ListIterator iterator$iv = $this$takeLastWhile$iv.listIterator($this$takeLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    FirCallableSymbol it = (FirCallableSymbol)iterator$iv.previous();
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it, symbol)) continue;
                    iterator$iv.next();
                    int expectedSize$iv = $this$takeLastWhile$iv.size() - iterator$iv.nextIndex();
                    if (expectedSize$iv == 0) {
                        list2 = CollectionsKt.emptyList();
                    } else {
                        ArrayList arrayList;
                        ArrayList $this$takeLastWhile_u24lambda_u240$iv = arrayList = new ArrayList(expectedSize$iv);
                        boolean bl2 = false;
                        while (iterator$iv.hasNext()) {
                            $this$takeLastWhile_u24lambda_u240$iv.add(iterator$iv.next());
                        }
                        list2 = arrayList;
                    }
                    break block7;
                }
                list2 = CollectionsKt.toList((Iterable)$this$takeLastWhile$iv);
            }
        }
        $this$takeLastWhile$iv = list2;
        List it = $this$takeLastWhile$iv;
        boolean bl = false;
        Collection collection = !((Collection)it).isEmpty() ? $this$takeLastWhile$iv : null;
        if (collection == null) {
            return;
        }
        List loopTail = collection;
        Set set = SetsKt.createSetBuilder();
        $this$takeLastWhile$iv = set;
        Set<FirCallableSymbol<?>> set2 = this.nonTrivialLoops;
        boolean bl3 = false;
        $this$calculateAndStoreNonTrivialLoop_u24lambda_u242.add(symbol);
        $this$calculateAndStoreNonTrivialLoop_u24lambda_u242.addAll(loopTail);
        set2.addAll(SetsKt.build((Set)set));
    }

    public final boolean belongToSomeNonTrivialLoop(@NotNull FirCallableSymbol<?> symbol) {
        Intrinsics.checkNotNullParameter(symbol, (String)"symbol");
        return this.nonTrivialLoops.contains(symbol);
    }
}

